/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.walkers.generic;

import ca.spottedleaf.dataconverter.converters.datatypes.DataType;
import ca.spottedleaf.dataconverter.converters.datatypes.DataWalker;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;

public class DataWalkerListPaths<T, R>
implements DataWalker<MapType<String>> {
    protected final DataType<T, R> type;
    protected final String[] paths;

    public DataWalkerListPaths(DataType<T, R> type, String ... paths) {
        this.type = type;
        this.paths = paths;
    }

    @Override
    public final MapType<String> walk(MapType<String> data, long fromVersion, long toVersion) {
        DataType<Object, R> type = this.type;
        for (String path : this.paths) {
            ListType list = data.getListUnchecked(path);
            if (list == null) continue;
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                Object current = list.getGeneric(i);
                R converted = type.convert(current, fromVersion, toVersion);
                if (converted == null) continue;
                list.setGeneric(i, converted);
            }
        }
        return null;
    }
}

