/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import com.google.common.collect.Collections2;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Set;
import java.util.function.Function;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.bossbar.BossBarImplementation;
import net.kyori.adventure.bossbar.BossBarViewer;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public final class BossBarImplementationImpl
implements BossBar.Listener,
BossBarImplementation {
    private final BossBar bar;
    private ServerBossEvent vanilla;

    public BossBarImplementationImpl(BossBar bar) {
        this.bar = bar;
    }

    public void playerShow(CraftPlayer player) {
        if (this.vanilla == null) {
            this.vanilla = new ServerBossEvent(PaperAdventure.asVanilla(this.bar.name()), PaperAdventure.asVanilla(this.bar.color()), PaperAdventure.asVanilla(this.bar.overlay()));
            this.vanilla.adventure = this.bar;
            this.bar.addListener((BossBar.Listener)this);
        }
        this.vanilla.addPlayer(player.getHandle());
    }

    public void playerHide(CraftPlayer player) {
        if (this.vanilla != null) {
            this.vanilla.removePlayer(player.getHandle());
            if (this.vanilla.getPlayers().isEmpty()) {
                this.bar.removeListener((BossBar.Listener)this);
                this.vanilla = null;
            }
        }
    }

    public void bossBarNameChanged(@NonNull BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
        this.maybeBroadcast(ClientboundBossEventPacket::createUpdateNamePacket);
    }

    public void bossBarProgressChanged(@NonNull BossBar bar, float oldProgress, float newProgress) {
        this.maybeBroadcast(ClientboundBossEventPacket::createUpdateProgressPacket);
    }

    public void bossBarColorChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color oldColor, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color newColor) {
        this.maybeBroadcast(ClientboundBossEventPacket::createUpdateStylePacket);
    }

    public void bossBarOverlayChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay oldOverlay, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay newOverlay) {
        this.maybeBroadcast(ClientboundBossEventPacket::createUpdateStylePacket);
    }

    public void bossBarFlagsChanged(@NonNull BossBar bar, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsAdded, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsRemoved) {
        this.maybeBroadcast(ClientboundBossEventPacket::createUpdatePropertiesPacket);
    }

    @NotNull
    public Iterable<? extends BossBarViewer> viewers() {
        return this.vanilla == null ? Set.of() : Collections2.transform(this.vanilla.getPlayers(), ServerPlayer::getBukkitEntity);
    }

    private void maybeBroadcast(Function<BossEvent, ClientboundBossEventPacket> fn) {
        if (this.vanilla != null) {
            this.vanilla.broadcast(fn);
        }
    }
}

