/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command;

import io.papermc.paper.command.CallbackCommand;
import io.papermc.paper.command.MSPTCommand;
import io.papermc.paper.command.PaperCommand;
import io.papermc.paper.command.PaperPluginsCommand;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import org.bukkit.command.Command;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class PaperCommands {
    private static final Map<String, Command> COMMANDS = new HashMap<String, Command>();

    private PaperCommands() {
    }

    public static void registerCommands(MinecraftServer server) {
        COMMANDS.forEach((s, command) -> server.server.getCommandMap().register(s, "Paper", command));
        server.server.getCommandMap().register("bukkit", (Command)new PaperPluginsCommand());
    }

    static {
        COMMANDS.put("paper", new PaperCommand("paper"));
        COMMANDS.put("callback", new CallbackCommand("callback"));
        COMMANDS.put("mspt", new MSPTCommand("mspt"));
    }
}

