/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.mapping;

import io.leangen.geantyref.GenericTypeReflector;
import io.papermc.paper.configuration.mapping.InnerClassInstanceSupplier;
import io.papermc.paper.configuration.mapping.MergeMap;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.objectmapping.FieldDiscoverer;
import org.spongepowered.configurate.serialize.SerializationException;

final class InnerClassInstanceFactory
implements FieldDiscoverer.MutableInstanceFactory<Map<Field, Object>> {
    private final InnerClassInstanceSupplier instanceSupplier;
    private final FieldDiscoverer.MutableInstanceFactory<Map<Field, Object>> fallback;
    private final AnnotatedType targetType;

    InnerClassInstanceFactory(InnerClassInstanceSupplier instanceSupplier, FieldDiscoverer.MutableInstanceFactory<Map<Field, Object>> fallback, AnnotatedType targetType) {
        this.instanceSupplier = instanceSupplier;
        this.fallback = fallback;
        this.targetType = targetType;
    }

    public Map<Field, Object> begin() {
        return (Map)this.fallback.begin();
    }

    public void complete(Object instance, Map<Field, Object> intermediate) throws SerializationException {
        Iterator<Map.Entry<Field, Object>> iter = intermediate.entrySet().iterator();
        try {
            while (iter.hasNext()) {
                Object object;
                Map.Entry<Field, Object> entry = iter.next();
                if (!entry.getKey().isAnnotationPresent(MergeMap.class) || !Map.class.isAssignableFrom(entry.getKey().getType()) || !((object = intermediate.get(entry.getKey())) instanceof Map)) continue;
                Map map = (Map)object;
                iter.remove();
                @Nullable Map existingMap = (Map)entry.getKey().get(instance);
                if (existingMap != null) {
                    existingMap.putAll(map);
                    continue;
                }
                entry.getKey().set(instance, entry.getValue());
            }
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(this.targetType.getType(), (Throwable)e);
        }
        this.fallback.complete(instance, intermediate);
    }

    public Object complete(Map<Field, Object> intermediate) throws SerializationException {
        Object targetInstance = Objects.requireNonNull(this.instanceSupplier.instanceMap().get(GenericTypeReflector.erase((Type)this.targetType.getType())), () -> String.valueOf(this.targetType.getType()) + " must already have an instance created");
        this.complete(targetInstance, intermediate);
        return targetInstance;
    }

    public boolean canCreateInstances() {
        return this.fallback.canCreateInstances();
    }
}

