/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.type;

import io.papermc.paper.configuration.type.Duration;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public final class DurationOrDisabled {
    private static final String DISABLE_VALUE = "disabled";
    public static final DurationOrDisabled USE_DISABLED = new DurationOrDisabled(Optional.empty());
    public static final ScalarSerializer<DurationOrDisabled> SERIALIZER = new Serializer();
    private Optional<Duration> value;

    public DurationOrDisabled(Optional<Duration> value) {
        this.value = value;
    }

    public Optional<Duration> value() {
        return this.value;
    }

    public void value(Optional<Duration> value) {
        this.value = value;
    }

    public Duration or(Duration fallback) {
        return this.value.orElse(fallback);
    }

    private static final class Serializer
    extends ScalarSerializer<DurationOrDisabled> {
        Serializer() {
            super(DurationOrDisabled.class);
        }

        public DurationOrDisabled deserialize(Type type, Object obj) throws SerializationException {
            if (obj instanceof String) {
                String string = (String)obj;
                if (DurationOrDisabled.DISABLE_VALUE.equalsIgnoreCase(string)) {
                    return USE_DISABLED;
                }
                return new DurationOrDisabled(Optional.of((Duration)Duration.SERIALIZER.deserialize(string)));
            }
            throw new SerializationException(String.valueOf(obj) + "(" + String.valueOf(type) + ") is not a duration or 'disabled'");
        }

        protected Object serialize(DurationOrDisabled item, Predicate<Class<?>> typeSupported) {
            return item.value.map(Duration::value).orElse(DurationOrDisabled.DISABLE_VALUE);
        }
    }
}

