/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.inventory.recipe;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public final class StackedContentsExtraMap {
    private final AtomicInteger idCounter = new AtomicInteger(BuiltInRegistries.ITEM.size());
    public final Object2IntMap<ItemStack> exactChoiceIds = new Object2IntOpenCustomHashMap(ItemStackLinkedSet.TYPE_AND_TAG);
    private final Int2ObjectMap<ItemStack> idToExactChoice = new Int2ObjectOpenHashMap();
    private final StackedContents contents;
    public final Map<Ingredient, IntList> extraStackingIds = new IdentityHashMap<Ingredient, IntList>();
    public Int2IntMap regularRemoved = new Int2IntArrayMap();

    public StackedContentsExtraMap(StackedContents contents, Recipe<?> recipe) {
        this.exactChoiceIds.defaultReturnValue(-1);
        this.contents = contents;
        this.initialize(recipe);
    }

    private void initialize(Recipe<?> recipe) {
        if (recipe.hasExactIngredients()) {
            for (Ingredient ingredient : recipe.getIngredients()) {
                if (ingredient.isEmpty() || !ingredient.exact) continue;
                ItemStack[] items = ingredient.getItems();
                IntArrayList idList = new IntArrayList(items.length);
                for (ItemStack item : items) {
                    idList.add(this.registerExact(item));
                    if (!item.getComponentsPatch().isEmpty()) continue;
                    idList.add(StackedContents.getStackingIndex(item));
                }
                idList.sort(IntComparators.NATURAL_COMPARATOR);
                this.extraStackingIds.put(ingredient, (IntList)idList);
            }
        }
    }

    private int registerExact(ItemStack exactChoice) {
        int existing = this.exactChoiceIds.getInt((Object)exactChoice);
        if (existing > -1) {
            return existing;
        }
        int id = this.idCounter.getAndIncrement();
        this.exactChoiceIds.put((Object)exactChoice, id);
        this.idToExactChoice.put(id, (Object)exactChoice);
        return id;
    }

    public ItemStack getById(int id) {
        return (ItemStack)this.idToExactChoice.get(id);
    }

    public void accountInput(CraftingInput input) {
        for (ItemStack item : input.items()) {
            int plainStackIdx;
            if (item.isEmpty() || !this.accountStack(item, 1) || this.contents.take(plainStackIdx = StackedContents.getStackingIndex(item), 1) != plainStackIdx) continue;
            this.regularRemoved.put(plainStackIdx, 1);
        }
    }

    public void resetExtras() {
        IntIterator intIterator = this.exactChoiceIds.values().iterator();
        while (intIterator.hasNext()) {
            int extraId = (Integer)intIterator.next();
            this.contents.contents.remove(extraId);
        }
        for (Int2IntMap.Entry entry : this.regularRemoved.int2IntEntrySet()) {
            this.contents.put(entry.getIntKey(), entry.getIntValue());
        }
    }

    public boolean accountStack(ItemStack stack, int count) {
        int id;
        if (!this.exactChoiceIds.isEmpty() && (id = this.exactChoiceIds.getInt((Object)stack)) >= 0) {
            this.contents.put(id, count);
            return true;
        }
        return false;
    }
}

