/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.pluginremap.reflect;

import com.mojang.logging.LogUtils;
import io.papermc.paper.pluginremap.reflect.ReflectionRemapper;
import io.papermc.paper.util.MappingEnvironment;
import io.papermc.paper.util.ObfHelper;
import io.papermc.reflectionrewriter.runtime.AbstractDefaultRulesReflectionProxy;
import io.papermc.reflectionrewriter.runtime.DefineClassReflectionProxy;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.slf4j.Logger;

@DefaultQualifier(value=NonNull.class)
public final class PaperReflection
extends AbstractDefaultRulesReflectionProxy
implements DefineClassReflectionProxy {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CB_PACKAGE_PREFIX = "org.bukkit.".concat("craftbukkit.");
    private static final String LEGACY_CB_PACKAGE_PREFIX = "org.bukkit.".concat("craftbukkit.") + "v1_21_R1.";
    private final DefineClassReflectionProxy defineClassProxy = DefineClassReflectionProxy.create(PaperReflection::processClass);
    private final Map<String, ObfHelper.ClassMapping> mappingsByMojangName;
    private final Map<String, ObfHelper.ClassMapping> mappingsByObfName;
    private final Map<String, Map<String, String>> strippedMethodMappings;

    PaperReflection() {
        if (!MappingEnvironment.hasMappings()) {
            this.mappingsByMojangName = Map.of();
            this.mappingsByObfName = Map.of();
            this.strippedMethodMappings = Map.of();
            return;
        }
        ObfHelper obfHelper = ObfHelper.INSTANCE;
        this.mappingsByMojangName = Objects.requireNonNull(obfHelper.mappingsByMojangName(), "mappingsByMojangName");
        this.mappingsByObfName = Objects.requireNonNull(obfHelper.mappingsByObfName(), "mappingsByObfName");
        this.strippedMethodMappings = this.mappingsByMojangName.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> ((ObfHelper.ClassMapping)entry.getValue()).strippedMethods()));
    }

    protected String mapClassName(String name) {
        @Nullable ObfHelper.ClassMapping mapping = this.mappingsByObfName.get(name);
        return mapping != null ? mapping.mojangName() : PaperReflection.removeCraftBukkitRelocation(name);
    }

    protected String mapDeclaredMethodName(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        @Nullable Map<String, String> mapping = this.strippedMethodMappings.get(clazz.getName());
        if (mapping == null) {
            return name;
        }
        return mapping.getOrDefault(PaperReflection.strippedMethodKey(name, parameterTypes), name);
    }

    protected String mapMethodName(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        @Nullable String mapped = this.findMappedMethodName(clazz, name, parameterTypes);
        return mapped != null ? mapped : name;
    }

    protected String mapDeclaredFieldName(Class<?> clazz, String name) {
        @Nullable ObfHelper.ClassMapping mapping = this.mappingsByMojangName.get(clazz.getName());
        if (mapping == null) {
            return name;
        }
        return mapping.fieldsByObf().getOrDefault(name, name);
    }

    protected String mapFieldName(Class<?> clazz, String name) {
        @Nullable String mapped = this.findMappedFieldName(clazz, name);
        return mapped != null ? mapped : name;
    }

    private @Nullable String findMappedMethodName(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Map<String, String> map = this.strippedMethodMappings.get(clazz.getName());
        String mapped = null;
        if (map != null && (mapped = map.get(PaperReflection.strippedMethodKey(name, parameterTypes))) != null) {
            return mapped;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            mapped = this.findMappedMethodName(superClass, name, parameterTypes);
        }
        if (mapped == null) {
            Class<?> i;
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            for (int j = 0; j < n && (mapped = this.findMappedMethodName(i = classArray[j], name, parameterTypes)) == null; ++j) {
            }
        }
        return mapped;
    }

    private @Nullable String findMappedFieldName(Class<?> clazz, String name) {
        ObfHelper.ClassMapping mapping = this.mappingsByMojangName.get(clazz.getName());
        String mapped = null;
        if (mapping != null && (mapped = mapping.fieldsByObf().get(name)) != null) {
            return mapped;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            mapped = this.findMappedFieldName(superClass, name);
        }
        if (mapped == null) {
            Class<?> i;
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            for (int j = 0; j < n && (mapped = this.findMappedFieldName(i = classArray[j], name)) == null; ++j) {
            }
        }
        return mapped;
    }

    private static String strippedMethodKey(String methodName, Class<?> ... parameterTypes) {
        return methodName + PaperReflection.parameterDescriptor(parameterTypes);
    }

    private static String parameterDescriptor(Class<?> ... parameterTypes) {
        if (parameterTypes == null) {
            return "()";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Class<?> parameterType : parameterTypes) {
            builder.append(parameterType.descriptorString());
        }
        builder.append(')');
        return builder.toString();
    }

    private static String removeCraftBukkitRelocation(String name) {
        if (MappingEnvironment.hasMappings()) {
            return name;
        }
        if (name.startsWith(LEGACY_CB_PACKAGE_PREFIX)) {
            return CB_PACKAGE_PREFIX + name.substring(LEGACY_CB_PACKAGE_PREFIX.length());
        }
        return name;
    }

    public Class<?> defineClass(Object loader, byte[] b, int off, int len) throws ClassFormatError {
        return this.defineClassProxy.defineClass(loader, b, off, len);
    }

    public Class<?> defineClass(Object loader, String name, byte[] b, int off, int len) throws ClassFormatError {
        return this.defineClassProxy.defineClass(loader, name, b, off, len);
    }

    public Class<?> defineClass(Object loader, @Nullable String name, byte[] b, int off, int len, @Nullable ProtectionDomain protectionDomain) throws ClassFormatError {
        return this.defineClassProxy.defineClass(loader, name, b, off, len, protectionDomain);
    }

    public Class<?> defineClass(Object loader, String name, ByteBuffer b, ProtectionDomain protectionDomain) throws ClassFormatError {
        return this.defineClassProxy.defineClass(loader, name, b, protectionDomain);
    }

    public Class<?> defineClass(Object secureLoader, String name, byte[] b, int off, int len, CodeSource cs) {
        return this.defineClassProxy.defineClass(secureLoader, name, b, off, len, cs);
    }

    public Class<?> defineClass(Object secureLoader, String name, ByteBuffer b, CodeSource cs) {
        return this.defineClassProxy.defineClass(secureLoader, name, b, cs);
    }

    public Class<?> defineClass(MethodHandles.Lookup lookup, byte[] bytes) throws IllegalAccessException {
        return this.defineClassProxy.defineClass(lookup, bytes);
    }

    private static byte[] processClass(byte[] bytes) {
        try {
            return ReflectionRemapper.processClass(bytes);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to process class bytes", (Throwable)ex);
            return bytes;
        }
    }
}

