/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.threadedregions;

import ca.spottedleaf.concurrentutil.util.Validate;
import ca.spottedleaf.moonrise.common.util.TickThread;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import org.bukkit.craftbukkit.entity.CraftEntity;

public final class EntityScheduler {
    public final CraftEntity entity;
    private long tickCount = 0L;
    private static final long RETIRED_TICK_COUNT = -1L;
    private final Object stateLock = new Object();
    private final Long2ObjectOpenHashMap<List<ScheduledTask>> oneTimeDelayed = new Long2ObjectOpenHashMap();
    private final ArrayDeque<ScheduledTask> currentlyExecuting = new ArrayDeque();

    public EntityScheduler(CraftEntity entity) {
        this.entity = Validate.notNull(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retire() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.tickCount == -1L) {
                throw new IllegalStateException("Already retired");
            }
            this.tickCount = -1L;
        }
        Entity thisEntity = this.entity.getHandleRaw();
        int len = this.currentlyExecuting.size();
        for (int i = 0; i < len; ++i) {
            ScheduledTask task = this.currentlyExecuting.pollFirst();
            Consumer<? extends Entity> retireTask = task.retired;
            if (retireTask == null) continue;
            retireTask.accept(thisEntity);
        }
        for (List tasks : this.oneTimeDelayed.values()) {
            int len2 = tasks.size();
            for (int i = 0; i < len2; ++i) {
                ScheduledTask task = (ScheduledTask)tasks.get(i);
                Consumer<? extends Entity> retireTask = task.retired;
                if (retireTask == null) continue;
                retireTask.accept(thisEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schedule(Consumer<? extends Entity> run, Consumer<? extends Entity> retired, long delay) {
        Validate.notNull(run, "Run task may not be null");
        ScheduledTask task = new ScheduledTask(run, retired);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.tickCount == -1L) {
                return false;
            }
            ((List)this.oneTimeDelayed.computeIfAbsent(this.tickCount + Math.max(1L, delay), keyInMap -> new ArrayList())).add(task);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTick() {
        int len;
        List toRun;
        Entity thisEntity = this.entity.getHandleRaw();
        TickThread.ensureTickThread(thisEntity, "May not tick entity scheduler asynchronously");
        Object object = this.stateLock;
        synchronized (object) {
            if (this.tickCount == -1L) {
                throw new IllegalStateException("Ticking retired scheduler");
            }
            ++this.tickCount;
            toRun = this.oneTimeDelayed.isEmpty() ? null : (List)this.oneTimeDelayed.remove(this.tickCount);
        }
        if (toRun != null) {
            len = toRun.size();
            for (int i = 0; i < len; ++i) {
                this.currentlyExecuting.addLast((ScheduledTask)toRun.get(i));
            }
        }
        len = this.currentlyExecuting.size();
        for (int i = 0; i < len && TickThread.isTickThreadFor(thisEntity); ++i) {
            ScheduledTask task = this.currentlyExecuting.pollFirst();
            if (this.tickCount == -1L) break;
            task.run.accept(thisEntity);
        }
    }

    private record ScheduledTask(Consumer<? extends Entity> run, Consumer<? extends Entity> retired) {
    }
}

