/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.destroystokyo.paper.util.SneakyThrow;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SystemReport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.CraftCrashReport;
import org.slf4j.Logger;

public class CrashReport {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
    private final String title;
    private final Throwable exception;
    private final List<CrashReportCategory> details = Lists.newArrayList();
    @Nullable
    private Path saveFile;
    private boolean trackingStackTrace = true;
    private StackTraceElement[] uncategorizedStackTrace = new StackTraceElement[0];
    private final SystemReport systemReport = new SystemReport();
    private List<String> extraInfo = List.of("", "DO NOT REPORT THIS TO PAPER! REPORT TO PURPUR INSTEAD!", "");

    public CrashReport(String message, Throwable cause) {
        StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(cause);
        this.title = message;
        this.exception = cause;
        this.systemReport.setDetail("CraftBukkit Information", new CraftCrashReport());
    }

    public String getTitle() {
        return this.title;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getDetails() {
        StringBuilder stringbuilder = new StringBuilder();
        this.getDetails(stringbuilder);
        return stringbuilder.toString();
    }

    public void getDetails(StringBuilder crashReportBuilder) {
        if (!(this.uncategorizedStackTrace != null && this.uncategorizedStackTrace.length > 0 || this.details.isEmpty())) {
            this.uncategorizedStackTrace = (StackTraceElement[])ArrayUtils.subarray((Object[])this.details.get(0).getStacktrace(), (int)0, (int)1);
        }
        if (this.uncategorizedStackTrace != null && this.uncategorizedStackTrace.length > 0) {
            crashReportBuilder.append("-- Head --\n");
            crashReportBuilder.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            crashReportBuilder.append("Stacktrace:\n");
            for (StackTraceElement stacktraceelement : this.uncategorizedStackTrace) {
                crashReportBuilder.append("\t").append("at ").append(stacktraceelement);
                crashReportBuilder.append("\n");
            }
            crashReportBuilder.append("\n");
        }
        for (CrashReportCategory crashreportsystemdetails : this.details) {
            crashreportsystemdetails.getDetails(crashReportBuilder);
            crashReportBuilder.append("\n\n");
        }
        this.systemReport.appendToCrashReportString(crashReportBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExceptionMessage() {
        String s;
        StringWriter stringwriter = null;
        PrintWriter printwriter = null;
        Throwable object = this.exception;
        if (object.getMessage() == null) {
            if (object instanceof NullPointerException) {
                object = new NullPointerException(this.title);
            } else if (object instanceof StackOverflowError) {
                object = new StackOverflowError(this.title);
            } else if (object instanceof OutOfMemoryError) {
                object = new OutOfMemoryError(this.title);
            }
            object.setStackTrace(this.exception.getStackTrace());
        }
        try {
            stringwriter = new StringWriter();
            printwriter = new PrintWriter(stringwriter);
            object.printStackTrace(printwriter);
            s = stringwriter.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Writer)stringwriter);
            IOUtils.closeQuietly(printwriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)stringwriter);
        IOUtils.closeQuietly((Writer)printwriter);
        return s;
    }

    public String getFriendlyReport(ReportType type, List<String> extraInfo) {
        StringBuilder stringbuilder = new StringBuilder();
        type.appendHeader(stringbuilder, extraInfo);
        stringbuilder.append("Time: ");
        stringbuilder.append(DATE_TIME_FORMATTER.format(ZonedDateTime.now()));
        stringbuilder.append("\n");
        stringbuilder.append("Description: ");
        stringbuilder.append(this.title);
        stringbuilder.append("\n\n");
        stringbuilder.append(this.getExceptionMessage());
        stringbuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i = 0; i < 87; ++i) {
            stringbuilder.append("-");
        }
        stringbuilder.append("\n\n");
        this.getDetails(stringbuilder);
        return stringbuilder.toString();
    }

    public String getFriendlyReport(ReportType type) {
        return this.getFriendlyReport(type, this.extraInfo);
    }

    @Nullable
    public Path getSaveFile() {
        return this.saveFile;
    }

    public boolean saveToFile(Path path, ReportType type, List<String> extraInfo) {
        if (this.saveFile != null) {
            return false;
        }
        try {
            if (path.getParent() != null) {
                FileUtil.createDirectoriesSafe(path.getParent());
            }
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedwriter.write(this.getFriendlyReport(type, extraInfo));
            }
            this.saveFile = path;
            return true;
        }
        catch (Throwable throwable2) {
            LOGGER.error("Could not save crash report to {}", (Object)path, (Object)throwable2);
            return false;
        }
    }

    public boolean saveToFile(Path path, ReportType type) {
        return this.saveToFile(path, type, this.extraInfo);
    }

    public SystemReport getSystemReport() {
        return this.systemReport;
    }

    public CrashReportCategory addCategory(String name) {
        return this.addCategory(name, 1);
    }

    public CrashReportCategory addCategory(String name, int ignoredStackTraceCallCount) {
        CrashReportCategory crashreportsystemdetails = new CrashReportCategory(name);
        if (this.trackingStackTrace) {
            int j = crashreportsystemdetails.fillInStackTrace(ignoredStackTraceCallCount);
            StackTraceElement[] astacktraceelement = this.exception.getStackTrace();
            StackTraceElement stacktraceelement = null;
            StackTraceElement stacktraceelement1 = null;
            int k = astacktraceelement.length - j;
            if (k < 0) {
                LOGGER.error("Negative index in crash report handler ({}/{})", (Object)astacktraceelement.length, (Object)j);
            }
            if (astacktraceelement != null && 0 <= k && k < astacktraceelement.length) {
                stacktraceelement = astacktraceelement[k];
                if (astacktraceelement.length + 1 - j < astacktraceelement.length) {
                    stacktraceelement1 = astacktraceelement[astacktraceelement.length + 1 - j];
                }
            }
            this.trackingStackTrace = crashreportsystemdetails.validateStackTrace(stacktraceelement, stacktraceelement1);
            if (astacktraceelement != null && astacktraceelement.length >= j && 0 <= k && k < astacktraceelement.length) {
                this.uncategorizedStackTrace = new StackTraceElement[k];
                System.arraycopy(astacktraceelement, 0, this.uncategorizedStackTrace, 0, this.uncategorizedStackTrace.length);
            } else {
                this.trackingStackTrace = false;
            }
        }
        this.details.add(crashreportsystemdetails);
        return crashreportsystemdetails;
    }

    public static CrashReport forThrowable(Throwable cause, String title) {
        CrashReport crashreport;
        if (cause instanceof ThreadDeath) {
            SneakyThrow.sneaky((Throwable)cause);
        }
        while (cause instanceof CompletionException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)cause;
            crashreport = reportedexception.getReport();
        } else {
            crashreport = new CrashReport(title, cause);
        }
        return crashreport;
    }

    public static void preload() {
        new CrashReport("Don't panic!", new Throwable()).getFriendlyReport(ReportType.CRASH);
    }
}

