/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ChunkPos;

public interface Component
extends Message,
FormattedText,
Iterable<Component> {
    default public Stream<Component> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.getSiblings().stream().flatMap(Component::stream)});
    }

    @Override
    default public Iterator<Component> iterator() {
        return this.stream().iterator();
    }

    public Style getStyle();

    public ComponentContents getContents();

    @Override
    default public String getString() {
        return FormattedText.super.getString();
    }

    default public String getString(int length) {
        StringBuilder stringbuilder = new StringBuilder();
        this.visit(s -> {
            int j = length - stringbuilder.length();
            if (j <= 0) {
                return STOP_ITERATION;
            }
            stringbuilder.append(s.length() <= j ? s : s.substring(0, j));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<Component> getSiblings();

    @Nullable
    default public String tryCollapseToString() {
        ComponentContents componentcontents = this.getContents();
        if (componentcontents instanceof PlainTextContents) {
            PlainTextContents literalcontents = (PlainTextContents)componentcontents;
            if (this.getSiblings().isEmpty() && this.getStyle().isEmpty()) {
                return literalcontents.text();
            }
        }
        return null;
    }

    default public MutableComponent plainCopy() {
        return MutableComponent.create(this.getContents());
    }

    default public MutableComponent copy() {
        return new MutableComponent(this.getContents(), new ArrayList<Component>(this.getSiblings()), this.getStyle());
    }

    public FormattedCharSequence getVisualOrderText();

    @Override
    default public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> styledVisitor, Style style) {
        Component ichatbasecomponent;
        Optional<T> optional1;
        Style chatmodifier1 = this.getStyle().applyTo(style);
        Optional<T> optional = this.getContents().visit(styledVisitor, chatmodifier1);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<Component> iterator = this.getSiblings().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).visit(styledVisitor, chatmodifier1)).isPresent());
        return optional1;
    }

    @Override
    default public <T> Optional<T> visit(FormattedText.ContentConsumer<T> visitor) {
        Component ichatbasecomponent;
        Optional<T> optional1;
        Optional<T> optional = this.getContents().visit(visitor);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<Component> iterator = this.getSiblings().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).visit(visitor)).isPresent());
        return optional1;
    }

    default public List<Component> toFlatList() {
        return this.toFlatList(Style.EMPTY);
    }

    default public List<Component> toFlatList(Style style) {
        ArrayList list = Lists.newArrayList();
        this.visit((chatmodifier1, s) -> {
            if (!s.isEmpty()) {
                list.add(Component.literal(s).withStyle(chatmodifier1));
            }
            return Optional.empty();
        }, style);
        return list;
    }

    default public boolean contains(Component text) {
        List<Component> list1;
        if (this.equals(text)) {
            return true;
        }
        List<Component> list = this.toFlatList();
        return Collections.indexOfSubList(list, list1 = text.toFlatList(this.getStyle())) != -1;
    }

    public static Component nullToEmpty(@Nullable String string) {
        return string != null ? Component.literal(string) : CommonComponents.EMPTY;
    }

    public static MutableComponent literal(String string) {
        return MutableComponent.create(PlainTextContents.create(string));
    }

    public static MutableComponent translatable(String key) {
        return MutableComponent.create(new TranslatableContents(key, null, TranslatableContents.NO_ARGS));
    }

    public static MutableComponent translatable(String key, Object ... args) {
        return MutableComponent.create(new TranslatableContents(key, null, args));
    }

    public static MutableComponent translatableEscape(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (TranslatableContents.isAllowedPrimitiveArgument(object) || object instanceof Component) continue;
            args[i] = String.valueOf(object);
        }
        return Component.translatable(key, args);
    }

    public static MutableComponent translatableWithFallback(String key, @Nullable String fallback) {
        return MutableComponent.create(new TranslatableContents(key, fallback, TranslatableContents.NO_ARGS));
    }

    public static MutableComponent translatableWithFallback(String key, @Nullable String fallback, Object ... args) {
        return MutableComponent.create(new TranslatableContents(key, fallback, args));
    }

    public static MutableComponent empty() {
        return MutableComponent.create(PlainTextContents.EMPTY);
    }

    public static MutableComponent keybind(String string) {
        return MutableComponent.create(new KeybindContents(string));
    }

    public static MutableComponent nbt(String rawPath, boolean interpret, Optional<Component> separator, DataSource dataSource) {
        return MutableComponent.create(new NbtContents(rawPath, interpret, separator, dataSource));
    }

    public static MutableComponent score(String name, String objective) {
        return MutableComponent.create(new ScoreContents(name, objective));
    }

    public static MutableComponent selector(String pattern, Optional<Component> separator) {
        return MutableComponent.create(new SelectorContents(pattern, separator));
    }

    public static Component translationArg(Date date) {
        return Component.literal(date.toString());
    }

    public static Component translationArg(Message message) {
        Component object;
        if (message instanceof Component) {
            Component ichatbasecomponent = (Component)message;
            object = ichatbasecomponent;
        } else {
            object = Component.literal(message.getString());
        }
        return object;
    }

    public static Component translationArg(UUID uuid) {
        return Component.literal(uuid.toString());
    }

    public static Component translationArg(ResourceLocation id) {
        return Component.literal(id.toString());
    }

    public static Component translationArg(ChunkPos pos) {
        return Component.literal(pos.toString());
    }

    public static Component translationArg(URI uri) {
        return Component.literal(uri.toString());
    }

    public static class Serializer {
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

        private Serializer() {
        }

        static MutableComponent deserialize(JsonElement json, HolderLookup.Provider registries) {
            return (MutableComponent)ComponentSerialization.CODEC.parse(registries.createSerializationContext(JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new);
        }

        static JsonElement serialize(Component text, HolderLookup.Provider registries) {
            return (JsonElement)ComponentSerialization.CODEC.encodeStart(registries.createSerializationContext(JsonOps.INSTANCE), (Object)text).getOrThrow(JsonParseException::new);
        }

        public static String toJson(Component text, HolderLookup.Provider registries) {
            return GSON.toJson(Serializer.serialize(text, registries));
        }

        @Nullable
        public static MutableComponent fromJson(String json, HolderLookup.Provider registries) {
            JsonElement jsonelement = JsonParser.parseString((String)json);
            return jsonelement == null ? null : Serializer.deserialize(jsonelement, registries);
        }

        @Nullable
        public static MutableComponent fromJson(@Nullable JsonElement json, HolderLookup.Provider registries) {
            return json == null ? null : Serializer.deserialize(json, registries);
        }

        @Nullable
        public static MutableComponent fromJsonLenient(String json, HolderLookup.Provider registries) {
            JsonReader jsonreader = new JsonReader((Reader)new StringReader(json));
            jsonreader.setLenient(true);
            JsonElement jsonelement = JsonParser.parseReader((JsonReader)jsonreader);
            return jsonelement == null ? null : Serializer.deserialize(jsonelement, registries);
        }
    }

    public static class SerializerAdapter
    implements JsonDeserializer<MutableComponent>,
    JsonSerializer<Component> {
        private final HolderLookup.Provider registries;

        public SerializerAdapter(HolderLookup.Provider registries) {
            this.registries = registries;
        }

        public MutableComponent deserialize(JsonElement jsonelement, Type type, JsonDeserializationContext jsondeserializationcontext) throws JsonParseException {
            return Serializer.deserialize(jsonelement, this.registries);
        }

        public JsonElement serialize(Component ichatbasecomponent, Type type, JsonSerializationContext jsonserializationcontext) {
            return Serializer.serialize(ichatbasecomponent, this.registries);
        }
    }
}

