/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public record BrainDebugPayload(BrainDump brainDump) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, BrainDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(BrainDebugPayload::write, BrainDebugPayload::new);
    public static final CustomPacketPayload.Type<BrainDebugPayload> TYPE = CustomPacketPayload.createType("debug/brain");

    private BrainDebugPayload(FriendlyByteBuf buf) {
        this(new BrainDump(buf));
    }

    private void write(FriendlyByteBuf buf) {
        this.brainDump.write(buf);
    }

    @Override
    public CustomPacketPayload.Type<BrainDebugPayload> type() {
        return TYPE;
    }

    public record BrainDump(UUID uuid, int id, String name, String profession, int xp, float health, float maxHealth, Vec3 pos, String inventory, @Nullable Path path, boolean wantsGolem, int angerLevel, List<String> activities, List<String> behaviors, List<String> memories, List<String> gossips, Set<BlockPos> pois, Set<BlockPos> potentialPois) {
        public BrainDump(FriendlyByteBuf buf) {
            this(buf.readUUID(), buf.readInt(), buf.readUtf(), buf.readUtf(), buf.readInt(), buf.readFloat(), buf.readFloat(), buf.readVec3(), buf.readUtf(), buf.readNullable(Path::createFromStream), buf.readBoolean(), buf.readInt(), buf.readList(FriendlyByteBuf::readUtf), buf.readList(FriendlyByteBuf::readUtf), buf.readList(FriendlyByteBuf::readUtf), buf.readList(FriendlyByteBuf::readUtf), buf.readCollection(HashSet::new, BlockPos.STREAM_CODEC), buf.readCollection(HashSet::new, BlockPos.STREAM_CODEC));
        }

        public void write(FriendlyByteBuf buf2) {
            buf2.writeUUID(this.uuid);
            buf2.writeInt(this.id);
            buf2.writeUtf(this.name);
            buf2.writeUtf(this.profession);
            buf2.writeInt(this.xp);
            buf2.writeFloat(this.health);
            buf2.writeFloat(this.maxHealth);
            buf2.writeVec3(this.pos);
            buf2.writeUtf(this.inventory);
            buf2.writeNullable(this.path, (buf, path) -> path.writeToStream((FriendlyByteBuf)((Object)buf)));
            buf2.writeBoolean(this.wantsGolem);
            buf2.writeInt(this.angerLevel);
            buf2.writeCollection(this.activities, FriendlyByteBuf::writeUtf);
            buf2.writeCollection(this.behaviors, FriendlyByteBuf::writeUtf);
            buf2.writeCollection(this.memories, FriendlyByteBuf::writeUtf);
            buf2.writeCollection(this.gossips, FriendlyByteBuf::writeUtf);
            buf2.writeCollection(this.pois, BlockPos.STREAM_CODEC);
            buf2.writeCollection(this.potentialPois, BlockPos.STREAM_CODEC);
        }

        public boolean hasPoi(BlockPos pos) {
            return this.pois.contains(pos);
        }

        public boolean hasPotentialPoi(BlockPos pos) {
            return this.potentialPois.contains(pos);
        }
    }
}

