/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import org.bukkit.craftbukkit.entity.CraftPlayer;

public class ClientboundPlayerInfoUpdatePacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundPlayerInfoUpdatePacket> STREAM_CODEC = Packet.codec(ClientboundPlayerInfoUpdatePacket::write, ClientboundPlayerInfoUpdatePacket::new);
    private final EnumSet<Action> actions;
    private final List<Entry> entries;

    public ClientboundPlayerInfoUpdatePacket(EnumSet<Action> actions, Collection<ServerPlayer> players) {
        this.actions = actions;
        this.entries = players.stream().map(Entry::new).toList();
    }

    public ClientboundPlayerInfoUpdatePacket(Action action, ServerPlayer player) {
        this.actions = EnumSet.of(action);
        this.entries = List.of(new Entry(player));
    }

    public ClientboundPlayerInfoUpdatePacket(EnumSet<Action> actions, List<Entry> entries) {
        this.actions = actions;
        this.entries = entries;
    }

    public ClientboundPlayerInfoUpdatePacket(EnumSet<Action> actions, Entry entry) {
        this.actions = actions;
        this.entries = List.of(entry);
    }

    public static ClientboundPlayerInfoUpdatePacket createPlayerInitializing(Collection<ServerPlayer> players) {
        EnumSet<Action[]> enumSet = EnumSet.of(Action.ADD_PLAYER, new Action[]{Action.INITIALIZE_CHAT, Action.UPDATE_GAME_MODE, Action.UPDATE_LISTED, Action.UPDATE_LATENCY, Action.UPDATE_DISPLAY_NAME});
        return new ClientboundPlayerInfoUpdatePacket(enumSet, players);
    }

    public static ClientboundPlayerInfoUpdatePacket createPlayerInitializing(Collection<ServerPlayer> players, ServerPlayer forPlayer) {
        EnumSet<Action[]> enumSet = EnumSet.of(Action.ADD_PLAYER, new Action[]{Action.INITIALIZE_CHAT, Action.UPDATE_GAME_MODE, Action.UPDATE_LISTED, Action.UPDATE_LATENCY, Action.UPDATE_DISPLAY_NAME});
        ArrayList<Entry> entries = new ArrayList<Entry>(players.size());
        CraftPlayer bukkitEntity = forPlayer.getBukkitEntity();
        for (ServerPlayer player : players) {
            entries.add(new Entry(player, bukkitEntity.isListed(player.getBukkitEntity())));
        }
        return new ClientboundPlayerInfoUpdatePacket((EnumSet<Action>)enumSet, (List<Entry>)entries);
    }

    public static ClientboundPlayerInfoUpdatePacket createSinglePlayerInitializing(ServerPlayer player, boolean listed) {
        EnumSet<Action[]> enumSet = EnumSet.of(Action.ADD_PLAYER, new Action[]{Action.INITIALIZE_CHAT, Action.UPDATE_GAME_MODE, Action.UPDATE_LISTED, Action.UPDATE_LATENCY, Action.UPDATE_DISPLAY_NAME});
        List<Entry> entries = List.of(new Entry(player, listed));
        return new ClientboundPlayerInfoUpdatePacket(enumSet, entries);
    }

    public static ClientboundPlayerInfoUpdatePacket updateListed(UUID playerInfoId, boolean listed) {
        EnumSet<Action> enumSet = EnumSet.of(Action.UPDATE_LISTED);
        return new ClientboundPlayerInfoUpdatePacket(enumSet, new Entry(playerInfoId, listed));
    }

    private ClientboundPlayerInfoUpdatePacket(RegistryFriendlyByteBuf buf) {
        this.actions = buf.readEnumSet(Action.class);
        this.entries = buf.readList(buf2 -> {
            EntryBuilder entryBuilder = new EntryBuilder(buf2.readUUID());
            for (Action action : this.actions) {
                action.reader.read(entryBuilder, (RegistryFriendlyByteBuf)((Object)buf2));
            }
            return entryBuilder.build();
        });
    }

    private void write(RegistryFriendlyByteBuf buf) {
        buf.writeEnumSet(this.actions, Action.class);
        buf.writeCollection(this.entries, (buf2, entry) -> {
            buf2.writeUUID(entry.profileId());
            for (Action action : this.actions) {
                action.writer.write((RegistryFriendlyByteBuf)((Object)buf2), (Entry)entry);
            }
        });
    }

    @Override
    public PacketType<ClientboundPlayerInfoUpdatePacket> type() {
        return GamePacketTypes.CLIENTBOUND_PLAYER_INFO_UPDATE;
    }

    @Override
    public void handle(ClientGamePacketListener listener) {
        listener.handlePlayerInfoUpdate(this);
    }

    public EnumSet<Action> actions() {
        return this.actions;
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public List<Entry> newEntries() {
        return this.actions.contains((Object)Action.ADD_PLAYER) ? this.entries : List.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actions", this.actions).add("entries", this.entries).toString();
    }

    public record Entry(UUID profileId, @Nullable GameProfile profile, boolean listed, int latency, GameType gameMode, @Nullable Component displayName, @Nullable RemoteChatSession.Data chatSession) {
        Entry(ServerPlayer player) {
            this(player, true);
        }

        Entry(ServerPlayer player, boolean listed) {
            this(player.getUUID(), player.getGameProfile(), listed, player.connection.latency(), player.gameMode.getGameModeForPlayer(), player.getTabListDisplayName(), Optionull.map(player.getChatSession(), RemoteChatSession::asData));
        }

        Entry(UUID profileId, boolean listed) {
            this(profileId, null, listed, 0, GameType.DEFAULT_MODE, null, null);
        }
    }

    public static enum Action {
        ADD_PLAYER((serialized, buf) -> {
            GameProfile gameProfile = new GameProfile(serialized.profileId, buf.readUtf(16));
            gameProfile.getProperties().putAll((Multimap)ByteBufCodecs.GAME_PROFILE_PROPERTIES.decode(buf));
            serialized.profile = gameProfile;
        }, (buf, entry) -> {
            GameProfile gameProfile = Objects.requireNonNull(entry.profile());
            buf.writeUtf(gameProfile.getName(), 16);
            ByteBufCodecs.GAME_PROFILE_PROPERTIES.encode(buf, gameProfile.getProperties());
        }),
        INITIALIZE_CHAT((serialized, buf) -> {
            serialized.chatSession = buf.readNullable(RemoteChatSession.Data::read);
        }, (buf, entry) -> {
            RemoteChatSession.Data chatSession = entry.chatSession;
            if (chatSession != null && chatSession.profilePublicKey().hasExpired()) {
                chatSession = null;
            }
            buf.writeNullable(chatSession, RemoteChatSession.Data::write);
        }),
        UPDATE_GAME_MODE((serialized, buf) -> {
            serialized.gameMode = GameType.byId(buf.readVarInt());
        }, (buf, entry) -> buf.writeVarInt(entry.gameMode().getId())),
        UPDATE_LISTED((serialized, buf) -> {
            serialized.listed = buf.readBoolean();
        }, (buf, entry) -> buf.writeBoolean(entry.listed())),
        UPDATE_LATENCY((serialized, buf) -> {
            serialized.latency = buf.readVarInt();
        }, (buf, entry) -> buf.writeVarInt(entry.latency())),
        UPDATE_DISPLAY_NAME((serialized, buf) -> {
            serialized.displayName = FriendlyByteBuf.readNullable(buf, ComponentSerialization.TRUSTED_STREAM_CODEC);
        }, (buf, entry) -> FriendlyByteBuf.writeNullable(buf, entry.displayName(), ComponentSerialization.TRUSTED_STREAM_CODEC));

        final Reader reader;
        final Writer writer;

        private Action(Reader reader, Writer writer) {
            this.reader = reader;
            this.writer = writer;
        }

        public static interface Reader {
            public void read(EntryBuilder var1, RegistryFriendlyByteBuf var2);
        }

        public static interface Writer {
            public void write(RegistryFriendlyByteBuf var1, Entry var2);
        }
    }

    static class EntryBuilder {
        final UUID profileId;
        @Nullable
        GameProfile profile;
        boolean listed;
        int latency;
        GameType gameMode = GameType.DEFAULT_MODE;
        @Nullable
        Component displayName;
        @Nullable
        RemoteChatSession.Data chatSession;

        EntryBuilder(UUID profileId) {
            this.profileId = profileId;
        }

        Entry build() {
            return new Entry(this.profileId, this.profile, this.listed, this.latency, this.gameMode, this.displayName, this.chatSession);
        }
    }
}

