/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new GsonBuilder().create();
    public Map<ResourceLocation, AdvancementHolder> advancements = new HashMap<ResourceLocation, AdvancementHolder>();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.Provider registries;

    public ServerAdvancementManager(HolderLookup.Provider registryLookup) {
        super(GSON, Registries.elementsDirPath(Registries.ADVANCEMENT));
        this.registries = registryLookup;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        RegistryOps registryops = this.registries.createSerializationContext(JsonOps.INSTANCE);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        prepared.forEach((minecraftkey, jsonelement) -> {
            if (SpigotConfig.disabledAdvancements != null && (SpigotConfig.disabledAdvancements.contains("*") || SpigotConfig.disabledAdvancements.contains(minecraftkey.toString()) || SpigotConfig.disabledAdvancements.contains(minecraftkey.getNamespace()))) {
                return;
            }
            try {
                Advancement advancement = (Advancement)Advancement.CODEC.parse((DynamicOps)registryops, jsonelement).getOrThrow(JsonParseException::new);
                this.validate((ResourceLocation)minecraftkey, advancement);
                builder.put(minecraftkey, (Object)new AdvancementHolder((ResourceLocation)minecraftkey, advancement));
            }
            catch (Exception exception) {
                LOGGER.error("Parsing error loading custom advancement {}: {}", minecraftkey, (Object)exception.getMessage());
            }
        });
        this.advancements = new HashMap<ResourceLocation, AdvancementHolder>((Map<ResourceLocation, AdvancementHolder>)builder.buildOrThrow());
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.addAll(this.advancements.values());
        LOGGER.info("Loaded {} advancements", (Object)advancementtree.nodes().size());
        for (AdvancementNode advancementnode : advancementtree.roots()) {
            if (!advancementnode.holder().value().display().isPresent()) continue;
            TreeNodePosition.run(advancementnode);
        }
        this.tree = advancementtree;
    }

    private void validate(ResourceLocation id, Advancement advancement) {
        ProblemReporter.Collector problemreporter_a = new ProblemReporter.Collector();
        advancement.validate(problemreporter_a, this.registries.asGetterLookup());
        problemreporter_a.getReport().ifPresent(s -> LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)id, s));
    }

    @Nullable
    public AdvancementHolder get(ResourceLocation id) {
        return this.advancements.get(id);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

