/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SetBlockCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("setblock").requires(source -> source.hasPermission(2))).then(Commands.argument("pos", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("block", BlockStateArgument.block(commandRegistryAccess)).executes(context -> SetBlockCommand.setBlock((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context, "block"), Mode.REPLACE, null))).then(Commands.literal("destroy").executes(context -> SetBlockCommand.setBlock((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context, "block"), Mode.DESTROY, null)))).then(Commands.literal("keep").executes(context -> SetBlockCommand.setBlock((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context, "block"), Mode.REPLACE, pos -> pos.getLevel().isEmptyBlock(pos.getPos()))))).then(Commands.literal("replace").executes(context -> SetBlockCommand.setBlock((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context, "block"), Mode.REPLACE, null)))))));
    }

    private static int setBlock(CommandSourceStack source, BlockPos pos, BlockInput block, Mode mode, @Nullable Predicate<BlockInWorld> condition) throws CommandSyntaxException {
        boolean bl2;
        ServerLevel serverLevel = source.getLevel();
        if (condition != null && !condition.test(new BlockInWorld(serverLevel, pos, true))) {
            throw ERROR_FAILED.create();
        }
        if (mode == Mode.DESTROY) {
            serverLevel.destroyBlock(pos, true);
            boolean bl = !block.getState().isAir() || !serverLevel.getBlockState(pos).isAir();
        } else {
            BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
            Clearable.tryClear(blockEntity);
            bl2 = true;
        }
        if (bl2 && !block.place(serverLevel, pos, 2)) {
            throw ERROR_FAILED.create();
        }
        serverLevel.blockUpdated(pos, block.getState().getBlock());
        source.sendSuccess(() -> Component.translatable("commands.setblock.success", pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    public static enum Mode {
        REPLACE,
        DESTROY;

    }

    public static interface Filter {
        @Nullable
        public BlockInput filter(BoundingBox var1, BlockPos var2, BlockInput var3, ServerLevel var4);
    }
}

