/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.translatable("commands.teleport.invalidPosition"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode<CommandSourceStack> literalcommandnode = dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("teleport").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(Commands.argument("location", Vec3Argument.vec3()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), Collections.singleton(((CommandSourceStack)commandcontext.getSource()).getEntityOrException()), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), WorldCoordinates.current(), null)))).then(Commands.argument("destination", EntityArgument.entity()).executes(commandcontext -> TeleportCommand.teleportToEntity((CommandSourceStack)commandcontext.getSource(), Collections.singleton(((CommandSourceStack)commandcontext.getSource()).getEntityOrException()), EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandcontext, "destination"))))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("location", Vec3Argument.vec3()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), null, null))).then(Commands.argument("rotation", RotationArgument.rotation()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), RotationArgument.getRotation((CommandContext<CommandSourceStack>)commandcontext, "rotation"), null)))).then(((LiteralArgumentBuilder)Commands.literal("facing").then(Commands.literal("entity").then(((RequiredArgumentBuilder)Commands.argument("facingEntity", EntityArgument.entity()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), null, new LookAtEntity(EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandcontext, "facingEntity"), EntityAnchorArgument.Anchor.FEET)))).then(Commands.argument("facingAnchor", EntityAnchorArgument.anchor()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), null, new LookAtEntity(EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandcontext, "facingEntity"), EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)commandcontext, "facingAnchor")))))))).then(Commands.argument("facingLocation", Vec3Argument.vec3()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), null, new LookAtPosition(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)commandcontext, "facingLocation")))))))).then(Commands.argument("destination", EntityArgument.entity()).executes(commandcontext -> TeleportCommand.teleportToEntity((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandcontext, "destination")))))));
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tp").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).redirect(literalcommandnode)));
    }

    private static int teleportToEntity(CommandSourceStack source, Collection<? extends net.minecraft.world.entity.Entity> targets, net.minecraft.world.entity.Entity destination) throws CommandSyntaxException {
        for (net.minecraft.world.entity.Entity entity : targets) {
            TeleportCommand.performTeleport(source, entity, (ServerLevel)destination.level(), destination.getX(), destination.getY(), destination.getZ(), EnumSet.noneOf(RelativeMovement.class), destination.getYRot(), destination.getXRot(), null);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.entity.single", ((net.minecraft.world.entity.Entity)targets.iterator().next()).getDisplayName(), destination.getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.entity.multiple", targets.size(), destination.getDisplayName()), true);
        }
        return targets.size();
    }

    private static int teleportToPos(CommandSourceStack source, Collection<? extends net.minecraft.world.entity.Entity> targets, ServerLevel world, Coordinates location, @Nullable Coordinates rotation, @Nullable LookAt facingLocation) throws CommandSyntaxException {
        Vec3 vec3d = location.getPosition(source);
        Vec2 vec2f = rotation == null ? null : rotation.getRotation(source);
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        if (location.isXRelative()) {
            set.add(RelativeMovement.X);
        }
        if (location.isYRelative()) {
            set.add(RelativeMovement.Y);
        }
        if (location.isZRelative()) {
            set.add(RelativeMovement.Z);
        }
        if (rotation == null) {
            set.add(RelativeMovement.X_ROT);
            set.add(RelativeMovement.Y_ROT);
        } else {
            if (rotation.isXRelative()) {
                set.add(RelativeMovement.X_ROT);
            }
            if (rotation.isYRelative()) {
                set.add(RelativeMovement.Y_ROT);
            }
        }
        for (net.minecraft.world.entity.Entity entity : targets) {
            if (rotation == null) {
                TeleportCommand.performTeleport(source, entity, world, vec3d.x, vec3d.y, vec3d.z, set, entity.getYRot(), entity.getXRot(), facingLocation);
                continue;
            }
            TeleportCommand.performTeleport(source, entity, world, vec3d.x, vec3d.y, vec3d.z, set, vec2f.y, vec2f.x, facingLocation);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.location.single", ((net.minecraft.world.entity.Entity)targets.iterator().next()).getDisplayName(), TeleportCommand.formatDouble(vec3d.x), TeleportCommand.formatDouble(vec3d.y), TeleportCommand.formatDouble(vec3d.z)), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.location.multiple", targets.size(), TeleportCommand.formatDouble(vec3d.x), TeleportCommand.formatDouble(vec3d.y), TeleportCommand.formatDouble(vec3d.z)), true);
        }
        return targets.size();
    }

    private static String formatDouble(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }

    private static void performTeleport(CommandSourceStack source, net.minecraft.world.entity.Entity target, ServerLevel world, double x, double y, double z, Set<RelativeMovement> movementFlags, float yaw, float pitch, @Nullable LookAt facingLocation) throws CommandSyntaxException {
        boolean result;
        BlockPos blockposition = BlockPos.containing(x, y, z);
        if (!Level.isInSpawnableBounds(blockposition)) {
            throw INVALID_POSITION.create();
        }
        float f2 = Mth.wrapDegrees(yaw);
        float f3 = Mth.wrapDegrees(pitch);
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            result = player.teleportTo(world, x, y, z, movementFlags, f2, f3, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            Location to = new Location((World)world.getWorld(), x, y, z, f2, f3);
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)target.getBukkitEntity(), target.getBukkitEntity().getLocation(), to);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getTo() == null) {
                return;
            }
            to = event.getTo();
            x = to.getX();
            y = to.getY();
            z = to.getZ();
            f2 = to.getYaw();
            f3 = to.getPitch();
            world = ((CraftWorld)to.getWorld()).getHandle();
            result = target.teleportTo(world, x, y, z, movementFlags, f2, f3);
        }
        if (result) {
            LivingEntity entityliving;
            if (facingLocation != null) {
                facingLocation.perform(source, target);
            }
            if (!(target instanceof LivingEntity) || !(entityliving = (LivingEntity)target).isFallFlying()) {
                target.setDeltaMovement(target.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                target.setOnGround(true);
            }
            if (target instanceof PathfinderMob) {
                PathfinderMob entitycreature = (PathfinderMob)target;
                entitycreature.getNavigation().stop();
            }
        }
    }

    @FunctionalInterface
    private static interface LookAt {
        public void perform(CommandSourceStack var1, net.minecraft.world.entity.Entity var2);
    }

    private record LookAtPosition(Vec3 position) implements LookAt
    {
        @Override
        public void perform(CommandSourceStack source, net.minecraft.world.entity.Entity entity) {
            entity.lookAt(source.getAnchor(), this.position);
        }
    }

    private record LookAtEntity(net.minecraft.world.entity.Entity entity, EntityAnchorArgument.Anchor anchor) implements LookAt
    {
        @Override
        public void perform(CommandSourceStack source, net.minecraft.world.entity.Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                entityplayer.lookAt(source.getAnchor(), this.entity, this.anchor);
            } else {
                entity.lookAt(source.getAnchor(), this.anchor.apply(this.entity));
            }
        }
    }
}

