/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public class ChunkTaskPriorityQueueSorter
implements ChunkHolder.LevelChangeListener,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<ProcessorHandle<?>, ChunkTaskPriorityQueue<? extends Function<ProcessorHandle<Unit>, ?>>> queues;
    private final Set<ProcessorHandle<?>> sleeping;
    private final ProcessorMailbox<StrictQueue.IntRunnable> mailbox;

    public ChunkTaskPriorityQueueSorter(List<ProcessorHandle<?>> actors, Executor executor, int maxQueues) {
        this.queues = actors.stream().collect(Collectors.toMap(Function.identity(), actor -> new ChunkTaskPriorityQueue(actor.name() + "_queue", maxQueues)));
        this.sleeping = Sets.newHashSet(actors);
        this.mailbox = new ProcessorMailbox<StrictQueue.IntRunnable>(new StrictQueue.FixedPriorityQueue(4), executor, "sorter");
    }

    public boolean hasWork() {
        return this.mailbox.hasWork() || this.queues.values().stream().anyMatch(ChunkTaskPriorityQueue::hasWork);
    }

    public static <T> Message<T> message(Function<ProcessorHandle<Unit>, T> taskFunction, long pos, IntSupplier lastLevelUpdatedToProvider) {
        return new Message<T>(taskFunction, pos, lastLevelUpdatedToProvider);
    }

    public static Message<Runnable> message(Runnable task, long pos, IntSupplier lastLevelUpdatedToProvider) {
        return new Message<Runnable>(yield -> () -> {
            task.run();
            yield.tell(Unit.INSTANCE);
        }, pos, lastLevelUpdatedToProvider);
    }

    public static Message<Runnable> message(GenerationChunkHolder holder, Runnable task) {
        return ChunkTaskPriorityQueueSorter.message(task, holder.getPos().toLong(), holder::getQueueLevel);
    }

    public static <T> Message<T> message(GenerationChunkHolder holder, Function<ProcessorHandle<Unit>, T> taskFunction) {
        return ChunkTaskPriorityQueueSorter.message(taskFunction, holder.getPos().toLong(), holder::getQueueLevel);
    }

    public static Release release(Runnable task, long pos, boolean removeTask) {
        return new Release(task, pos, removeTask);
    }

    public <T> ProcessorHandle<Message<T>> getProcessor(ProcessorHandle<T> executor, boolean addBlocker) {
        return (ProcessorHandle)this.mailbox.ask(yield -> new StrictQueue.IntRunnable(0, () -> {
            this.getQueue(executor);
            yield.tell(ProcessorHandle.of("chunk priority sorter around " + executor.name(), task -> this.submit(executor, task.task, task.pos, task.level, addBlocker)));
        })).join();
    }

    public ProcessorHandle<Release> getReleaseProcessor(ProcessorHandle<Runnable> executor) {
        return (ProcessorHandle)this.mailbox.ask(yield -> new StrictQueue.IntRunnable(0, () -> yield.tell(ProcessorHandle.of("chunk priority sorter around " + executor.name(), message -> this.release(executor, message.pos, message.task, message.clearQueue))))).join();
    }

    @Override
    @Override
    public void onLevelChange(ChunkPos pos, IntSupplier levelGetter, int targetLevel, IntConsumer levelSetter) {
        this.mailbox.tell(new StrictQueue.IntRunnable(0, () -> {
            int j = levelGetter.getAsInt();
            this.queues.values().forEach(queue -> queue.resortChunkTasks(j, pos, targetLevel));
            levelSetter.accept(targetLevel);
        }));
    }

    private <T> void release(ProcessorHandle<T> actor, long chunkPos, Runnable callback, boolean clearTask) {
        this.mailbox.tell(new StrictQueue.IntRunnable(1, () -> {
            ChunkTaskPriorityQueue chunkTaskPriorityQueue = this.getQueue(actor);
            chunkTaskPriorityQueue.release(chunkPos, clearTask);
            if (this.sleeping.remove(actor)) {
                this.pollTask(chunkTaskPriorityQueue, actor);
            }
            callback.run();
        }));
    }

    private <T> void submit(ProcessorHandle<T> actor, Function<ProcessorHandle<Unit>, T> task, long chunkPos, IntSupplier lastLevelUpdatedToProvider, boolean addBlocker) {
        this.mailbox.tell(new StrictQueue.IntRunnable(2, () -> {
            ChunkTaskPriorityQueue chunkTaskPriorityQueue = this.getQueue(actor);
            int i = lastLevelUpdatedToProvider.getAsInt();
            chunkTaskPriorityQueue.submit(Optional.of(task), chunkPos, i);
            if (addBlocker) {
                chunkTaskPriorityQueue.submit(Optional.empty(), chunkPos, i);
            }
            if (this.sleeping.remove(actor)) {
                this.pollTask(chunkTaskPriorityQueue, actor);
            }
        }));
    }

    private <T> void pollTask(ChunkTaskPriorityQueue<Function<ProcessorHandle<Unit>, T>> queue, ProcessorHandle<T> actor) {
        this.mailbox.tell(new StrictQueue.IntRunnable(3, () -> {
            Stream<Either<Either, Runnable>> stream = queue.pop();
            if (stream == null) {
                this.sleeping.add(actor);
            } else {
                CompletableFuture.allOf((CompletableFuture[])stream.map(executeOrAddBlocking -> executeOrAddBlocking.map(actor::ask, addBlocking -> {
                    addBlocking.run();
                    return CompletableFuture.completedFuture(Unit.INSTANCE);
                })).toArray(CompletableFuture[]::new)).thenAccept(void_ -> this.pollTask(queue, actor));
            }
        }));
    }

    private <T> ChunkTaskPriorityQueue<Function<ProcessorHandle<Unit>, T>> getQueue(ProcessorHandle<T> actor) {
        ChunkTaskPriorityQueue<Function<ProcessorHandle<Unit>, T>> chunkTaskPriorityQueue = this.queues.get(actor);
        if (chunkTaskPriorityQueue == null) {
            throw Util.pauseInIde(new IllegalArgumentException("No queue for: " + String.valueOf(actor)));
        }
        return chunkTaskPriorityQueue;
    }

    @VisibleForTesting
    public String getDebugStatus() {
        return this.queues.entrySet().stream().map(entry -> ((ProcessorHandle)entry.getKey()).name() + "=[" + ((ChunkTaskPriorityQueue)entry.getValue()).getAcquired().stream().map(pos -> pos + ":" + String.valueOf(new ChunkPos((long)pos))).collect(Collectors.joining(",")) + "]").collect(Collectors.joining(",")) + ", s=" + this.sleeping.size();
    }

    @Override
    @Override
    public void close() {
        this.queues.keySet().forEach(ProcessorHandle::close);
    }

    public static final class Message<T> {
        final Function<ProcessorHandle<Unit>, T> task;
        final long pos;
        final IntSupplier level;

        Message(Function<ProcessorHandle<Unit>, T> taskFunction, long pos, IntSupplier lastLevelUpdatedToProvider) {
            this.task = taskFunction;
            this.pos = pos;
            this.level = lastLevelUpdatedToProvider;
        }
    }

    public static final class Release {
        final Runnable task;
        final long pos;
        final boolean clearQueue;

        Release(Runnable callback, long pos, boolean removeTask) {
            this.task = callback;
            this.pos = pos;
            this.clearQueue = removeTask;
        }
    }
}

