/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class DownloadCacheCleaner {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void vacuumCacheDir(Path directory, int maxRetained) {
        try {
            List<PathAndTime> list = DownloadCacheCleaner.listFilesWithModificationTimes(directory);
            int i = list.size() - maxRetained;
            if (i <= 0) {
                return;
            }
            list.sort(PathAndTime.NEWEST_FIRST);
            List<PathAndPriority> list2 = DownloadCacheCleaner.prioritizeFilesInDirs(list);
            Collections.reverse(list2);
            list2.sort(PathAndPriority.HIGHEST_PRIORITY_FIRST);
            HashSet<Path> set = new HashSet<Path>();
            for (int j = 0; j < i; ++j) {
                PathAndPriority pathAndPriority = list2.get(j);
                Path path = pathAndPriority.path;
                try {
                    Files.delete(path);
                    if (pathAndPriority.removalPriority != 0) continue;
                    set.add(path.getParent());
                    continue;
                }
                catch (IOException iOException) {
                    LOGGER.warn("Failed to delete cache file {}", (Object)path, (Object)iOException);
                }
            }
            set.remove(directory);
            for (Path path2 : set) {
                try {
                    Files.delete(path2);
                }
                catch (DirectoryNotEmptyException path) {
                }
                catch (IOException iOException2) {
                    LOGGER.warn("Failed to delete empty(?) cache directory {}", (Object)path2, (Object)iOException2);
                }
            }
        }
        catch (IOException | UncheckedIOException exception) {
            LOGGER.error("Failed to vacuum cache dir {}", (Object)directory, (Object)exception);
        }
    }

    private static List<PathAndTime> listFilesWithModificationTimes(final Path directory) throws IOException {
        try {
            final ArrayList<PathAndTime> list = new ArrayList<PathAndTime>();
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                    if (basicFileAttributes.isRegularFile() && !path.getParent().equals(directory)) {
                        FileTime fileTime = basicFileAttributes.lastModifiedTime();
                        list.add(new PathAndTime(path, fileTime));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.visitFile((Path)object, basicFileAttributes);
                }
            });
            return list;
        }
        catch (NoSuchFileException noSuchFileException) {
            return List.of();
        }
    }

    private static List<PathAndPriority> prioritizeFilesInDirs(List<PathAndTime> files) {
        ArrayList<PathAndPriority> list = new ArrayList<PathAndPriority>();
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        for (PathAndTime pathAndTime : files) {
            int i = object2IntOpenHashMap.addTo((Object)pathAndTime.path.getParent(), 1);
            list.add(new PathAndPriority(pathAndTime.path, i));
        }
        return list;
    }

    record PathAndTime(Path path, FileTime modifiedTime) {
        public static final Comparator<PathAndTime> NEWEST_FIRST = Comparator.comparing(PathAndTime::modifiedTime).reversed();
    }

    record PathAndPriority(Path path, int removalPriority) {
        public static final Comparator<PathAndPriority> HIGHEST_PRIORITY_FIRST = Comparator.comparing(PathAndPriority::removalPriority).reversed();
    }
}

