/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.tag.PaperTagListenerManager;
import io.papermc.paper.tag.TagEventConfig;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.util.DependencySorter;
import org.slf4j.Logger;

public class TagLoader<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final Function<ResourceLocation, Optional<? extends T>> idToValue;
    private final String directory;

    public TagLoader(Function<ResourceLocation, Optional<? extends T>> registryGetter, String dataType) {
        this.idToValue = registryGetter;
        this.directory = dataType;
    }

    public Map<ResourceLocation, List<EntryWithSource>> load(ResourceManager resourceManager) {
        HashMap map = Maps.newHashMap();
        FileToIdConverter fileToIdConverter = FileToIdConverter.json(this.directory);
        for (Map.Entry<ResourceLocation, List<Resource>> entry : fileToIdConverter.listMatchingResourceStacks(resourceManager).entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            ResourceLocation resourceLocation2 = fileToIdConverter.fileToId(resourceLocation);
            for (Resource resource : entry.getValue()) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        List list = map.computeIfAbsent(resourceLocation2, id -> new ArrayList());
                        TagFile tagFile = (TagFile)TagFile.CODEC.parse(new Dynamic<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, jsonElement)).getOrThrow();
                        if (tagFile.replace()) {
                            list.clear();
                        }
                        String string = resource.sourcePackId();
                        tagFile.entries().forEach(entryx -> list.add(new EntryWithSource((TagEntry)entryx, string)));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception var17) {
                    LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{resourceLocation2, resourceLocation, resource.sourcePackId(), var17});
                }
            }
        }
        return map;
    }

    private Either<Collection<EntryWithSource>, Collection<T>> build(TagEntry.Lookup<T> valueGetter, List<EntryWithSource> entries) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayList<EntryWithSource> list = new ArrayList<EntryWithSource>();
        for (EntryWithSource entryWithSource : entries) {
            if (entryWithSource.entry().build(valueGetter, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0))) continue;
            list.add(entryWithSource);
        }
        return list.isEmpty() ? Either.right(builder.build()) : Either.left(list);
    }

    public Map<ResourceLocation, Collection<T>> build(Map<ResourceLocation, List<EntryWithSource>> tags, @Nullable TagEventConfig<T, ?> eventConfig) {
        tags = PaperTagListenerManager.INSTANCE.firePreFlattenEvent(tags, eventConfig);
        final HashMap map = Maps.newHashMap();
        TagEntry.Lookup lookup = new TagEntry.Lookup<T>(){

            @Override
            @Nullable
            public T element(ResourceLocation id) {
                return TagLoader.this.idToValue.apply(id).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> tag(ResourceLocation id) {
                return (Collection)map.get(id);
            }
        };
        DependencySorter<ResourceLocation, SortingEntry> dependencySorter = new DependencySorter<ResourceLocation, SortingEntry>();
        tags.forEach((id, entries) -> dependencySorter.addEntry((ResourceLocation)id, new SortingEntry((List<EntryWithSource>)entries)));
        dependencySorter.orderByDependencies((id, dependencies) -> this.build(lookup, dependencies.entries).ifLeft(missingReferences -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", id, (Object)missingReferences.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(resolvedEntries -> map.put(id, resolvedEntries)));
        return PaperTagListenerManager.INSTANCE.firePostFlattenEvent(map, eventConfig);
    }

    public Map<ResourceLocation, Collection<T>> loadAndBuild(ResourceManager manager, @Nullable TagEventConfig<T, ?> eventConfig) {
        return this.build(this.load(manager), eventConfig);
    }

    public record EntryWithSource(TagEntry entry, String source) {
        @Override
        public String toString() {
            return String.valueOf(this.entry) + " (from " + this.source + ")";
        }
    }

    record SortingEntry(List<EntryWithSource> entries) implements DependencySorter.Entry<ResourceLocation>
    {
        @Override
        public void visitRequiredDependencies(Consumer<ResourceLocation> callback) {
            this.entries.forEach(entry -> entry.entry.visitRequiredDependencies(callback));
        }

        @Override
        public void visitOptionalDependencies(Consumer<ResourceLocation> callback) {
            this.entries.forEach(entry -> entry.entry.visitOptionalDependencies(callback));
        }
    }
}

