/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class WorldGenSettingsFix
extends DataFix {
    private static final String VILLAGE = "minecraft:village";
    private static final String DESERT_PYRAMID = "minecraft:desert_pyramid";
    private static final String IGLOO = "minecraft:igloo";
    private static final String JUNGLE_TEMPLE = "minecraft:jungle_pyramid";
    private static final String SWAMP_HUT = "minecraft:swamp_hut";
    private static final String PILLAGER_OUTPOST = "minecraft:pillager_outpost";
    private static final String END_CITY = "minecraft:endcity";
    private static final String WOODLAND_MANSION = "minecraft:mansion";
    private static final String OCEAN_MONUMENT = "minecraft:monument";
    private static final ImmutableMap<String, StructureFeatureConfiguration> DEFAULTS = ImmutableMap.builder().put((Object)"minecraft:village", (Object)new StructureFeatureConfiguration(32, 8, 10387312)).put((Object)"minecraft:desert_pyramid", (Object)new StructureFeatureConfiguration(32, 8, 14357617)).put((Object)"minecraft:igloo", (Object)new StructureFeatureConfiguration(32, 8, 14357618)).put((Object)"minecraft:jungle_pyramid", (Object)new StructureFeatureConfiguration(32, 8, 14357619)).put((Object)"minecraft:swamp_hut", (Object)new StructureFeatureConfiguration(32, 8, 14357620)).put((Object)"minecraft:pillager_outpost", (Object)new StructureFeatureConfiguration(32, 8, 165745296)).put((Object)"minecraft:monument", (Object)new StructureFeatureConfiguration(32, 5, 10387313)).put((Object)"minecraft:endcity", (Object)new StructureFeatureConfiguration(20, 11, 10387313)).put((Object)"minecraft:mansion", (Object)new StructureFeatureConfiguration(80, 20, 10387319)).build();

    public WorldGenSettingsFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("WorldGenSettings building", this.getInputSchema().getType(References.WORLD_GEN_SETTINGS), worldGenSettingsTyped -> worldGenSettingsTyped.update(DSL.remainderFinder(), WorldGenSettingsFix::fix));
    }

    private static <T> Dynamic<T> noise(long seed, DynamicLike<T> worldGenSettingsDynamic, Dynamic<T> settingsDynamic, Dynamic<T> biomeSourceDynamic) {
        return worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:noise")), (Object)((Object)worldGenSettingsDynamic.createString("biome_source")), biomeSourceDynamic, (Object)((Object)worldGenSettingsDynamic.createString("seed")), (Object)((Object)worldGenSettingsDynamic.createLong(seed)), (Object)((Object)worldGenSettingsDynamic.createString("settings")), settingsDynamic));
    }

    private static <T> Dynamic<T> vanillaBiomeSource(Dynamic<T> worldGenSettingsDynamic, long seed, boolean legacyBiomeInitLayer, boolean largeBiomes) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)worldGenSettingsDynamic.createString("type"), (Object)worldGenSettingsDynamic.createString("minecraft:vanilla_layered")).put((Object)worldGenSettingsDynamic.createString("seed"), (Object)worldGenSettingsDynamic.createLong(seed)).put((Object)worldGenSettingsDynamic.createString("large_biomes"), (Object)worldGenSettingsDynamic.createBoolean(largeBiomes));
        if (legacyBiomeInitLayer) {
            builder.put((Object)worldGenSettingsDynamic.createString("legacy_biome_init_layer"), (Object)worldGenSettingsDynamic.createBoolean(legacyBiomeInitLayer));
        }
        return worldGenSettingsDynamic.createMap((Map)builder.build());
    }

    private static <T> Dynamic<T> fix(Dynamic<T> worldGenSettingsDynamic) {
        Dynamic<T> dynamic12;
        DynamicOps dynamicOps = worldGenSettingsDynamic.getOps();
        long l = worldGenSettingsDynamic.get("RandomSeed").asLong(0L);
        Optional optional = worldGenSettingsDynamic.get("generatorName").asString().map(generatorName -> generatorName.toLowerCase(Locale.ROOT)).result();
        Optional optional2 = worldGenSettingsDynamic.get("legacy_custom_options").asString().result().map(Optional::of).orElseGet(() -> {
            if (optional.equals(Optional.of("customized"))) {
                return worldGenSettingsDynamic.get("generatorOptions").asString().result();
            }
            return Optional.empty();
        });
        boolean bl = false;
        if (optional.equals(Optional.of("customized"))) {
            Dynamic<T> dynamic = WorldGenSettingsFix.defaultOverworld(worldGenSettingsDynamic, l);
        } else if (optional.isEmpty()) {
            Dynamic<T> dynamic2 = WorldGenSettingsFix.defaultOverworld(worldGenSettingsDynamic, l);
        } else {
            switch ((String)optional.get()) {
                case "flat": {
                    OptionalDynamic<T> optionalDynamic = worldGenSettingsDynamic.get("generatorOptions");
                    Map<Dynamic<T>, Dynamic<T>> map = WorldGenSettingsFix.fixFlatStructures(dynamicOps, optionalDynamic);
                    Dynamic dynamic3 = worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:flat")), (Object)((Object)worldGenSettingsDynamic.createString("settings")), (Object)((Object)worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("structures")), (Object)((Object)worldGenSettingsDynamic.createMap(map)), (Object)((Object)worldGenSettingsDynamic.createString("layers")), (Object)((Object)optionalDynamic.get("layers").result().orElseGet(() -> worldGenSettingsDynamic.createList(Stream.of(worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("height")), (Object)((Object)worldGenSettingsDynamic.createInt(1)), (Object)((Object)worldGenSettingsDynamic.createString("block")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:bedrock")))), worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("height")), (Object)((Object)worldGenSettingsDynamic.createInt(2)), (Object)((Object)worldGenSettingsDynamic.createString("block")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:dirt")))), worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("height")), (Object)((Object)worldGenSettingsDynamic.createInt(1)), (Object)((Object)worldGenSettingsDynamic.createString("block")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:grass_block")))))))), (Object)((Object)worldGenSettingsDynamic.createString("biome")), (Object)((Object)worldGenSettingsDynamic.createString(optionalDynamic.get("biome").asString("minecraft:plains"))))))));
                    break;
                }
                case "debug_all_block_states": {
                    Dynamic dynamic4 = worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:debug"))));
                    break;
                }
                case "buffet": {
                    Dynamic dynamic10;
                    Dynamic dynamic7;
                    OptionalDynamic<T> optionalDynamic2 = worldGenSettingsDynamic.get("generatorOptions");
                    OptionalDynamic optionalDynamic3 = optionalDynamic2.get("chunk_generator");
                    Optional optional3 = optionalDynamic3.get("type").asString().result();
                    if (Objects.equals(optional3, Optional.of("minecraft:caves"))) {
                        Dynamic dynamic5 = worldGenSettingsDynamic.createString("minecraft:caves");
                        bl = true;
                    } else if (Objects.equals(optional3, Optional.of("minecraft:floating_islands"))) {
                        Dynamic dynamic6 = worldGenSettingsDynamic.createString("minecraft:floating_islands");
                    } else {
                        dynamic7 = worldGenSettingsDynamic.createString("minecraft:overworld");
                    }
                    Dynamic dynamic8 = optionalDynamic2.get("biome_source").result().orElseGet(() -> worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:fixed")))));
                    if (dynamic8.get("type").asString().result().equals(Optional.of("minecraft:fixed"))) {
                        String string = dynamic8.get("options").get("biomes").asStream().findFirst().flatMap(biomeDynamic -> biomeDynamic.asString().result()).orElse("minecraft:ocean");
                        Dynamic dynamic9 = dynamic8.remove("options").set("biome", worldGenSettingsDynamic.createString(string));
                    } else {
                        dynamic10 = dynamic8;
                    }
                    Dynamic<T> dynamic11 = WorldGenSettingsFix.noise(l, worldGenSettingsDynamic, dynamic7, dynamic10);
                    break;
                }
                default: {
                    boolean bl2 = ((String)optional.get()).equals("default");
                    boolean bl3 = ((String)optional.get()).equals("default_1_1") || bl2 && worldGenSettingsDynamic.get("generatorVersion").asInt(0) == 0;
                    boolean bl4 = ((String)optional.get()).equals("amplified");
                    boolean bl5 = ((String)optional.get()).equals("largebiomes");
                    dynamic12 = WorldGenSettingsFix.noise(l, worldGenSettingsDynamic, worldGenSettingsDynamic.createString(bl4 ? "minecraft:amplified" : "minecraft:overworld"), WorldGenSettingsFix.vanillaBiomeSource(worldGenSettingsDynamic, l, bl3, bl5));
                }
            }
        }
        boolean bl6 = worldGenSettingsDynamic.get("MapFeatures").asBoolean(true);
        boolean bl7 = worldGenSettingsDynamic.get("BonusChest").asBoolean(false);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(dynamicOps.createString("seed"), dynamicOps.createLong(l));
        builder.put(dynamicOps.createString("generate_features"), dynamicOps.createBoolean(bl6));
        builder.put(dynamicOps.createString("bonus_chest"), dynamicOps.createBoolean(bl7));
        builder.put(dynamicOps.createString("dimensions"), WorldGenSettingsFix.vanillaLevels(worldGenSettingsDynamic, l, dynamic12, bl));
        optional2.ifPresent(legacyCustomOptions -> builder.put(dynamicOps.createString("legacy_custom_options"), dynamicOps.createString(legacyCustomOptions)));
        return new Dynamic<Object>(dynamicOps, dynamicOps.createMap((Map)builder.build()));
    }

    protected static <T> Dynamic<T> defaultOverworld(Dynamic<T> worldGenSettingsDynamic, long seed) {
        return WorldGenSettingsFix.noise(seed, worldGenSettingsDynamic, worldGenSettingsDynamic.createString("minecraft:overworld"), WorldGenSettingsFix.vanillaBiomeSource(worldGenSettingsDynamic, seed, false, false));
    }

    protected static <T> T vanillaLevels(Dynamic<T> worldGenSettingsDynamic, long seed, Dynamic<T> generatorSettingsDynamic, boolean caves) {
        DynamicOps dynamicOps = worldGenSettingsDynamic.getOps();
        return (T)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("minecraft:overworld"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:overworld" + (caves ? "_caves" : "")), (Object)dynamicOps.createString("generator"), generatorSettingsDynamic.getValue())), (Object)dynamicOps.createString("minecraft:the_nether"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:the_nether"), (Object)dynamicOps.createString("generator"), WorldGenSettingsFix.noise(seed, worldGenSettingsDynamic, worldGenSettingsDynamic.createString("minecraft:nether"), worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:multi_noise")), (Object)((Object)worldGenSettingsDynamic.createString("seed")), (Object)((Object)worldGenSettingsDynamic.createLong(seed)), (Object)((Object)worldGenSettingsDynamic.createString("preset")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:nether"))))).getValue())), (Object)dynamicOps.createString("minecraft:the_end"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:the_end"), (Object)dynamicOps.createString("generator"), WorldGenSettingsFix.noise(seed, worldGenSettingsDynamic, worldGenSettingsDynamic.createString("minecraft:end"), worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:the_end")), (Object)((Object)worldGenSettingsDynamic.createString("seed")), (Object)((Object)worldGenSettingsDynamic.createLong(seed))))).getValue()))));
    }

    private static <T> Map<Dynamic<T>, Dynamic<T>> fixFlatStructures(DynamicOps<T> worldGenSettingsDynamicOps, OptionalDynamic<T> generatorOptionsDynamic) {
        MutableInt mutableInt = new MutableInt(32);
        MutableInt mutableInt2 = new MutableInt(3);
        MutableInt mutableInt3 = new MutableInt(128);
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        HashMap map = Maps.newHashMap();
        if (generatorOptionsDynamic.result().isEmpty()) {
            mutableBoolean.setTrue();
            map.put(VILLAGE, (StructureFeatureConfiguration)DEFAULTS.get((Object)VILLAGE));
        }
        generatorOptionsDynamic.get("structures").flatMap(Dynamic::getMapValues).ifSuccess(map2 -> map2.forEach((oldStructureName, dynamic) -> dynamic.getMapValues().result().ifPresent(map2 -> map2.forEach((propertyName, spacing) -> {
            String string = oldStructureName.asString("");
            String string2 = propertyName.asString("");
            String string3 = spacing.asString("");
            if ("stronghold".equals(string)) {
                mutableBoolean.setTrue();
                switch (string2) {
                    case "distance": {
                        mutableInt.setValue(WorldGenSettingsFix.getInt(string3, mutableInt.getValue(), 1));
                        return;
                    }
                    case "spread": {
                        mutableInt2.setValue(WorldGenSettingsFix.getInt(string3, mutableInt2.getValue(), 1));
                        return;
                    }
                    case "count": {
                        mutableInt3.setValue(WorldGenSettingsFix.getInt(string3, mutableInt3.getValue(), 1));
                        return;
                    }
                }
                return;
            }
            switch (string2) {
                case "distance": {
                    switch (string) {
                        case "village": {
                            WorldGenSettingsFix.setSpacing(map, VILLAGE, string3, 9);
                            return;
                        }
                        case "biome_1": {
                            WorldGenSettingsFix.setSpacing(map, DESERT_PYRAMID, string3, 9);
                            WorldGenSettingsFix.setSpacing(map, IGLOO, string3, 9);
                            WorldGenSettingsFix.setSpacing(map, JUNGLE_TEMPLE, string3, 9);
                            WorldGenSettingsFix.setSpacing(map, SWAMP_HUT, string3, 9);
                            WorldGenSettingsFix.setSpacing(map, PILLAGER_OUTPOST, string3, 9);
                            return;
                        }
                        case "endcity": {
                            WorldGenSettingsFix.setSpacing(map, END_CITY, string3, 1);
                            return;
                        }
                        case "mansion": {
                            WorldGenSettingsFix.setSpacing(map, WOODLAND_MANSION, string3, 1);
                            return;
                        }
                    }
                    return;
                }
                case "separation": {
                    if ("oceanmonument".equals(string)) {
                        StructureFeatureConfiguration structureFeatureConfiguration = map.getOrDefault(OCEAN_MONUMENT, (StructureFeatureConfiguration)DEFAULTS.get((Object)OCEAN_MONUMENT));
                        int i = WorldGenSettingsFix.getInt(string3, structureFeatureConfiguration.separation, 1);
                        map.put(OCEAN_MONUMENT, new StructureFeatureConfiguration(i, structureFeatureConfiguration.separation, structureFeatureConfiguration.salt));
                    }
                    return;
                }
                case "spacing": {
                    if ("oceanmonument".equals(string)) {
                        WorldGenSettingsFix.setSpacing(map, OCEAN_MONUMENT, string3, 1);
                    }
                    return;
                }
            }
        }))));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)generatorOptionsDynamic.createString("structures"), (Object)generatorOptionsDynamic.createMap(map.entrySet().stream().collect(Collectors.toMap(entry -> generatorOptionsDynamic.createString((String)entry.getKey()), entry -> ((StructureFeatureConfiguration)entry.getValue()).serialize(worldGenSettingsDynamicOps)))));
        if (mutableBoolean.isTrue()) {
            builder.put((Object)generatorOptionsDynamic.createString("stronghold"), (Object)generatorOptionsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)generatorOptionsDynamic.createString("distance")), (Object)((Object)generatorOptionsDynamic.createInt(mutableInt.getValue().intValue())), (Object)((Object)generatorOptionsDynamic.createString("spread")), (Object)((Object)generatorOptionsDynamic.createInt(mutableInt2.getValue().intValue())), (Object)((Object)generatorOptionsDynamic.createString("count")), (Object)((Object)generatorOptionsDynamic.createInt(mutableInt3.getValue().intValue())))));
        }
        return builder.build();
    }

    private static int getInt(String string, int defaultValue) {
        return NumberUtils.toInt((String)string, (int)defaultValue);
    }

    private static int getInt(String string, int defaultValue, int minValue) {
        return Math.max(minValue, WorldGenSettingsFix.getInt(string, defaultValue));
    }

    private static void setSpacing(Map<String, StructureFeatureConfiguration> map, String structureId, String spacingStr, int minSpacing) {
        StructureFeatureConfiguration structureFeatureConfiguration = map.getOrDefault(structureId, (StructureFeatureConfiguration)DEFAULTS.get((Object)structureId));
        int i = WorldGenSettingsFix.getInt(spacingStr, structureFeatureConfiguration.spacing, minSpacing);
        map.put(structureId, new StructureFeatureConfiguration(i, structureFeatureConfiguration.separation, structureFeatureConfiguration.salt));
    }

    static final class StructureFeatureConfiguration {
        public static final Codec<StructureFeatureConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("spacing").forGetter(structureFeatureConfiguration -> structureFeatureConfiguration.spacing), (App)Codec.INT.fieldOf("separation").forGetter(structureFeatureConfiguration -> structureFeatureConfiguration.separation), (App)Codec.INT.fieldOf("salt").forGetter(structureFeatureConfiguration -> structureFeatureConfiguration.salt)).apply((Applicative)instance, StructureFeatureConfiguration::new));
        final int spacing;
        final int separation;
        final int salt;

        public StructureFeatureConfiguration(int spacing, int separation, int salt) {
            this.spacing = spacing;
            this.separation = separation;
            this.salt = salt;
        }

        public <T> Dynamic<T> serialize(DynamicOps<T> dynamicOps) {
            return new Dynamic<Object>(dynamicOps, CODEC.encodeStart(dynamicOps, (Object)this).result().orElse(dynamicOps.emptyMap()));
        }
    }
}

