/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.LongSerializationPolicy;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import net.minecraft.Util;
import net.minecraft.util.profiling.jfr.Percentiles;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.ChunkIdentification;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.IoSummary;
import net.minecraft.util.profiling.jfr.stats.PacketIdentification;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;
import net.minecraft.util.profiling.jfr.stats.TimedStatSummary;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class JfrResultJsonSerializer {
    private static final String BYTES_PER_SECOND = "bytesPerSecond";
    private static final String COUNT = "count";
    private static final String DURATION_NANOS_TOTAL = "durationNanosTotal";
    private static final String TOTAL_BYTES = "totalBytes";
    private static final String COUNT_PER_SECOND = "countPerSecond";
    final Gson gson = new GsonBuilder().setPrettyPrinting().setLongSerializationPolicy(LongSerializationPolicy.DEFAULT).create();

    private static void serializePacketId(PacketIdentification packet, JsonObject json) {
        json.addProperty("protocolId", packet.protocolId());
        json.addProperty("packetId", packet.packetId());
    }

    private static void serializeChunkId(ChunkIdentification chunk, JsonObject json) {
        json.addProperty("level", chunk.level());
        json.addProperty("dimension", chunk.dimension());
        json.addProperty("x", (Number)chunk.x());
        json.addProperty("z", (Number)chunk.z());
    }

    public String format(JfrStatsResult profile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("startedEpoch", (Number)profile.recordingStarted().toEpochMilli());
        jsonObject.addProperty("endedEpoch", (Number)profile.recordingEnded().toEpochMilli());
        jsonObject.addProperty("durationMs", (Number)profile.recordingDuration().toMillis());
        Duration duration = profile.worldCreationDuration();
        if (duration != null) {
            jsonObject.addProperty("worldGenDurationMs", (Number)duration.toMillis());
        }
        jsonObject.add("heap", this.heap(profile.heapSummary()));
        jsonObject.add("cpuPercent", this.cpu(profile.cpuLoadStats()));
        jsonObject.add("network", this.network(profile));
        jsonObject.add("fileIO", this.fileIO(profile));
        jsonObject.add("serverTick", this.serverTicks(profile.tickTimes()));
        jsonObject.add("threadAllocation", this.threadAllocations(profile.threadAllocationSummary()));
        jsonObject.add("chunkGen", this.chunkGen(profile.chunkGenSummary()));
        return this.gson.toJson((JsonElement)jsonObject);
    }

    private JsonElement heap(GcHeapStat.Summary statistics) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("allocationRateBytesPerSecond", (Number)statistics.allocationRateBytesPerSecond());
        jsonObject.addProperty("gcCount", (Number)statistics.totalGCs());
        jsonObject.addProperty("gcOverHeadPercent", (Number)Float.valueOf(statistics.gcOverHead()));
        jsonObject.addProperty("gcTotalDurationMs", (Number)statistics.gcTotalDuration().toMillis());
        return jsonObject;
    }

    private JsonElement chunkGen(List<Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>>> statistics) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(DURATION_NANOS_TOTAL, (Number)statistics.stream().mapToDouble(pair -> ((TimedStatSummary)pair.getSecond()).totalDuration().toNanos()).sum());
        JsonArray jsonArray = Util.make(new JsonArray(), json -> jsonObject.add("status", (JsonElement)json));
        for (Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>> pair2 : statistics) {
            TimedStatSummary timedStatSummary = (TimedStatSummary)pair2.getSecond();
            JsonObject jsonObject2 = Util.make(new JsonObject(), arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            jsonObject2.addProperty("state", ((ChunkStatus)pair2.getFirst()).toString());
            jsonObject2.addProperty(COUNT, (Number)timedStatSummary.count());
            jsonObject2.addProperty(DURATION_NANOS_TOTAL, (Number)timedStatSummary.totalDuration().toNanos());
            jsonObject2.addProperty("durationNanosAvg", (Number)(timedStatSummary.totalDuration().toNanos() / (long)timedStatSummary.count()));
            JsonObject jsonObject3 = Util.make(new JsonObject(), json -> jsonObject2.add("durationNanosPercentiles", (JsonElement)json));
            timedStatSummary.percentilesNanos().forEach((quantile, value) -> jsonObject3.addProperty("p" + quantile, (Number)value));
            Function<ChunkGenStat, JsonElement> function = sample -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("durationNanos", (Number)sample.duration().toNanos());
                jsonObject.addProperty("level", sample.level());
                jsonObject.addProperty("chunkPosX", (Number)sample.chunkPos().x);
                jsonObject.addProperty("chunkPosZ", (Number)sample.chunkPos().z);
                jsonObject.addProperty("worldPosX", (Number)sample.worldPos().x());
                jsonObject.addProperty("worldPosZ", (Number)sample.worldPos().z());
                return jsonObject;
            };
            jsonObject2.add("fastest", function.apply((ChunkGenStat)timedStatSummary.fastest()));
            jsonObject2.add("slowest", function.apply((ChunkGenStat)timedStatSummary.slowest()));
            jsonObject2.add("secondSlowest", (JsonElement)(timedStatSummary.secondSlowest() != null ? function.apply((ChunkGenStat)timedStatSummary.secondSlowest()) : JsonNull.INSTANCE));
        }
        return jsonObject;
    }

    private JsonElement threadAllocations(ThreadAllocationStat.Summary statistics) {
        JsonArray jsonArray = new JsonArray();
        statistics.allocationsPerSecondByThread().forEach((threadName, allocation) -> jsonArray.add((JsonElement)Util.make(new JsonObject(), json -> {
            json.addProperty("thread", threadName);
            json.addProperty(BYTES_PER_SECOND, (Number)allocation);
        })));
        return jsonArray;
    }

    private JsonElement serverTicks(List<TickTimeStat> samples) {
        if (samples.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        double[] ds = samples.stream().mapToDouble(sample -> (double)sample.currentAverage().toNanos() / 1000000.0).toArray();
        DoubleSummaryStatistics doubleSummaryStatistics = DoubleStream.of(ds).summaryStatistics();
        jsonObject.addProperty("minMs", (Number)doubleSummaryStatistics.getMin());
        jsonObject.addProperty("averageMs", (Number)doubleSummaryStatistics.getAverage());
        jsonObject.addProperty("maxMs", (Number)doubleSummaryStatistics.getMax());
        Map<Integer, Double> map = Percentiles.evaluate(ds);
        map.forEach((quantile, value) -> jsonObject.addProperty("p" + quantile, (Number)value));
        return jsonObject;
    }

    private JsonElement fileIO(JfrStatsResult profile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("write", this.fileIoSummary(profile.fileWrites()));
        jsonObject.add("read", this.fileIoSummary(profile.fileReads()));
        jsonObject.add("chunksRead", this.ioSummary(profile.readChunks(), JfrResultJsonSerializer::serializeChunkId));
        jsonObject.add("chunksWritten", this.ioSummary(profile.writtenChunks(), JfrResultJsonSerializer::serializeChunkId));
        return jsonObject;
    }

    private JsonElement fileIoSummary(FileIOStat.Summary statistics) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(TOTAL_BYTES, (Number)statistics.totalBytes());
        jsonObject.addProperty(COUNT, (Number)statistics.counts());
        jsonObject.addProperty(BYTES_PER_SECOND, (Number)statistics.bytesPerSecond());
        jsonObject.addProperty(COUNT_PER_SECOND, (Number)statistics.countsPerSecond());
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("topContributors", (JsonElement)jsonArray);
        statistics.topTenContributorsByTotalBytes().forEach(pair -> {
            JsonObject jsonObject = new JsonObject();
            jsonArray.add((JsonElement)jsonObject);
            jsonObject.addProperty("path", (String)pair.getFirst());
            jsonObject.addProperty(TOTAL_BYTES, (Number)pair.getSecond());
        });
        return jsonObject;
    }

    private JsonElement network(JfrStatsResult profile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("sent", this.ioSummary(profile.sentPacketsSummary(), JfrResultJsonSerializer::serializePacketId));
        jsonObject.add("received", this.ioSummary(profile.receivedPacketsSummary(), JfrResultJsonSerializer::serializePacketId));
        return jsonObject;
    }

    private <T> JsonElement ioSummary(IoSummary<T> statistics, BiConsumer<T, JsonObject> callback) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(TOTAL_BYTES, (Number)statistics.getTotalSize());
        jsonObject.addProperty(COUNT, (Number)statistics.getTotalCount());
        jsonObject.addProperty(BYTES_PER_SECOND, (Number)statistics.getSizePerSecond());
        jsonObject.addProperty(COUNT_PER_SECOND, (Number)statistics.getCountsPerSecond());
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("topContributors", (JsonElement)jsonArray);
        statistics.largestSizeContributors().forEach(topContributor -> {
            JsonObject jsonObject = new JsonObject();
            jsonArray.add((JsonElement)jsonObject);
            Object object = topContributor.getFirst();
            IoSummary.CountAndSize countAndSize = (IoSummary.CountAndSize)topContributor.getSecond();
            callback.accept(object, jsonObject);
            jsonObject.addProperty(TOTAL_BYTES, (Number)countAndSize.totalSize());
            jsonObject.addProperty(COUNT, (Number)countAndSize.totalCount());
            jsonObject.addProperty("averageSize", (Number)Float.valueOf(countAndSize.averageSize()));
        });
        return jsonObject;
    }

    private JsonElement cpu(List<CpuLoadStat> samples) {
        JsonObject jsonObject = new JsonObject();
        BiFunction<List, ToDoubleFunction, JsonObject> biFunction = (samplesx, valueGetter) -> {
            JsonObject jsonObject = new JsonObject();
            DoubleSummaryStatistics doubleSummaryStatistics = samplesx.stream().mapToDouble(valueGetter).summaryStatistics();
            jsonObject.addProperty("min", (Number)doubleSummaryStatistics.getMin());
            jsonObject.addProperty("average", (Number)doubleSummaryStatistics.getAverage());
            jsonObject.addProperty("max", (Number)doubleSummaryStatistics.getMax());
            return jsonObject;
        };
        jsonObject.add("jvm", (JsonElement)biFunction.apply(samples, CpuLoadStat::jvm));
        jsonObject.add("userJvm", (JsonElement)biFunction.apply(samples, CpuLoadStat::userJvm));
        jsonObject.add("system", (JsonElement)biFunction.apply(samples, CpuLoadStat::system));
        return jsonObject;
    }
}

