/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.destroystokyo.paper.loottable.PaperLootableInventory;
import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.jetbrains.annotations.Contract;

public interface RandomizableContainer
extends Container {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";

    @Nullable
    public ResourceKey<LootTable> getLootTable();

    public void setLootTable(@Nullable ResourceKey<LootTable> var1);

    default public void setLootTable(@Nullable ResourceKey<LootTable> lootTableId, long lootTableSeed) {
        this.setLootTable(lootTableId);
        this.setLootTableSeed(lootTableSeed);
    }

    public long getLootTableSeed();

    public void setLootTableSeed(long var1);

    public BlockPos getBlockPos();

    @Nullable
    public Level getLevel();

    public static void setBlockEntityLootTable(BlockGetter world, RandomSource random, BlockPos pos, ResourceKey<LootTable> lootTableId) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RandomizableContainer) {
            RandomizableContainer randomizableContainer = (RandomizableContainer)((Object)blockEntity);
            randomizableContainer.setLootTable(lootTableId, random.nextLong());
        }
    }

    default public boolean tryLoadLootTable(CompoundTag nbt) {
        if (nbt.contains(LOOT_TABLE_TAG, 8)) {
            this.setLootTable(Optionull.map(ResourceLocation.tryParse(nbt.getString(LOOT_TABLE_TAG)), rl -> ResourceKey.create(Registries.LOOT_TABLE, rl)));
            if (this.lootableData() != null && this.getLootTable() != null) {
                this.lootableData().loadNbt(nbt);
            }
            if (nbt.contains(LOOT_TABLE_SEED_TAG, 4)) {
                this.setLootTableSeed(nbt.getLong(LOOT_TABLE_SEED_TAG));
            } else {
                this.setLootTableSeed(0L);
            }
            return this.lootableData() == null;
        }
        return false;
    }

    default public boolean trySaveLootTable(CompoundTag nbt) {
        long l;
        ResourceKey<LootTable> resourceKey = this.getLootTable();
        if (resourceKey == null) {
            return false;
        }
        nbt.putString(LOOT_TABLE_TAG, resourceKey.location().toString());
        if (this.lootableData() != null) {
            this.lootableData().saveNbt(nbt);
        }
        if ((l = this.getLootTableSeed()) != 0L) {
            nbt.putLong(LOOT_TABLE_SEED_TAG, l);
        }
        return this.lootableData() == null;
    }

    default public void unpackLootTable(@Nullable Player player) {
        this.unpackLootTable(player, false);
    }

    default public void unpackLootTable(@Nullable Player player, boolean forceClearLootTable) {
        Level level = this.getLevel();
        BlockPos blockPos = this.getBlockPos();
        ResourceKey<LootTable> resourceKey = this.getLootTable();
        if (resourceKey != null && level != null && level.getServer() != null) {
            if (this.lootableData() != null && !this.lootableData().shouldReplenish(this, PaperLootableInventoryData.CONTAINER, player)) {
                if (forceClearLootTable) {
                    this.setLootTable(null);
                }
            } else {
                LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(resourceKey);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.GENERATE_LOOT.trigger((ServerPlayer)player, resourceKey);
                }
                if (forceClearLootTable || this.lootableData() == null || this.lootableData().shouldClearLootTable(this, PaperLootableInventoryData.CONTAINER, player)) {
                    this.setLootTable(null);
                }
                LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockPos));
                if (player != null) {
                    builder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, player);
                }
                lootTable.fill(this, builder.create(LootContextParamSets.CHEST), this.getLootTableSeed());
            }
        }
    }

    @Nullable
    @Contract(pure=true)
    default public PaperLootableInventoryData lootableData() {
        return null;
    }

    default public PaperLootableInventory getLootableInventory() {
        CraftBlock block = CraftBlock.at(Objects.requireNonNull(this.getLevel(), "Cannot manage loot tables on block entities not in world"), this.getBlockPos());
        return (PaperLootableInventory)block.getState(false);
    }
}

