/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import io.papermc.paper.adventure.PaperAdventure;
import javax.annotation.Nullable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.purpurmc.purpur.PurpurConfig;

public class DamageSource {
    private final Holder<DamageType> type;
    @Nullable
    private final Entity causingEntity;
    @Nullable
    private final Entity directEntity;
    @Nullable
    private final Vec3 damageSourcePosition;
    @Nullable
    private Block directBlock;
    @Nullable
    private BlockState directBlockState;
    private boolean sweep = false;
    private boolean melting = false;
    private boolean poison = false;
    private boolean scissors = false;
    private boolean stonecutter = false;
    @Nullable
    private Entity customEventDamager = null;
    private boolean critical;

    public DamageSource sweep() {
        this.sweep = true;
        return this;
    }

    public boolean isSweep() {
        return this.sweep;
    }

    public DamageSource melting() {
        this.melting = true;
        return this;
    }

    public boolean isMelting() {
        return this.melting;
    }

    public DamageSource poison() {
        this.poison = true;
        return this;
    }

    public boolean isPoison() {
        return this.poison;
    }

    public DamageSource scissors() {
        this.scissors = true;
        return this;
    }

    public boolean isScissors() {
        return this.scissors;
    }

    public DamageSource stonecutter() {
        this.stonecutter = true;
        return this;
    }

    public boolean isStonecutter() {
        return this.stonecutter;
    }

    @Nullable
    public Entity getCustomEventDamager() {
        return this.customEventDamager != null ? this.customEventDamager : this.directEntity;
    }

    public DamageSource customEventDamager(Entity entity) {
        if (this.directEntity != null) {
            throw new IllegalStateException("Cannot set custom event damager when direct entity is already set (report a bug to Paper)");
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.customEventDamager = entity;
        return damageSource;
    }

    public Block getDirectBlock() {
        return this.directBlock;
    }

    public DamageSource directBlock(Level world, BlockPos blockPosition) {
        if (blockPosition == null || world == null) {
            return this;
        }
        return this.directBlock(CraftBlock.at(world, blockPosition));
    }

    public DamageSource directBlock(Block block) {
        if (block == null) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.directBlock = block;
        return damageSource;
    }

    public BlockState getDirectBlockState() {
        return this.directBlockState;
    }

    public DamageSource directBlockState(BlockState blockState) {
        if (blockState == null) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.directBlockState = blockState;
        return damageSource;
    }

    private DamageSource cloneInstance() {
        DamageSource damageSource = new DamageSource(this.type, this.directEntity, this.causingEntity, this.damageSourcePosition);
        damageSource.directBlock = this.getDirectBlock();
        damageSource.directBlockState = this.getDirectBlockState();
        damageSource.sweep = this.isSweep();
        damageSource.poison = this.isPoison();
        damageSource.melting = this.isMelting();
        damageSource.scissors = this.isScissors();
        damageSource.stonecutter = this.isStonecutter();
        return damageSource;
    }

    public String toString() {
        return "DamageSource (" + this.type().msgId() + ")";
    }

    public float getFoodExhaustion() {
        return this.type().exhaustion();
    }

    public boolean isDirect() {
        return this.causingEntity == this.directEntity;
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity source, @Nullable Entity attacker, @Nullable Vec3 position) {
        this.type = type;
        this.causingEntity = attacker;
        this.directEntity = source;
        this.damageSourcePosition = position;
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity source, @Nullable Entity attacker) {
        this(type, source, attacker, null);
    }

    public DamageSource(Holder<DamageType> type, Vec3 position) {
        this(type, null, null, position);
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity attacker) {
        this(type, attacker, attacker);
    }

    public DamageSource(Holder<DamageType> type) {
        this(type, null, null, null);
    }

    @Nullable
    public Entity getDirectEntity() {
        return this.directEntity;
    }

    @Nullable
    public Entity getEntity() {
        return this.causingEntity;
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return this.directEntity != null ? this.directEntity.getWeaponItem() : null;
    }

    public Component getLocalizedDeathMessage(LivingEntity killed) {
        ItemStack itemstack;
        String s = "death.attack." + this.type().msgId();
        if (this.causingEntity == null && this.directEntity == null) {
            LivingEntity entityliving1 = killed.getKillCredit();
            String s1 = s + ".player";
            return entityliving1 != null ? Component.translatable(s1, killed.getDisplayName(), entityliving1.getDisplayName()) : Component.translatable(s, killed.getDisplayName());
        }
        Component ichatbasecomponent = this.causingEntity == null ? this.directEntity.getDisplayName() : this.causingEntity.getDisplayName();
        Entity entity = this.causingEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity entityliving2 = (LivingEntity)entity;
            itemstack = entityliving2.getMainHandItem();
        } else {
            itemstack = ItemStack.EMPTY;
        }
        ItemStack itemstack1 = itemstack;
        return !itemstack1.isEmpty() && (PurpurConfig.playerDeathsAlwaysShowItem || itemstack1.has(DataComponents.CUSTOM_NAME)) ? Component.translatable(s + ".item", killed.getDisplayName(), ichatbasecomponent, itemstack1.getDisplayName()) : Component.translatable(s, killed.getDisplayName(), ichatbasecomponent);
    }

    public Component getLocalizedDeathMessage(String str, LivingEntity entity) {
        net.kyori.adventure.text.Component name = PaperAdventure.asAdventure(entity.getDisplayName());
        TagResolver.Single template = Placeholder.component((String)"player", (ComponentLike)name);
        net.kyori.adventure.text.Component component = MiniMessage.miniMessage().deserialize(str, (TagResolver)template);
        return PaperAdventure.asVanilla(component);
    }

    public String getMsgId() {
        return this.type().msgId();
    }

    public boolean scalesWithDifficulty() {
        return switch (this.type().scaling()) {
            case DamageScaling.NEVER -> false;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> this.causingEntity instanceof LivingEntity && !(this.causingEntity instanceof Player);
            case DamageScaling.ALWAYS -> true;
            default -> throw new MatchException(null, null);
        };
    }

    public boolean isCreativePlayer() {
        Entity entity = this.getEntity();
        if (entity instanceof Player) {
            Player entityhuman = (Player)entity;
            if (entityhuman.getAbilities().instabuild) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    @Nullable
    public Vec3 getSourcePosition() {
        return this.damageSourcePosition != null ? this.damageSourcePosition : (this.directEntity != null ? this.directEntity.position() : null);
    }

    @Nullable
    public Vec3 sourcePositionRaw() {
        return this.damageSourcePosition;
    }

    public boolean is(TagKey<DamageType> tag) {
        return this.type.is(tag);
    }

    public boolean is(ResourceKey<DamageType> typeKey) {
        return this.type.is(typeKey);
    }

    public DamageType type() {
        return this.type.value();
    }

    public Holder<DamageType> typeHolder() {
        return this.type;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public DamageSource critical() {
        return this.critical(true);
    }

    public DamageSource critical(boolean critical) {
        this.critical = critical;
        return this;
    }
}

