/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class AreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TIME_BETWEEN_APPLICATIONS = 5;
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(AreaEffectCloud.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.defineId(AreaEffectCloud.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.defineId(AreaEffectCloud.class, EntityDataSerializers.PARTICLE);
    private static final float MAX_RADIUS = 32.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    public PotionContents potionContents = PotionContents.EMPTY;
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    public int waitTime = 20;
    public int reapplicationDelay = 20;
    public int durationOnUse;
    public float radiusOnUse;
    public float radiusPerTick;
    @Nullable
    private LivingEntity owner;
    @Nullable
    public UUID ownerUUID;

    public AreaEffectCloud(EntityType<? extends AreaEffectCloud> type, Level world) {
        super(type, world);
        this.noPhysics = true;
    }

    public AreaEffectCloud(Level world, double x, double y, double z) {
        this((EntityType<? extends AreaEffectCloud>)EntityType.AREA_EFFECT_CLOUD, world);
        this.setPos(x, y, z);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_RADIUS, Float.valueOf(3.0f));
        builder.define(DATA_WAITING, false);
        builder.define(DATA_PARTICLE, ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, -1));
    }

    public void setRadius(float radius) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, Float.valueOf(Mth.clamp(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public float getRadius() {
        return this.getEntityData().get(DATA_RADIUS).floatValue();
    }

    public void setPotionContents(PotionContents potionContentsComponent) {
        this.potionContents = potionContentsComponent;
        this.updateColor();
    }

    public void updateColor() {
        ParticleOptions particleparam = this.entityData.get(DATA_PARTICLE);
        if (particleparam instanceof ColorParticleOption) {
            ColorParticleOption colorparticleoption = (ColorParticleOption)particleparam;
            int i = this.potionContents.equals(PotionContents.EMPTY) ? 0 : this.potionContents.getColor();
            this.entityData.set(DATA_PARTICLE, ColorParticleOption.create(colorparticleoption.getType(), FastColor.ARGB32.opaque(i)));
        }
    }

    public void addEffect(MobEffectInstance effect) {
        this.setPotionContents(this.potionContents.withEffectAdded(effect));
    }

    public ParticleOptions getParticle() {
        return this.getEntityData().get(DATA_PARTICLE);
    }

    public void setParticle(ParticleOptions particle) {
        this.getEntityData().set(DATA_PARTICLE, particle);
    }

    protected void setWaiting(boolean waiting) {
        this.getEntityData().set(DATA_WAITING, waiting);
    }

    public boolean isWaiting() {
        return this.getEntityData().get(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.tickCount >= this.waitTime + this.duration) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
    }

    @Override
    public void tick() {
        block22: {
            float f;
            block23: {
                boolean flag1;
                boolean flag;
                block21: {
                    float f1;
                    int i;
                    super.tick();
                    flag = this.isWaiting();
                    f = this.getRadius();
                    if (!this.level().isClientSide) break block21;
                    if (flag && this.random.nextBoolean()) {
                        return;
                    }
                    ParticleOptions particleparam = this.getParticle();
                    if (flag) {
                        i = 2;
                        f1 = 0.2f;
                    } else {
                        i = Mth.ceil((float)Math.PI * f * f);
                        f1 = f;
                    }
                    for (int j = 0; j < i; ++j) {
                        float f2 = this.random.nextFloat() * ((float)Math.PI * 2);
                        float f3 = Mth.sqrt(this.random.nextFloat()) * f1;
                        double d0 = this.getX() + (double)(Mth.cos(f2) * f3);
                        double d1 = this.getY();
                        double d2 = this.getZ() + (double)(Mth.sin(f2) * f3);
                        if (particleparam.getType() == ParticleTypes.ENTITY_EFFECT) {
                            if (flag && this.random.nextBoolean()) {
                                this.level().addAlwaysVisibleParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, -1), d0, d1, d2, 0.0, 0.0, 0.0);
                                continue;
                            }
                            this.level().addAlwaysVisibleParticle(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                            continue;
                        }
                        if (flag) {
                            this.level().addAlwaysVisibleParticle(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                            continue;
                        }
                        this.level().addAlwaysVisibleParticle(particleparam, d0, d1, d2, (0.5 - this.random.nextDouble()) * 0.15, 0.01f, (0.5 - this.random.nextDouble()) * 0.15);
                    }
                    break block22;
                }
                if (this.tickCount >= this.waitTime + this.duration) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
                boolean bl = flag1 = this.tickCount < this.waitTime;
                if (flag != flag1) {
                    this.setWaiting(flag1);
                }
                if (flag1) {
                    return;
                }
                if (this.radiusPerTick != 0.0f) {
                    if ((f += this.radiusPerTick) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.setRadius(f);
                }
                if (this.tickCount % 5 != 0) break block22;
                this.victims.entrySet().removeIf(entry -> this.tickCount >= (Integer)entry.getValue());
                if (this.potionContents.hasEffects()) break block23;
                this.victims.clear();
                break block22;
            }
            ArrayList list = Lists.newArrayList();
            if (this.potionContents.potion().isPresent()) {
                for (MobEffectInstance mobeffect : this.potionContents.potion().get().value().getEffects()) {
                    list.add(new MobEffectInstance(mobeffect.getEffect(), mobeffect.mapDuration(k -> k / 4), mobeffect.getAmplifier(), mobeffect.isAmbient(), mobeffect.isVisible()));
                }
            }
            list.addAll(this.potionContents.customEffects());
            List<LivingEntity> list1 = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox());
            if (list1.isEmpty()) break block22;
            Iterator<LivingEntity> iterator1 = list1.iterator();
            ArrayList<org.bukkit.entity.LivingEntity> entities = new ArrayList<org.bukkit.entity.LivingEntity>();
            while (iterator1.hasNext()) {
                double d4;
                double d3;
                double d5;
                LivingEntity entityliving = iterator1.next();
                if (this.victims.containsKey(entityliving) || !entityliving.isAffectedByPotions()) continue;
                Stream stream = list.stream();
                Objects.requireNonNull(entityliving);
                if (stream.noneMatch(entityliving::canBeAffected) || !((d5 = (d3 = entityliving.getX() - this.getX()) * d3 + (d4 = entityliving.getZ() - this.getZ()) * d4) <= (double)(f * f))) continue;
                entities.add((org.bukkit.entity.LivingEntity)entityliving.getBukkitEntity());
            }
            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
            if (!event.isCancelled()) {
                for (org.bukkit.entity.LivingEntity entity : event.getAffectedEntities()) {
                    if (!(entity instanceof CraftLivingEntity)) continue;
                    LivingEntity entityliving = ((CraftLivingEntity)entity).getHandle();
                    this.victims.put(entityliving, this.tickCount + this.reapplicationDelay);
                    for (MobEffectInstance mobeffect1 : list) {
                        if (mobeffect1.getEffect().value().isInstantenous()) {
                            mobeffect1.getEffect().value().applyInstantenousEffect(this, this.getOwner(), entityliving, mobeffect1.getAmplifier(), 0.5);
                            continue;
                        }
                        entityliving.addEffect(new MobEffectInstance(mobeffect1), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                    }
                    if (this.radiusOnUse != 0.0f) {
                        if ((f += this.radiusOnUse) < 0.5f) {
                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                            return;
                        }
                        this.setRadius(f);
                    }
                    if (this.durationOnUse == 0) continue;
                    this.duration += this.durationOnUse;
                    if (this.duration > 0) continue;
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float radiusOnUse) {
        this.radiusOnUse = radiusOnUse;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float radiusGrowth) {
        this.radiusPerTick = radiusGrowth;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int durationOnUse) {
        this.durationOnUse = durationOnUse;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.tickCount = nbt.getInt("Age");
        this.duration = nbt.getInt("Duration");
        this.waitTime = nbt.getInt("WaitTime");
        this.reapplicationDelay = nbt.getInt("ReapplicationDelay");
        this.durationOnUse = nbt.getInt("DurationOnUse");
        this.radiusOnUse = nbt.getFloat("RadiusOnUse");
        this.radiusPerTick = nbt.getFloat("RadiusPerTick");
        this.setRadius(nbt.getFloat("Radius"));
        if (nbt.hasUUID("Owner")) {
            this.ownerUUID = nbt.getUUID("Owner");
        }
        RegistryOps<Tag> registryops = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        if (nbt.contains("Particle", 10)) {
            ParticleTypes.CODEC.parse(registryops, (Object)nbt.get("Particle")).resultOrPartial(s -> LOGGER.warn("Failed to parse area effect cloud particle options: '{}'", s)).ifPresent(this::setParticle);
        }
        if (nbt.contains("potion_contents")) {
            PotionContents.CODEC.parse(registryops, (Object)nbt.get("potion_contents")).resultOrPartial(s -> LOGGER.warn("Failed to parse area effect cloud potions: '{}'", s)).ifPresent(this::setPotionContents);
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putInt("Age", this.tickCount);
        nbt.putInt("Duration", this.duration);
        nbt.putInt("WaitTime", this.waitTime);
        nbt.putInt("ReapplicationDelay", this.reapplicationDelay);
        nbt.putInt("DurationOnUse", this.durationOnUse);
        nbt.putFloat("RadiusOnUse", this.radiusOnUse);
        nbt.putFloat("RadiusPerTick", this.radiusPerTick);
        nbt.putFloat("Radius", this.getRadius());
        RegistryOps<Tag> registryops = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        nbt.put("Particle", (Tag)ParticleTypes.CODEC.encodeStart(registryops, (Object)this.getParticle()).getOrThrow());
        if (this.ownerUUID != null) {
            nbt.putUUID("Owner", this.ownerUUID);
        }
        if (!this.potionContents.equals(PotionContents.EMPTY)) {
            Tag nbtbase = (Tag)PotionContents.CODEC.encodeStart(registryops, (Object)this.potionContents).getOrThrow();
            nbt.put("potion_contents", nbtbase);
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_RADIUS.equals(data)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(data);
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable(this.getRadius() * 2.0f, 0.5f);
    }
}

