/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerEntity;
import com.destroystokyo.paper.event.entity.EntityTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import gg.pufferfish.pufferfish.PufferfishConfig;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import io.papermc.paper.event.player.PlayerUntrackEntityEvent;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndGatewayBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftEndGateway;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.event.CraftPortalEvent;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;

public abstract class Entity
implements SyncedDataHolder,
Nameable,
EntityAccess,
CommandSource,
ScoreHolder,
ChunkSystemEntity,
EntityTrackerEntity {
    public static ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("rhino");
    private static final int CURRENT_LEVEL = 2;
    public boolean preserveMotion = true;
    public static RandomSource SHARED_RANDOM = new RandomRandomSource();
    public CreatureSpawnEvent.SpawnReason spawnReason;
    public boolean collisionLoadChunks = false;
    private CraftEntity bukkitEntity;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String ID_TAG = "id";
    public static final String PASSENGERS_TAG = "Passengers";
    private static final AtomicInteger ENTITY_COUNTER = new AtomicInteger();
    public static final int CONTENTS_SLOT_INDEX = 0;
    public static final int BOARDING_COOLDOWN = 60;
    public static final int TOTAL_AIR_SUPPLY = 300;
    public static final int MAX_ENTITY_TAG_COUNT = 1024;
    public static final float DELTA_AFFECTED_BY_BLOCKS_BELOW_0_2 = 0.2f;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_0_5 = 0.500001;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_1_0 = 0.999999;
    public static final int BASE_TICKS_REQUIRED_TO_FREEZE = 140;
    public static final int FREEZE_HURT_FREQUENCY = 40;
    public static final int BASE_SAFE_FALL_DISTANCE = 3;
    private static final AABB INITIAL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double WATER_FLOW_SCALE = 0.014;
    private static final double LAVA_FAST_FLOW_SCALE = 0.007;
    private static final double LAVA_SLOW_FLOW_SCALE = 0.0023333333333333335;
    public static final String UUID_TAG = "UUID";
    private static double viewScale = 1.0;
    private final EntityType<?> type;
    private int id;
    public boolean blocksBuilding;
    public ImmutableList<Entity> passengers;
    protected int boardingCooldown;
    @javax.annotation.Nullable
    private Entity vehicle;
    private Level level;
    public double xo;
    public double yo;
    public double zo;
    private Vec3 position;
    private BlockPos blockPosition;
    private ChunkPos chunkPosition;
    private Vec3 deltaMovement;
    private float yRot;
    private float xRot;
    public float yRotO;
    public float xRotO;
    private AABB bb;
    public boolean onGround;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean verticalCollisionBelow;
    public boolean minorHorizontalCollision;
    public boolean hurtMarked;
    protected Vec3 stuckSpeedMultiplier;
    @javax.annotation.Nullable
    private RemovalReason removalReason;
    public static final float DEFAULT_BB_WIDTH = 0.6f;
    public static final float DEFAULT_BB_HEIGHT = 1.8f;
    public float walkDistO;
    public float walkDist;
    public float moveDist;
    public float flyDist;
    public float fallDistance;
    private float nextStep = 1.0f;
    public double xOld;
    public double yOld;
    public double zOld;
    public float maxUpStep;
    public boolean noPhysics;
    public final RandomSource random;
    public int tickCount;
    private int remainingFireTicks;
    public boolean wasTouchingWater;
    protected Object2DoubleMap<TagKey<Fluid>> fluidHeight;
    protected boolean wasEyeInWater;
    private final Set<TagKey<Fluid>> fluidOnEyes;
    public int invulnerableTime;
    protected boolean firstTick;
    protected final SynchedEntityData entityData;
    protected static final EntityDataAccessor<Byte> DATA_SHARED_FLAGS_ID = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BYTE);
    protected static final int FLAG_ONFIRE = 0;
    private static final int FLAG_SHIFT_KEY_DOWN = 1;
    private static final int FLAG_SPRINTING = 3;
    private static final int FLAG_SWIMMING = 4;
    public static final int FLAG_INVISIBLE = 5;
    protected static final int FLAG_GLOWING = 6;
    protected static final int FLAG_FALL_FLYING = 7;
    private static final EntityDataAccessor<Integer> DATA_AIR_SUPPLY_ID = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<net.minecraft.network.chat.Component>> DATA_CUSTOM_NAME = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.OPTIONAL_COMPONENT);
    private static final EntityDataAccessor<Boolean> DATA_CUSTOM_NAME_VISIBLE = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SILENT = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_NO_GRAVITY = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Pose> DATA_POSE = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.POSE);
    private static final EntityDataAccessor<Integer> DATA_TICKS_FROZEN = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.INT);
    private EntityInLevelCallback levelCallback;
    private final VecDeltaCodec packetPositionCodec;
    public boolean noCulling;
    public boolean hasImpulse;
    @javax.annotation.Nullable
    public PortalProcessor portalProcess;
    public int portalCooldown;
    private boolean invulnerable;
    protected UUID uuid;
    protected String stringUUID;
    private boolean hasGlowingTag;
    private final Set<String> tags;
    private final double[] pistonDeltas;
    private long pistonDeltasGameTime;
    protected EntityDimensions dimensions;
    private float eyeHeight;
    public boolean isInPowderSnow;
    public boolean wasInPowderSnow;
    public boolean wasOnFire;
    public Optional<BlockPos> mainSupportingBlockPos;
    private boolean onGroundNoBlocks;
    private float crystalSoundIntensity;
    private int lastCrystalSoundPlayTick;
    public boolean hasVisualFire;
    @javax.annotation.Nullable
    private BlockState inBlockState;
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    @javax.annotation.Nullable
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPos lastLavaContact;
    public boolean pluginRemoved = false;
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    protected int numCollisions = 0;
    public boolean fromNetherPortal;
    public long activatedImmunityTick = Integer.MIN_VALUE;
    public boolean isTemporarilyActive;
    public boolean spawnedViaMobSpawner;
    @javax.annotation.Nullable
    private Vector origin;
    @javax.annotation.Nullable
    private UUID originWorld;
    public boolean freezeLocked = false;
    public boolean fixedPose = false;
    public boolean activatedPriorityReset = false;
    public int activatedPriority = PufferfishConfig.maximumActivationPrio;
    public final BlockPos.MutableBlockPos cachedBlockPos = new BlockPos.MutableBlockPos();
    @javax.annotation.Nullable
    public Boolean immuneToFire = null;
    private final boolean isHardColliding = this.moonrise$isHardCollidingUncached();
    private FullChunkStatus chunkStatus;
    private int sectionX = Integer.MIN_VALUE;
    private int sectionY = Integer.MIN_VALUE;
    private int sectionZ = Integer.MIN_VALUE;
    private boolean updatingSectionStatus;
    private ChunkMap.TrackedEntity trackedEntity;
    public final Object posLock = new Object();
    private Vec3 moveVector;
    private double moveStartX;
    private double moveStartY;
    private double moveStartZ;
    public BlockPos portalPos = BlockPos.ZERO;
    @javax.annotation.Nullable
    private Player rider = null;

    static boolean isLevelAtLeast(CompoundTag tag, int level) {
        return tag.contains("Bukkit.updateLevel") && tag.getInt("Bukkit.updateLevel") >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            Entity entity = this;
            synchronized (entity) {
                if (this.bukkitEntity == null) {
                    this.bukkitEntity = CraftEntity.getEntity(this.level.getCraftServer(), this);
                    return this.bukkitEntity;
                }
            }
        }
        return this.bukkitEntity;
    }

    public CraftEntity getBukkitEntityRaw() {
        return this.bukkitEntity;
    }

    @Override
    public CommandSender getBukkitSender(CommandSourceStack wrapper) {
        return this.getBukkitEntity();
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public void setOrigin(@Nonnull Location location) {
        this.origin = location.toVector();
        this.originWorld = location.getWorld().getUID();
    }

    @javax.annotation.Nullable
    public Vector getOriginVector() {
        return this.origin != null ? this.origin.clone() : null;
    }

    @javax.annotation.Nullable
    public UUID getOriginWorld() {
        return this.originWorld;
    }

    public float getBukkitYaw() {
        return this.yRot;
    }

    public boolean isChunkLoaded() {
        return this.level.hasChunk((int)Math.floor(this.getX()) >> 4, (int)Math.floor(this.getZ()) >> 4);
    }

    public final AABB getBoundingBoxAt(double x, double y, double z) {
        return this.dimensions.makeBoundingBox(x, y, z);
    }

    @Override
    public final boolean moonrise$isHardColliding() {
        return this.isHardColliding;
    }

    @Override
    public final FullChunkStatus moonrise$getChunkStatus() {
        return this.chunkStatus;
    }

    @Override
    public final void moonrise$setChunkStatus(FullChunkStatus status) {
        this.chunkStatus = status;
    }

    @Override
    public final int moonrise$getSectionX() {
        return this.sectionX;
    }

    @Override
    public final void moonrise$setSectionX(int x) {
        this.sectionX = x;
    }

    @Override
    public final int moonrise$getSectionY() {
        return this.sectionY;
    }

    @Override
    public final void moonrise$setSectionY(int y) {
        this.sectionY = y;
    }

    @Override
    public final int moonrise$getSectionZ() {
        return this.sectionZ;
    }

    @Override
    public final void moonrise$setSectionZ(int z) {
        this.sectionZ = z;
    }

    @Override
    public final boolean moonrise$isUpdatingSectionStatus() {
        return this.updatingSectionStatus;
    }

    @Override
    public final void moonrise$setUpdatingSectionStatus(boolean to) {
        this.updatingSectionStatus = to;
    }

    @Override
    public final boolean moonrise$hasAnyPlayerPassengers() {
        if (this.passengers.isEmpty()) {
            return false;
        }
        return this.getIndirectPassengersStream().anyMatch(entity -> entity instanceof Player);
    }

    @Override
    public final ChunkMap.TrackedEntity moonrise$getTrackedEntity() {
        return this.trackedEntity;
    }

    @Override
    public final void moonrise$setTrackedEntity(ChunkMap.TrackedEntity trackedEntity) {
        this.trackedEntity = trackedEntity;
    }

    private static void collectIndirectPassengers(List<Entity> into, List<Entity> from) {
        for (Entity passenger : from) {
            into.add(passenger);
            Entity.collectIndirectPassengers(into, passenger.passengers);
        }
    }

    public boolean canSaveToDisk() {
        return true;
    }

    public boolean isSunBurnTick() {
        if (this.level().isDay() && !this.level().isClientSide) {
            boolean flag;
            float f = this.getLightLevelDependentMagicValue();
            BlockPos blockposition = BlockPos.containing(this.getX(), this.getEyeY(), this.getZ());
            boolean bl = flag = this.isInWaterRainOrBubble() || this.isInPowderSnow || this.wasInPowderSnow;
            if (f > 0.5f && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && !flag && this.level().canSeeSky(blockposition)) {
                return true;
            }
        }
        return false;
    }

    public Entity(EntityType<?> type, Level world) {
        this.id = ENTITY_COUNTER.incrementAndGet();
        this.passengers = ImmutableList.of();
        this.deltaMovement = Vec3.ZERO;
        this.bb = INITIAL_AABB;
        this.stuckSpeedMultiplier = Vec3.ZERO;
        this.random = world == null || world.purpurConfig.entitySharedRandom ? SHARED_RANDOM : RandomSource.create();
        this.remainingFireTicks = -this.getFireImmuneTicks();
        this.fluidHeight = new Object2DoubleArrayMap(2);
        this.fluidOnEyes = new HashSet<TagKey<Fluid>>();
        this.firstTick = true;
        this.levelCallback = EntityInLevelCallback.NULL;
        this.packetPositionCodec = new VecDeltaCodec();
        this.uuid = Mth.createInsecureUUID(this.random);
        this.stringUUID = this.uuid.toString();
        this.tags = Sets.newHashSet();
        this.pistonDeltas = new double[]{0.0, 0.0, 0.0};
        this.mainSupportingBlockPos = Optional.empty();
        this.onGroundNoBlocks = false;
        this.inBlockState = null;
        this.type = type;
        this.level = world;
        this.dimensions = type.getDimensions();
        this.position = Vec3.ZERO;
        this.blockPosition = BlockPos.ZERO;
        this.chunkPosition = ChunkPos.ZERO;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        SynchedEntityData.Builder datawatcher_a = new SynchedEntityData.Builder(this);
        datawatcher_a.define(DATA_SHARED_FLAGS_ID, (byte)0);
        datawatcher_a.define(DATA_AIR_SUPPLY_ID, this.getMaxAirSupply());
        datawatcher_a.define(DATA_CUSTOM_NAME_VISIBLE, false);
        datawatcher_a.define(DATA_CUSTOM_NAME, Optional.empty());
        datawatcher_a.define(DATA_SILENT, false);
        datawatcher_a.define(DATA_NO_GRAVITY, false);
        datawatcher_a.define(DATA_POSE, Pose.STANDING);
        datawatcher_a.define(DATA_TICKS_FROZEN, 0);
        this.defineSynchedData(datawatcher_a);
        this.entityData = datawatcher_a.build();
        this.setPos(0.0, 0.0, 0.0);
        this.eyeHeight = this.dimensions.eyeHeight();
    }

    public boolean isColliding(BlockPos pos, BlockState state) {
        VoxelShape voxelshape = state.getCollisionShape(this.level(), pos, CollisionContext.of(this));
        VoxelShape voxelshape1 = voxelshape.move(pos.getX(), pos.getY(), pos.getZ());
        return Shapes.joinIsNotEmpty(voxelshape1, Shapes.create(this.getBoundingBox()), BooleanOp.AND);
    }

    public int getTeamColor() {
        PlayerTeam scoreboardteam = this.getTeam();
        return scoreboardteam != null && scoreboardteam.getColor().getColor() != null ? scoreboardteam.getColor().getColor() : 0xFFFFFF;
    }

    public boolean isSpectator() {
        return false;
    }

    public final void unRide() {
        if (this.isVehicle()) {
            this.ejectPassengers();
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void syncPacketPositionCodec(double x, double y, double z) {
        this.packetPositionCodec.setBase(new Vec3(x, y, z));
    }

    public VecDeltaCodec getPositionCodec() {
        return this.packetPositionCodec;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean addTag(String tag) {
        return this.tags.size() >= 1024 ? false : this.tags.add(tag);
    }

    public boolean removeTag(String tag) {
        return this.tags.remove(tag);
    }

    public void kill() {
        this.remove(RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    public final void discard() {
        this.discard(null);
    }

    public final void discard(EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.DISCARDED, cause);
    }

    protected abstract void defineSynchedData(SynchedEntityData.Builder var1);

    public SynchedEntityData getEntityData() {
        return this.entityData;
    }

    public void refreshEntityData(ServerPlayer to) {
        List<SynchedEntityData.DataValue<?>> list = this.entityData.packAll();
        if (list != null && to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            to.connection.send(new ClientboundSetEntityDataPacket(this.getId(), list));
        }
    }

    public void resendPossiblyDesyncedEntityData(ServerPlayer player) {
        if (player.getBukkitEntity().canSee(this.getBukkitEntity())) {
            ChunkMap.TrackedEntity tracker;
            ServerLevel world = (ServerLevel)this.level();
            ChunkMap.TrackedEntity trackedEntity = tracker = world == null ? null : (ChunkMap.TrackedEntity)world.getChunkSource().chunkMap.entityMap.get(this.getId());
            if (tracker == null) {
                return;
            }
            ServerEntity serverEntity = tracker.serverEntity;
            ArrayList<Packet<? super ClientGamePacketListener>> list = new ArrayList<Packet<? super ClientGamePacketListener>>();
            serverEntity.sendPairingData(player, list::add);
            player.connection.send(new ClientboundBundlePacket((Iterable<Packet<? super ClientGamePacketListener>>)list));
        }
    }

    public void resendPossiblyDesyncedDataValues(List<EntityDataAccessor<?>> keys, ServerPlayer to) {
        if (!to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            return;
        }
        ArrayList values = new ArrayList(keys.size());
        for (EntityDataAccessor<?> key : keys) {
            SynchedEntityData.DataItem<?> synchedValue = this.entityData.getItem(key);
            values.add(synchedValue.value());
        }
        to.connection.send(new ClientboundSetEntityDataPacket(this.id, values));
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).id == this.id : false;
    }

    public int hashCode() {
        return this.id;
    }

    public void remove(RemovalReason reason) {
        this.setRemoved(reason, null);
    }

    public void remove(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.setRemoved(entity_removalreason, cause);
    }

    public void onClientRemoval() {
    }

    public void setPose(Pose pose) {
        if (this.fixedPose) {
            return;
        }
        if (pose == this.getPose()) {
            return;
        }
        if (!this.generation) {
            this.level.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), org.bukkit.entity.Pose.values()[pose.ordinal()]));
        }
        this.entityData.set(DATA_POSE, pose);
    }

    public Pose getPose() {
        return this.entityData.get(DATA_POSE);
    }

    public boolean hasPose(Pose pose) {
        return this.getPose() == pose;
    }

    public boolean closerThan(Entity entity, double radius) {
        return this.position().closerThan(entity.position(), radius);
    }

    public boolean closerThan(Entity entity, double horizontalRadius, double verticalRadius) {
        double d2 = entity.getX() - this.getX();
        double d3 = entity.getY() - this.getY();
        double d4 = entity.getZ() - this.getZ();
        return Mth.lengthSquared(d2, d4) < Mth.square(horizontalRadius) && Mth.square(d3) < Mth.square(verticalRadius);
    }

    public void setRot(float yaw, float pitch) {
        if (Float.isNaN(yaw)) {
            yaw = 0.0f;
        }
        if (yaw == Float.POSITIVE_INFINITY || yaw == Float.NEGATIVE_INFINITY) {
            if (this instanceof ServerPlayer) {
                this.level.getCraftServer().getLogger().warning(this.getScoreboardName() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            yaw = 0.0f;
        }
        if (Float.isNaN(pitch)) {
            pitch = 0.0f;
        }
        if (pitch == Float.POSITIVE_INFINITY || pitch == Float.NEGATIVE_INFINITY) {
            if (this instanceof ServerPlayer) {
                this.level.getCraftServer().getLogger().warning(this.getScoreboardName() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            pitch = 0.0f;
        }
        this.setYRot(yaw % 360.0f);
        this.setXRot(pitch % 360.0f);
    }

    public final void setPos(Vec3 pos) {
        this.setPos(pos.x(), pos.y(), pos.z());
    }

    public void setPos(double x, double y, double z) {
        this.setPosRaw(x, y, z, true);
    }

    protected AABB makeBoundingBox() {
        return this.dimensions.makeBoundingBox(this.position);
    }

    protected void reapplyPosition() {
        this.setPos(this.position.x, this.position.y, this.position.z);
    }

    public void turn(double cursorDeltaX, double cursorDeltaY) {
        float f = (float)cursorDeltaY * 0.15f;
        float f1 = (float)cursorDeltaX * 0.15f;
        this.setXRot(this.getXRot() + f);
        this.setYRot(this.getYRot() + f1);
        this.setXRot(Mth.clamp(this.getXRot(), -90.0f, 90.0f));
        this.xRotO += f;
        this.yRotO += f1;
        this.xRotO = Mth.clamp(this.xRotO, -90.0f, 90.0f);
        if (this.vehicle != null) {
            this.vehicle.onPassengerTurned(this);
        }
    }

    public void tick() {
        if (this.type != EntityType.PLAYER && this.type.ttl >= 0 && this.tickCount >= this.type.ttl) {
            this.discard(EntityRemoveEvent.Cause.DISCARD);
            return;
        }
        this.baseTick();
    }

    public void postTick() {
        if (!(this instanceof ServerPlayer) && this.isAlive()) {
            this.handlePortal();
        }
    }

    public void baseTick() {
        Entity entity;
        if (this.firstTick && (entity = this) instanceof NeutralMob) {
            NeutralMob neutralMob = (NeutralMob)((Object)entity);
            neutralMob.tickInitialPersistentAnger(this.level);
        }
        this.inBlockState = null;
        if (this.isPassenger() && this.getVehicle().isRemoved()) {
            this.stopRiding();
        }
        if (this.boardingCooldown > 0) {
            --this.boardingCooldown;
        }
        this.walkDistO = this.walkDist;
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        if (this instanceof ServerPlayer) {
            this.handlePortal();
        }
        if (this.canSpawnSprintParticle()) {
            this.spawnSprintParticle();
        }
        this.wasInPowderSnow = this.isInPowderSnow;
        this.isInPowderSnow = false;
        this.updateInWaterStateAndDoFluidPushing();
        this.updateFluidOnEyes();
        this.updateSwimming();
        if (this.level().isClientSide) {
            this.clearFire();
        } else if (this.remainingFireTicks > 0) {
            if (this.fireImmune()) {
                this.setRemainingFireTicks(this.remainingFireTicks - 4);
                if (this.remainingFireTicks < 0) {
                    this.clearFire();
                }
            } else {
                if (this.remainingFireTicks % 20 == 0 && !this.isInLava()) {
                    this.hurt(this.damageSources().onFire(), 1.0f);
                }
                this.setRemainingFireTicks(this.remainingFireTicks - 1);
            }
            if (this.getTicksFrozen() > 0 && !this.freezeLocked) {
                this.setTicksFrozen(0);
                this.level().levelEvent(null, 1009, this.blockPosition, 1);
            }
        }
        if (this.isInLava()) {
            this.lavaHurt();
            this.fallDistance *= 0.5f;
        } else {
            this.lastLavaContact = null;
        }
        this.checkBelowWorld();
        if (!this.level().isClientSide) {
            this.setSharedFlagOnFire(this.remainingFireTicks > 0);
        }
        this.firstTick = false;
        if (!this.level().isClientSide && this instanceof Leashable) {
            Leashable.tickLeash((Entity)((Object)((Leashable)((Object)this))));
        }
    }

    public void setSharedFlagOnFire(boolean onFire) {
        this.setSharedFlag(0, onFire || this.hasVisualFire);
    }

    public void checkBelowWorld() {
        block7: {
            Entity entity;
            block6: {
                if (!this.level.getWorld().isVoidDamageEnabled()) {
                    return;
                }
                if (this.getY() < (double)this.level.getMinBuildHeight() + this.level.getWorld().getVoidDamageMinBuildHeightOffset()) break block6;
                if (this.level.getWorld().getEnvironment() != World.Environment.NETHER || !this.level.paperConfig().environment.netherCeilingVoidDamageHeight.test(v -> this.getY() >= (double)v)) break block7;
                Entity entity2 = this;
                if (!(entity2 instanceof Player)) break block6;
                Player player = (Player)entity2;
                if (player.getAbilities().invulnerable) break block7;
            }
            if (this.level().purpurConfig.teleportOnNetherCeilingDamage && this.level.getWorld().getEnvironment() == World.Environment.NETHER && (entity = this) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.teleport(MCUtil.toLocation(this.level, this.level.getSharedSpawnPos()));
            } else {
                this.onBelowWorld();
            }
        }
    }

    public void setPortalCooldown() {
        this.portalCooldown = this.getDimensionChangingDelay();
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean isOnPortalCooldown() {
        return this.portalCooldown > 0;
    }

    protected void processPortalCooldown() {
        if (this.isOnPortalCooldown()) {
            --this.portalCooldown;
        }
    }

    public void lavaHurt() {
        if (!this.fireImmune()) {
            if (this instanceof LivingEntity && this.remainingFireTicks <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.level, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.level.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
            if (this.hurt(this.damageSources().lava().directBlock(this.level, this.lastLavaContact), 4.0f)) {
                this.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
            }
        }
    }

    public final void igniteForSeconds(float seconds) {
        this.igniteForSeconds(seconds, true);
    }

    public final void igniteForSeconds(float f, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), f);
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            f = event.getDuration();
        }
        this.igniteForTicks(Mth.floor(f * 20.0f));
    }

    public void igniteForTicks(int ticks) {
        if (this.remainingFireTicks < ticks) {
            this.setRemainingFireTicks(ticks);
        }
    }

    public void setRemainingFireTicks(int fireTicks) {
        this.remainingFireTicks = fireTicks;
    }

    public int getRemainingFireTicks() {
        return this.remainingFireTicks;
    }

    public void clearFire() {
        this.setRemainingFireTicks(0);
    }

    protected void onBelowWorld() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean isFree(double offsetX, double offsetY, double offsetZ) {
        return this.isFree(this.getBoundingBox().move(offsetX, offsetY, offsetZ));
    }

    private boolean isFree(AABB box) {
        return this.level().noCollision(this, box) && !this.level().containsAnyLiquid(box);
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
        this.checkSupportingBlock(onGround, null);
    }

    public void setOnGroundWithMovement(boolean onGround, Vec3 movement) {
        this.onGround = onGround;
        this.checkSupportingBlock(onGround, movement);
    }

    public boolean isSupportedBy(BlockPos pos) {
        return this.mainSupportingBlockPos.isPresent() && this.mainSupportingBlockPos.get().equals(pos);
    }

    protected void checkSupportingBlock(boolean onGround, @javax.annotation.Nullable Vec3 movement) {
        if (onGround) {
            AABB axisalignedbb = this.getBoundingBox();
            AABB axisalignedbb1 = new AABB(axisalignedbb.minX, axisalignedbb.minY - 1.0E-6, axisalignedbb.minZ, axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
            Optional<BlockPos> optional = this.level.findSupportingBlock(this, axisalignedbb1);
            if (!optional.isPresent() && !this.onGroundNoBlocks) {
                if (movement != null) {
                    AABB axisalignedbb2 = axisalignedbb1.move(-movement.x, 0.0, -movement.z);
                    optional = this.level.findSupportingBlock(this, axisalignedbb2);
                    this.mainSupportingBlockPos = optional;
                }
            } else {
                this.mainSupportingBlockPos = optional;
            }
            this.onGroundNoBlocks = optional.isEmpty();
        } else {
            this.onGroundNoBlocks = false;
            if (this.mainSupportingBlockPos.isPresent()) {
                this.mainSupportingBlockPos = Optional.empty();
            }
        }
    }

    public boolean onGround() {
        return this.onGround;
    }

    public final Vec3 getMoveVector() {
        return this.moveVector;
    }

    public final double getMoveStartX() {
        return this.moveStartX;
    }

    public final double getMoveStartY() {
        return this.moveStartY;
    }

    public final double getMoveStartZ() {
        return this.moveStartZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(MoverType movementType, Vec3 movement) {
        Vec3 originalMovement = movement;
        TickThread.ensureTickThread("Cannot move an entity off-main");
        Object object = this.posLock;
        synchronized (object) {
            this.moveStartX = this.getX();
            this.moveStartY = this.getY();
            this.moveStartZ = this.getZ();
            this.moveVector = movement;
        }
        try {
            if (this.noPhysics) {
                this.setPos(this.getX() + movement.x, this.getY() + movement.y, this.getZ() + movement.z);
            } else {
                this.wasOnFire = this.isOnFire();
                if (movementType == MoverType.PISTON) {
                    this.activatedTick = Math.max(this.activatedTick, (long)(MinecraftServer.currentTick + 20));
                    this.activatedImmunityTick = Math.max(this.activatedImmunityTick, (long)(MinecraftServer.currentTick + 20));
                    if ((movement = this.limitPistonMovement(movement)).equals(Vec3.ZERO)) {
                        return;
                    }
                }
                if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
                    movement = movement.multiply(this.stuckSpeedMultiplier);
                    this.stuckSpeedMultiplier = Vec3.ZERO;
                    this.setDeltaMovement(Vec3.ZERO);
                }
                if (this.isTemporarilyActive && !(this instanceof ItemEntity) && movement == this.getDeltaMovement() && movementType == MoverType.SELF) {
                    this.setDeltaMovement(Vec3.ZERO);
                    return;
                }
                Vec3 vec3d1 = this.collide(movement = this.maybeBackOffFromEdge(movement, movementType));
                double d0 = vec3d1.lengthSqr();
                if (d0 > 1.0E-7) {
                    BlockHitResult movingobjectpositionblock;
                    if (this.fallDistance != 0.0f && d0 >= 1.0 && (movingobjectpositionblock = this.level().clip(new ClipContext(this.position(), this.position().add(vec3d1), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, this))).getType() != HitResult.Type.MISS) {
                        this.resetFallDistance();
                    }
                    this.setPos(this.getX() + vec3d1.x, this.getY() + vec3d1.y, this.getZ() + vec3d1.z);
                }
                boolean flag = !Mth.equal(movement.x, vec3d1.x);
                boolean flag1 = !Mth.equal(movement.z, vec3d1.z);
                this.horizontalCollision = flag || flag1;
                this.verticalCollision = movement.y != vec3d1.y;
                this.verticalCollisionBelow = this.verticalCollision && movement.y < 0.0;
                this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor(vec3d1) : false;
                this.setOnGroundWithMovement(this.verticalCollisionBelow, vec3d1);
                BlockPos blockposition = this.getOnPosLegacy();
                BlockState iblockdata = this.level().getBlockState(blockposition);
                this.checkFallDamage(vec3d1.y, this.onGround(), iblockdata, blockposition);
                if (this.isRemoved()) {
                } else {
                    MovementEmission entity_movementemission;
                    if (this.horizontalCollision) {
                        Vec3 vec3d2 = this.getDeltaMovement();
                        this.setDeltaMovement(flag ? 0.0 : vec3d2.x, vec3d2.y, flag1 ? 0.0 : vec3d2.z);
                    }
                    Block block = iblockdata.getBlock();
                    if (movement.y != vec3d1.y) {
                        block.updateEntityAfterFallOn(this.level(), this);
                    }
                    if (this.horizontalCollision && this.getBukkitEntity() instanceof Vehicle) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        org.bukkit.block.Block bl = this.level.getWorld().getBlockAt(Mth.floor(this.getX()), Mth.floor(this.getY()), Mth.floor(this.getZ()));
                        if (movement.x > vec3d1.x) {
                            bl = bl.getRelative(BlockFace.EAST);
                        } else if (movement.x < vec3d1.x) {
                            bl = bl.getRelative(BlockFace.WEST);
                        } else if (movement.z > vec3d1.z) {
                            bl = bl.getRelative(BlockFace.SOUTH);
                        } else if (movement.z < vec3d1.z) {
                            bl = bl.getRelative(BlockFace.NORTH);
                        }
                        if (!bl.getType().isAir()) {
                            VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl, CraftVector.toBukkit(originalMovement));
                            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
                        }
                    }
                    if (this.onGround()) {
                        block.stepOn(this.level(), blockposition, iblockdata, this);
                    }
                    if ((entity_movementemission = this.getMovementEmission()).emitsAnything() && !this.isPassenger()) {
                        double d1 = vec3d1.x;
                        double d2 = vec3d1.y;
                        double d3 = vec3d1.z;
                        this.flyDist += (float)(vec3d1.length() * 0.6);
                        BlockPos blockposition1 = this.getOnPos();
                        BlockState iblockdata1 = this.level().getBlockState(blockposition1);
                        boolean flag2 = this.isStateClimbable(iblockdata1);
                        if (!flag2) {
                            d2 = 0.0;
                        }
                        this.walkDist += (float)vec3d1.horizontalDistance() * 0.6f;
                        this.moveDist += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                        if (this.moveDist > this.nextStep && !iblockdata1.isAir()) {
                            boolean flag3 = blockposition1.equals(blockposition);
                            boolean flag4 = this.vibrationAndSoundEffectsFromBlock(blockposition, iblockdata, entity_movementemission.emitsSounds(), flag3, movement);
                            if (!flag3) {
                                flag4 |= this.vibrationAndSoundEffectsFromBlock(blockposition1, iblockdata1, false, entity_movementemission.emitsEvents(), movement);
                            }
                            if (flag4) {
                                this.nextStep = this.nextStep();
                            } else if (this.isInWater()) {
                                this.nextStep = this.nextStep();
                                if (entity_movementemission.emitsSounds()) {
                                    this.waterSwimSound();
                                }
                                if (entity_movementemission.emitsEvents()) {
                                    this.gameEvent(GameEvent.SWIM);
                                }
                            }
                        } else if (iblockdata1.isAir()) {
                            this.processFlappingMovement();
                        }
                    }
                    this.tryCheckInsideBlocks();
                    float f = this.getBlockSpeedFactor();
                    this.setDeltaMovement(this.getDeltaMovement().multiply(f, 1.0, f));
                    if (this.level().getBlockStatesIfLoaded(this.getBoundingBox().deflate(1.0E-6)).noneMatch(iblockdata2 -> iblockdata2.is(BlockTags.FIRE) || iblockdata2.is(Blocks.LAVA))) {
                        if (this.remainingFireTicks <= 0) {
                            this.setRemainingFireTicks(-this.getFireImmuneTicks());
                        }
                        if (this.wasOnFire && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
                            this.playEntityOnFireExtinguishedSound();
                        }
                    }
                    if (this.isOnFire() && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
                        this.setRemainingFireTicks(-this.getFireImmuneTicks());
                    }
                }
            }
        }
        finally {
            object = this.posLock;
            synchronized (object) {
                this.moveVector = null;
            }
        }
    }

    private boolean isStateClimbable(BlockState state) {
        return state.is(BlockTags.CLIMBABLE) || state.is(Blocks.POWDER_SNOW);
    }

    private boolean vibrationAndSoundEffectsFromBlock(BlockPos pos, BlockState state, boolean playSound, boolean emitEvent, Vec3 movement) {
        if (state.isAir()) {
            return false;
        }
        boolean flag2 = this.isStateClimbable(state);
        if ((this.onGround() || flag2 || this.isCrouching() && movement.y == 0.0 || this.isOnRails()) && !this.isSwimming()) {
            if (playSound) {
                this.walkingStepSound(pos, state);
            }
            if (emitEvent) {
                this.level().gameEvent(GameEvent.STEP, this.position(), GameEvent.Context.of(this, state));
            }
            return true;
        }
        return false;
    }

    protected boolean isHorizontalCollisionMinor(Vec3 adjustedMovement) {
        return false;
    }

    protected void tryCheckInsideBlocks() {
        try {
            this.checkInsideBlocks();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Checking entity block collision");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Entity being checked for collision");
            this.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected void playEntityOnFireExtinguishedSound() {
        this.playSound(SoundEvents.GENERIC_EXTINGUISH_FIRE, 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    public void extinguishFire() {
        if (!this.level().isClientSide && this.wasOnFire) {
            this.playEntityOnFireExtinguishedSound();
        }
        this.clearFire();
    }

    protected void processFlappingMovement() {
        if (this.isFlapping()) {
            this.onFlap();
            if (this.getMovementEmission().emitsEvents()) {
                this.gameEvent(GameEvent.FLAP);
            }
        }
    }

    @Deprecated
    public BlockPos getOnPosLegacy() {
        return this.getOnPos(0.2f);
    }

    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.500001f);
    }

    public BlockPos getOnPos() {
        return this.getOnPos(1.0E-5f);
    }

    protected BlockPos getOnPos(float offset) {
        if (this.mainSupportingBlockPos.isPresent() && this.level().getChunkIfLoadedImmediately(this.mainSupportingBlockPos.get()) != null) {
            BlockPos blockposition = this.mainSupportingBlockPos.get();
            if (offset <= 1.0E-5f) {
                return blockposition;
            }
            BlockState iblockdata = this.level().getBlockState(blockposition);
            return ((double)offset > 0.5 || !iblockdata.is(BlockTags.FENCES)) && !iblockdata.is(BlockTags.WALLS) && !(iblockdata.getBlock() instanceof FenceGateBlock) ? blockposition.atY(Mth.floor(this.position.y - (double)offset)) : blockposition;
        }
        int i = Mth.floor(this.position.x);
        int j = Mth.floor(this.position.y - (double)offset);
        int k = Mth.floor(this.position.z);
        return new BlockPos(i, j, k);
    }

    protected float getBlockJumpFactor() {
        float f = this.level().getBlockState(this.blockPosition()).getBlock().getJumpFactor();
        float f1 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getJumpFactor();
        return (double)f == 1.0 ? f1 : f;
    }

    protected float getBlockSpeedFactor() {
        BlockState iblockdata = this.level().getBlockState(this.blockPosition());
        float f = iblockdata.getBlock().getSpeedFactor();
        return !iblockdata.is(Blocks.WATER) && !iblockdata.is(Blocks.BUBBLE_COLUMN) ? ((double)f == 1.0 ? this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getSpeedFactor() : f) : f;
    }

    protected Vec3 maybeBackOffFromEdge(Vec3 movement, MoverType type) {
        return movement;
    }

    protected Vec3 limitPistonMovement(Vec3 movement) {
        if (movement.lengthSqr() <= 1.0E-7) {
            return movement;
        }
        long i = this.level().getGameTime();
        if (i != this.pistonDeltasGameTime) {
            Arrays.fill(this.pistonDeltas, 0.0);
            this.pistonDeltasGameTime = i;
        }
        if (movement.x != 0.0) {
            double d0 = this.applyPistonMovementRestriction(Direction.Axis.X, movement.x);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(d0, 0.0, 0.0);
        }
        if (movement.y != 0.0) {
            double d0 = this.applyPistonMovementRestriction(Direction.Axis.Y, movement.y);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(0.0, d0, 0.0);
        }
        if (movement.z != 0.0) {
            double d0 = this.applyPistonMovementRestriction(Direction.Axis.Z, movement.z);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(0.0, 0.0, d0);
        }
        return Vec3.ZERO;
    }

    private double applyPistonMovementRestriction(Direction.Axis axis, double offsetFactor) {
        int i = axis.ordinal();
        double d1 = Mth.clamp(offsetFactor + this.pistonDeltas[i], -0.51, 0.51);
        offsetFactor = d1 - this.pistonDeltas[i];
        this.pistonDeltas[i] = d1;
        return offsetFactor;
    }

    private Vec3 collide(Vec3 movement) {
        boolean zZero;
        boolean xZero = movement.x == 0.0;
        boolean yZero = movement.y == 0.0;
        boolean bl = zZero = movement.z == 0.0;
        if (xZero & yZero & zZero) {
            return movement;
        }
        Level world = this.level;
        AABB currBoundingBox = this.getBoundingBox();
        if (CollisionUtil.isEmpty(currBoundingBox)) {
            return movement;
        }
        ArrayList<AABB> potentialCollisionsBB = new ArrayList<AABB>();
        ArrayList<VoxelShape> potentialCollisionsVoxel = new ArrayList<VoxelShape>();
        double stepHeight = this.maxUpStep();
        boolean onGround = this.onGround;
        AABB collisionBox = xZero & zZero ? (movement.y > 0.0 ? CollisionUtil.cutUpwards(currBoundingBox, movement.y) : CollisionUtil.cutDownwards(currBoundingBox, movement.y)) : (stepHeight > 0.0 && (onGround || movement.y < 0.0) ? (movement.y <= 0.0 ? CollisionUtil.expandUpwards(currBoundingBox.expandTowards(movement.x, movement.y, movement.z), stepHeight) : currBoundingBox.expandTowards(movement.x, Math.max(stepHeight, movement.y), movement.z)) : currBoundingBox.expandTowards(movement.x, movement.y, movement.z));
        CollisionUtil.getCollisions(world, this, collisionBox, potentialCollisionsVoxel, potentialCollisionsBB, 4, null, null);
        if (potentialCollisionsVoxel.isEmpty() && potentialCollisionsBB.isEmpty()) {
            return movement;
        }
        Vec3 limitedMoveVector = CollisionUtil.performCollisions(movement, currBoundingBox, potentialCollisionsVoxel, potentialCollisionsBB);
        if (stepHeight > 0.0 && (onGround || limitedMoveVector.y != movement.y && movement.y < 0.0) && (limitedMoveVector.x != movement.x || limitedMoveVector.z != movement.z)) {
            Vec3 vec3d4;
            Vec3 vec3d2 = CollisionUtil.performCollisions(new Vec3(movement.x, stepHeight, movement.z), currBoundingBox, potentialCollisionsVoxel, potentialCollisionsBB);
            Vec3 vec3d3 = CollisionUtil.performCollisions(new Vec3(0.0, stepHeight, 0.0), currBoundingBox.expandTowards(movement.x, 0.0, movement.z), potentialCollisionsVoxel, potentialCollisionsBB);
            if (vec3d3.y < stepHeight && (vec3d4 = CollisionUtil.performCollisions(new Vec3(movement.x, 0.0, movement.z), currBoundingBox.move(vec3d3), potentialCollisionsVoxel, potentialCollisionsBB).add(vec3d3)).horizontalDistanceSqr() > vec3d2.horizontalDistanceSqr()) {
                vec3d2 = vec3d4;
            }
            if (vec3d2.horizontalDistanceSqr() > limitedMoveVector.horizontalDistanceSqr()) {
                return vec3d2.add(CollisionUtil.performCollisions(new Vec3(0.0, -vec3d2.y + movement.y, 0.0), currBoundingBox.move(vec3d2), potentialCollisionsVoxel, potentialCollisionsBB));
            }
            return limitedMoveVector;
        }
        return limitedMoveVector;
    }

    private static float[] collectCandidateStepUpHeights(AABB collisionBox, List<VoxelShape> collisions, float f, float stepHeight) {
        FloatArraySet floatarrayset = new FloatArraySet(4);
        block0: for (VoxelShape voxelshape : collisions) {
            DoubleList doublelist = voxelshape.getCoords(Direction.Axis.Y);
            DoubleListIterator doublelistiterator = doublelist.iterator();
            while (doublelistiterator.hasNext()) {
                double d0 = doublelistiterator.next();
                float f2 = (float)(d0 - collisionBox.minY);
                if (!(f2 >= 0.0f) || f2 == stepHeight) continue;
                if (f2 > f) continue block0;
                floatarrayset.add(f2);
            }
        }
        float[] afloat = floatarrayset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }

    public static Vec3 collideBoundingBox(@javax.annotation.Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> collisions) {
        List<VoxelShape> list1 = Entity.collectColliders(entity, world, collisions, entityBoundingBox.expandTowards(movement));
        return Entity.collideWithShapes(movement, entityBoundingBox, list1);
    }

    private static List<VoxelShape> collectColliders(@javax.annotation.Nullable Entity entity, Level world, List<VoxelShape> regularCollisions, AABB movingEntityBoundingBox) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(regularCollisions.size() + 1));
        if (!regularCollisions.isEmpty()) {
            builder.addAll(regularCollisions);
        }
        WorldBorder worldborder = world.getWorldBorder();
        boolean bl = flag = entity != null && worldborder.isInsideCloseToBorder(entity, movingEntityBoundingBox);
        if (flag) {
            builder.add((Object)worldborder.getCollisionShape());
        }
        builder.addAll(world.getBlockCollisions(entity, movingEntityBoundingBox));
        return builder.build();
    }

    private static Vec3 collideWithShapes(Vec3 movement, AABB entityBoundingBox, List<VoxelShape> collisions) {
        boolean flag;
        if (collisions.isEmpty()) {
            return movement;
        }
        double d0 = movement.x;
        double d1 = movement.y;
        double d2 = movement.z;
        if (d1 != 0.0 && (d1 = Shapes.collide(Direction.Axis.Y, entityBoundingBox, collisions, d1)) != 0.0) {
            entityBoundingBox = entityBoundingBox.move(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = Shapes.collide(Direction.Axis.Z, entityBoundingBox, collisions, d2)) != 0.0) {
            entityBoundingBox = entityBoundingBox.move(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = Shapes.collide(Direction.Axis.X, entityBoundingBox, collisions, d0);
            if (!flag && d0 != 0.0) {
                entityBoundingBox = entityBoundingBox.move(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = Shapes.collide(Direction.Axis.Z, entityBoundingBox, collisions, d2);
        }
        return new Vec3(d0, d1, d2);
    }

    protected float nextStep() {
        return (int)this.moveDist + 1;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.GENERIC_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.GENERIC_SPLASH;
    }

    protected SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.GENERIC_SPLASH;
    }

    public SoundEvent getSwimSound0() {
        return this.getSwimSound();
    }

    public SoundEvent getSwimSplashSound0() {
        return this.getSwimSplashSound();
    }

    public SoundEvent getSwimHighSpeedSplashSound0() {
        return this.getSwimHighSpeedSplashSound();
    }

    protected void checkInsideBlocks() {
        AABB axisalignedbb = this.getBoundingBox();
        BlockPos blockposition = BlockPos.containing(axisalignedbb.minX + 1.0E-7, axisalignedbb.minY + 1.0E-7, axisalignedbb.minZ + 1.0E-7);
        BlockPos blockposition1 = BlockPos.containing(axisalignedbb.maxX - 1.0E-7, axisalignedbb.maxY - 1.0E-7, axisalignedbb.maxZ - 1.0E-7);
        if (this.level().hasChunksAt(blockposition, blockposition1)) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
            for (int i = blockposition.getX(); i <= blockposition1.getX(); ++i) {
                for (int j = blockposition.getY(); j <= blockposition1.getY(); ++j) {
                    for (int k = blockposition.getZ(); k <= blockposition1.getZ(); ++k) {
                        if (!this.isAlive()) {
                            return;
                        }
                        blockposition_mutableblockposition.set(i, j, k);
                        BlockState iblockdata = this.level().getBlockState(blockposition_mutableblockposition);
                        try {
                            iblockdata.entityInside(this.level(), blockposition_mutableblockposition, this);
                            this.onInsideBlock(iblockdata);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.forThrowable(throwable, "Colliding entity with block");
                            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Block being collided with");
                            CrashReportCategory.populateBlockDetails(crashreportsystemdetails, this.level(), blockposition_mutableblockposition, iblockdata);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected void onInsideBlock(BlockState state) {
    }

    public BlockPos adjustSpawnLocation(ServerLevel world, BlockPos basePos) {
        BlockPos blockposition1 = world.getSharedSpawnPos();
        Vec3 vec3d = blockposition1.getCenter();
        int i = world.getChunkAt(blockposition1).getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockposition1.getX(), blockposition1.getZ()) + 1;
        return BlockPos.containing(vec3d.x, i, vec3d.z);
    }

    public void gameEvent(Holder<GameEvent> event, @javax.annotation.Nullable Entity entity) {
        this.level().gameEvent(entity, event, this.position);
    }

    public void gameEvent(Holder<GameEvent> event) {
        this.gameEvent(event, this);
    }

    private void walkingStepSound(BlockPos pos, BlockState state) {
        this.playStepSound(pos, state);
        if (this.shouldPlayAmethystStepSound(state)) {
            this.playAmethystStepSound();
        }
    }

    protected void waterSwimSound() {
        Entity entity = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float f = entity == this ? 0.35f : 0.4f;
        Vec3 vec3d = entity.getDeltaMovement();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.x * vec3d.x * (double)0.2f + vec3d.y * vec3d.y + vec3d.z * vec3d.z * (double)0.2f) * f);
        this.playSwimSound(f1);
    }

    protected BlockPos getPrimaryStepSoundBlockPos(BlockPos pos) {
        BlockPos blockposition1 = pos.above();
        BlockState iblockdata = this.level().getBlockState(blockposition1);
        return !iblockdata.is(BlockTags.INSIDE_STEP_SOUND_BLOCKS) && !iblockdata.is(BlockTags.COMBINATION_STEP_SOUND_BLOCKS) ? pos : blockposition1;
    }

    protected void playCombinationStepSounds(BlockState primaryState, BlockState secondaryState) {
        SoundType soundeffecttype = primaryState.getSoundType();
        this.playSound(soundeffecttype.getStepSound(), soundeffecttype.getVolume() * 0.15f, soundeffecttype.getPitch());
        this.playMuffledStepSound(secondaryState);
    }

    protected void playMuffledStepSound(BlockState state) {
        SoundType soundeffecttype = state.getSoundType();
        this.playSound(soundeffecttype.getStepSound(), soundeffecttype.getVolume() * 0.05f, soundeffecttype.getPitch() * 0.8f);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        SoundType soundeffecttype = state.getSoundType();
        this.playSound(soundeffecttype.getStepSound(), soundeffecttype.getVolume() * 0.15f, soundeffecttype.getPitch());
    }

    private boolean shouldPlayAmethystStepSound(BlockState state) {
        return state.is(BlockTags.CRYSTAL_SOUND_BLOCKS) && this.tickCount >= this.lastCrystalSoundPlayTick + 20;
    }

    private void playAmethystStepSound() {
        this.crystalSoundIntensity *= (float)Math.pow(0.997, this.tickCount - this.lastCrystalSoundPlayTick);
        this.crystalSoundIntensity = Math.min(1.0f, this.crystalSoundIntensity + 0.07f);
        float f = 0.5f + this.crystalSoundIntensity * this.random.nextFloat() * 1.2f;
        float f1 = 0.1f + this.crystalSoundIntensity * 1.2f;
        this.playSound(SoundEvents.AMETHYST_BLOCK_CHIME, f1, f);
        this.lastCrystalSoundPlayTick = this.tickCount;
    }

    protected void playSwimSound(float volume) {
        this.playSound(this.getSwimSound(), volume, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    protected void onFlap() {
    }

    protected boolean isFlapping() {
        return false;
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (!this.isSilent()) {
            this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), sound, this.getSoundSource(), volume, pitch);
        }
    }

    public void playSound(SoundEvent event) {
        if (!this.isSilent()) {
            this.playSound(event, 1.0f, 1.0f);
        }
    }

    public boolean isSilent() {
        return this.entityData.get(DATA_SILENT);
    }

    public void setSilent(boolean silent) {
        this.entityData.set(DATA_SILENT, silent);
    }

    public boolean isNoGravity() {
        return this.entityData.get(DATA_NO_GRAVITY);
    }

    public void setNoGravity(boolean noGravity) {
        this.entityData.set(DATA_NO_GRAVITY, noGravity);
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public final double getGravity() {
        return this.isNoGravity() ? 0.0 : this.getDefaultGravity();
    }

    protected void applyGravity() {
        double d0 = this.getGravity();
        if (d0 != 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -d0, 0.0));
        }
    }

    protected MovementEmission getMovementEmission() {
        return MovementEmission.ALL;
    }

    public boolean dampensVibrations() {
        return false;
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
        if (onGround) {
            if (this.fallDistance > 0.0f) {
                state.getBlock().fallOn(this.level(), state, landedPosition, this, this.fallDistance);
                this.level().gameEvent(GameEvent.HIT_GROUND, this.position, GameEvent.Context.of(this, this.mainSupportingBlockPos.map(blockposition1 -> this.level().getBlockState((BlockPos)blockposition1)).orElse(state)));
            }
            this.resetFallDistance();
        } else if (heightDifference < 0.0) {
            this.fallDistance -= (float)heightDifference;
        }
    }

    public boolean fireImmune() {
        return this.immuneToFire != null ? this.immuneToFire.booleanValue() : this.getType().fireImmune();
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.type.is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return false;
        }
        if (this.isVehicle()) {
            for (Entity entity : this.getPassengers()) {
                entity.causeFallDamage(fallDistance, damageMultiplier, damageSource);
            }
        }
        return false;
    }

    public boolean isInWater() {
        return this.wasTouchingWater;
    }

    public boolean isInRain() {
        BlockPos blockposition = this.blockPosition();
        return this.level().isRainingAt(blockposition) || this.level().isRainingAt(BlockPos.containing(blockposition.getX(), this.getBoundingBox().maxY, blockposition.getZ()));
    }

    public boolean isInBubbleColumn() {
        return this.getInBlockState().is(Blocks.BUBBLE_COLUMN);
    }

    public boolean isInWaterOrRain() {
        return this.isInWater() || this.isInRain();
    }

    public boolean isInWaterRainOrBubble() {
        return this.isInWater() || this.isInRain() || this.isInBubbleColumn();
    }

    public boolean isInWaterOrBubble() {
        return this.isInWater() || this.isInBubbleColumn();
    }

    public boolean isInLiquid() {
        return this.isInWaterOrBubble() || this.isInLava();
    }

    public boolean isUnderWater() {
        return this.wasEyeInWater && this.isInWater();
    }

    public void updateSwimming() {
        if (this.isSwimming()) {
            this.setSwimming(this.isSprinting() && this.isInWater() && !this.isPassenger());
        } else {
            this.setSwimming(this.isSprinting() && this.isUnderWater() && !this.isPassenger() && this.level().getFluidState(this.blockPosition).is(FluidTags.WATER));
        }
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        this.fluidHeight.clear();
        this.updateInWaterStateAndDoWaterCurrentPushing();
        double d0 = this.level().dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.updateFluidHeightAndDoFluidPushing(FluidTags.LAVA, d0);
        return this.isInWater() || flag;
    }

    public void updateInWaterStateAndDoWaterCurrentPushing() {
        Boat entityboat;
        Entity entity = this.getVehicle();
        if (entity instanceof Boat && !(entityboat = (Boat)entity).isUnderWater()) {
            this.wasTouchingWater = false;
            return;
        }
        if (this.updateFluidHeightAndDoFluidPushing(FluidTags.WATER, 0.014)) {
            if (!this.wasTouchingWater && !this.firstTick) {
                this.doWaterSplashEffect();
            }
            this.resetFallDistance();
            this.wasTouchingWater = true;
            this.clearFire();
        } else {
            this.wasTouchingWater = false;
        }
    }

    private void updateFluidOnEyes() {
        Boat entityboat;
        this.wasEyeInWater = this.isEyeInFluid(FluidTags.WATER);
        this.fluidOnEyes.clear();
        double d0 = this.getEyeY();
        Entity entity = this.getVehicle();
        if (entity instanceof Boat && !(entityboat = (Boat)entity).isUnderWater() && entityboat.getBoundingBox().maxY >= d0 && entityboat.getBoundingBox().minY <= d0) {
            return;
        }
        BlockPos blockposition = BlockPos.containing(this.getX(), d0, this.getZ());
        FluidState fluid = this.level().getFluidState(blockposition);
        double d1 = (float)blockposition.getY() + fluid.getHeight(this.level(), blockposition);
        if (d1 > d0) {
            Stream<TagKey<Fluid>> stream = fluid.getTags();
            Set<TagKey<Fluid>> set = this.fluidOnEyes;
            Objects.requireNonNull(this.fluidOnEyes);
            stream.forEach(set::add);
        }
    }

    protected void doWaterSplashEffect() {
        double d1;
        double d0;
        Entity entity = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float f = entity == this ? 0.2f : 0.9f;
        Vec3 vec3d = entity.getDeltaMovement();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.x * vec3d.x * (double)0.2f + vec3d.y * vec3d.y + vec3d.z * vec3d.z * (double)0.2f) * f);
        if (f1 < 0.25f) {
            this.playSound(this.getSwimSplashSound(), f1, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        } else {
            this.playSound(this.getSwimHighSpeedSplashSound(), f1, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
        float f2 = Mth.floor(this.getY());
        int i = 0;
        while ((float)i < 1.0f + this.dimensions.width() * 20.0f) {
            d0 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            d1 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(ParticleTypes.BUBBLE, this.getX() + d0, f2 + 1.0f, this.getZ() + d1, vec3d.x, vec3d.y - this.random.nextDouble() * (double)0.2f, vec3d.z);
            ++i;
        }
        i = 0;
        while ((float)i < 1.0f + this.dimensions.width() * 20.0f) {
            d0 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            d1 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(ParticleTypes.SPLASH, this.getX() + d0, f2 + 1.0f, this.getZ() + d1, vec3d.x, vec3d.y, vec3d.z);
            ++i;
        }
        this.gameEvent(GameEvent.SPLASH);
    }

    @Deprecated
    protected BlockState getBlockStateOnLegacy() {
        return this.level().getBlockState(this.getOnPosLegacy());
    }

    public BlockState getBlockStateOn() {
        return this.level().getBlockState(this.getOnPos());
    }

    public boolean canSpawnSprintParticle() {
        return this.isSprinting() && !this.isInWater() && !this.isSpectator() && !this.isCrouching() && !this.isInLava() && this.isAlive();
    }

    protected void spawnSprintParticle() {
        BlockPos blockposition = this.getOnPosLegacy();
        BlockState iblockdata = this.level().getBlockState(blockposition);
        if (iblockdata.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 vec3d = this.getDeltaMovement();
            BlockPos blockposition1 = this.blockPosition();
            double d0 = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            double d1 = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            if (blockposition1.getX() != blockposition.getX()) {
                d0 = Mth.clamp(d0, (double)blockposition.getX(), (double)blockposition.getX() + 1.0);
            }
            if (blockposition1.getZ() != blockposition.getZ()) {
                d1 = Mth.clamp(d1, (double)blockposition.getZ(), (double)blockposition.getZ() + 1.0);
            }
            this.level().addParticle(new BlockParticleOption(ParticleTypes.BLOCK, iblockdata), d0, this.getY() + 0.1, d1, vec3d.x * -4.0, 1.5, vec3d.z * -4.0);
        }
    }

    public boolean isEyeInFluid(TagKey<Fluid> fluidTag) {
        return this.fluidOnEyes.contains(fluidTag);
    }

    public boolean isInLava() {
        return !this.firstTick && this.fluidHeight.getDouble(FluidTags.LAVA) > 0.0;
    }

    public void moveRelative(float speed, Vec3 movementInput) {
        Vec3 vec3d1 = Entity.getInputVector(movementInput, speed, this.getYRot());
        this.setDeltaMovement(this.getDeltaMovement().add(vec3d1));
    }

    private static Vec3 getInputVector(Vec3 movementInput, float speed, float yaw) {
        double d0 = movementInput.lengthSqr();
        if (d0 < 1.0E-7) {
            return Vec3.ZERO;
        }
        Vec3 vec3d1 = (d0 > 1.0 ? movementInput.normalize() : movementInput).scale(speed);
        float f2 = Mth.sin(yaw * ((float)Math.PI / 180));
        float f3 = Mth.cos(yaw * ((float)Math.PI / 180));
        return new Vec3(vec3d1.x * (double)f3 - vec3d1.z * (double)f2, vec3d1.y, vec3d1.z * (double)f3 + vec3d1.x * (double)f2);
    }

    @Deprecated
    public float getLightLevelDependentMagicValue() {
        return this.level().hasChunkAt(this.getBlockX(), this.getBlockZ()) ? this.level().getLightLevelDependentMagicValue(BlockPos.containing(this.getX(), this.getEyeY(), this.getZ())) : 0.0f;
    }

    public void absMoveTo(double x, double y, double z, float yaw, float pitch) {
        this.absMoveTo(x, y, z);
        this.absRotateTo(yaw, pitch);
    }

    public void absRotateTo(float yaw, float pitch) {
        this.setYRot(yaw % 360.0f);
        this.setXRot(Mth.clamp(pitch, -90.0f, 90.0f) % 360.0f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.setYHeadRot(yaw);
    }

    public void absMoveTo(double x, double y, double z) {
        double d3 = Mth.clamp(x, -3.0E7, 3.0E7);
        double d4 = Mth.clamp(z, -3.0E7, 3.0E7);
        this.xo = d3;
        this.yo = y;
        this.zo = d4;
        this.setPos(d3, y, d4);
        if (this.valid) {
            this.level.getChunk((int)Math.floor(this.getX()) >> 4, (int)Math.floor(this.getZ()) >> 4);
        }
    }

    public void moveTo(Vec3 pos) {
        this.moveTo(pos.x, pos.y, pos.z);
    }

    public void moveTo(double x, double y, double z) {
        this.moveTo(x, y, z, this.getYRot(), this.getXRot());
    }

    public void moveTo(BlockPos pos, float yaw, float pitch) {
        this.moveTo(pos.getBottomCenter(), yaw, pitch);
    }

    public void moveTo(Vec3 pos, float yaw, float pitch) {
        this.moveTo(pos.x, pos.y, pos.z, yaw, pitch);
    }

    public void moveTo(double x, double y, double z, float yaw, float pitch) {
        if (!this.preserveMotion) {
            this.deltaMovement = Vec3.ZERO;
        } else {
            this.preserveMotion = false;
        }
        this.setPosRaw(x, y, z);
        this.setYRot(yaw);
        this.setXRot(pitch);
        this.setOldPosAndRot();
        this.reapplyPosition();
        this.setYHeadRot(yaw);
    }

    public final void setOldPosAndRot() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        this.xo = d0;
        this.yo = d1;
        this.zo = d2;
        this.xOld = d0;
        this.yOld = d1;
        this.zOld = d2;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public float distanceTo(Entity entity) {
        float f = (float)(this.getX() - entity.getX());
        float f1 = (float)(this.getY() - entity.getY());
        float f2 = (float)(this.getZ() - entity.getZ());
        return Mth.sqrt(f * f + f1 * f1 + f2 * f2);
    }

    public double distanceToSqr(double x, double y, double z) {
        double d3 = this.getX() - x;
        double d4 = this.getY() - y;
        double d5 = this.getZ() - z;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double distanceToSqr(Entity entity) {
        return this.distanceToSqr(entity.position());
    }

    public double distanceToSqr(Vec3 vector) {
        double d0 = this.getX() - vector.x;
        double d1 = this.getY() - vector.y;
        double d2 = this.getZ() - vector.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void playerTouch(Player player) {
    }

    public void push(Entity entity) {
        if (!(this.isPassengerOfSameVehicle(entity) || entity.noPhysics || this.noPhysics)) {
            double d1;
            if (this.level.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof ServerPlayer) && !(this instanceof ServerPlayer)) {
                return;
            }
            double d0 = entity.getX() - this.getX();
            double d2 = Mth.absMax(d0, d1 = entity.getZ() - this.getZ());
            if (d2 >= (double)0.01f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                if (!this.isVehicle() && this.isPushable()) {
                    this.push(-d0, 0.0, -d1);
                }
                if (!entity.isVehicle() && entity.isPushable()) {
                    entity.push(d0, 0.0, d1);
                }
            }
        }
    }

    public void push(Vec3 velocity) {
        this.push(velocity.x, velocity.y, velocity.z);
    }

    public void push(double deltaX, double deltaY, double deltaZ) {
        this.push(deltaX, deltaY, deltaZ, null);
    }

    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
        Vector delta = new Vector(deltaX, deltaY, deltaZ);
        if (pushingEntity != null) {
            EntityPushedByEntityAttackEvent event = new EntityPushedByEntityAttackEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityKnockbackEvent.Cause.PUSH, (org.bukkit.entity.Entity)pushingEntity.getBukkitEntity(), delta);
            if (!event.callEvent()) {
                return;
            }
            delta = event.getKnockback();
        }
        this.setDeltaMovement(this.getDeltaMovement().add(delta.getX(), delta.getY(), delta.getZ()));
        this.hasImpulse = true;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.markHurt();
        return false;
    }

    public final Vec3 getViewVector(float tickDelta) {
        return this.calculateViewVector(this.getViewXRot(tickDelta), this.getViewYRot(tickDelta));
    }

    public Direction getNearestViewDirection() {
        return Direction.getNearest(this.getViewVector(1.0f));
    }

    public float getViewXRot(float tickDelta) {
        return tickDelta == 1.0f ? this.getXRot() : Mth.lerp(tickDelta, this.xRotO, this.getXRot());
    }

    public float getViewYRot(float tickDelta) {
        return tickDelta == 1.0f ? this.getYRot() : Mth.lerp(tickDelta, this.yRotO, this.getYRot());
    }

    public final Vec3 calculateViewVector(float pitch, float yaw) {
        float f2 = pitch * ((float)Math.PI / 180);
        float f3 = -yaw * ((float)Math.PI / 180);
        float f4 = Mth.cos(f3);
        float f5 = Mth.sin(f3);
        float f6 = Mth.cos(f2);
        float f7 = Mth.sin(f2);
        return new Vec3(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3 getUpVector(float tickDelta) {
        return this.calculateUpVector(this.getViewXRot(tickDelta), this.getViewYRot(tickDelta));
    }

    protected final Vec3 calculateUpVector(float pitch, float yaw) {
        return this.calculateViewVector(pitch - 90.0f, yaw);
    }

    public final Vec3 getEyePosition() {
        return new Vec3(this.getX(), this.getEyeY(), this.getZ());
    }

    public final Vec3 getEyePosition(float tickDelta) {
        double d0 = Mth.lerp((double)tickDelta, this.xo, this.getX());
        double d1 = Mth.lerp((double)tickDelta, this.yo, this.getY()) + (double)this.getEyeHeight();
        double d2 = Mth.lerp((double)tickDelta, this.zo, this.getZ());
        return new Vec3(d0, d1, d2);
    }

    public Vec3 getLightProbePosition(float tickDelta) {
        return this.getEyePosition(tickDelta);
    }

    public final Vec3 getPosition(float delta) {
        double d0 = Mth.lerp((double)delta, this.xo, this.getX());
        double d1 = Mth.lerp((double)delta, this.yo, this.getY());
        double d2 = Mth.lerp((double)delta, this.zo, this.getZ());
        return new Vec3(d0, d1, d2);
    }

    public HitResult pick(double maxDistance, float tickDelta, boolean includeFluids) {
        Vec3 vec3d = this.getEyePosition(tickDelta);
        Vec3 vec3d1 = this.getViewVector(tickDelta);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * maxDistance, vec3d1.y * maxDistance, vec3d1.z * maxDistance);
        return this.level().clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, includeFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, this));
    }

    public boolean canBeHitByProjectile() {
        return this.isAlive() && this.isPickable();
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return this.isCollidable(false);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.isPushable();
    }

    public void awardKillScore(Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled instanceof ServerPlayer) {
            CriteriaTriggers.ENTITY_KILLED_PLAYER.trigger((ServerPlayer)entityKilled, this, damageSource);
        }
    }

    public boolean shouldRender(double cameraX, double cameraY, double cameraZ) {
        double d3 = this.getX() - cameraX;
        double d4 = this.getY() - cameraY;
        double d5 = this.getZ() - cameraZ;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.shouldRenderAtSqrDistance(d6);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.getBoundingBox().getSize();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * viewScale) * d1;
    }

    public boolean saveAsPassenger(CompoundTag nbt) {
        return this.saveAsPassenger(nbt, true);
    }

    public boolean saveAsPassenger(CompoundTag nbttagcompound, boolean includeAll) {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        String s = this.getEncodeId();
        if (!this.persist || s == null) {
            return false;
        }
        nbttagcompound.putString(ID_TAG, s);
        this.saveWithoutId(nbttagcompound, includeAll);
        return true;
    }

    public boolean serializeEntity(CompoundTag compound) {
        ArrayList<Entity> pass = new ArrayList<Entity>(this.getPassengers());
        this.passengers = ImmutableList.of();
        boolean result = this.save(compound);
        this.passengers = ImmutableList.copyOf(pass);
        return result;
    }

    public boolean save(CompoundTag nbt) {
        return this.isPassenger() ? false : this.saveAsPassenger(nbt);
    }

    public CompoundTag saveWithoutId(CompoundTag nbt) {
        return this.saveWithoutId(nbt, true);
    }

    public CompoundTag saveWithoutId(CompoundTag nbttagcompound, boolean includeAll) {
        try {
            ListTag nbttaglist;
            int i;
            if (includeAll) {
                if (this.vehicle != null) {
                    nbttagcompound.put("Pos", this.newDoubleList(this.vehicle.getX(), this.getY(), this.vehicle.getZ()));
                } else {
                    nbttagcompound.put("Pos", this.newDoubleList(this.getX(), this.getY(), this.getZ()));
                }
            }
            Vec3 vec3d = this.getDeltaMovement();
            nbttagcompound.put("Motion", this.newDoubleList(vec3d.x, vec3d.y, vec3d.z));
            if (Float.isNaN(this.yRot)) {
                this.yRot = 0.0f;
            }
            if (Float.isNaN(this.xRot)) {
                this.xRot = 0.0f;
            }
            nbttagcompound.put("Rotation", this.newFloatList(this.getYRot(), this.getXRot()));
            nbttagcompound.putFloat("FallDistance", this.fallDistance);
            nbttagcompound.putShort("Fire", (short)this.remainingFireTicks);
            nbttagcompound.putShort("Air", (short)this.getAirSupply());
            nbttagcompound.putBoolean("OnGround", this.onGround());
            nbttagcompound.putBoolean("Invulnerable", this.invulnerable);
            nbttagcompound.putInt("PortalCooldown", this.portalCooldown);
            if (includeAll) {
                nbttagcompound.putUUID(UUID_TAG, this.getUUID());
                nbttagcompound.putLong("WorldUUIDLeast", ((ServerLevel)this.level).getWorld().getUID().getLeastSignificantBits());
                nbttagcompound.putLong("WorldUUIDMost", ((ServerLevel)this.level).getWorld().getUID().getMostSignificantBits());
            }
            nbttagcompound.putInt("Bukkit.updateLevel", 2);
            if (!this.persist) {
                nbttagcompound.putBoolean("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                nbttagcompound.putBoolean("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                nbttagcompound.putBoolean("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                nbttagcompound.putInt("Bukkit.MaxAirSupply", this.getMaxAirSupply());
            }
            nbttagcompound.putInt("Spigot.ticksLived", this.tickCount);
            net.minecraft.network.chat.Component ichatbasecomponent = this.getCustomName();
            if (ichatbasecomponent != null) {
                nbttagcompound.putString("CustomName", Component.Serializer.toJson(ichatbasecomponent, this.registryAccess()));
            }
            if (this.isCustomNameVisible()) {
                nbttagcompound.putBoolean("CustomNameVisible", this.isCustomNameVisible());
            }
            if (this.isSilent()) {
                nbttagcompound.putBoolean("Silent", this.isSilent());
            }
            if (this.isNoGravity()) {
                nbttagcompound.putBoolean("NoGravity", this.isNoGravity());
            }
            if (this.hasGlowingTag) {
                nbttagcompound.putBoolean("Glowing", true);
            }
            if ((i = this.getTicksFrozen()) > 0) {
                nbttagcompound.putInt("TicksFrozen", this.getTicksFrozen());
            }
            if (this.hasVisualFire) {
                nbttagcompound.putBoolean("HasVisualFire", this.hasVisualFire);
            }
            if (!this.tags.isEmpty()) {
                nbttaglist = new ListTag();
                for (String s : this.tags) {
                    nbttaglist.add(StringTag.valueOf(s));
                }
                nbttagcompound.put("Tags", nbttaglist);
            }
            this.addAdditionalSaveData(nbttagcompound, includeAll);
            if (this.isVehicle()) {
                nbttaglist = new ListTag();
                for (Entity entity : this.getPassengers()) {
                    CompoundTag nbttagcompound1;
                    if (!entity.saveAsPassenger(nbttagcompound1 = new CompoundTag(), includeAll)) continue;
                    nbttaglist.add(nbttagcompound1);
                }
                if (!nbttaglist.isEmpty()) {
                    nbttagcompound.put(PASSENGERS_TAG, nbttaglist);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(nbttagcompound);
            }
            if (this.origin != null) {
                UUID originWorld;
                UUID uUID = this.originWorld != null ? this.originWorld : (originWorld = this.level != null ? this.level.getWorld().getUID() : null);
                if (originWorld != null) {
                    nbttagcompound.putUUID("Paper.OriginWorld", originWorld);
                }
                nbttagcompound.put("Paper.Origin", this.newDoubleList(this.origin.getX(), this.origin.getY(), this.origin.getZ()));
            }
            if (this.spawnReason != null) {
                nbttagcompound.putString("Paper.SpawnReason", this.spawnReason.name());
            }
            if (this.spawnedViaMobSpawner) {
                nbttagcompound.putBoolean("Paper.FromMobSpawner", true);
            }
            if (this.fromNetherPortal) {
                nbttagcompound.putBoolean("Paper.FromNetherPortal", true);
            }
            if (this.freezeLocked) {
                nbttagcompound.putBoolean("Paper.FreezeLock", true);
            }
            if (this.immuneToFire != null) {
                nbttagcompound.putBoolean("Purpur.FireImmune", this.immuneToFire);
            }
            return nbttagcompound;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Saving entity NBT");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Entity being saved");
            this.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(CompoundTag nbt) {
        try {
            ListTag originTag;
            ListTag nbttaglist = nbt.getList("Pos", 6);
            ListTag nbttaglist1 = nbt.getList("Motion", 6);
            ListTag nbttaglist2 = nbt.getList("Rotation", 5);
            double d0 = nbttaglist1.getDouble(0);
            double d1 = nbttaglist1.getDouble(1);
            double d2 = nbttaglist1.getDouble(2);
            this.setDeltaMovement(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
            double d3 = 3.0000512E7;
            this.setPosRaw(Mth.clamp(nbttaglist.getDouble(0), -3.0000512E7, 3.0000512E7), Mth.clamp(nbttaglist.getDouble(1), -2.0E7, 2.0E7), Mth.clamp(nbttaglist.getDouble(2), -3.0000512E7, 3.0000512E7));
            this.setYRot(nbttaglist2.getFloat(0));
            this.setXRot(nbttaglist2.getFloat(1));
            this.setOldPosAndRot();
            this.setYHeadRot(this.getYRot());
            this.setYBodyRot(this.getYRot());
            this.fallDistance = nbt.getFloat("FallDistance");
            this.remainingFireTicks = nbt.getShort("Fire");
            if (nbt.contains("Air")) {
                this.setAirSupply(nbt.getShort("Air"));
            }
            this.onGround = nbt.getBoolean("OnGround");
            this.invulnerable = nbt.getBoolean("Invulnerable");
            this.portalCooldown = nbt.getInt("PortalCooldown");
            if (nbt.hasUUID(UUID_TAG)) {
                this.uuid = nbt.getUUID(UUID_TAG);
                this.stringUUID = this.uuid.toString();
            }
            if (!Double.isFinite(this.getX()) || !Double.isFinite(this.getY()) || !Double.isFinite(this.getZ())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.getYRot()) || !Double.isFinite(this.getXRot())) throw new IllegalStateException("Entity has invalid rotation");
            this.reapplyPosition();
            this.setRot(this.getYRot(), this.getXRot());
            if (nbt.contains("CustomName", 8)) {
                String s = nbt.getString("CustomName");
                try {
                    this.setCustomName(Component.Serializer.fromJson(s, (HolderLookup.Provider)this.registryAccess()));
                }
                catch (Exception exception) {
                    LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
                }
            }
            this.setCustomNameVisible(nbt.getBoolean("CustomNameVisible"));
            this.setSilent(nbt.getBoolean("Silent"));
            this.setNoGravity(nbt.getBoolean("NoGravity"));
            this.setGlowingTag(nbt.getBoolean("Glowing"));
            this.setTicksFrozen(nbt.getInt("TicksFrozen"));
            this.hasVisualFire = nbt.getBoolean("HasVisualFire");
            if (nbt.contains("Tags", 9)) {
                this.tags.clear();
                ListTag nbttaglist3 = nbt.getList("Tags", 8);
                int i = Math.min(nbttaglist3.size(), 1024);
                for (int j = 0; j < i; ++j) {
                    this.tags.add(nbttaglist3.getString(j));
                }
            }
            this.readAdditionalSaveData(nbt);
            if (this.repositionEntityAfterLoad()) {
                this.reapplyPosition();
            }
            if (this instanceof LivingEntity) {
                this.tickCount = nbt.getInt("Spigot.ticksLived");
            }
            this.persist = !nbt.contains("Bukkit.persist") || nbt.getBoolean("Bukkit.persist");
            boolean bl = this.visibleByDefault = !nbt.contains("Bukkit.visibleByDefault") || nbt.getBoolean("Bukkit.visibleByDefault");
            if (nbt.contains("Bukkit.MaxAirSupply")) {
                this.maxAirTicks = nbt.getInt("Bukkit.MaxAirSupply");
            }
            this.getBukkitEntity().readBukkitValues(nbt);
            if (nbt.contains("Bukkit.invisible")) {
                boolean bukkitInvisible = nbt.getBoolean("Bukkit.invisible");
                this.setInvisible(bukkitInvisible);
                this.persistentInvisibility = bukkitInvisible;
            }
            if (!(originTag = nbt.getList("Paper.Origin", 6)).isEmpty()) {
                UUID originWorld = null;
                if (nbt.contains("Paper.OriginWorld")) {
                    originWorld = nbt.getUUID("Paper.OriginWorld");
                } else if (this.level != null) {
                    originWorld = this.level.getWorld().getUID();
                }
                this.originWorld = originWorld;
                this.origin = new Vector(originTag.getDouble(0), originTag.getDouble(1), originTag.getDouble(2));
            }
            this.spawnedViaMobSpawner = nbt.getBoolean("Paper.FromMobSpawner");
            this.fromNetherPortal = nbt.getBoolean("Paper.FromNetherPortal");
            if (nbt.contains("Paper.SpawnReason")) {
                String spawnReasonName = nbt.getString("Paper.SpawnReason");
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)spawnReasonName);
                }
                catch (Exception ignored) {
                    LOGGER.error("Unknown SpawnReason " + spawnReasonName + " for " + String.valueOf(this));
                }
            }
            if (this.spawnReason == null) {
                if (this.spawnedViaMobSpawner) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                } else if (this instanceof Mob && (this instanceof Animal || this instanceof AbstractFish) && !((Mob)this).removeWhenFarAway(0.0) && !nbt.getBoolean("PersistenceRequired")) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
                }
            }
            if (this.spawnReason == null) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            }
            if (nbt.contains("Paper.FreezeLock")) {
                this.freezeLocked = nbt.getBoolean("Paper.FreezeLock");
            }
            if (!nbt.contains("Purpur.FireImmune")) return;
            this.immuneToFire = nbt.getBoolean("Purpur.FireImmune");
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Loading entity NBT");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Entity being loaded");
            this.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean repositionEntityAfterLoad() {
        return true;
    }

    @javax.annotation.Nullable
    public final String getEncodeId() {
        EntityType<?> entitytypes = this.getType();
        ResourceLocation minecraftkey = EntityType.getKey(entitytypes);
        return entitytypes.canSerialize() && minecraftkey != null ? minecraftkey.toString() : null;
    }

    protected void addAdditionalSaveData(CompoundTag nbttagcompound, boolean includeAll) {
        this.addAdditionalSaveData(nbttagcompound);
    }

    protected abstract void readAdditionalSaveData(CompoundTag var1);

    protected abstract void addAdditionalSaveData(CompoundTag var1);

    protected ListTag newDoubleList(double ... values) {
        ListTag nbttaglist = new ListTag();
        double[] adouble1 = values;
        int i = values.length;
        for (int j = 0; j < i; ++j) {
            double d0 = adouble1[j];
            nbttaglist.add(DoubleTag.valueOf(d0));
        }
        return nbttaglist;
    }

    protected ListTag newFloatList(float ... values) {
        ListTag nbttaglist = new ListTag();
        float[] afloat1 = values;
        int i = values.length;
        for (int j = 0; j < i; ++j) {
            float f = afloat1[j];
            nbttaglist.add(FloatTag.valueOf(f));
        }
        return nbttaglist;
    }

    @javax.annotation.Nullable
    public ItemEntity spawnAtLocation(ItemLike item) {
        return this.spawnAtLocation(item, 0);
    }

    @javax.annotation.Nullable
    public ItemEntity spawnAtLocation(ItemLike item, int yOffset) {
        return this.spawnAtLocation(new ItemStack(item), (float)yOffset);
    }

    @javax.annotation.Nullable
    public ItemEntity spawnAtLocation(ItemStack stack) {
        return this.spawnAtLocation(stack, 0.0f);
    }

    @javax.annotation.Nullable
    public ItemEntity spawnAtLocation(ItemStack stack, float yOffset) {
        return this.spawnAtLocation(stack, yOffset, null);
    }

    @javax.annotation.Nullable
    public ItemEntity spawnAtLocation(ItemStack stack, float yOffset, @javax.annotation.Nullable Consumer<? super ItemEntity> delayedAddConsumer) {
        if (stack.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide) {
            return null;
        }
        if (this instanceof LivingEntity && !((LivingEntity)this).forceDrops) {
            ((LivingEntity)this).drops.add(new DefaultDrop(stack, itemStack -> {
                ItemEntity itemEntity = new ItemEntity(this.level, this.getX(), this.getY() + (double)yOffset, this.getZ(), (ItemStack)itemStack);
                itemEntity.setDefaultPickUpDelay();
                this.level.addFreshEntity(itemEntity);
                if (delayedAddConsumer != null) {
                    delayedAddConsumer.accept(itemEntity);
                }
            }));
            return null;
        }
        ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY() + (double)yOffset, this.getZ(), stack.copy());
        stack.setCount(0);
        entityitem.setDefaultPickUpDelay();
        return this.spawnAtLocation(entityitem);
    }

    @javax.annotation.Nullable
    public ItemEntity spawnAtLocation(ItemEntity entityitem) {
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        this.level().addFreshEntity(entityitem);
        return entityitem;
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public boolean isInWall() {
        if (this.noPhysics) {
            return false;
        }
        float reducedWith = this.dimensions.width() * 0.8f;
        AABB box = AABB.ofSize(this.getEyePosition(), reducedWith, 1.0E-6, reducedWith);
        if (CollisionUtil.isEmpty(box)) {
            return false;
        }
        BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
        int minX = Mth.floor(box.minX);
        int minY = Mth.floor(box.minY);
        int minZ = Mth.floor(box.minZ);
        int maxX = Mth.floor(box.maxX);
        int maxY = Mth.floor(box.maxY);
        int maxZ = Mth.floor(box.maxZ);
        ChunkSource chunkProvider = this.level.getChunkSource();
        long lastChunkKey = ChunkPos.INVALID_CHUNK_POS;
        LevelChunk lastChunk = null;
        for (int fz = minZ; fz <= maxZ; ++fz) {
            tempPos.setZ(fz);
            for (int fx = minX; fx <= maxX; ++fx) {
                int newChunkX = fx >> 4;
                int newChunkZ = fz >> 4;
                LevelChunk chunk = lastChunkKey == (lastChunkKey = CoordinateUtils.getChunkKey(newChunkX, newChunkZ)) ? lastChunk : (LevelChunk)chunkProvider.getChunk(newChunkX, newChunkZ, ChunkStatus.FULL, true);
                tempPos.setX(fx);
                for (int fy = minY; fy <= maxY; ++fy) {
                    VoxelShape collisionShape;
                    tempPos.setY(fy);
                    BlockState state = chunk.getBlockState(tempPos);
                    if (state.moonrise$emptyCollisionShape() || !state.isSuffocating(this.level, tempPos) || (collisionShape = state.getCollisionShape(this.level, tempPos)).isEmpty()) continue;
                    AABB toCollide = box.move(-((double)fx), -((double)fy), -((double)fz));
                    AABB singleAABB = collisionShape.moonrise$getSingleAABBRepresentation();
                    if (!(singleAABB != null ? CollisionUtil.voxelShapeIntersect(singleAABB, toCollide) : CollisionUtil.voxelShapeIntersectNoEmpty(collisionShape, toCollide))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        Entity entity;
        if (this.isAlive() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.getLeashHolder() == player) {
                if (!this.level().isClientSide()) {
                    if (hand == InteractionHand.OFF_HAND && (this.level().purpurConfig.villagerCanBeLeashed || this.level().purpurConfig.wanderingTraderCanBeLeashed) && this instanceof AbstractVillager) {
                        return InteractionResult.CONSUME;
                    }
                    PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(this, player, hand, !player.hasInfiniteMaterials());
                    if (event.isCancelled()) {
                        ((ServerPlayer)player).connection.send(new ClientboundSetEntityLinkPacket(this, leashable.getLeashHolder()));
                        return InteractionResult.PASS;
                    }
                    leashable.dropLeash(true, event.isDropLeash());
                    this.gameEvent(GameEvent.ENTITY_INTERACT, player);
                }
                return InteractionResult.sidedSuccess(this.level().isClientSide);
            }
            ItemStack itemstack = player.getItemInHand(hand);
            if (itemstack.is(Items.LEAD) && leashable.canHaveALeashAttachedToIt()) {
                if (!this.level().isClientSide()) {
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, player, player, hand).isCancelled()) {
                        ((ServerPlayer)player).connection.send(new ClientboundSetEntityLinkPacket(this, leashable.getLeashHolder()));
                        player.containerMenu.sendAllDataToRemote();
                        return InteractionResult.PASS;
                    }
                    leashable.setLeashedTo(player, true);
                }
                itemstack.shrink(1);
                return InteractionResult.sidedSuccess(this.level().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canCollideWith(Entity other) {
        return other.canBeCollidedWith() && !this.isPassengerOfSameVehicle(other);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void rideTick() {
        this.setDeltaMovement(Vec3.ZERO);
        this.tick();
        if (this.isPassenger()) {
            this.getVehicle().positionRider(this);
        }
    }

    public final void positionRider(Entity passenger) {
        if (this.hasPassenger(passenger)) {
            this.positionRider(passenger, Entity::setPos);
        }
    }

    protected void positionRider(Entity passenger, MoveFunction positionUpdater) {
        Vec3 vec3d = this.getPassengerRidingPosition(passenger);
        Vec3 vec3d1 = passenger.getVehicleAttachmentPoint(this);
        positionUpdater.accept(passenger, vec3d.x - vec3d1.x, vec3d.y - vec3d1.y, vec3d.z - vec3d1.z);
    }

    public void onPassengerTurned(Entity passenger) {
    }

    public Vec3 getVehicleAttachmentPoint(Entity vehicle) {
        return this.getAttachments().get(EntityAttachment.VEHICLE, 0, this.yRot);
    }

    public Vec3 getPassengerRidingPosition(Entity passenger) {
        return this.position().add(this.getPassengerAttachmentPoint(passenger, this.dimensions, 1.0f));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimensions, float scaleFactor) {
        return Entity.getDefaultPassengerAttachmentPoint(this, passenger, dimensions.attachments());
    }

    protected static Vec3 getDefaultPassengerAttachmentPoint(Entity vehicle, Entity passenger, EntityAttachments attachments) {
        int i = vehicle.getPassengers().indexOf(passenger);
        return attachments.getClamped(EntityAttachment.PASSENGER, i, vehicle.yRot);
    }

    public boolean startRiding(Entity entity) {
        return this.startRiding(entity, false);
    }

    public boolean showVehicleHealth() {
        return this instanceof LivingEntity;
    }

    public boolean startRiding(Entity entity, boolean force) {
        EntityMountEvent event;
        if (entity == this.vehicle || entity.level != this.level) {
            return false;
        }
        if (!entity.couldAcceptPassenger()) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.vehicle != null) {
            if (entity1.vehicle == this) {
                return false;
            }
            entity1 = entity1.vehicle;
        }
        if (!(force || this.canRide(entity) && entity.canAddPassenger(this))) {
            return false;
        }
        if (entity.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof org.bukkit.entity.LivingEntity) {
            event = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
        }
        event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
        this.setPose(Pose.STANDING);
        this.vehicle = entity;
        this.vehicle.addPassenger(this);
        entity.getIndirectPassengersStream().filter(entity2 -> entity2 instanceof ServerPlayer).forEach(entity2 -> CriteriaTriggers.START_RIDING_TRIGGER.trigger((ServerPlayer)entity2));
        return true;
    }

    protected boolean canRide(Entity entity) {
        return !this.isShiftKeyDown() && this.boardingCooldown <= 0;
    }

    public void ejectPassengers() {
        for (int i = this.passengers.size() - 1; i >= 0; --i) {
            ((Entity)this.passengers.get(i)).stopRiding();
        }
    }

    public void removeVehicle() {
        this.removeVehicle(false);
    }

    public void removeVehicle(boolean suppressCancellation) {
        if (this.vehicle != null) {
            Entity entity = this.vehicle;
            this.vehicle = null;
            if (!entity.removePassenger(this, suppressCancellation)) {
                this.vehicle = entity;
            }
        }
    }

    public void stopRiding() {
        this.stopRiding(false);
    }

    public void stopRiding(boolean suppressCancellation) {
        this.removeVehicle(suppressCancellation);
    }

    protected void addPassenger(Entity passenger) {
        if (passenger.getVehicle() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.passengers.isEmpty()) {
            this.passengers = ImmutableList.of((Object)passenger);
        } else {
            ArrayList list = Lists.newArrayList(this.passengers);
            if (!this.level().isClientSide && passenger instanceof Player && !(this.getFirstPassenger() instanceof Player)) {
                list.add(0, passenger);
            } else {
                list.add(passenger);
            }
            this.passengers = ImmutableList.copyOf((Collection)list);
        }
        if (this.isRidable() && this.passengers.get(0) == passenger && passenger instanceof Player) {
            Player player = (Player)passenger;
            this.onMount(player);
            this.rider = player;
        }
        this.gameEvent(GameEvent.ENTITY_MOUNT, passenger);
    }

    protected boolean removePassenger(Entity entity) {
        return this.removePassenger(entity, false);
    }

    protected boolean removePassenger(Entity entity, boolean suppressCancellation) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.getVehicle() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof org.bukkit.entity.LivingEntity) {
            CraftEntity craftn;
            Entity n;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.LivingEntity)entity.getBukkitEntity(), !suppressCancellation);
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), !suppressCancellation);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.rider != null && this.passengers.get(0) == this.rider) {
            this.onDismount(this.rider);
            this.rider = null;
        }
        this.passengers = this.passengers.size() == 1 && this.passengers.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.passengers.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.boardingCooldown = 60;
        this.gameEvent(GameEvent.ENTITY_DISMOUNT, entity);
        return true;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.passengers.isEmpty();
    }

    protected boolean couldAcceptPassenger() {
        return true;
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.setPos(x, y, z);
        this.setRot(yaw, pitch);
    }

    public double lerpTargetX() {
        return this.getX();
    }

    public double lerpTargetY() {
        return this.getY();
    }

    public double lerpTargetZ() {
        return this.getZ();
    }

    public float lerpTargetXRot() {
        return this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.getYRot();
    }

    public void lerpHeadTo(float yaw, int interpolationSteps) {
        this.setYHeadRot(yaw);
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public Vec3 getLookAngle() {
        return this.calculateViewVector(this.getXRot(), this.getYRot());
    }

    public Vec3 getHandHoldingItemAngle(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof Player)) {
            return Vec3.ZERO;
        }
        Player entityhuman = (Player)entity;
        boolean flag = entityhuman.getOffhandItem().is(item) && !entityhuman.getMainHandItem().is(item);
        HumanoidArm enummainhand = flag ? entityhuman.getMainArm().getOpposite() : entityhuman.getMainArm();
        return this.calculateViewVector(0.0f, this.getYRot() + (float)(enummainhand == HumanoidArm.RIGHT ? 80 : -80)).scale(0.5);
    }

    public Vec2 getRotationVector() {
        return new Vec2(this.getXRot(), this.getYRot());
    }

    public Vec3 getForward() {
        return Vec3.directionFromRotation(this.getRotationVector());
    }

    public void setAsInsidePortal(Portal portal, BlockPos pos) {
        if (this.isOnPortalCooldown()) {
            if (!this.level().purpurConfig.playerFixStuckPortal || !(this instanceof Player) || pos.equals(this.portalPos)) {
                this.setPortalCooldown();
            }
        } else if (this.level.purpurConfig.entitiesCanUsePortals || this instanceof ServerPlayer) {
            if (this.portalProcess != null && this.portalProcess.isSamePortal(portal)) {
                this.portalProcess.updateEntryPosition(pos.immutable());
                this.portalProcess.setAsInsidePortalThisTick(true);
                this.portalPos = BlockPos.ZERO;
            } else {
                this.portalProcess = new PortalProcessor(portal, pos.immutable());
            }
        }
    }

    protected void handlePortal() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.processPortalCooldown();
            if (this.portalProcess != null) {
                if (this.portalProcess.processPortalTeleportation(worldserver, this, this.canUsePortal(false))) {
                    this.setPortalCooldown();
                    DimensionTransition dimensiontransition = this.portalProcess.getPortalDestination(worldserver, this);
                    if (dimensiontransition != null) {
                        ServerLevel worldserver1 = dimensiontransition.newLevel();
                        if (this instanceof ServerPlayer || worldserver1 != null && (worldserver1.dimension() == worldserver.dimension() || this.canChangeDimensions(worldserver, worldserver1))) {
                            this.changeDimension(dimensiontransition);
                        }
                    }
                } else if (this.portalProcess.hasExpired()) {
                    this.portalProcess = null;
                }
            }
        }
    }

    public int getDimensionChangingDelay() {
        Entity entity = this.getFirstPassenger();
        return entity instanceof ServerPlayer ? entity.getDimensionChangingDelay() : 300;
    }

    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
    }

    public void handleDamageEvent(DamageSource damageSource) {
    }

    public void handleEntityEvent(byte status) {
        switch (status) {
            case 53: {
                HoneyBlock.showSlideParticles(this);
            }
        }
    }

    public void animateHurt(float yaw) {
    }

    public boolean isOnFire() {
        boolean flag = this.level() != null && this.level().isClientSide;
        return !this.fireImmune() && (this.remainingFireTicks > 0 || flag && this.getSharedFlag(0));
    }

    public boolean isPassenger() {
        return this.getVehicle() != null;
    }

    public boolean isVehicle() {
        return !this.passengers.isEmpty();
    }

    public boolean dismountsUnderwater() {
        return this.getType().is(EntityTypeTags.DISMOUNTS_UNDERWATER);
    }

    public boolean canControlVehicle() {
        return !this.getType().is(EntityTypeTags.NON_CONTROLLING_RIDER);
    }

    public void setShiftKeyDown(boolean sneaking) {
        this.setSharedFlag(1, sneaking);
    }

    public boolean isShiftKeyDown() {
        return this.getSharedFlag(1);
    }

    public boolean isSteppingCarefully() {
        return this.isShiftKeyDown();
    }

    public boolean isSuppressingBounce() {
        return this.isShiftKeyDown();
    }

    public boolean isDiscrete() {
        return this.isShiftKeyDown();
    }

    public boolean isDescending() {
        return this.isShiftKeyDown();
    }

    public boolean isCrouching() {
        return this.hasPose(Pose.CROUCHING);
    }

    public boolean isSprinting() {
        return this.getSharedFlag(3);
    }

    public void setSprinting(boolean sprinting) {
        this.setSharedFlag(3, sprinting);
    }

    public boolean isSwimming() {
        return this.getSharedFlag(4);
    }

    public boolean isVisuallySwimming() {
        return this.hasPose(Pose.SWIMMING);
    }

    public boolean isVisuallyCrawling() {
        return this.isVisuallySwimming() && !this.isInWater();
    }

    public void setSwimming(boolean swimming) {
        if (this.valid && this.isSwimming() != swimming && this instanceof LivingEntity && CraftEventFactory.callToggleSwimEvent((LivingEntity)this, swimming).isCancelled()) {
            return;
        }
        this.setSharedFlag(4, swimming);
    }

    public final boolean hasGlowingTag() {
        return this.hasGlowingTag;
    }

    public final void setGlowingTag(boolean glowing) {
        this.hasGlowingTag = glowing;
        this.setSharedFlag(6, this.isCurrentlyGlowing());
    }

    public boolean isCurrentlyGlowing() {
        return this.level().isClientSide() ? this.getSharedFlag(6) : this.hasGlowingTag;
    }

    public boolean isInvisible() {
        return this.getSharedFlag(5);
    }

    public boolean isInvisibleTo(Player player) {
        if (player.isSpectator()) {
            return false;
        }
        PlayerTeam scoreboardteam = this.getTeam();
        return scoreboardteam != null && player != null && player.getTeam() == scoreboardteam && scoreboardteam.canSeeFriendlyInvisibles() ? false : this.isInvisible();
    }

    public boolean isOnRails() {
        return false;
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> callback) {
    }

    @javax.annotation.Nullable
    public PlayerTeam getTeam() {
        if (!this.level().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof Player)) {
            return null;
        }
        return this.level().getScoreboard().getPlayersTeam(this.getScoreboardName());
    }

    public boolean isAlliedTo(Entity other) {
        return this.isAlliedTo(other.getTeam());
    }

    public boolean isAlliedTo(Team team) {
        return this.getTeam() != null ? this.getTeam().isAlliedTo(team) : false;
    }

    public void setInvisible(boolean invisible) {
        if (!this.persistentInvisibility) {
            this.setSharedFlag(5, invisible);
        }
    }

    public boolean getSharedFlag(int index) {
        return (this.entityData.get(DATA_SHARED_FLAGS_ID) & 1 << index) != 0;
    }

    public void setSharedFlag(int index, boolean value) {
        byte b0 = this.entityData.get(DATA_SHARED_FLAGS_ID);
        if (value) {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(b0 | 1 << index));
        } else {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(b0 & ~(1 << index)));
        }
    }

    public int getMaxAirSupply() {
        return this.level == null ? this.maxAirTicks : this.level().purpurConfig.drowningAirTicks;
    }

    public int getAirSupply() {
        return this.entityData.get(DATA_AIR_SUPPLY_ID);
    }

    public void setAirSupply(int air) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), air);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.getAirSupply() != air) {
            this.entityData.markDirty(DATA_AIR_SUPPLY_ID);
            return;
        }
        this.entityData.set(DATA_AIR_SUPPLY_ID, event.getAmount());
    }

    public int getTicksFrozen() {
        return this.entityData.get(DATA_TICKS_FROZEN);
    }

    public void setTicksFrozen(int frozenTicks) {
        this.entityData.set(DATA_TICKS_FROZEN, frozenTicks);
    }

    public float getPercentFrozen() {
        int i = this.getTicksRequiredToFreeze();
        return (float)Math.min(this.getTicksFrozen(), i) / (float)i;
    }

    public boolean isFullyFrozen() {
        return this.getTicksFrozen() >= this.getTicksRequiredToFreeze();
    }

    public int getTicksRequiredToFreeze() {
        return 140;
    }

    public void thunderHit(ServerLevel world, LightningBolt lightning) {
        this.setRemainingFireTicks(this.remainingFireTicks + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = lightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.remainingFireTicks == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            } else {
                this.setRemainingFireTicks(this.remainingFireTicks - 1);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.fireImmune()) {
            return;
        }
        if (!this.hurt(this.damageSources().lightningBolt().customEventDamager(lightning), 5.0f)) {
            return;
        }
    }

    public void onAboveBubbleCol(boolean drag) {
        Vec3 vec3d = this.getDeltaMovement();
        double d0 = drag ? Math.max(-0.9, vec3d.y - 0.03) : Math.min(1.8, vec3d.y + 0.1);
        this.setDeltaMovement(vec3d.x, d0, vec3d.z);
    }

    public void onInsideBubbleColumn(boolean drag) {
        Vec3 vec3d = this.getDeltaMovement();
        double d0 = drag ? Math.max(-0.3, vec3d.y - 0.03) : Math.min(0.7, vec3d.y + 0.06);
        this.setDeltaMovement(vec3d.x, d0, vec3d.z);
        this.resetFallDistance();
    }

    public boolean killedEntity(ServerLevel world, LivingEntity other) {
        return true;
    }

    public void checkSlowFallDistance() {
        if (this.getDeltaMovement().y() > -0.5 && this.fallDistance > 1.0f) {
            this.fallDistance = 1.0f;
        }
    }

    public void resetFallDistance() {
        this.fallDistance = 0.0f;
    }

    protected void moveTowardsClosestSpace(double x, double y, double z) {
        BlockPos blockposition = BlockPos.containing(x, y, z);
        Vec3 vec3d = new Vec3(x - (double)blockposition.getX(), y - (double)blockposition.getY(), z - (double)blockposition.getZ());
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        Direction enumdirection = Direction.UP;
        double d3 = Double.MAX_VALUE;
        for (Direction enumdirection1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d5;
            blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, enumdirection1);
            if (this.level().getBlockState(blockposition_mutableblockposition).isCollisionShapeFullBlock(this.level(), blockposition_mutableblockposition)) continue;
            double d4 = vec3d.get(enumdirection1.getAxis());
            double d = d5 = enumdirection1.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f = this.random.nextFloat() * 0.2f + 0.1f;
        float f1 = enumdirection.getAxisDirection().getStep();
        Vec3 vec3d1 = this.getDeltaMovement().scale(0.75);
        if (enumdirection.getAxis() == Direction.Axis.X) {
            this.setDeltaMovement(f1 * f, vec3d1.y, vec3d1.z);
        } else if (enumdirection.getAxis() == Direction.Axis.Y) {
            this.setDeltaMovement(vec3d1.x, f1 * f, vec3d1.z);
        } else if (enumdirection.getAxis() == Direction.Axis.Z) {
            this.setDeltaMovement(vec3d1.x, vec3d1.y, f1 * f);
        }
    }

    public void makeStuckInBlock(BlockState state, Vec3 multiplier) {
        this.resetFallDistance();
        this.stuckSpeedMultiplier = multiplier;
    }

    private static net.minecraft.network.chat.Component removeAction(net.minecraft.network.chat.Component textComponent) {
        MutableComponent ichatmutablecomponent = textComponent.plainCopy().setStyle(textComponent.getStyle().withClickEvent(null));
        for (net.minecraft.network.chat.Component ichatbasecomponent1 : textComponent.getSiblings()) {
            ichatmutablecomponent.append(Entity.removeAction(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public net.minecraft.network.chat.Component getName() {
        net.minecraft.network.chat.Component ichatbasecomponent = this.getCustomName();
        return ichatbasecomponent != null ? Entity.removeAction(ichatbasecomponent) : this.getTypeName();
    }

    protected net.minecraft.network.chat.Component getTypeName() {
        return this.type.getDescription();
    }

    public boolean is(Entity entity) {
        return this == entity;
    }

    public float getYHeadRot() {
        return 0.0f;
    }

    public void setYHeadRot(float headYaw) {
    }

    public void setYBodyRot(float bodyYaw) {
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity attacker) {
        return false;
    }

    public String toString() {
        String s = this.level() == null ? "~NULL~" : this.level().toString();
        return this.removalReason != null ? String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.getName().getString(), this.id, this.uuid, s, this.getX(), this.getY(), this.getZ(), this.chunkPosition(), this.tickCount, this.valid, this.removalReason}) : String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b]", this.getClass().getSimpleName(), this.getName().getString(), this.id, this.uuid, s, this.getX(), this.getY(), this.getZ(), this.chunkPosition(), this.tickCount, this.valid);
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        return this.isRemoved() || this.invulnerable && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !damageSource.isCreativePlayer() || damageSource.is(DamageTypeTags.IS_FIRE) && this.fireImmune() || damageSource.is(DamageTypeTags.IS_FALL) && this.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE);
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean invulnerable) {
        this.invulnerable = invulnerable;
    }

    public void copyPosition(Entity entity) {
        this.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
    }

    public void restoreFrom(Entity original) {
        CraftEntity bukkitEntity = original.bukkitEntity;
        if (bukkitEntity != null) {
            bukkitEntity.setHandle(this);
            this.bukkitEntity = bukkitEntity;
        }
        CompoundTag nbttagcompound = original.saveWithoutId(new CompoundTag());
        nbttagcompound.remove("Dimension");
        this.load(nbttagcompound);
        this.portalCooldown = original.portalCooldown;
        this.portalProcess = original.portalProcess;
    }

    @javax.annotation.Nullable
    public Entity changeDimension(DimensionTransition teleportTarget) {
        Level world = this.level();
        if (!this.isAlive() || !this.valid) {
            LOGGER.warn("Illegal Entity Teleport " + String.valueOf(this) + " to " + String.valueOf(teleportTarget.newLevel()) + ":" + String.valueOf(teleportTarget.pos()), new Throwable());
            return null;
        }
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (!this.isRemoved()) {
                Entity entity2;
                EntityTeleportEvent teleEvent;
                BlockEntity blockEntity;
                Location to = new Location((World)teleportTarget.newLevel().getWorld(), teleportTarget.pos().x, teleportTarget.pos().y, teleportTarget.pos().z, teleportTarget.yRot(), this.getXRot());
                if (this.portalProcess != null && this.portalProcess.isSamePortal((EndGatewayBlock)Blocks.END_GATEWAY) && (blockEntity = this.level.getBlockEntity(this.portalProcess.getEntryPosition())) instanceof TheEndGatewayBlockEntity) {
                    TheEndGatewayBlockEntity theEndGatewayBlockEntity = (TheEndGatewayBlockEntity)blockEntity;
                    teleEvent = new EntityTeleportEndGatewayEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), this.getBukkitEntity().getLocation(), to, (EndGateway)new CraftEndGateway(to.getWorld(), theEndGatewayBlockEntity));
                    teleEvent.callEvent();
                } else {
                    teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                }
                if (teleEvent.isCancelled() || teleEvent.getTo() == null) {
                    return null;
                }
                to = teleEvent.getTo();
                if (this.portalProcess != null) {
                    CraftEntity bukkitEntity = this.getBukkitEntity();
                    Vec3 velocity = teleportTarget.speed();
                    EntityPortalExitEvent event = new EntityPortalExitEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), to.clone(), bukkitEntity.getVelocity(), CraftVector.toBukkit(velocity));
                    event.callEvent();
                    if (!event.isCancelled() && event.getTo() != null) {
                        to = event.getTo().clone();
                        velocity = CraftVector.toNMS(event.getAfter());
                    }
                    teleportTarget = new DimensionTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), velocity, to.getYaw(), to.getPitch(), teleportTarget.missingRespawnBlock(), teleportTarget.postDimensionTransition(), teleportTarget.cause());
                }
                if (this.isRemoved()) {
                    return null;
                }
                ServerLevel worldserver1 = teleportTarget.newLevel();
                List<Entity> list = this.getPassengers();
                this.unRide();
                ArrayList<Entity> list1 = new ArrayList<Entity>();
                for (Entity entity1 : list) {
                    Entity entity4 = entity1.changeDimension(teleportTarget);
                    if (entity4 == null) continue;
                    list1.add(entity4);
                }
                Entity entity = entity2 = worldserver1.dimension() == worldserver.dimension() ? this : this.getType().create(worldserver1);
                if (entity2 != null) {
                    if (this != entity2) {
                        Entity entity3 = this;
                        if (entity3 instanceof Leashable) {
                            Leashable leashable = (Leashable)((Object)entity3);
                            leashable.dropLeash(true, true);
                        }
                        entity2.restoreFrom(this);
                        this.removeAfterChangingDimensions();
                    }
                    entity2.moveTo(teleportTarget.pos().x, teleportTarget.pos().y, teleportTarget.pos().z, teleportTarget.yRot(), entity2.getXRot());
                    entity2.setDeltaMovement(teleportTarget.speed());
                    if (this != entity2 && this.inWorld) {
                        worldserver1.addDuringTeleport(entity2);
                    }
                    for (Entity entity4 : list1) {
                        entity4.startRiding(entity2, true);
                    }
                    worldserver.resetEmptyTime();
                    worldserver1.resetEmptyTime();
                    teleportTarget.postDimensionTransition().onTransition(entity2);
                }
                return entity2;
            }
        }
        return null;
    }

    public void placePortalTicket(BlockPos pos) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            worldserver.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkPos(pos), 3, pos);
        }
    }

    protected void removeAfterChangingDimensions() {
        Leashable leashable;
        this.setRemoved(RemovalReason.CHANGED_DIMENSION, null);
        Entity entity = this;
        if (entity instanceof Leashable && (leashable = (Leashable)((Object)entity)).isLeashed()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, false);
            event.callEvent();
            leashable.dropLeash(true, event.isDropLeash());
        }
    }

    public Vec3 getRelativePortalPosition(Direction.Axis portalAxis, BlockUtil.FoundRectangle portalRect) {
        return PortalShape.getRelativePosition(portalRect, portalAxis, this.position(), this.getDimensions(this.getPose()));
    }

    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        PortalType portalType = switch (cause) {
            case PlayerTeleportEvent.TeleportCause.END_PORTAL -> PortalType.ENDER;
            case PlayerTeleportEvent.TeleportCause.NETHER_PORTAL -> PortalType.NETHER;
            case PlayerTeleportEvent.TeleportCause.END_GATEWAY -> PortalType.END_GATEWAY;
            default -> PortalType.CUSTOM;
        };
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, true, creationRadius, portalType);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.isAlive()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public boolean canUsePortal(boolean allowVehicles) {
        return !(!allowVehicles && this.isPassenger() || !this.isAlive() || !this.level.purpurConfig.entitiesCanUsePortals && !(this instanceof ServerPlayer));
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return this.isAlive() && this.valid;
    }

    public float getBlockExplosionResistance(Explosion explosion, BlockGetter world, BlockPos pos, BlockState blockState, FluidState fluidState, float max) {
        return max;
    }

    public boolean shouldBlockExplode(Explosion explosion, BlockGetter world, BlockPos pos, BlockState state, float explosionPower) {
        return true;
    }

    public int getMaxFallDistance() {
        return 3;
    }

    public boolean isIgnoringBlockTriggers() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory section) {
        section.setDetail("Entity Type", () -> {
            String s = String.valueOf(EntityType.getKey(this.getType()));
            return s + " (" + this.getClass().getCanonicalName() + ")";
        });
        section.setDetail("Entity ID", this.id);
        section.setDetail("Entity Name", () -> this.getName().getString());
        section.setDetail("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.getX(), this.getY(), this.getZ()));
        section.setDetail("Entity's Block location", CrashReportCategory.formatLocation((LevelHeightAccessor)this.level(), Mth.floor(this.getX()), Mth.floor(this.getY()), Mth.floor(this.getZ())));
        Vec3 vec3d = this.getDeltaMovement();
        section.setDetail("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.x, vec3d.y, vec3d.z));
        section.setDetail("Entity's Passengers", () -> this.getPassengers().toString());
        section.setDetail("Entity's Vehicle", () -> String.valueOf(this.getVehicle()));
    }

    public boolean displayFireAnimation() {
        return this.isOnFire() && !this.isSpectator();
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
        this.stringUUID = this.uuid.toString();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public String getStringUUID() {
        return this.stringUUID;
    }

    @Override
    public String getScoreboardName() {
        return this.stringUUID;
    }

    public boolean isPushedByFluid() {
        return true;
    }

    public static double getViewScale() {
        return viewScale;
    }

    public static void setViewScale(double value) {
        viewScale = value;
    }

    @Override
    public net.minecraft.network.chat.Component getDisplayName() {
        return PlayerTeam.formatNameForTeam(this.getTeam(), this.getName()).withStyle(chatmodifier -> chatmodifier.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()));
    }

    public void setCustomName(@javax.annotation.Nullable net.minecraft.network.chat.Component name) {
        this.entityData.set(DATA_CUSTOM_NAME, Optional.ofNullable(name));
    }

    @Override
    @javax.annotation.Nullable
    public net.minecraft.network.chat.Component getCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).orElse(null);
    }

    @Override
    public boolean hasCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).isPresent();
    }

    public void setCustomNameVisible(boolean visible) {
        this.entityData.set(DATA_CUSTOM_NAME_VISIBLE, visible);
    }

    public boolean isCustomNameVisible() {
        return this.entityData.get(DATA_CUSTOM_NAME_VISIBLE);
    }

    public boolean teleportTo(ServerLevel worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleportTo(worldserver, d0, d1, d2, set, f, f1);
    }

    public boolean teleportTo(ServerLevel world, double destX, double destY, double destZ, Set<RelativeMovement> flags, float yaw, float pitch) {
        float f2 = Mth.clamp(pitch, -90.0f, 90.0f);
        if (world == this.level()) {
            this.moveTo(destX, destY, destZ, yaw, f2);
            this.teleportPassengers();
            this.setYHeadRot(yaw);
        } else {
            this.unRide();
            Object entity = this.getType().create(world);
            if (entity == null) {
                return false;
            }
            ((Entity)entity).restoreFrom(this);
            ((Entity)entity).moveTo(destX, destY, destZ, yaw, f2);
            ((Entity)entity).setYHeadRot(yaw);
            this.setRemoved(RemovalReason.CHANGED_DIMENSION, null);
            if (this.inWorld) {
                world.addDuringTeleport((Entity)entity);
            }
        }
        return true;
    }

    public void dismountTo(double destX, double destY, double destZ) {
        this.teleportTo(destX, destY, destZ);
    }

    public void teleportTo(double destX, double destY, double destZ) {
        if (this.level() instanceof ServerLevel) {
            this.moveTo(destX, destY, destZ, this.getYRot(), this.getXRot());
            this.teleportPassengers();
        }
    }

    private void teleportPassengers() {
        this.getSelfAndPassengers().forEach(entity -> {
            for (Entity entity1 : entity.passengers) {
                entity.positionRider(entity1, Entity::moveTo);
            }
        });
    }

    public void teleportRelative(double offsetX, double offsetY, double offsetZ) {
        this.teleportTo(this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ);
    }

    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    @Override
    public void onSyncedDataUpdated(List<SynchedEntityData.DataValue<?>> entries) {
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_POSE.equals(data)) {
            this.refreshDimensions();
        }
    }

    @Deprecated
    protected void fixupDimensions() {
        EntityDimensions entitysize;
        Pose entitypose = this.getPose();
        this.dimensions = entitysize = this.getDimensions(entitypose);
        this.eyeHeight = entitysize.eyeHeight();
    }

    public void refreshDimensions() {
        boolean flag;
        EntityDimensions entitysize1;
        EntityDimensions entitysize = this.dimensions;
        Pose entitypose = this.getPose();
        this.dimensions = entitysize1 = this.getDimensions(entitypose);
        this.eyeHeight = entitysize1.eyeHeight();
        this.reapplyPosition();
        boolean bl = flag = (double)entitysize1.width() <= 4.0 && (double)entitysize1.height() <= 4.0;
        if (!(this.level.isClientSide || this.firstTick || this.noPhysics || !flag || !(entitysize1.width() > entitysize.width()) && !(entitysize1.height() > entitysize.height()) || this instanceof Player)) {
            this.fudgePositionAfterSizeChange(entitysize);
        }
    }

    public boolean fudgePositionAfterSizeChange(EntityDimensions previous) {
        VoxelShape voxelshape1;
        Optional<Vec3> optional1;
        double d1;
        double d0;
        EntityDimensions entitysize1 = this.getDimensions(this.getPose());
        Vec3 vec3d = this.position().add(0.0, (double)previous.height() / 2.0, 0.0);
        VoxelShape voxelshape = Shapes.create(AABB.ofSize(vec3d, d0 = (double)Math.max(0.0f, entitysize1.width() - previous.width()) + 1.0E-6, d1 = (double)Math.max(0.0f, entitysize1.height() - previous.height()) + 1.0E-6, d0));
        Optional<Vec3> optional = this.level.findFreePosition(this, voxelshape, vec3d, entitysize1.width(), entitysize1.height(), entitysize1.width());
        if (optional.isPresent()) {
            this.setPos(optional.get().add(0.0, (double)(-entitysize1.height()) / 2.0, 0.0));
            return true;
        }
        if (entitysize1.width() > previous.width() && entitysize1.height() > previous.height() && (optional1 = this.level.findFreePosition(this, voxelshape1 = Shapes.create(AABB.ofSize(vec3d, d0, 1.0E-6, d0)), vec3d, entitysize1.width(), previous.height(), entitysize1.width())).isPresent()) {
            this.setPos(optional1.get().add(0.0, (double)(-previous.height()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return Direction.fromYRot(this.getYRot());
    }

    public Direction getMotionDirection() {
        return this.getDirection();
    }

    protected HoverEvent createHoverEvent() {
        return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, new HoverEvent.EntityTooltipInfo(this.getType(), this.getUUID(), this.getName()));
    }

    public boolean broadcastToPlayer(ServerPlayer spectator) {
        return true;
    }

    @Override
    public final AABB getBoundingBox() {
        return this.bb;
    }

    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox();
    }

    public final void setBoundingBox(AABB boundingBox) {
        double minX = boundingBox.minX;
        double minY = boundingBox.minY;
        double minZ = boundingBox.minZ;
        double maxX = boundingBox.maxX;
        double maxY = boundingBox.maxY;
        double maxZ = boundingBox.maxZ;
        double len = boundingBox.maxX - boundingBox.minX;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = boundingBox.maxY - boundingBox.minY) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = boundingBox.maxZ - boundingBox.minZ) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.bb = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float getEyeHeight(Pose pose) {
        return this.getDimensions(pose).eyeHeight();
    }

    public final float getEyeHeight() {
        return this.eyeHeight;
    }

    public Vec3 getLeashOffset(float tickDelta) {
        return this.getLeashOffset();
    }

    protected Vec3 getLeashOffset() {
        return new Vec3(0.0, this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public SlotAccess getSlot(int mappedIndex) {
        return SlotAccess.NULL;
    }

    public void sendMiniMessage(@javax.annotation.Nullable String message) {
        if (message != null && !message.isEmpty()) {
            this.sendMessage(MiniMessage.miniMessage().deserialize((Object)message));
        }
    }

    public void sendMessage(@javax.annotation.Nullable Component message) {
        if (message != null) {
            this.sendSystemMessage(PaperAdventure.asVanilla(message));
        }
    }

    @Override
    public void sendSystemMessage(net.minecraft.network.chat.Component message) {
    }

    public Level getCommandSenderWorld() {
        return this.level();
    }

    @javax.annotation.Nullable
    public MinecraftServer getServer() {
        return this.level().getServer();
    }

    public InteractionResult interactAt(Player player, Vec3 hitPos, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        if (PlayerUntrackEntityEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerUntrackEntityEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity()).callEvent();
        }
    }

    public float rotate(Rotation rotation) {
        float f = Mth.wrapDegrees(this.getYRot());
        switch (rotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 270.0f;
            }
            case CLOCKWISE_90: {
                return f + 90.0f;
            }
        }
        return f;
    }

    public float mirror(Mirror mirror) {
        float f = Mth.wrapDegrees(this.getYRot());
        switch (mirror) {
            case FRONT_BACK: {
                return -f;
            }
            case LEFT_RIGHT: {
                return 180.0f - f;
            }
        }
        return f;
    }

    public boolean onlyOpCanSetNbt() {
        return false;
    }

    public ProjectileDeflection deflection(Projectile projectile) {
        return this.getType().is(EntityTypeTags.DEFLECTS_PROJECTILES) ? ProjectileDeflection.REVERSE : ProjectileDeflection.NONE;
    }

    @javax.annotation.Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public final boolean hasControllingPassenger() {
        return this.getControllingPassenger() != null;
    }

    public final List<Entity> getPassengers() {
        return this.passengers;
    }

    @javax.annotation.Nullable
    public Entity getFirstPassenger() {
        return this.passengers.isEmpty() ? null : (Entity)this.passengers.get(0);
    }

    public boolean hasPassenger(Entity passenger) {
        return this.passengers.contains((Object)passenger);
    }

    public boolean hasPassenger(Predicate<Entity> predicate) {
        Entity entity;
        UnmodifiableIterator unmodifiableiterator = this.passengers.iterator();
        do {
            if (unmodifiableiterator.hasNext()) continue;
            return false;
        } while (!predicate.test(entity = (Entity)unmodifiableiterator.next()));
        return true;
    }

    private Stream<Entity> getIndirectPassengersStream() {
        if (this.passengers.isEmpty()) {
            return Stream.of(new Entity[0]);
        }
        return this.passengers.stream().flatMap(Entity::getSelfAndPassengers);
    }

    public Stream<Entity> getSelfAndPassengers() {
        if (this.passengers.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.getIndirectPassengersStream());
    }

    public Stream<Entity> getPassengersAndSelf() {
        if (this.passengers.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(this.passengers.stream().flatMap(Entity::getPassengersAndSelf), Stream.of(this));
    }

    public Iterable<Entity> getIndirectPassengers() {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        if (this.passengers.isEmpty()) {
            return ret;
        }
        Entity.collectIndirectPassengers(ret, this.passengers);
        return ret;
    }

    private Iterable<Entity> getIndirectPassengers_old() {
        return () -> this.getIndirectPassengersStream().iterator();
    }

    public int countPlayerPassengers() {
        return (int)this.getIndirectPassengersStream().filter(entity -> entity instanceof Player).count();
    }

    public boolean hasExactlyOnePlayerPassenger() {
        if (this.passengers.isEmpty()) {
            return false;
        }
        return this.countPlayerPassengers() == 1;
    }

    public Entity getRootVehicle() {
        Entity entity = this;
        while (entity.isPassenger()) {
            entity = entity.getVehicle();
        }
        return entity;
    }

    public boolean isPassengerOfSameVehicle(Entity entity) {
        return this.getRootVehicle() == entity.getRootVehicle();
    }

    public boolean hasIndirectPassenger(Entity passenger) {
        if (!passenger.isPassenger()) {
            return false;
        }
        Entity entity1 = passenger.getVehicle();
        return entity1 == this ? true : this.hasIndirectPassenger(entity1);
    }

    public boolean isControlledByLocalInstance() {
        LivingEntity entityliving = this.getControllingPassenger();
        if (entityliving instanceof Player) {
            Player entityhuman = (Player)entityliving;
            return entityhuman.isLocalPlayer();
        }
        return this.isEffectiveAi();
    }

    public boolean isEffectiveAi() {
        return !this.level().isClientSide;
    }

    protected static Vec3 getCollisionHorizontalEscapeVector(double vehicleWidth, double passengerWidth, float passengerYaw) {
        double d2 = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f1 = -Mth.sin(passengerYaw * ((float)Math.PI / 180));
        float f2 = Mth.cos(passengerYaw * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f2));
        return new Vec3((double)f1 * d2 / (double)f3, 0.0, (double)f2 * d2 / (double)f3);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        return new Vec3(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @javax.annotation.Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    @javax.annotation.Nullable
    public Entity getControlledVehicle() {
        return this.vehicle != null && this.vehicle.getControllingPassenger() == this ? this.vehicle : null;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.NORMAL;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public int getFireImmuneTicks() {
        return 1;
    }

    public CommandSourceStack createCommandSourceStack() {
        return new CommandSourceStack(this, this.position(), this.getRotationVector(), this.level() instanceof ServerLevel ? (ServerLevel)this.level() : null, this.getPermissionLevel(), this.getName().getString(), this.getDisplayName(), this.level().getServer(), this);
    }

    protected int getPermissionLevel() {
        return 0;
    }

    public boolean hasPermissions(int permissionLevel) {
        return this.getPermissionLevel() >= permissionLevel;
    }

    @Override
    public boolean acceptsSuccess() {
        return this.level().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public boolean shouldInformAdmins() {
        return true;
    }

    public void lookAt(EntityAnchorArgument.Anchor anchorPoint, Vec3 target) {
        Vec3 vec3d1 = anchorPoint.apply(this);
        double d0 = target.x - vec3d1.x;
        double d1 = target.y - vec3d1.y;
        double d2 = target.z - vec3d1.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.setXRot(Mth.wrapDegrees((float)(-(Mth.atan2(d1, d3) * 57.2957763671875))));
        this.setYRot(Mth.wrapDegrees((float)(Mth.atan2(d2, d0) * 57.2957763671875) - 90.0f));
        this.setYHeadRot(this.getYRot());
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    public float getPreciseBodyRotation(float delta) {
        return Mth.lerp(delta, this.yRotO, this.yRot);
    }

    public AABB getAxisForFluidCheck() {
        return this.getBoundingBox().deflate(0.001);
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tag, double speed) {
        AABB axisalignedbb = this.getBoundingBox().deflate(0.001);
        int minBlockX = Mth.floor(axisalignedbb.minX);
        int maxBlockX = Mth.ceil(axisalignedbb.maxX);
        int minBlockY = Mth.floor(axisalignedbb.minY);
        int maxBlockY = Mth.ceil(axisalignedbb.maxY);
        int minBlockZ = Mth.floor(axisalignedbb.minZ);
        int maxBlockZ = Mth.ceil(axisalignedbb.maxZ);
        double d1 = 0.0;
        boolean flag = this.isPushedByFluid();
        boolean flag1 = false;
        Vec3 vec3d = Vec3.ZERO;
        int k1 = 0;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        int minSection = WorldUtil.getMinSection(this.level());
        int maxSection = WorldUtil.getMaxSection(this.level());
        int minBlock = minSection << 4;
        int maxBlock = maxSection << 4 | 0xF;
        if (minBlockY > maxBlock || maxBlockY < minBlock) {
            return false;
        }
        int minYIterate = Math.max(minBlock, minBlockY);
        int maxYIterate = Math.min(maxBlock, maxBlockY);
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            int minZ = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
            int maxZ = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 16;
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                int minX = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                int maxX = currChunkX == maxChunkX ? maxBlockX & 0xF : 16;
                ChunkAccess chunk = this.level().getChunkIfLoadedImmediately(currChunkX, currChunkZ);
                if (chunk == null) {
                    return false;
                }
                LevelChunkSection[] sections = chunk.getSections();
                for (int currY = minYIterate; currY < maxYIterate; ++currY) {
                    LevelChunkSection section = sections[(currY >> 4) - minSection];
                    if (section == null || section.hasOnlyAir() || section.fluidStateCount == 0) {
                        currY = (currY & 0xFFFFFFF0) + 15;
                        continue;
                    }
                    PalettedContainer<BlockState> blocks = section.states;
                    for (int currZ = minZ; currZ < maxZ; ++currZ) {
                        for (int currX = minX; currX < maxX; ++currX) {
                            FluidState fluid = blocks.get(currX & 0xF, currY & 0xF, currZ & 0xF).getFluidState();
                            if (!fluid.is(tag)) continue;
                            blockposition_mutableblockposition.set((currChunkX << 4) + currX, currY, (currChunkZ << 4) + currZ);
                            double d2 = (float)currY + fluid.getHeight(this.level(), blockposition_mutableblockposition);
                            if (!(d2 >= axisalignedbb.minY)) continue;
                            flag1 = true;
                            d1 = Math.max(d2 - axisalignedbb.minY, d1);
                            if (flag) {
                                Vec3 vec3d1 = fluid.getFlow(this.level(), blockposition_mutableblockposition);
                                if (d1 < 0.4) {
                                    vec3d1 = vec3d1.scale(d1);
                                }
                                vec3d = vec3d.add(vec3d1);
                                ++k1;
                            }
                            if (tag != FluidTags.LAVA) continue;
                            this.lastLavaContact = blockposition_mutableblockposition.immutable();
                        }
                    }
                }
            }
        }
        if (vec3d.length() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.scale(1.0 / (double)k1);
            }
            if (!(this instanceof Player)) {
                vec3d = vec3d.normalize();
            }
            Vec3 vec3d2 = this.getDeltaMovement();
            vec3d = vec3d.scale(speed);
            double d3 = 0.003;
            if (Math.abs(vec3d2.x) < 0.003 && Math.abs(vec3d2.z) < 0.003 && vec3d.length() < 0.0045000000000000005) {
                vec3d = vec3d.normalize().scale(0.0045000000000000005);
            }
            this.setDeltaMovement(this.getDeltaMovement().add(vec3d));
        }
        this.fluidHeight.put(tag, d1);
        return flag1;
    }

    public boolean touchingUnloadedChunk() {
        AABB axisalignedbb = this.getBoundingBox().inflate(1.0);
        int i = Mth.floor(axisalignedbb.minX);
        int j = Mth.ceil(axisalignedbb.maxX);
        int k = Mth.floor(axisalignedbb.minZ);
        int l = Mth.ceil(axisalignedbb.maxZ);
        return !this.level().hasChunksAt(i, k, j, l);
    }

    public double getFluidHeight(TagKey<Fluid> fluid) {
        return this.fluidHeight.getDouble(fluid);
    }

    public double getFluidJumpThreshold() {
        return (double)this.getEyeHeight() < 0.4 ? 0.0 : 0.4;
    }

    public final float getBbWidth() {
        return this.dimensions.width();
    }

    public final float getBbHeight() {
        return this.dimensions.height();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        return new ClientboundAddEntityPacket(this, entityTrackerEntry);
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.type.getDimensions();
    }

    public final EntityAttachments getAttachments() {
        return this.dimensions.attachments();
    }

    public Vec3 position() {
        return this.position;
    }

    public Vec3 trackingPosition() {
        return this.position();
    }

    @Override
    public BlockPos blockPosition() {
        return this.blockPosition;
    }

    public BlockState getInBlockState() {
        if (this.inBlockState == null) {
            this.inBlockState = this.level().getBlockState(this.blockPosition());
        }
        return this.inBlockState;
    }

    public ChunkPos chunkPosition() {
        return this.chunkPosition;
    }

    public Vec3 getDeltaMovement() {
        return this.deltaMovement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeltaMovement(Vec3 velocity) {
        Object object = this.posLock;
        synchronized (object) {
            this.deltaMovement = velocity;
        }
    }

    public void addDeltaMovement(Vec3 velocity) {
        this.setDeltaMovement(this.getDeltaMovement().add(velocity));
    }

    public void setDeltaMovement(double x, double y, double z) {
        this.setDeltaMovement(new Vec3(x, y, z));
    }

    public final int getBlockX() {
        return this.blockPosition.getX();
    }

    public final double getX() {
        return this.position.x;
    }

    public double getX(double widthScale) {
        return this.position.x + (double)this.getBbWidth() * widthScale;
    }

    public double getRandomX(double widthScale) {
        return this.getX((2.0 * this.random.nextDouble() - 1.0) * widthScale);
    }

    public final int getBlockY() {
        return this.blockPosition.getY();
    }

    public final double getY() {
        return this.position.y;
    }

    public double getY(double heightScale) {
        return this.position.y + (double)this.getBbHeight() * heightScale;
    }

    public double getRandomY() {
        return this.getY(this.random.nextDouble());
    }

    public double getEyeY() {
        return this.position.y + (double)this.eyeHeight;
    }

    public final int getBlockZ() {
        return this.blockPosition.getZ();
    }

    public final double getZ() {
        return this.position.z;
    }

    public double getZ(double widthScale) {
        return this.position.z + (double)this.getBbWidth() * widthScale;
    }

    public double getRandomZ(double widthScale) {
        return this.getZ((2.0 * this.random.nextDouble() - 1.0) * widthScale);
    }

    public static boolean checkPosition(Entity entity, double newX, double newY, double newZ) {
        String entityInfo;
        if (Double.isFinite(newX) && Double.isFinite(newY) && Double.isFinite(newZ)) {
            return true;
        }
        try {
            entityInfo = entity.toString();
        }
        catch (Exception ex) {
            entityInfo = "[Entity info unavailable] ";
        }
        LOGGER.error("New entity position is invalid! Tried to set invalid position ({},{},{}) for entity {} located at {}, entity info: {}", new Object[]{newX, newY, newZ, entity.getClass().getName(), entity.position, entityInfo, new Throwable()});
        return false;
    }

    public final void setPosRaw(double x, double y, double z) {
        this.setPosRaw(x, y, z, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosRaw(double x, double y, double z, boolean forceBoundingBoxUpdate) {
        if (this.updatingSectionStatus) {
            LOGGER.error("Refusing to update position for entity " + String.valueOf(this) + " to position " + String.valueOf(new Vec3(x, y, z)) + " since it is processing a section status update", new Throwable());
            return;
        }
        if (!Entity.checkPosition(this, x, y, z)) {
            return;
        }
        if (this instanceof ItemEntity && GlobalConfiguration.get().misc.fixEntityPositionDesync) {
            x = (double)Mth.lfloor(x * 4096.0) * 2.44140625E-4;
            y = (double)Mth.lfloor(y * 4096.0) * 2.44140625E-4;
            z = (double)Mth.lfloor(z * 4096.0) * 2.44140625E-4;
        }
        if (this.position.x != x || this.position.y != y || this.position.z != z) {
            Object object = this.posLock;
            synchronized (object) {
                this.position = new Vec3(x, y, z);
            }
            int i = Mth.floor(x);
            int j = Mth.floor(y);
            int k = Mth.floor(z);
            if (i != this.blockPosition.getX() || j != this.blockPosition.getY() || k != this.blockPosition.getZ()) {
                this.blockPosition = new BlockPos(i, j, k);
                this.inBlockState = null;
                if (SectionPos.blockToSectionCoord(i) != this.chunkPosition.x || SectionPos.blockToSectionCoord(k) != this.chunkPosition.z) {
                    this.chunkPosition = new ChunkPos(this.blockPosition);
                }
            }
            this.levelCallback.onMove();
        }
        if (!(this instanceof HangingEntity) && (forceBoundingBoxUpdate || this.position.x != x || this.position.y != y || this.position.z != z)) {
            this.setBoundingBox(this.makeBoundingBox());
        }
    }

    public void checkDespawn() {
    }

    public Vec3 getRopeHoldPosition(float delta) {
        return this.getPosition(delta).add(0.0, (double)this.eyeHeight * 0.7, 0.0);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        int i = packet.getId();
        double d0 = packet.getX();
        double d1 = packet.getY();
        double d2 = packet.getZ();
        this.syncPacketPositionCodec(d0, d1, d2);
        this.moveTo(d0, d1, d2);
        this.setXRot(packet.getXRot());
        this.setYRot(packet.getYRot());
        this.setId(i);
        this.setUUID(packet.getUUID());
    }

    @javax.annotation.Nullable
    public ItemStack getPickResult() {
        return null;
    }

    public void setIsInPowderSnow(boolean inPowderSnow) {
        this.isInPowderSnow = inPowderSnow;
    }

    public boolean canFreeze() {
        return !this.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES);
    }

    public boolean isFreezing() {
        return (this.isInPowderSnow || this.wasInPowderSnow) && this.canFreeze();
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getVisualRotationYInDegrees() {
        return this.getYRot();
    }

    public void setYRot(float yaw) {
        if (!Float.isFinite(yaw)) {
            Util.logAndPauseIfInIde("Invalid entity rotation: " + yaw + ", discarding.");
        } else {
            this.yRot = yaw;
        }
    }

    public float getXRot() {
        return this.xRot;
    }

    public void setXRot(float pitch) {
        if (!Float.isFinite(pitch)) {
            Util.logAndPauseIfInIde("Invalid entity rotation: " + pitch + ", discarding.");
        } else {
            this.xRot = pitch;
        }
    }

    public boolean canSprint() {
        return false;
    }

    public float maxUpStep() {
        return this.maxUpStep;
    }

    public void onExplosionHit(@javax.annotation.Nullable Entity entity) {
    }

    public final boolean isRemoved() {
        return this.removalReason != null;
    }

    @javax.annotation.Nullable
    public RemovalReason getRemovalReason() {
        return this.removalReason;
    }

    @Override
    public final void setRemoved(RemovalReason reason) {
        this.setRemoved(reason, null);
    }

    @Override
    public final void setRemoved(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        boolean alreadyRemoved;
        if (!this.level.moonrise$getEntityLookup().canRemoveEntity(this)) {
            LOGGER.warn("Entity " + String.valueOf(this) + " is currently prevented from being removed from the world since it is processing section status updates", new Throwable());
            return;
        }
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        boolean bl = alreadyRemoved = this.removalReason != null;
        if (this.removalReason == null) {
            this.removalReason = entity_removalreason;
        }
        if (this.removalReason.shouldDestroy()) {
            this.stopRiding();
        }
        if (this.removalReason != RemovalReason.UNLOADED_TO_CHUNK) {
            this.getPassengers().forEach(Entity::stopRiding);
        }
        this.levelCallback.onRemove(entity_removalreason);
        if (!(this instanceof ServerPlayer) && entity_removalreason != RemovalReason.CHANGED_DIMENSION && !alreadyRemoved) {
            this.retireScheduler();
        }
    }

    public void unsetRemoved() {
        this.removalReason = null;
    }

    public final void retireScheduler() {
        this.getBukkitEntity().taskScheduler.retire();
    }

    @Override
    public void setLevelCallback(EntityInLevelCallback changeListener) {
        this.levelCallback = changeListener;
    }

    @Override
    public boolean shouldBeSaved() {
        return this.removalReason != null && !this.removalReason.shouldSave() ? false : (this.isPassenger() ? false : !this.isVehicle() || !this.moonrise$hasAnyPlayerPassengers());
    }

    @Override
    public boolean isAlwaysTicking() {
        return false;
    }

    public boolean mayInteract(Level world, BlockPos pos) {
        return true;
    }

    public Level level() {
        return this.level;
    }

    public void setLevel(Level world) {
        this.level = world;
    }

    public DamageSources damageSources() {
        return this.level().damageSources();
    }

    public RegistryAccess registryAccess() {
        return this.level().registryAccess();
    }

    protected void lerpPositionAndRotationStep(int step, double x, double y, double z, double yaw, double pitch) {
        double d5 = 1.0 / (double)step;
        double d6 = Mth.lerp(d5, this.getX(), x);
        double d7 = Mth.lerp(d5, this.getY(), y);
        double d8 = Mth.lerp(d5, this.getZ(), z);
        float f = (float)Mth.rotLerp(d5, (double)this.getYRot(), yaw);
        float f1 = (float)Mth.lerp(d5, (double)this.getXRot(), pitch);
        this.setPos(d6, d7, d8);
        this.setRot(f, f1);
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public Vec3 getKnownMovement() {
        LivingEntity entityliving = this.getControllingPassenger();
        if (entityliving instanceof Player) {
            Player entityhuman = (Player)entityliving;
            if (this.isAlive()) {
                return entityhuman.getKnownMovement();
            }
        }
        return this.getDeltaMovement();
    }

    @javax.annotation.Nullable
    public ItemStack getWeaponItem() {
        return null;
    }

    public static int nextEntityId() {
        return ENTITY_COUNTER.incrementAndGet();
    }

    public boolean isTicking() {
        return ((ServerChunkCache)this.level.getChunkSource()).isPositionTicking(this);
    }

    @javax.annotation.Nullable
    public Player getRider() {
        return this.rider;
    }

    public boolean isRidable() {
        return false;
    }

    public boolean isControllable() {
        return true;
    }

    public void onMount(Player rider) {
        if (this instanceof Mob) {
            ((Mob)this).setTarget(null, null, false);
            ((Mob)this).getNavigation().stop();
        }
        rider.setJumping(false);
    }

    public void onDismount(Player player) {
    }

    public boolean onSpacebar() {
        return false;
    }

    public boolean onClick(InteractionHand hand) {
        return false;
    }

    public boolean processClick(InteractionHand hand) {
        return false;
    }

    public static enum RemovalReason {
        KILLED(true, false),
        DISCARDED(true, false),
        UNLOADED_TO_CHUNK(false, true),
        UNLOADED_WITH_PLAYER(false, false),
        CHANGED_DIMENSION(false, false);

        private final boolean destroy;
        private final boolean save;

        private RemovalReason(boolean flag, boolean flag1) {
            this.destroy = flag;
            this.save = flag1;
        }

        public boolean shouldDestroy() {
            return this.destroy;
        }

        public boolean shouldSave() {
            return this.save;
        }
    }

    public static enum MovementEmission {
        NONE(false, false),
        SOUNDS(true, false),
        EVENTS(false, true),
        ALL(true, true);

        final boolean sounds;
        final boolean events;

        private MovementEmission(boolean flag, boolean flag1) {
            this.sounds = flag;
            this.events = flag1;
        }

        public boolean emitsAnything() {
            return this.events || this.sounds;
        }

        public boolean emitsEvents() {
            return this.events;
        }

        public boolean emitsSounds() {
            return this.sounds;
        }
    }

    public record DefaultDrop(net.minecraft.world.item.Item item, org.bukkit.inventory.ItemStack stack, @javax.annotation.Nullable Consumer<ItemStack> dropConsumer) {
        public DefaultDrop(ItemStack stack, Consumer<ItemStack> dropConsumer) {
            this(stack.getItem(), CraftItemStack.asCraftMirror(stack), dropConsumer);
        }

        public void runConsumer(Consumer<org.bukkit.inventory.ItemStack> fallback) {
            if (this.dropConsumer == null || CraftItemType.bukkitToMinecraft(this.stack.getType()) != this.item) {
                fallback.accept(this.stack);
            } else {
                this.dropConsumer.accept(CraftItemStack.asNMSCopy(this.stack));
            }
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    private static final class RandomRandomSource
    extends Random
    implements BitRandomSource {
        private boolean locked = false;

        private RandomRandomSource() {
        }

        @Override
        public synchronized void setSeed(long seed) {
            if (this.locked) {
                LOGGER.error("Ignoring setSeed on Entity.SHARED_RANDOM", new Throwable());
            } else {
                super.setSeed(seed);
                this.locked = true;
            }
        }

        @Override
        public RandomSource fork() {
            return new LegacyRandomSource(this.nextLong());
        }

        @Override
        public PositionalRandomFactory forkPositional() {
            return new LegacyRandomSource.LegacyPositionalRandomFactory(this.nextLong());
        }

        @Override
        public int next(int bits) {
            return super.next(bits);
        }

        @Override
        public int nextInt(int origin, int bound) {
            return BitRandomSource.super.nextInt(origin, bound);
        }

        @Override
        public long nextLong() {
            return BitRandomSource.super.nextLong();
        }

        @Override
        public int nextInt() {
            return BitRandomSource.super.nextInt();
        }

        @Override
        public int nextInt(int bound) {
            return BitRandomSource.super.nextInt(bound);
        }

        @Override
        public boolean nextBoolean() {
            return BitRandomSource.super.nextBoolean();
        }

        @Override
        public float nextFloat() {
            return BitRandomSource.super.nextFloat();
        }

        @Override
        public double nextDouble() {
            return BitRandomSource.super.nextDouble();
        }

        @Override
        public double nextGaussian() {
            return super.nextGaussian();
        }
    }
}

