/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.ItemEntity;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftItem;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;

public class GoToWantedItem {
    public static BehaviorControl<LivingEntity> create(float speed, boolean requiresWalkTarget, int radius) {
        return GoToWantedItem.create(entityliving -> true, speed, requiresWalkTarget, radius);
    }

    public static <E extends LivingEntity> BehaviorControl<E> create(Predicate<E> startCondition, float speed, boolean requiresWalkTarget, int radius) {
        return BehaviorBuilder.create(behaviorbuilder_b -> {
            BehaviorBuilder behaviorbuilder = requiresWalkTarget ? behaviorbuilder_b.registered(MemoryModuleType.WALK_TARGET) : behaviorbuilder_b.absent(MemoryModuleType.WALK_TARGET);
            return behaviorbuilder_b.group(behaviorbuilder_b.registered(MemoryModuleType.LOOK_TARGET), behaviorbuilder, behaviorbuilder_b.present(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM), behaviorbuilder_b.registered(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1, memoryaccessor2, memoryaccessor3) -> (worldserver, entityliving, j) -> {
                ItemEntity entityitem = (ItemEntity)behaviorbuilder_b.get(memoryaccessor2);
                if (behaviorbuilder_b.tryGet(memoryaccessor3).isEmpty() && startCondition.test(entityliving) && entityitem.closerThan(entityliving, radius) && entityliving.level().getWorldBorder().isWithinBounds(entityitem.blockPosition())) {
                    if (entityliving instanceof Allay) {
                        EntityTargetEvent event = CraftEventFactory.callEntityTargetEvent(entityliving, entityitem, EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
                        if (event.isCancelled()) {
                            return false;
                        }
                        if (!(event.getTarget() instanceof CraftItem)) {
                            memoryaccessor2.erase();
                            return false;
                        }
                        entityitem = (ItemEntity)((CraftEntity)event.getTarget()).getHandle();
                    }
                    WalkTarget memorytarget = new WalkTarget(new EntityTracker(entityitem, false), speed, 0);
                    memoryaccessor.set(new EntityTracker(entityitem, true));
                    memoryaccessor1.set(memorytarget);
                    return true;
                }
                return false;
            });
        });
    }
}

