/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class LongJumpToRandomPos<E extends Mob>
extends Behavior<E> {
    protected static final int FIND_JUMP_TRIES = 20;
    private static final int PREPARE_JUMP_DURATION = 40;
    protected static final int MIN_PATHFIND_DISTANCE_TO_VALID_JUMP = 8;
    private static final int TIME_OUT_DURATION = 200;
    private static final List<Integer> ALLOWED_ANGLES = Lists.newArrayList((Object[])new Integer[]{65, 70, 75, 80});
    private final UniformInt timeBetweenLongJumps;
    protected final int maxLongJumpHeight;
    protected final int maxLongJumpWidth;
    protected final float maxJumpVelocityMultiplier;
    protected List<PossibleJump> jumpCandidates = Lists.newArrayList();
    protected Optional<Vec3> initialPosition = Optional.empty();
    @Nullable
    protected Vec3 chosenJump;
    protected int findJumpTries;
    protected long prepareJumpStart;
    private final Function<E, SoundEvent> getJumpSound;
    private final BiPredicate<E, BlockPos> acceptableLandingSpot;

    public LongJumpToRandomPos(UniformInt cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, SoundEvent> entityToSound) {
        this(cooldownRange, verticalRange, horizontalRange, maxRange, entityToSound, LongJumpToRandomPos::defaultAcceptableLandingSpot);
    }

    public static <E extends Mob> boolean defaultAcceptableLandingSpot(E entity, BlockPos pos) {
        BlockPos blockPos;
        Level level = entity.level();
        return level.getBlockState(blockPos = pos.below()).isSolidRender(level, blockPos) && entity.getPathfindingMalus(WalkNodeEvaluator.getPathTypeStatic(entity, pos)) == 0.0f;
    }

    public LongJumpToRandomPos(UniformInt cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, SoundEvent> entityToSound, BiPredicate<E, BlockPos> jumpToPredicate) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 200);
        this.timeBetweenLongJumps = cooldownRange;
        this.maxLongJumpHeight = verticalRange;
        this.maxLongJumpWidth = horizontalRange;
        this.maxJumpVelocityMultiplier = maxRange;
        this.getJumpSound = entityToSound;
        this.acceptableLandingSpot = jumpToPredicate;
    }

    @Override
    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, Mob entity) {
        boolean bl;
        boolean bl2 = bl = entity.onGround() && !entity.isInWater() && !entity.isInLava() && !world.getBlockState(entity.blockPosition()).is(Blocks.HONEY_BLOCK);
        if (!bl) {
            entity.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, this.timeBetweenLongJumps.sample(world.random) / 2);
        }
        return bl;
    }

    @Override
    @Override
    protected boolean canStillUse(ServerLevel serverLevel, Mob mob, long l) {
        boolean bl;
        boolean bl2 = bl = this.initialPosition.isPresent() && this.initialPosition.get().equals(mob.position()) && this.findJumpTries > 0 && !mob.isInWaterOrBubble() && (this.chosenJump != null || !this.jumpCandidates.isEmpty());
        if (!bl && mob.getBrain().getMemory(MemoryModuleType.LONG_JUMP_MID_JUMP).isEmpty()) {
            mob.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, this.timeBetweenLongJumps.sample(serverLevel.random) / 2);
            mob.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        }
        return bl;
    }

    @Override
    @Override
    protected void start(ServerLevel serverLevel, E mob, long l) {
        this.chosenJump = null;
        this.findJumpTries = 20;
        this.initialPosition = Optional.of(((Entity)mob).position());
        BlockPos blockPos = ((Entity)mob).blockPosition();
        int i = blockPos.getX();
        int j = blockPos.getY();
        int k = blockPos.getZ();
        this.jumpCandidates = BlockPos.betweenClosedStream(i - this.maxLongJumpWidth, j - this.maxLongJumpHeight, k - this.maxLongJumpWidth, i + this.maxLongJumpWidth, j + this.maxLongJumpHeight, k + this.maxLongJumpWidth).filter(blockPos2 -> !blockPos2.equals(blockPos)).map(blockPos2 -> new PossibleJump(blockPos2.immutable(), Mth.ceil(blockPos.distSqr((Vec3i)blockPos2)))).collect(Collectors.toCollection(Lists::newArrayList));
    }

    @Override
    @Override
    protected void tick(ServerLevel world, E entity, long time) {
        if (this.chosenJump != null) {
            if (time - this.prepareJumpStart >= 40L) {
                ((Entity)entity).setYRot(((LivingEntity)entity).yBodyRot);
                ((LivingEntity)entity).setDiscardFriction(true);
                double d = this.chosenJump.length();
                double e = d + (double)((LivingEntity)entity).getJumpBoostPower();
                ((Entity)entity).setDeltaMovement(this.chosenJump.scale(e / d));
                ((LivingEntity)entity).getBrain().setMemory(MemoryModuleType.LONG_JUMP_MID_JUMP, true);
                world.playSound(null, (Entity)entity, this.getJumpSound.apply(entity), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        } else {
            --this.findJumpTries;
            this.pickCandidate(world, entity, time);
        }
    }

    protected void pickCandidate(ServerLevel world, E entity, long time) {
        while (!this.jumpCandidates.isEmpty()) {
            Vec3 vec3;
            Vec3 vec32;
            PossibleJump possibleJump;
            BlockPos blockPos;
            Optional<PossibleJump> optional = this.getJumpCandidate(world);
            if (optional.isEmpty() || !this.isAcceptableLandingPosition(world, entity, blockPos = (possibleJump = optional.get()).getJumpTarget()) || (vec32 = this.calculateOptimalJumpVector((Mob)entity, vec3 = Vec3.atCenterOf(blockPos))) == null) continue;
            ((LivingEntity)entity).getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(blockPos));
            PathNavigation pathNavigation = ((Mob)entity).getNavigation();
            Path path = pathNavigation.createPath(blockPos, 0, 8);
            if (path != null && path.canReach()) continue;
            this.chosenJump = vec32;
            this.prepareJumpStart = time;
            return;
        }
    }

    protected Optional<PossibleJump> getJumpCandidate(ServerLevel world) {
        Optional<PossibleJump> optional = WeightedRandom.getRandomItem(world.random, this.jumpCandidates);
        optional.ifPresent(this.jumpCandidates::remove);
        return optional;
    }

    private boolean isAcceptableLandingPosition(ServerLevel world, E entity, BlockPos pos) {
        BlockPos blockPos = ((Entity)entity).blockPosition();
        int i = blockPos.getX();
        int j = blockPos.getZ();
        if (i == pos.getX() && j == pos.getZ()) {
            return false;
        }
        return this.acceptableLandingSpot.test(entity, pos);
    }

    @Nullable
    protected Vec3 calculateOptimalJumpVector(Mob entity, Vec3 targetPos) {
        ArrayList list = Lists.newArrayList(ALLOWED_ANGLES);
        Collections.shuffle(list);
        float f = (float)(entity.getAttributeValue(Attributes.JUMP_STRENGTH) * (double)this.maxJumpVelocityMultiplier);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Optional<Vec3> optional = LongJumpUtil.calculateJumpVectorForAngle(entity, targetPos, f, i, true);
            if (!optional.isPresent()) continue;
            return optional.get();
        }
        return null;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel world, LivingEntity entity, long time) {
        return this.canStillUse(world, (Mob)entity, time);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel world, LivingEntity entity, long time) {
        this.start(world, (E)((Mob)entity), time);
    }

    public static class PossibleJump
    extends WeightedEntry.IntrusiveBase {
        private final BlockPos jumpTarget;

        public PossibleJump(BlockPos pos, int weight) {
            super(weight);
            this.jumpTarget = pos;
        }

        public BlockPos getJumpTarget() {
            return this.jumpTarget;
        }
    }
}

