/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class SetWalkTargetAwayFrom {
    public static BehaviorControl<PathfinderMob> pos(MemoryModuleType<BlockPos> posModule, float speed, int range, boolean requiresWalkTarget) {
        return SetWalkTargetAwayFrom.create(posModule, speed, range, requiresWalkTarget, Vec3::atBottomCenterOf);
    }

    public static OneShot<PathfinderMob> entity(MemoryModuleType<? extends Entity> entityModule, float speed, int range, boolean requiresWalkTarget) {
        return SetWalkTargetAwayFrom.create(entityModule, speed, range, requiresWalkTarget, Entity::position);
    }

    private static <T> OneShot<PathfinderMob> create(MemoryModuleType<T> posSource, float speed, int range, boolean requiresWalkTarget, Function<T, Vec3> posGetter) {
        return BehaviorBuilder.create(context -> context.group(context.registered(MemoryModuleType.WALK_TARGET), context.present(posSource)).apply((Applicative)context, (walkTarget, posSourcex) -> (world, entity, time) -> {
            Vec3 vec34;
            Vec3 vec33;
            Vec3 vec32;
            Optional optional = context.tryGet(walkTarget);
            if (optional.isPresent() && !requiresWalkTarget) {
                return false;
            }
            Vec3 vec3 = entity.position();
            if (!vec3.closerThan(vec32 = (Vec3)posGetter.apply(context.get(posSourcex)), range)) {
                return false;
            }
            if (optional.isPresent() && ((WalkTarget)optional.get()).getSpeedModifier() == speed && (vec33 = ((WalkTarget)optional.get()).getTarget().currentPosition().subtract(vec3)).dot(vec34 = vec32.subtract(vec3)) < 0.0) {
                return false;
            }
            for (int j = 0; j < 10; ++j) {
                Vec3 vec35 = LandRandomPos.getPosAway(entity, 16, 7, vec32);
                if (vec35 == null) continue;
                walkTarget.set(new WalkTarget(vec35, speed, 0));
                break;
            }
            return true;
        }));
    }
}

