/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class TryLaySpawnOnWaterNearLand {
    public static BehaviorControl<LivingEntity> create(Block frogSpawn) {
        return BehaviorBuilder.create((BehaviorBuilder.Instance<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.absent(MemoryModuleType.ATTACK_TARGET), behaviorbuilder_b.present(MemoryModuleType.WALK_TARGET), behaviorbuilder_b.present(MemoryModuleType.IS_PREGNANT)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1, memoryaccessor2) -> (worldserver, entityliving, i) -> {
            if (!entityliving.isInWater() && entityliving.onGround()) {
                BlockPos blockposition = entityliving.blockPosition().below();
                for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
                    BlockPos blockposition2;
                    BlockPos blockposition1 = blockposition.relative(enumdirection);
                    if (!worldserver.getBlockState(blockposition1).getCollisionShape(worldserver, blockposition1).getFaceShape(Direction.UP).isEmpty() || !worldserver.getFluidState(blockposition1).is(Fluids.WATER) || !worldserver.getBlockState(blockposition2 = blockposition1.above()).isAir()) continue;
                    BlockState iblockdata = frogSpawn.defaultBlockState();
                    if (!CraftEventFactory.callEntityChangeBlockEvent(entityliving, blockposition2, iblockdata)) {
                        memoryaccessor2.erase();
                        return true;
                    }
                    worldserver.setBlock(blockposition2, iblockdata, 3);
                    worldserver.gameEvent(GameEvent.BLOCK_PLACE, blockposition2, GameEvent.Context.of(entityliving, iblockdata));
                    worldserver.playSound((Player)null, entityliving, SoundEvents.FROG_LAY_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
                    memoryaccessor2.erase();
                    return true;
                }
                return true;
            }
            return false;
        }));
    }
}

