/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class Cow
extends Animal {
    private boolean isNaturallyAggressiveToPlayers;
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.COW.getDimensions().scale(0.5f).withEyeHeight(0.665f);
    private int redMushroomsFed = 0;
    private int brownMushroomsFed = 0;

    public Cow(EntityType<? extends Cow> type, Level world) {
        super((EntityType<? extends Animal>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.cowRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.cowRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.cowControllable;
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.cowMaxHealth);
        this.getAttribute(Attributes.SCALE).setBaseValue(this.level().purpurConfig.cowScale);
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(this.level().purpurConfig.cowNaturallyAggressiveToPlayersDamage);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.level().purpurConfig.cowBreedingTicks;
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.cowTakeDamageFromWater;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData entityData) {
        this.isNaturallyAggressiveToPlayers = world.getLevel().purpurConfig.cowNaturallyAggressiveToPlayersChance > 0.0 && this.random.nextDouble() <= world.getLevel().purpurConfig.cowNaturallyAggressiveToPlayersChance;
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.cowAlwaysDropExp;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new FloatGoal(this));
        this.goalSelector.addGoal(0, new HasRider(this));
        this.goalSelector.addGoal(1, new PanicGoal(this, 2.0));
        this.goalSelector.addGoal(1, new MeleeAttackGoal(this, 1.2f, true));
        this.goalSelector.addGoal(2, new BreedGoal(this, 1.0));
        this.goalSelector.addGoal(3, new TemptGoal(this, 1.25, itemstack -> this.level().purpurConfig.cowFeedMushrooms > 0 && (itemstack.is(Blocks.RED_MUSHROOM.asItem()) || itemstack.is(Blocks.BROWN_MUSHROOM.asItem())) || itemstack.is(ItemTags.COW_FOOD), false));
        this.goalSelector.addGoal(4, new FollowParentGoal(this, 1.25));
        this.goalSelector.addGoal(5, new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(6, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(0, new NearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, target -> this.isNaturallyAggressiveToPlayers));
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.COW_FOOD);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.2f).add(Attributes.ATTACK_DAMAGE, 0.0);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.COW_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.COW_HURT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.COW_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.COW_STEP, 0.15f, 1.0f);
    }

    @Override
    public float getSoundVolume() {
        return 0.4f;
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.getRider() != null) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(Items.BUCKET) && !this.isBaby()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((ServerLevel)player.level(), player, this.blockPosition(), this.blockPosition(), null, itemstack, Items.MILK_BUCKET, hand);
            if (event.isCancelled()) {
                player.containerMenu.sendAllDataToRemote();
                return this.tryRide(player, hand);
            }
            player.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.createFilledResult(itemstack, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.setItemInHand(hand, itemstack1);
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        if (this.level().purpurConfig.cowFeedMushrooms > 0 && this.getType() != EntityType.MOOSHROOM && this.isMushroom(itemstack)) {
            return this.feedMushroom(player, itemstack);
        }
        return super.mobInteract(player, hand);
    }

    @Override
    @Nullable
    public Cow getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return EntityType.COW.create(world);
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(pose);
    }

    private boolean isMushroom(ItemStack stack) {
        return stack.getItem() == Blocks.RED_MUSHROOM.asItem() || stack.getItem() == Blocks.BROWN_MUSHROOM.asItem();
    }

    private int incrementFeedCount(ItemStack stack) {
        if (stack.getItem() == Blocks.RED_MUSHROOM.asItem()) {
            return ++this.redMushroomsFed;
        }
        return ++this.brownMushroomsFed;
    }

    private InteractionResult feedMushroom(Player player, ItemStack stack) {
        this.level().broadcastEntityEvent(this, (byte)18);
        this.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
        if (this.incrementFeedCount(stack) < this.level().purpurConfig.cowFeedMushrooms) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        MushroomCow mooshroom = EntityType.MOOSHROOM.create(this.level());
        if (mooshroom == null) {
            return InteractionResult.PASS;
        }
        if (stack.getItem() == Blocks.BROWN_MUSHROOM.asItem()) {
            mooshroom.setVariant(MushroomCow.MushroomType.BROWN);
        } else {
            mooshroom.setVariant(MushroomCow.MushroomType.RED);
        }
        mooshroom.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        mooshroom.setHealth(this.getHealth());
        mooshroom.setAge(this.getAge());
        mooshroom.copyPosition(this);
        mooshroom.setYBodyRot(this.yBodyRot);
        mooshroom.setYHeadRot(this.getYHeadRot());
        mooshroom.yRotO = this.yRotO;
        mooshroom.xRotO = this.xRotO;
        if (this.hasCustomName()) {
            mooshroom.setCustomName(this.getCustomName());
        }
        if (CraftEventFactory.callEntityTransformEvent((LivingEntity)this, mooshroom, EntityTransformEvent.TransformReason.INFECTION).isCancelled()) {
            return InteractionResult.PASS;
        }
        this.level().addFreshEntity(mooshroom);
        this.remove(Entity.RemovalReason.DISCARDED, EntityRemoveEvent.Cause.DISCARD);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        for (int i = 0; i < 15; ++i) {
            ((ServerLevel)this.level()).sendParticles(((ServerLevel)this.level()).players(), null, ParticleTypes.HAPPY_VILLAGER, this.getX() + (double)this.random.nextFloat(), this.getY() + (double)(this.random.nextFloat() * 2.0f), this.getZ() + (double)this.random.nextFloat(), 1, this.random.nextGaussian() * 0.05, this.random.nextGaussian() * 0.05, this.random.nextGaussian() * 0.05, 0.0, true);
        }
        return InteractionResult.SUCCESS;
    }
}

