/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.purpurmc.purpur.PurpurConfig;

public class MushroomCow
extends Cow
implements Shearable,
VariantHolder<MushroomType> {
    private static final EntityDataAccessor<String> DATA_TYPE = SynchedEntityData.defineId(MushroomCow.class, EntityDataSerializers.STRING);
    private static final int MUTATE_CHANCE = 1024;
    private static final String TAG_STEW_EFFECTS = "stew_effects";
    @Nullable
    public SuspiciousStewEffects stewEffects;
    @Nullable
    private UUID lastLightningBoltUUID;

    public MushroomCow(EntityType<? extends MushroomCow> type, Level world) {
        super((EntityType<? extends Cow>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.mooshroomRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.mooshroomRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.mooshroomControllable;
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.mooshroomMaxHealth);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.level().purpurConfig.mooshroomBreedingTicks;
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.mooshroomTakeDamageFromWater;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.mooshroomAlwaysDropExp;
    }

    @Override
    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return world.getBlockState(pos.below()).is(Blocks.MYCELIUM) ? 10.0f : world.getPathfindingCostFromLightLevels(pos);
    }

    public static boolean checkMushroomSpawnRules(EntityType<MushroomCow> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(BlockTags.MOOSHROOMS_SPAWNABLE_ON) && MushroomCow.isBrightEnoughToSpawn(world, pos);
    }

    @Override
    public void thunderHit(ServerLevel world, LightningBolt lightning) {
        UUID uuid = lightning.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == MushroomType.RED ? MushroomType.BROWN : MushroomType.RED);
            this.lastLightningBoltUUID = uuid;
            this.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TYPE, MushroomType.RED.type);
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(Items.BOWL) && !this.isBaby()) {
            ItemStack itemstack1;
            boolean flag = false;
            if (this.stewEffects != null) {
                flag = true;
                itemstack1 = new ItemStack(Items.SUSPICIOUS_STEW);
                itemstack1.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.stewEffects);
                this.stewEffects = null;
            } else {
                itemstack1 = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack itemstack2 = ItemUtils.createFilledResult(itemstack, player, itemstack1, false);
            player.setItemInHand(hand, itemstack2);
            SoundEvent soundeffect = flag ? SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY : SoundEvents.MOOSHROOM_MILK;
            this.playSound(soundeffect, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        if (itemstack.is(Items.SHEARS) && this.readyForShearing()) {
            List<ItemStack> drops = this.generateDefaultDrops(EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LOOTING, itemstack));
            PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand, drops);
            if (event != null) {
                if (event.isCancelled()) {
                    return this.tryRide(player, hand);
                }
                drops = CraftItemStack.asNMSCopy(event.getDrops());
            }
            this.shear(SoundSource.PLAYERS, drops);
            this.gameEvent(GameEvent.SHEAR, player);
            if (!this.level().isClientSide) {
                itemstack.hurtAndBreak(1, player, MushroomCow.getSlotForHand(hand));
            }
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        if (this.getVariant() == MushroomType.BROWN && itemstack.is(ItemTags.SMALL_FLOWERS)) {
            if (this.stewEffects != null) {
                for (int i = 0; i < 2; ++i) {
                    this.level().addParticle(ParticleTypes.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                Optional<SuspiciousStewEffects> optional = this.getEffectsFromItemStack(itemstack);
                if (optional.isEmpty()) {
                    return this.tryRide(player, hand);
                }
                itemstack.consume(1, player);
                for (int j = 0; j < 4; ++j) {
                    this.level().addParticle(ParticleTypes.EFFECT, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.stewEffects = optional.get();
                this.playSound(SoundEvents.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void shear(SoundSource shearedSoundCategory) {
        this.shear(shearedSoundCategory, this.generateDefaultDrops(0));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(int looting) {
        ArrayList<ItemStack> dropEntities = new ArrayList<ItemStack>(5);
        for (int i = 0; i < 5 + (PurpurConfig.allowShearsLooting ? looting : 0); ++i) {
            dropEntities.add(new ItemStack(this.getVariant().getBlockState().getBlock()));
        }
        return dropEntities;
    }

    @Override
    public void shear(SoundSource shearedSoundCategory, List<ItemStack> drops) {
        Cow entitycow;
        this.level().playSound((Player)null, this, SoundEvents.MOOSHROOM_SHEAR, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.level().isClientSide() && (entitycow = EntityType.COW.create(this.level())) != null) {
            ((ServerLevel)this.level()).sendParticles(ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            entitycow.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            entitycow.setHealth(this.getHealth());
            entitycow.copyPosition(this);
            entitycow.yBodyRot = this.yBodyRot;
            entitycow.setYHeadRot(this.getYHeadRot());
            entitycow.yRotO = this.yRotO;
            entitycow.xRotO = this.xRotO;
            if (this.hasCustomName()) {
                entitycow.setCustomName(this.getCustomName());
                entitycow.setCustomNameVisible(this.isCustomNameVisible());
            }
            if (this.isPersistenceRequired()) {
                entitycow.setPersistenceRequired();
            }
            entitycow.setInvulnerable(this.isInvulnerable());
            if (CraftEventFactory.callEntityTransformEvent((LivingEntity)this, entitycow, EntityTransformEvent.TransformReason.SHEARED).isCancelled()) {
                return;
            }
            this.level().addFreshEntity(entitycow, CreatureSpawnEvent.SpawnReason.SHEARED);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            for (ItemStack drop : drops) {
                ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY(1.0), this.getZ(), drop);
                this.spawnAtLocation(entityitem);
            }
        }
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("Type", this.getVariant().getSerializedName());
        if (this.stewEffects != null) {
            SuspiciousStewEffects.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.stewEffects).ifSuccess(nbtbase -> nbt.put(TAG_STEW_EFFECTS, (Tag)nbtbase));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setVariant(MushroomType.byType(nbt.getString("Type")));
        if (nbt.contains(TAG_STEW_EFFECTS, 9)) {
            SuspiciousStewEffects.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(TAG_STEW_EFFECTS)).ifSuccess(suspicioussteweffects -> {
                this.stewEffects = suspicioussteweffects;
            });
        }
    }

    private Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack flower) {
        SuspiciousEffectHolder suspiciouseffectholder = SuspiciousEffectHolder.tryGet(flower.getItem());
        return suspiciouseffectholder != null ? Optional.of(suspiciouseffectholder.getSuspiciousEffects()) : Optional.empty();
    }

    @Override
    public void setVariant(MushroomType variant) {
        this.entityData.set(DATA_TYPE, variant.type);
    }

    @Override
    public MushroomType getVariant() {
        return MushroomType.byType(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public MushroomCow getBreedOffspring(ServerLevel world, AgeableMob entity) {
        MushroomCow entitymushroomcow = EntityType.MOOSHROOM.create(world);
        if (entitymushroomcow != null) {
            entitymushroomcow.setVariant(this.getOffspringType((MushroomCow)entity));
        }
        return entitymushroomcow;
    }

    private MushroomType getOffspringType(MushroomCow mooshroom) {
        MushroomType entitymushroomcow_type1;
        MushroomType entitymushroomcow_type = this.getVariant();
        MushroomType entitymushroomcow_type2 = entitymushroomcow_type == (entitymushroomcow_type1 = mooshroom.getVariant()) && this.random.nextInt(1024) == 0 ? (entitymushroomcow_type == MushroomType.BROWN ? MushroomType.RED : MushroomType.BROWN) : (this.random.nextBoolean() ? entitymushroomcow_type : entitymushroomcow_type1);
        return entitymushroomcow_type2;
    }

    public static enum MushroomType implements StringRepresentable
    {
        RED("red", Blocks.RED_MUSHROOM.defaultBlockState()),
        BROWN("brown", Blocks.BROWN_MUSHROOM.defaultBlockState());

        public static final StringRepresentable.EnumCodec<MushroomType> CODEC;
        final String type;
        final BlockState blockState;

        private MushroomType(String s, BlockState iblockdata) {
            this.type = s;
            this.blockState = iblockdata;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        static MushroomType byType(String name) {
            return CODEC.byName(name, RED);
        }

        static {
            CODEC = StringRepresentable.fromEnum(MushroomType::values);
        }
    }
}

