/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Material;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.purpurmc.purpur.controller.FlyingMoveControllerWASD;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.slf4j.Logger;

public class EnderDragon
extends Mob
implements Enemy {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.defineId(EnderDragon.class, EntityDataSerializers.INT);
    private static final TargetingConditions CRYSTAL_DESTROY_TARGETING = TargetingConditions.forCombat().range(64.0);
    private static final int GROWL_INTERVAL_MIN = 200;
    private static final int GROWL_INTERVAL_MAX = 400;
    private static final float SITTING_ALLOWED_DAMAGE_PERCENTAGE = 0.25f;
    private static final String DRAGON_DEATH_TIME_KEY = "DragonDeathTime";
    private static final String DRAGON_PHASE_KEY = "DragonPhase";
    public final double[][] positions = new double[64][3];
    public int posPointer = -1;
    public final EnderDragonPart[] subEntities;
    public final EnderDragonPart head;
    private final EnderDragonPart neck;
    private final EnderDragonPart body;
    private final EnderDragonPart tail1;
    private final EnderDragonPart tail2;
    private final EnderDragonPart tail3;
    private final EnderDragonPart wing1;
    private final EnderDragonPart wing2;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public int dragonDeathTime;
    public float yRotA;
    @Nullable
    public EndCrystal nearestCrystal;
    @Nullable
    private EndDragonFight dragonFight;
    private BlockPos fightOrigin = BlockPos.ZERO;
    private final EnderDragonPhaseManager phaseManager;
    private int growlTime = 100;
    private float sittingDamageReceived;
    private final Node[] nodes = new Node[24];
    private final int[] nodeAdjacency = new int[24];
    private final BinaryHeap openSet = new BinaryHeap();
    private final Explosion explosionSource;
    @Nullable
    private BlockPos podium;
    private boolean hadRider;

    public EnderDragon(EntityType<? extends EnderDragon> entitytypes, Level world) {
        super((EntityType<? extends Mob>)EntityType.ENDER_DRAGON, world);
        this.head = new EnderDragonPart(this, "head", 1.0f, 1.0f);
        this.neck = new EnderDragonPart(this, "neck", 3.0f, 3.0f);
        this.body = new EnderDragonPart(this, "body", 5.0f, 3.0f);
        this.tail1 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail2 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail3 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.wing1 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.wing2 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.subEntities = new EnderDragonPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.setHealth(this.getMaxHealth());
        this.noPhysics = true;
        this.noCulling = true;
        this.phaseManager = new EnderDragonPhaseManager(this);
        this.explosionSource = new Explosion(world, this, null, null, Double.NaN, Double.NaN, Double.NaN, Float.NaN, true, Explosion.BlockInteraction.DESTROY, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
        this.moveControl = new FlyingMoveControllerWASD(this, this){

            @Override
            public void vanillaTick() {
            }
        };
        this.lookControl = new LookControllerWASD(this, this){

            @Override
            public void vanillaTick() {
            }

            @Override
            public void purpurTick(Player rider) {
                this.setYawPitch(rider.getYRot() - 180.0f, rider.xRotO * 0.5f);
            }
        };
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.enderDragonRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.enderDragonRidableInWater;
    }

    public void setDragonFight(EndDragonFight fight) {
        this.dragonFight = fight;
    }

    public void setFightOrigin(BlockPos fightOrigin) {
        this.fightOrigin = fightOrigin;
    }

    public BlockPos getFightOrigin() {
        return this.fightOrigin;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.enderDragonControllable;
    }

    @Override
    public double getMaxY() {
        return this.level().purpurConfig.enderDragonMaxY;
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.enderDragonMaxHealth);
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.enderDragonTakeDamageFromWater;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0);
    }

    public BlockPos getPodium() {
        if (this.podium == null) {
            return EndPodiumFeature.getLocation(this.getFightOrigin());
        }
        return this.podium;
    }

    public void setPodium(@Nullable BlockPos blockPos) {
        this.podium = blockPos;
    }

    @Override
    public boolean isFlapping() {
        float f = Mth.cos(this.flapTime * ((float)Math.PI * 2));
        float f1 = Mth.cos(this.oFlapTime * ((float)Math.PI * 2));
        return f1 <= -0.3f && f >= -0.3f;
    }

    @Override
    public void onFlap() {
        if (this.level().isClientSide && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PHASE, EnderDragonPhase.HOVERING.getId());
    }

    public double[] getLatencyPos(int segmentNumber, float tickDelta) {
        if (this.isDeadOrDying()) {
            tickDelta = 0.0f;
        }
        tickDelta = 1.0f - tickDelta;
        int j = this.posPointer - segmentNumber & 0x3F;
        int k = this.posPointer - segmentNumber - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.positions[j][0];
        double d1 = Mth.wrapDegrees(this.positions[k][0] - d0);
        adouble[0] = d0 + d1 * (double)tickDelta;
        d0 = this.positions[j][1];
        d1 = this.positions[k][1] - d0;
        adouble[1] = d0 + d1 * (double)tickDelta;
        adouble[2] = Mth.lerp((double)tickDelta, this.positions[j][2], this.positions[k][2]);
        return adouble;
    }

    @Override
    public void aiStep() {
        ServerLevel worldserver;
        EndDragonFight enderdragonbattle;
        Level world;
        boolean hasRider;
        boolean bl = hasRider = this.getRider() != null && this.isControllable();
        if (hasRider) {
            if (!this.hadRider) {
                this.hadRider = true;
                this.noPhysics = false;
                this.dimensions = EntityDimensions.scalable(4.0f, 2.0f);
            }
            this.moveControl.tick();
            this.lookControl.tick();
            this.moveRelative((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.1f, new Vec3(-this.getStrafeMot(), this.getVerticalMot(), -this.getForwardMot()));
            Vec3 mot = this.getDeltaMovement();
            this.setDeltaMovement(mot);
            this.move(MoverType.PLAYER, mot);
            mot = mot.multiply(0.9f, 0.9f, 0.9f);
            this.setDeltaMovement(mot);
            this.phaseManager.setPhase(mot.x() * mot.x() + mot.z() * mot.z() < (double)0.005f ? EnderDragonPhase.HOVERING : EnderDragonPhase.HOLDING_PATTERN);
        } else if (this.hadRider) {
            this.hadRider = false;
            this.noPhysics = true;
            this.dimensions = EntityDimensions.scalable(16.0f, 8.0f);
            this.phaseManager.setPhase(EnderDragonPhase.HOLDING_PATTERN);
        }
        this.processFlappingMovement();
        if (this.level().isClientSide) {
            this.setHealth(this.getHealth());
            if (!this.isSilent() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_GROWL, this.getSoundSource(), 2.5f, 0.8f + this.random.nextFloat() * 0.3f, false);
                this.growlTime = 200 + this.random.nextInt(200);
            }
        }
        if (this.dragonFight == null && (world = this.level()) instanceof ServerLevel && (enderdragonbattle = (worldserver = (ServerLevel)world).getDragonFight()) != null && this.getUUID().equals(enderdragonbattle.getDragonUUID())) {
            this.dragonFight = enderdragonbattle;
        }
        this.oFlapTime = this.flapTime;
        if (this.isDeadOrDying()) {
            if (hasRider) {
                this.ejectPassengers();
            }
            float f1 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(ParticleTypes.EXPLOSION, this.getX() + (double)f1, this.getY() + 2.0 + (double)f, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        } else {
            this.checkCrystals();
            Vec3 vec3d = this.getDeltaMovement();
            float f = 0.2f / ((float)vec3d.horizontalDistance() * 10.0f + 1.0f);
            this.flapTime = !hasRider && this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (!hasRider && this.inWall ? (this.flapTime += f * 0.5f) : (this.flapTime += (f *= (float)Math.pow(2.0, vec3d.y))));
            this.setYRot(Mth.wrapDegrees(this.getYRot()));
            if (this.isNoAi()) {
                this.flapTime = 0.5f;
            } else {
                int k;
                float f5;
                float f4;
                if (this.posPointer < 0) {
                    for (int i = 0; i < this.positions.length; ++i) {
                        this.positions[i][0] = this.getYRot();
                        this.positions[i][1] = this.getY();
                    }
                }
                if (++this.posPointer == this.positions.length) {
                    this.posPointer = 0;
                }
                this.positions[this.posPointer][0] = this.getYRot();
                this.positions[this.posPointer][1] = this.getY();
                if (this.level().isClientSide) {
                    if (this.lerpSteps > 0) {
                        this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
                        --this.lerpSteps;
                    }
                    this.phaseManager.getCurrentPhase().doClientTick();
                } else if (!hasRider) {
                    Vec3 vec3d1;
                    DragonPhaseInstance idragoncontroller = this.phaseManager.getCurrentPhase();
                    idragoncontroller.doServerTick();
                    if (this.phaseManager.getCurrentPhase() != idragoncontroller) {
                        idragoncontroller = this.phaseManager.getCurrentPhase();
                        idragoncontroller.doServerTick();
                    }
                    if ((vec3d1 = idragoncontroller.getFlyTargetLocation()) != null && idragoncontroller.getPhase() != EnderDragonPhase.HOVERING) {
                        double d0 = vec3d1.x - this.getX();
                        double d1 = vec3d1.y - this.getY();
                        double d2 = vec3d1.z - this.getZ();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f6 = idragoncontroller.getFlySpeed();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = Mth.clamp(d1 / d4, (double)(-f6), (double)f6);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, d1 * 0.01, 0.0));
                        this.setYRot(Mth.wrapDegrees(this.getYRot()));
                        Vec3 vec3d2 = vec3d1.subtract(this.getX(), this.getY(), this.getZ()).normalize();
                        Vec3 vec3d3 = new Vec3(Mth.sin(this.getYRot() * ((float)Math.PI / 180)), this.getDeltaMovement().y, -Mth.cos(this.getYRot() * ((float)Math.PI / 180))).normalize();
                        float f3 = Math.max(((float)vec3d3.dot(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            f4 = Mth.clamp(Mth.wrapDegrees(180.0f - (float)Mth.atan2(d0, d2) * 57.295776f - this.getYRot()), -50.0f, 50.0f);
                            this.yRotA *= 0.8f;
                            this.yRotA += f4 * idragoncontroller.getTurnSpeed();
                            this.setYRot(this.getYRot() + this.yRotA * 0.1f);
                        }
                        f4 = (float)(2.0 / (d3 + 1.0));
                        f5 = 0.06f;
                        this.moveRelative(0.06f * (f3 * f4 + (1.0f - f4)), new Vec3(0.0, 0.0, -1.0));
                        if (this.inWall) {
                            this.move(MoverType.SELF, this.getDeltaMovement().scale(0.8f));
                        } else {
                            this.move(MoverType.SELF, this.getDeltaMovement());
                        }
                        Vec3 vec3d4 = this.getDeltaMovement().normalize();
                        double d5 = 0.8 + 0.15 * (vec3d4.dot(vec3d3) + 1.0) / 2.0;
                        this.setDeltaMovement(this.getDeltaMovement().multiply(d5, 0.91f, d5));
                    }
                }
                this.yBodyRot = this.getYRot();
                Vec3[] avec3d = new Vec3[this.subEntities.length];
                for (int j = 0; j < this.subEntities.length; ++j) {
                    avec3d[j] = new Vec3(this.subEntities[j].getX(), this.subEntities[j].getY(), this.subEntities[j].getZ());
                }
                float f7 = (float)(this.getLatencyPos(5, 1.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f8 = Mth.cos(f7);
                float f9 = Mth.sin(f7);
                float f10 = this.getYRot() * ((float)Math.PI / 180);
                float f11 = Mth.sin(f10);
                float f12 = Mth.cos(f10);
                this.tickPart(this.body, f11 * 0.5f, 0.0, -f12 * 0.5f);
                this.tickPart(this.wing1, f12 * 4.5f, 2.0, f11 * 4.5f);
                this.tickPart(this.wing2, f12 * -4.5f, 2.0, f11 * -4.5f);
                Level world1 = this.level();
                if (world1 instanceof ServerLevel) {
                    ServerLevel worldserver1 = (ServerLevel)world1;
                    if (!hasRider && this.hurtTime == 0) {
                        this.knockBack(worldserver1, worldserver1.getEntities(this, this.wing1.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.knockBack(worldserver1, worldserver1.getEntities(this, this.wing2.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.hurt(worldserver1.getEntities(this, this.head.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.hurt(worldserver1.getEntities(this, this.neck.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    }
                }
                float f13 = Mth.sin(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
                float f14 = Mth.cos(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
                float f15 = this.getHeadYOffset();
                this.tickPart(this.head, f13 * 6.5f * f8, f15 + f9 * 6.5f, -f14 * 6.5f * f8);
                this.tickPart(this.neck, f13 * 5.5f * f8, f15 + f9 * 5.5f, -f14 * 5.5f * f8);
                double[] adouble = this.getLatencyPos(5, 1.0f);
                for (k = 0; k < 3; ++k) {
                    EnderDragonPart entitycomplexpart = null;
                    if (k == 0) {
                        entitycomplexpart = this.tail1;
                    }
                    if (k == 1) {
                        entitycomplexpart = this.tail2;
                    }
                    if (k == 2) {
                        entitycomplexpart = this.tail3;
                    }
                    double[] adouble1 = this.getLatencyPos(12 + k * 2, 1.0f);
                    float f16 = this.getYRot() * ((float)Math.PI / 180) + this.rotWrap(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f3 = Mth.sin(f16);
                    f4 = Mth.cos(f16);
                    f5 = 1.5f;
                    float f17 = (float)(k + 1) * 2.0f;
                    this.tickPart(entitycomplexpart, -(f11 * 1.5f + f3 * f17) * f8, adouble1[1] - adouble[1] - (double)((f17 + 1.5f) * f9) + 1.5, (f12 * 1.5f + f4 * f17) * f8);
                }
                if (!this.level().isClientSide) {
                    boolean bl2 = this.inWall = !hasRider && this.checkWalls(this.head.getBoundingBox()) | this.checkWalls(this.neck.getBoundingBox()) | this.checkWalls(this.body.getBoundingBox());
                    if (this.dragonFight != null) {
                        this.dragonFight.updateDragon(this);
                    }
                }
                for (k = 0; k < this.subEntities.length; ++k) {
                    this.subEntities[k].xo = avec3d[k].x;
                    this.subEntities[k].yo = avec3d[k].y;
                    this.subEntities[k].zo = avec3d[k].z;
                    this.subEntities[k].xOld = avec3d[k].x;
                    this.subEntities[k].yOld = avec3d[k].y;
                    this.subEntities[k].zOld = avec3d[k].z;
                }
            }
        }
    }

    private void tickPart(EnderDragonPart enderDragonPart, double dx, double dy, double dz) {
        enderDragonPart.setPos(this.getX() + dx, this.getY() + dy, this.getZ() + dz);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        double[] adouble = this.getLatencyPos(5, 1.0f);
        double[] adouble1 = this.getLatencyPos(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void checkCrystals() {
        if (this.nearestCrystal != null) {
            if (this.nearestCrystal.isRemoved()) {
                this.nearestCrystal = null;
            } else if (this.tickCount % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.setHealth((float)((double)this.getHealth() + event.getAmount()));
                }
            }
        }
        if (this.random.nextInt(10) == 0) {
            List<EndCrystal> list = this.level().getEntitiesOfClass(EndCrystal.class, this.getBoundingBox().inflate(32.0));
            EndCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EndCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.distanceToSqr(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.nearestCrystal = entityendercrystal;
        }
    }

    private void knockBack(ServerLevel world, List<Entity> entities) {
        double d0 = (this.body.getBoundingBox().minX + this.body.getBoundingBox().maxX) / 2.0;
        double d1 = (this.body.getBoundingBox().minZ + this.body.getBoundingBox().maxZ) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity entityliving = (LivingEntity)entity;
            double d2 = entity.getX() - d0;
            double d3 = entity.getZ() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.push(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0, this);
            if (this.phaseManager.getCurrentPhase().isSitting() || entityliving.getLastHurtByMobTimestamp() >= entity.tickCount - 2) continue;
            DamageSource damagesource = this.damageSources().mobAttack(this);
            entity.hurt(damagesource, 5.0f);
            EnchantmentHelper.doPostAttackEffects(world, entity, damagesource);
        }
    }

    private void hurt(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            DamageSource damagesource = this.damageSources().mobAttack(this);
            entity.hurt(damagesource, 10.0f);
            Level world = this.level();
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel worldserver = (ServerLevel)world;
            EnchantmentHelper.doPostAttackEffects(worldserver, entity, damagesource);
        }
    }

    private float rotWrap(double yawDegrees) {
        return (float)Mth.wrapDegrees(yawDegrees);
    }

    private boolean checkWalls(AABB box) {
        int i = Mth.floor(box.minX);
        int j = Mth.floor(box.minY);
        int k = Mth.floor(box.minZ);
        int l = Mth.floor(box.maxX);
        int i1 = Mth.floor(box.maxY);
        int j1 = Mth.floor(box.maxZ);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockposition = new BlockPos(k1, l1, i2);
                    BlockState iblockdata = this.level().getBlockState(blockposition);
                    if (iblockdata.isAir() || iblockdata.is(BlockTags.DRAGON_TRANSPARENT)) continue;
                    if ((this.level().purpurConfig.enderDragonBypassMobGriefing || this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) && !iblockdata.is(BlockTags.DRAGON_IMMUNE)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(this.level(), blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.getBlockInteraction());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.level().removeBlock(new BlockPos(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                CraftBlock tntBlock;
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPos blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().getBlock();
                if (nmsBlock.dropFromExplosion(this.explosionSource)) {
                    BlockEntity tileentity = craftBlock.getNMS().hasBlockEntity() ? this.level().getBlockEntity(blockposition) : null;
                    LootParams.Builder loottableinfo_builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockposition)).withParameter(LootContextParams.TOOL, ItemStack.EMPTY).withParameter(LootContextParams.EXPLOSION_RADIUS, Float.valueOf(1.0f / event.getYield())).withOptionalParameter(LootContextParams.BLOCK_ENTITY, tileentity);
                    craftBlock.getNMS().getDrops(loottableinfo_builder).forEach(itemstack -> Block.popResource(this.level(), blockposition, itemstack));
                    craftBlock.getNMS().spawnAfterBreak((ServerLevel)this.level(), blockposition, ItemStack.EMPTY, false);
                }
                if (!new TNTPrimeEvent((org.bukkit.block.Block)(tntBlock = CraftBlock.at(this.level(), blockposition)), TNTPrimeEvent.PrimeReason.EXPLOSION, (org.bukkit.entity.Entity)this.explosionSource.getIndirectSourceEntity().getBukkitEntity()).callEvent()) continue;
                nmsBlock.wasExploded(this.level(), blockposition, this.explosionSource);
                this.level().removeBlock(blockposition, false);
            }
        }
        if (flag1) {
            BlockPos blockposition1 = new BlockPos(i + this.random.nextInt(l - i + 1), j + this.random.nextInt(i1 - j + 1), k + this.random.nextInt(j1 - k + 1));
            this.level().levelEvent(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean hurt(EnderDragonPart part, DamageSource source, float amount) {
        if (this.phaseManager.getCurrentPhase().getPhase() == EnderDragonPhase.DYING) {
            return false;
        }
        amount = this.phaseManager.getCurrentPhase().onHurt(source, amount);
        if (part != this.head) {
            amount = amount / 4.0f + Math.min(amount, 1.0f);
        }
        if (amount < 0.01f) {
            return false;
        }
        if (source.getEntity() instanceof Player || source.is(DamageTypeTags.ALWAYS_HURTS_ENDER_DRAGONS)) {
            float f1 = this.getHealth();
            this.reallyHurt(source, amount);
            if (this.isDeadOrDying() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(EnderDragonPhase.DYING);
            }
            if (this.phaseManager.getCurrentPhase().isSitting()) {
                this.sittingDamageReceived = this.sittingDamageReceived + f1 - this.getHealth();
                if (this.sittingDamageReceived > 0.25f * this.getMaxHealth()) {
                    this.sittingDamageReceived = 0.0f;
                    this.phaseManager.setPhase(EnderDragonPhase.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        return !this.level().isClientSide ? this.hurt(this.body, source, amount) : false;
    }

    protected boolean reallyHurt(DamageSource source, float amount) {
        return super.hurt(source, amount);
    }

    @Override
    public void kill() {
        this.silentDeath = true;
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, this.damageSources().genericKill());
        if (deathEvent.isCancelled()) {
            this.silentDeath = false;
            return;
        }
        this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        this.gameEvent(GameEvent.ENTITY_DIE);
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
            this.dragonFight.setDragonKilled(this);
        }
    }

    @Override
    public int getExpReward(Entity entity) {
        boolean flag = this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
        int short0 = 500;
        if (this.dragonFight != null && (this.level().purpurConfig.enderDragonAlwaysDropsFullExp || !this.dragonFight.hasPreviouslyKilledDragon())) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void tickDeath() {
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
        }
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float f = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(ParticleTypes.EXPLOSION_EMITTER, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        int short0 = this.expToDrop;
        if (this.level() instanceof ServerLevel) {
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0) {
                ExperienceOrb.award((ServerLevel)this.level(), this.position(), Mth.floor((float)short0 * 0.08f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.lastHurtByPlayer, this);
            }
            if (this.dragonDeathTime == 1 && !this.isSilent()) {
                int viewDistance = ((ServerLevel)this.level()).getCraftServer().getViewDistance() * 16;
                for (ServerPlayer player : this.level().getPlayersForGlobalSoundGamerule()) {
                    double deltaX = this.getX() - player.getX();
                    double deltaZ = this.getZ() - player.getZ();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    double soundRadiusSquared = this.level().getGlobalSoundRangeSquared(config -> config.dragonDeathSoundRadius);
                    if (!this.level().getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS) && distanceSquared > soundRadiusSquared) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.getX() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.getZ() + deltaZ / deltaLength * (double)viewDistance;
                        player.connection.send(new ClientboundLevelEventPacket(1028, new BlockPos((int)relativeX, (int)this.getY(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.connection.send(new ClientboundLevelEventPacket(1028, new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ()), 0, true));
                }
            }
        }
        this.move(MoverType.SELF, new Vec3(0.0, 0.1f, 0.0));
        if (this.dragonDeathTime == 200 && this.level() instanceof ServerLevel) {
            ExperienceOrb.award((ServerLevel)this.level(), this.position(), Mth.floor((float)short0 * 0.2f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.lastHurtByPlayer, this);
            if (this.dragonFight != null) {
                this.dragonFight.setDragonKilled(this);
            }
            this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
            this.gameEvent(GameEvent.ENTITY_DIE);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int i = 0; i < 24; ++i) {
                int l;
                int k;
                int j = 5;
                if (i < 12) {
                    k = Mth.floor(60.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)));
                    l = Mth.floor(60.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)));
                } else if (i < 20) {
                    i1 = i - 12;
                    k = Mth.floor(40.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l = Mth.floor(40.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j += 10;
                } else {
                    i1 = i - 20;
                    k = Mth.floor(20.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                    l = Mth.floor(20.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                }
                int j1 = Math.max(this.level().getSeaLevel() + 10, this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(k, 0, l)).getY() + j);
                this.nodes[i] = new Node(k, j1, l);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.getX(), this.getY(), this.getZ());
    }

    public int findClosestNode(double x, double y, double z) {
        float f = 10000.0f;
        int i = 0;
        Node pathpoint = new Node(Mth.floor(x), Mth.floor(y), Mth.floor(z));
        int b0 = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            b0 = 12;
        }
        for (int j = b0; j < 24; ++j) {
            float f1;
            if (this.nodes[j] == null || !((f1 = this.nodes[j].distanceToSqr(pathpoint)) < f)) continue;
            f = f1;
            i = j;
        }
        return i;
    }

    @Nullable
    public Path findPath(int from, int to, @Nullable Node pathNode) {
        Node pathpoint1;
        for (int k = 0; k < 24; ++k) {
            pathpoint1 = this.nodes[k];
            pathpoint1.closed = false;
            pathpoint1.h = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = 0.0f;
            pathpoint1.cameFrom = null;
            pathpoint1.heapIdx = -1;
        }
        Node pathpoint2 = this.nodes[from];
        pathpoint1 = this.nodes[to];
        pathpoint2.f = 0.0f;
        pathpoint2.h = pathpoint2.h = pathpoint2.distanceTo(pathpoint1);
        this.openSet.clear();
        this.openSet.insert(pathpoint2);
        Node pathpoint3 = pathpoint2;
        int b0 = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            b0 = 12;
        }
        while (!this.openSet.isEmpty()) {
            int i1;
            Node pathpoint4 = this.openSet.pop();
            if (pathpoint4.equals(pathpoint1)) {
                if (pathNode != null) {
                    pathNode.cameFrom = pathpoint1;
                    pathpoint1 = pathNode;
                }
                return this.reconstructPath(pathpoint2, pathpoint1);
            }
            if (pathpoint4.distanceTo(pathpoint1) < pathpoint3.distanceTo(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.closed = true;
            int l = 0;
            for (i1 = 0; i1 < 24; ++i1) {
                if (this.nodes[i1] != pathpoint4) {
                    continue;
                }
                l = i1;
                break;
            }
            for (i1 = b0; i1 < 24; ++i1) {
                if ((this.nodeAdjacency[l] & 1 << i1) <= 0) continue;
                Node pathpoint5 = this.nodes[i1];
                if (pathpoint5.closed) continue;
                float f = pathpoint4.f + pathpoint4.distanceTo(pathpoint5);
                if (pathpoint5.inOpenSet() && !(f < pathpoint5.f)) continue;
                pathpoint5.cameFrom = pathpoint4;
                pathpoint5.f = f;
                pathpoint5.h = pathpoint5.distanceTo(pathpoint1);
                if (pathpoint5.inOpenSet()) {
                    this.openSet.changeCost(pathpoint5, pathpoint5.f + pathpoint5.h);
                    continue;
                }
                pathpoint5.h = pathpoint5.f + pathpoint5.h;
                this.openSet.insert(pathpoint5);
            }
        }
        if (pathpoint3 == pathpoint2) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)from, (Object)to);
        if (pathNode != null) {
            pathNode.cameFrom = pathpoint3;
            pathpoint3 = pathNode;
        }
        return this.reconstructPath(pathpoint2, pathpoint3);
    }

    private Path reconstructPath(Node unused, Node node) {
        ArrayList list = Lists.newArrayList();
        Node pathpoint2 = node;
        list.add(0, node);
        while (pathpoint2.cameFrom != null) {
            pathpoint2 = pathpoint2.cameFrom;
            list.add(0, pathpoint2);
        }
        return new Path(list, new BlockPos(node.x, node.y, node.z), true);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt(DRAGON_PHASE_KEY, this.phaseManager.getCurrentPhase().getPhase().getId());
        nbt.putInt(DRAGON_DEATH_TIME_KEY, this.dragonDeathTime);
        nbt.putInt("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains(DRAGON_PHASE_KEY)) {
            this.phaseManager.setPhase(EnderDragonPhase.getById(nbt.getInt(DRAGON_PHASE_KEY)));
        }
        if (nbt.contains(DRAGON_DEATH_TIME_KEY)) {
            this.dragonDeathTime = nbt.getInt(DRAGON_DEATH_TIME_KEY);
        }
        if (nbt.contains("Bukkit.expToDrop")) {
            this.expToDrop = nbt.getInt("Bukkit.expToDrop");
        }
    }

    @Override
    public void checkDespawn() {
    }

    public EnderDragonPart[] getSubEntities() {
        return this.subEntities;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENDER_DRAGON_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ENDER_DRAGON_HURT;
    }

    @Override
    public float getSoundVolume() {
        return 5.0f;
    }

    public float getHeadPartYOffset(int segmentOffset, double[] segment1, double[] segment2) {
        double d0;
        DragonPhaseInstance idragoncontroller = this.phaseManager.getCurrentPhase();
        EnderDragonPhase<? extends DragonPhaseInstance> dragoncontrollerphase = idragoncontroller.getPhase();
        if (dragoncontrollerphase != EnderDragonPhase.LANDING && dragoncontrollerphase != EnderDragonPhase.TAKEOFF) {
            d0 = idragoncontroller.isSitting() ? (double)segmentOffset : (segmentOffset == 6 ? 0.0 : segment2[1] - segment1[1]);
        } else {
            BlockPos blockposition = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.getPodium());
            double d1 = Math.max(Math.sqrt(blockposition.distToCenterSqr(this.position())) / 4.0, 1.0);
            d0 = (double)segmentOffset / d1;
        }
        return (float)d0;
    }

    public Vec3 getHeadLookVector(float tickDelta) {
        Vec3 vec3d;
        DragonPhaseInstance idragoncontroller = this.phaseManager.getCurrentPhase();
        EnderDragonPhase<? extends DragonPhaseInstance> dragoncontrollerphase = idragoncontroller.getPhase();
        if (dragoncontrollerphase != EnderDragonPhase.LANDING && dragoncontrollerphase != EnderDragonPhase.TAKEOFF) {
            if (idragoncontroller.isSitting()) {
                float f2 = this.getXRot();
                float f1 = 1.5f;
                this.setXRot(-45.0f);
                vec3d = this.getViewVector(tickDelta);
                this.setXRot(f2);
            } else {
                vec3d = this.getViewVector(tickDelta);
            }
        } else {
            BlockPos blockposition = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.getPodium());
            float f1 = Math.max((float)Math.sqrt(blockposition.distToCenterSqr(this.position())) / 4.0f, 1.0f);
            float f3 = 6.0f / f1;
            float f4 = this.getXRot();
            float f5 = 1.5f;
            this.setXRot(-f3 * 1.5f * 5.0f);
            vec3d = this.getViewVector(tickDelta);
            this.setXRot(f4);
        }
        return vec3d;
    }

    public void onCrystalDestroyed(EndCrystal endCrystal, BlockPos pos, DamageSource source) {
        Player entityhuman = source.getEntity() instanceof Player ? (Player)source.getEntity() : this.level().getNearestPlayer(CRYSTAL_DESTROY_TARGETING, pos.getX(), pos.getY(), pos.getZ());
        if (endCrystal == this.nearestCrystal) {
            this.hurt(this.head, this.damageSources().explosion(endCrystal, entityhuman), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(endCrystal, pos, source, entityhuman);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_PHASE.equals(data) && this.level().isClientSide) {
            this.phaseManager.setPhase(EnderDragonPhase.getById(this.getEntityData().get(DATA_PHASE)));
        }
        super.onSyncedDataUpdated(data);
    }

    public EnderDragonPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public EndDragonFight getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public boolean addEffect(MobEffectInstance effect, @Nullable Entity source) {
        return false;
    }

    @Override
    protected boolean canRide(Entity entity) {
        if (this.level().purpurConfig.enderDragonCanRideVehicles) {
            return this.boardingCooldown <= 0;
        }
        return false;
    }

    @Override
    public boolean canUsePortal(boolean allowVehicles) {
        return false;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        EnderDragonPart[] aentitycomplexpart = this.getSubEntities();
        for (int i = 0; i < aentitycomplexpart.length; ++i) {
            aentitycomplexpart[i].setId(i + packet.getId());
        }
    }

    @Override
    public boolean canAttack(LivingEntity target) {
        return target.canBeSeenAsEnemy();
    }

    @Override
    protected float sanitizeScale(float scale) {
        return 1.0f;
    }
}

