/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.purpurmc.purpur.controller.FlyingWithSpacebarMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class WitherBoss
extends Monster
implements PowerableMob,
RangedAttackMob {
    private static final EntityDataAccessor<Integer> DATA_TARGET_A = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TARGET_B = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TARGET_C = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final List<EntityDataAccessor<Integer>> DATA_TARGETS = ImmutableList.of(DATA_TARGET_A, DATA_TARGET_B, DATA_TARGET_C);
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final int INVULNERABLE_TICKS = 220;
    private final float[] xRotHeads = new float[2];
    private final float[] yRotHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private int destroyBlocksTick;
    public final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = entityliving -> !entityliving.getType().is(EntityTypeTags.WITHER_FRIENDS) && entityliving.attackable();
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.forCombat().range(20.0).selector(LIVING_ENTITY_SELECTOR);
    @Nullable
    private UUID summoner;
    private int shootCooldown = 0;
    private boolean canPortal = false;
    private FlyingWithSpacebarMoveControllerWASD purpurController = new FlyingWithSpacebarMoveControllerWASD((Mob)this, 0.1f);

    public void setCanTravelThroughPortals(boolean canPortal) {
        this.canPortal = canPortal;
    }

    public WitherBoss(EntityType<? extends WitherBoss> type, Level world) {
        super((EntityType<? extends Monster>)type, world);
        this.moveControl = new FlyingMoveControl(this, 10, false){

            @Override
            public void tick() {
                if (this.mob.getRider() != null && this.mob.isControllable()) {
                    WitherBoss.this.purpurController.purpurTick(this.mob.getRider());
                } else {
                    super.tick();
                }
            }
        };
        this.setHealth(this.getMaxHealth());
        this.xpReward = 50;
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.witherMaxHealth);
        this.getAttribute(Attributes.SCALE).setBaseValue(this.level().purpurConfig.witherScale);
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.witherTakeDamageFromWater;
    }

    @Nullable
    public UUID getSummoner() {
        return this.summoner;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoner = summoner;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.witherAlwaysDropExp;
    }

    @Override
    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation navigationflying = new FlyingPathNavigation(this, world);
        navigationflying.setCanOpenDoors(false);
        navigationflying.setCanFloat(true);
        navigationflying.setCanPassDoors(true);
        return navigationflying;
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.witherRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.witherRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.witherControllable;
    }

    @Override
    public double getMaxY() {
        return this.level().purpurConfig.witherMaxY;
    }

    @Override
    public void travel(Vec3 vec3) {
        super.travel(vec3);
        if (this.getRider() != null && this.isControllable() && !this.onGround) {
            float speed = (float)this.getAttributeValue(Attributes.FLYING_SPEED) * 5.0f;
            this.setSpeed(speed);
            Vec3 mot = this.getDeltaMovement();
            this.move(MoverType.SELF, mot.multiply(speed, 0.5, speed));
            this.setDeltaMovement(mot.scale(0.9));
        }
    }

    @Override
    public void onMount(Player rider) {
        super.onMount(rider);
        this.entityData.set(DATA_TARGETS.get(0), 0);
        this.entityData.set(DATA_TARGETS.get(1), 0);
        this.entityData.set(DATA_TARGETS.get(2), 0);
        this.getNavigation().stop();
        this.shootCooldown = 20;
    }

    @Override
    public boolean onClick(InteractionHand hand) {
        int[] nArray;
        Player player = this.getRider();
        if (hand == InteractionHand.MAIN_HAND) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 2;
        }
        return this.shoot(player, nArray);
    }

    public boolean shoot(@Nullable Player rider, int[] heads) {
        Vec3 loc;
        if (this.shootCooldown > 0) {
            return false;
        }
        this.shootCooldown = 20;
        if (rider == null) {
            return false;
        }
        CraftHumanEntity player = rider.getBukkitEntity();
        if (!player.hasPermission("allow.special.wither")) {
            return false;
        }
        HitResult rayTrace = this.getRayTrace(120, ClipContext.Fluid.NONE);
        if (rayTrace == null) {
            return false;
        }
        if (rayTrace.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)rayTrace).getBlockPos();
            loc = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        } else if (rayTrace.getType() == HitResult.Type.ENTITY) {
            Entity target = ((EntityHitResult)rayTrace).getEntity();
            loc = new Vec3(target.getX(), target.getY() + (double)(target.getEyeHeight() / 2.0f), target.getZ());
        } else {
            Block block = player.getTargetBlock(null, 120);
            loc = new Vec3((double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5);
        }
        for (int head : heads) {
            this.shoot(head, loc.x(), loc.y(), loc.z(), rider);
        }
        return true;
    }

    public void shoot(int head, double x, double y, double z, Player rider) {
        this.level().levelEvent(null, 1024, this.blockPosition(), 0);
        double headX = this.getHeadX(head);
        double headY = this.getHeadY(head);
        double headZ = this.getHeadZ(head);
        Vec3 vec3d = new Vec3(x - headX, y - headY, z - headZ);
        WitherSkull skull = new WitherSkull(this.level(), this, vec3d.normalize());
        skull.setPosRaw(headX, headY, headZ);
        this.level().addFreshEntity(skull);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new HasRider(this));
        this.goalSelector.addGoal(0, new WitherDoNothingGoal());
        this.goalSelector.addGoal(2, new RangedAttackGoal(this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(5, new WaterAvoidingRandomFlyingGoal(this, 1.0));
        this.goalSelector.addGoal(6, new LookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(0, new HasRider(this));
        this.targetSelector.addGoal(1, new HurtByTargetGoal(this, new Class[0]));
        this.targetSelector.addGoal(2, new NearestAttackableTargetGoal<LivingEntity>(this, LivingEntity.class, 0, false, false, LIVING_ENTITY_SELECTOR));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TARGET_A, 0);
        builder.define(DATA_TARGET_B, 0);
        builder.define(DATA_TARGET_C, 0);
        builder.define(DATA_ID_INV, 0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("Invul", this.getInvulnerableTicks());
        if (this.getSummoner() != null) {
            nbt.putUUID("Purpur.Summoner", this.getSummoner());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setInvulnerableTicks(nbt.getInt("Invul"));
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
        if (nbt.contains("Purpur.Summoner")) {
            this.setSummoner(nbt.getUUID("Purpur.Summoner"));
        }
    }

    @Override
    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossEvent.setName(this.getDisplayName());
    }

    @Override
    public boolean shouldCheckForSuffocation() {
        return true;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.WITHER_HURT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.WITHER_DEATH;
    }

    @Override
    public void aiStep() {
        int i;
        Entity entity;
        Vec3 vec3d = this.getDeltaMovement().multiply(1.0, 0.6, 1.0);
        if (!this.level().isClientSide && this.getAlternativeTarget(0) > 0 && (entity = this.level().getEntity(this.getAlternativeTarget(0))) != null) {
            double d0 = vec3d.y;
            if (this.getY() < entity.getY() || !this.isPowered() && this.getY() < entity.getY() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3(vec3d.x, d0, vec3d.z);
            Vec3 vec3d1 = new Vec3(entity.getX() - this.getX(), 0.0, entity.getZ() - this.getZ());
            if (vec3d1.horizontalDistanceSqr() > 9.0) {
                Vec3 vec3d2 = vec3d1.normalize();
                vec3d = vec3d.add(vec3d2.x * 0.3 - vec3d.x * 0.6, 0.0, vec3d2.z * 0.3 - vec3d.z * 0.6);
            }
        }
        this.setDeltaMovement(vec3d);
        if (vec3d.horizontalDistanceSqr() > 0.05) {
            this.setYRot((float)Mth.atan2(vec3d.z, vec3d.x) * 57.295776f - 90.0f);
        }
        super.aiStep();
        for (i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotHeads[i];
            this.xRotOHeads[i] = this.xRotHeads[i];
        }
        for (i = 0; i < 2; ++i) {
            int j = this.getAlternativeTarget(i + 1);
            Entity entity1 = null;
            if (j > 0) {
                entity1 = this.level().getEntity(j);
            }
            if (entity1 != null) {
                double d1 = this.getHeadX(i + 1);
                double d2 = this.getHeadY(i + 1);
                double d3 = this.getHeadZ(i + 1);
                double d4 = entity1.getX() - d1;
                double d5 = entity1.getEyeY() - d2;
                double d6 = entity1.getZ() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f = (float)(Mth.atan2(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(Mth.atan2(d5, d7) * 57.2957763671875));
                this.xRotHeads[i] = this.rotlerp(this.xRotHeads[i], f1, 40.0f);
                this.yRotHeads[i] = this.rotlerp(this.yRotHeads[i], f, 10.0f);
                continue;
            }
            this.yRotHeads[i] = this.rotlerp(this.yRotHeads[i], this.yBodyRot, 10.0f);
        }
        boolean flag = this.isPowered();
        for (int j = 0; j < 3; ++j) {
            double d8 = this.getHeadX(j);
            double d9 = this.getHeadY(j);
            double d10 = this.getHeadZ(j);
            float f2 = 0.3f * this.getScale();
            this.level().addParticle(ParticleTypes.SMOKE, d8 + this.random.nextGaussian() * (double)f2, d9 + this.random.nextGaussian() * (double)f2, d10 + this.random.nextGaussian() * (double)f2, 0.0, 0.0, 0.0);
            if (!flag || this.level().random.nextInt(4) != 0) continue;
            this.level().addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, 0.7f, 0.7f, 0.5f), d8 + this.random.nextGaussian() * (double)f2, d9 + this.random.nextGaussian() * (double)f2, d10 + this.random.nextGaussian() * (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulnerableTicks() > 0) {
            float f3 = 3.3f * this.getScale();
            for (int k = 0; k < 3; ++k) {
                this.level().addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, 0.7f, 0.7f, 0.9f), this.getX() + this.random.nextGaussian(), this.getY() + (double)(this.random.nextFloat() * f3), this.getZ() + this.random.nextGaussian(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void customServerAiStep() {
        if (this.getRider() != null && this.isControllable()) {
            Vec3 mot = this.getDeltaMovement();
            this.setDeltaMovement(mot.x(), mot.y() + (this.getVerticalMot() > 0.0f ? 0.07 : 0.0), mot.z());
        }
        if (this.shootCooldown > 0) {
            --this.shootCooldown;
        }
        if (this.getInvulnerableTicks() > 0) {
            int i = this.getInvulnerableTicks() - 1;
            this.bossEvent.setProgress(1.0f - (float)i / 220.0f);
            if (i <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.level().explode((Entity)this, this.getX(), this.getEyeY(), this.getZ(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.MOB);
                }
                if (!this.isSilent() && this.level().purpurConfig.witherPlaySpawnSound) {
                    int viewDistance = ((ServerLevel)this.level()).getCraftServer().getViewDistance() * 16;
                    for (ServerPlayer player : this.level().getPlayersForGlobalSoundGamerule()) {
                        double deltaX = this.getX() - player.getX();
                        double deltaZ = this.getZ() - player.getZ();
                        double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                        double soundRadiusSquared = this.level().getGlobalSoundRangeSquared(config -> config.witherSpawnSoundRadius);
                        if (!this.level().getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS) && distanceSquared > soundRadiusSquared) continue;
                        if (distanceSquared > (double)(viewDistance * viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.getX() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.getZ() + deltaZ / deltaLength * (double)viewDistance;
                            player.connection.send(new ClientboundLevelEventPacket(1023, new BlockPos((int)relativeX, (int)this.getY(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.connection.send(new ClientboundLevelEventPacket(1023, this.blockPosition(), 0, true));
                    }
                }
            }
            this.setInvulnerableTicks(i);
            if (this.tickCount % 10 == 0) {
                this.heal(this.getMaxHealth() / 33.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int j;
            super.customServerAiStep();
            for (int i = 1; i < 3; ++i) {
                LivingEntity entityliving1;
                if (this.tickCount < this.nextHeadUpdate[i - 1]) continue;
                this.nextHeadUpdate[i - 1] = this.tickCount + 10 + this.random.nextInt(10);
                if (this.level().getDifficulty() == Difficulty.NORMAL || this.level().getDifficulty() == Difficulty.HARD) {
                    int k = i - 1;
                    int l = this.idleHeadUpdates[i - 1];
                    this.idleHeadUpdates[k] = this.idleHeadUpdates[i - 1] + 1;
                    if (l > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = Mth.nextDouble(this.random, this.getX() - 10.0, this.getX() + 10.0);
                        double d1 = Mth.nextDouble(this.random, this.getY() - 5.0, this.getY() + 5.0);
                        double d2 = Mth.nextDouble(this.random, this.getZ() - 10.0, this.getZ() + 10.0);
                        this.performRangedAttack(i + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[i - 1] = 0;
                    }
                }
                if ((j = this.getAlternativeTarget(i)) > 0) {
                    LivingEntity entityliving = (LivingEntity)this.level().getEntity(j);
                    if (entityliving != null && this.canAttack(entityliving) && this.distanceToSqr(entityliving) <= 900.0 && this.hasLineOfSight(entityliving)) {
                        this.performRangedAttack(i + 1, entityliving);
                        this.nextHeadUpdate[i - 1] = this.tickCount + 40 + this.random.nextInt(20);
                        this.idleHeadUpdates[i - 1] = 0;
                        continue;
                    }
                    this.setAlternativeTarget(i, 0);
                    continue;
                }
                List<LivingEntity> list = this.level().getNearbyEntities(LivingEntity.class, TARGETING_CONDITIONS, this, this.getBoundingBox().inflate(20.0, 8.0, 20.0));
                if (list.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, entityliving1 = list.get(this.random.nextInt(list.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.setAlternativeTarget(i, entityliving1.getId());
            }
            if (this.getTarget() != null) {
                this.setAlternativeTarget(0, this.getTarget().getId());
            } else {
                this.setAlternativeTarget(0, 0);
            }
            if (this.destroyBlocksTick > 0) {
                --this.destroyBlocksTick;
                if (this.destroyBlocksTick == 0 && (this.level().purpurConfig.witherBypassMobGriefing || this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING))) {
                    boolean flag = false;
                    j = Mth.floor(this.getBbWidth() / 2.0f + 1.0f);
                    int i1 = Mth.floor(this.getBbHeight());
                    for (BlockPos blockposition : BlockPos.betweenClosed(this.getBlockX() - j, this.getBlockY(), this.getBlockZ() - j, this.getBlockX() + j, this.getBlockY() + i1, this.getBlockZ() + j)) {
                        BlockState iblockdata = this.level().getBlockState(blockposition);
                        if (!WitherBoss.canDestroy(iblockdata) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, iblockdata.getFluidState().createLegacyBlock())) continue;
                        flag = this.level().destroyBlock(blockposition, true, this) || flag;
                    }
                    if (flag) {
                        this.level().levelEvent(null, 1022, this.blockPosition(), 0);
                    }
                }
            }
            if (this.tickCount % this.level().purpurConfig.witherHealthRegenDelay == 0) {
                this.heal(this.level().purpurConfig.witherHealthRegenAmount, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    public static boolean canDestroy(BlockState block) {
        return !block.isAir() && !block.is(BlockTags.WITHER_IMMUNE);
    }

    public void makeInvulnerable() {
        this.setInvulnerableTicks(220);
        this.bossEvent.setProgress(0.0f);
        this.setHealth(this.getMaxHealth() / 3.0f);
    }

    @Override
    public void makeStuckInBlock(BlockState state, Vec3 multiplier) {
    }

    @Override
    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
    }

    @Override
    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossEvent.removePlayer(player);
    }

    private double getHeadX(int headIndex) {
        if (headIndex <= 0) {
            return this.getX();
        }
        float f = (this.yBodyRot + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.cos(f);
        return this.getX() + (double)f1 * 1.3 * (double)this.getScale();
    }

    private double getHeadY(int headIndex) {
        float f = headIndex <= 0 ? 3.0f : 2.2f;
        return this.getY() + (double)(f * this.getScale());
    }

    private double getHeadZ(int headIndex) {
        if (headIndex <= 0) {
            return this.getZ();
        }
        float f = (this.yBodyRot + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.sin(f);
        return this.getZ() + (double)f1 * 1.3 * (double)this.getScale();
    }

    private float rotlerp(float prevAngle, float desiredAngle, float maxDifference) {
        float f3 = Mth.wrapDegrees(desiredAngle - prevAngle);
        if (f3 > maxDifference) {
            f3 = maxDifference;
        }
        if (f3 < -maxDifference) {
            f3 = -maxDifference;
        }
        return prevAngle + f3;
    }

    private void performRangedAttack(int headIndex, LivingEntity target) {
        this.performRangedAttack(headIndex, target.getX(), target.getY() + (double)target.getEyeHeight() * 0.5, target.getZ(), headIndex == 0 && this.random.nextFloat() < 0.001f);
    }

    private void performRangedAttack(int headIndex, double targetX, double targetY, double targetZ, boolean charged) {
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1024, this.blockPosition(), 0);
        }
        double d3 = this.getHeadX(headIndex);
        double d4 = this.getHeadY(headIndex);
        double d5 = this.getHeadZ(headIndex);
        double d6 = targetX - d3;
        double d7 = targetY - d4;
        double d8 = targetZ - d5;
        Vec3 vec3d = new Vec3(d6, d7, d8);
        WitherSkull entitywitherskull = new WitherSkull(this.level(), this, vec3d.normalize());
        entitywitherskull.setOwner(this);
        if (charged) {
            entitywitherskull.setDangerous(true);
        }
        entitywitherskull.setPosRaw(d3, d4, d5);
        this.level().addFreshEntity(entitywitherskull);
    }

    @Override
    public void performRangedAttack(LivingEntity target, float pullProgress) {
        this.performRangedAttack(0, target);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!source.is(DamageTypeTags.WITHER_IMMUNE_TO) && !(source.getEntity() instanceof WitherBoss)) {
            Entity entity;
            if (this.getInvulnerableTicks() > 0 && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                return false;
            }
            if (this.isPowered() && ((entity = source.getDirectEntity()) instanceof AbstractArrow || entity instanceof WindCharge)) {
                return false;
            }
            entity = source.getEntity();
            if (entity != null && entity.getType().is(EntityTypeTags.WITHER_FRIENDS)) {
                return false;
            }
            if (this.destroyBlocksTick <= 0) {
                this.destroyBlocksTick = 20;
            }
            int i = 0;
            while (i < this.idleHeadUpdates.length) {
                int n = i++;
                this.idleHeadUpdates[n] = this.idleHeadUpdates[n] + 3;
            }
            return super.hurt(source, amount);
        }
        return false;
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel world, DamageSource source, boolean causedByPlayer) {
        super.dropCustomDeathLoot(world, source, causedByPlayer);
        ItemEntity entityitem = this.spawnAtLocation(new ItemStack(Items.NETHER_STAR), 0.0f, ItemEntity::setExtendedLifetime);
        if (entityitem != null) {
            entityitem.setExtendedLifetime();
        }
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.noActionTime = 0;
        }
    }

    @Override
    public boolean addEffect(MobEffectInstance effect, @Nullable Entity source) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 300.0).add(Attributes.MOVEMENT_SPEED, 0.6f).add(Attributes.FLYING_SPEED, 0.6f).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.ARMOR, 4.0);
    }

    public float getHeadYRot(int headIndex) {
        return this.yRotHeads[headIndex];
    }

    public float getHeadXRot(int headIndex) {
        return this.xRotHeads[headIndex];
    }

    public int getInvulnerableTicks() {
        return this.entityData.get(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int ticks) {
        this.entityData.set(DATA_ID_INV, ticks);
    }

    public int getAlternativeTarget(int headIndex) {
        return this.getRider() != null && this.isControllable() ? 0 : this.entityData.get(DATA_TARGETS.get(headIndex));
    }

    public void setAlternativeTarget(int headIndex, int id) {
        if (this.getRider() == null || !this.isControllable()) {
            this.entityData.set(DATA_TARGETS.get(headIndex), id);
        }
    }

    @Override
    public boolean isPowered() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Override
    protected boolean canRide(Entity entity) {
        if (this.level().purpurConfig.witherCanRideVehicles) {
            return this.boardingCooldown <= 0;
        }
        return false;
    }

    @Override
    public boolean canUsePortal(boolean allowVehicles) {
        return this.canPortal;
    }

    @Override
    public boolean canBeAffected(MobEffectInstance effect) {
        return effect.is(MobEffects.WITHER) && this.level().paperConfig().entities.mobEffects.immuneToWitherEffect.wither ? false : super.canBeAffected(effect);
    }

    private class WitherDoNothingGoal
    extends Goal {
        public WitherDoNothingGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            return WitherBoss.this.getInvulnerableTicks() > 0;
        }
    }
}

