/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;

public class LeashFenceKnotEntity
extends BlockAttachedEntity {
    public static final double OFFSET_Y = 0.375;

    public LeashFenceKnotEntity(EntityType<? extends LeashFenceKnotEntity> type, Level world) {
        super((EntityType<? extends BlockAttachedEntity>)type, world);
    }

    public LeashFenceKnotEntity(Level world, BlockPos pos) {
        super(EntityType.LEASH_KNOT, world, pos);
        this.setPos(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    protected void recalculateBoundingBox() {
        this.setPosRaw((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.375, (double)this.pos.getZ() + 0.5);
        double d0 = (double)this.getType().getWidth() / 2.0;
        double d1 = this.getType().getHeight();
        this.setBoundingBox(new AABB(this.getX() - d0, this.getY(), this.getZ() - d0, this.getX() + d0, this.getY() + d1, this.getZ() + d0));
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 1024.0;
    }

    @Override
    public void dropItem(@Nullable Entity breaker) {
        this.playSound(SoundEvents.LEASH_KNOT_BREAK, 1.0f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        boolean flag = false;
        List<Leashable> list = LeadItem.leashableInArea(this.level(), this.getPos(), leashable -> {
            Entity entity = leashable.getLeashHolder();
            return entity == player || entity == this;
        });
        for (Leashable leashable2 : list) {
            Entity leashed;
            if (leashable2.getLeashHolder() != player) continue;
            if (leashable2 instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable2), this, player, hand).isCancelled()) {
                ((ServerPlayer)player).connection.send(new ClientboundSetEntityLinkPacket(leashed, leashable2.getLeashHolder()));
                flag = true;
                continue;
            }
            leashable2.setLeashedTo(this, true);
            flag = true;
        }
        boolean flag1 = false;
        if (!flag) {
            boolean die = true;
            for (Leashable leashable1 : list) {
                boolean dropLeash;
                if (!leashable1.isLeashed() || leashable1.getLeashHolder() != this) continue;
                boolean bl = dropLeash = !player.hasInfiniteMaterials();
                if (leashable1 instanceof Entity) {
                    Entity leashed = (Entity)((Object)leashable1);
                    PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(leashed, player, hand, dropLeash);
                    dropLeash = event.isDropLeash();
                    if (event.isCancelled()) {
                        die = false;
                        continue;
                    }
                }
                leashable1.dropLeash(true, dropLeash);
                flag1 = true;
            }
            if (die) {
                this.discard(EntityRemoveEvent.Cause.DROP);
            }
        }
        if (flag || flag1) {
            this.gameEvent(GameEvent.BLOCK_ATTACH, player);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public boolean survives() {
        return this.level().getBlockState(this.pos).is(BlockTags.FENCES);
    }

    public static LeashFenceKnotEntity getOrCreateKnot(Level world, BlockPos pos) {
        LeashFenceKnotEntity entityleash;
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        List<LeashFenceKnotEntity> list = world.getEntitiesOfClass(LeashFenceKnotEntity.class, new AABB((double)i - 1.0, (double)j - 1.0, (double)k - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0));
        Iterator<LeashFenceKnotEntity> iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            LeashFenceKnotEntity entityleash1 = new LeashFenceKnotEntity(world, pos);
            world.addFreshEntity(entityleash1);
            return entityleash1;
        } while (!(entityleash = iterator.next()).getPos().equals(pos));
        return entityleash;
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.LEASH_KNOT_PLACE, 1.0f, 1.0f);
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        return new ClientboundAddEntityPacket((Entity)this, 0, this.getPos());
    }

    @Override
    public Vec3 getRopeHoldPosition(float delta) {
        return this.getPosition(delta).add(0.0, 0.2, 0.0);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.LEAD);
    }
}

