/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.util.Vector;
import org.purpurmc.purpur.controller.FlyingMoveControllerWASD;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.entity.PhantomFlames;
import org.purpurmc.purpur.entity.ai.HasRider;

public class Phantom
extends FlyingMob
implements Enemy {
    public static final float FLAP_DEGREES_PER_TICK = 7.448451f;
    public static final int TICKS_PER_FLAP = Mth.ceil(24.166098f);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.defineId(Phantom.class, EntityDataSerializers.INT);
    Vec3 moveTargetPoint = Vec3.ZERO;
    public BlockPos anchorPoint = BlockPos.ZERO;
    AttackPhase attackPhase = AttackPhase.CIRCLE;
    private static final Ingredient TORCH = Ingredient.of(Items.TORCH, Items.SOUL_TORCH);
    Vec3 crystalPosition;
    @Nullable
    UUID spawningEntity;

    public Phantom(EntityType<? extends Phantom> type, Level world) {
        super((EntityType<? extends FlyingMob>)type, world);
        this.xpReward = 5;
        this.moveControl = new PhantomMoveControl(this);
        this.lookControl = new PhantomLookControl(this, this, this);
        this.setShouldBurnInDay(true);
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.phantomRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.phantomRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.phantomControllable;
    }

    @Override
    public double getMaxY() {
        return this.level().purpurConfig.phantomMaxY;
    }

    @Override
    public void travel(Vec3 vec3) {
        super.travel(vec3);
        if (this.getRider() != null && this.isControllable() && !this.onGround) {
            float speed = (float)this.getAttributeValue(Attributes.FLYING_SPEED);
            this.setSpeed(speed);
            Vec3 mot = this.getDeltaMovement();
            this.move(MoverType.SELF, mot.multiply(speed, speed, speed));
            this.setDeltaMovement(mot.scale(0.9));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FLYING_SPEED, 3.0);
    }

    @Override
    public boolean onSpacebar() {
        if (this.getRider() != null && this.getRider().getBukkitEntity().hasPermission("allow.special.phantom")) {
            this.shoot();
        }
        return false;
    }

    public boolean shoot() {
        Location loc = ((org.bukkit.entity.LivingEntity)this.getBukkitEntity()).getEyeLocation();
        loc.setPitch(-loc.getPitch());
        Vector target = loc.getDirection().normalize().multiply(100).add(loc.toVector());
        PhantomFlames flames = new PhantomFlames(this.level(), this);
        flames.canGrief = this.level().purpurConfig.phantomAllowGriefing;
        flames.shoot(target.getX() - this.getX(), target.getY() - this.getY(), target.getZ() - this.getZ(), 1.0f, 5.0f);
        this.level().addFreshEntity(flames);
        return true;
    }

    @Override
    protected void dropFromLootTable(DamageSource damageSource, boolean causedByPlayer) {
        boolean dropped = false;
        if (this.lastHurtByPlayer == null && damageSource.getEntity() instanceof EndCrystal && this.random.nextInt(5) < 1) {
            boolean bl = dropped = this.spawnAtLocation(new ItemStack(Items.PHANTOM_MEMBRANE)) != null;
        }
        if (!dropped) {
            super.dropFromLootTable(damageSource, causedByPlayer);
        }
    }

    public boolean isCirclingCrystal() {
        return this.crystalPosition != null;
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.phantomTakeDamageFromWater;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.phantomAlwaysDropExp;
    }

    @Override
    public boolean isFlapping() {
        return (this.getUniqueFlapTickOffset() + this.tickCount) % TICKS_PER_FLAP == 0;
    }

    @Override
    protected BodyRotationControl createBodyControl() {
        return new PhantomBodyRotationControl(this);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new HasRider(this));
        if (this.level().purpurConfig.phantomOrbitCrystalRadius > 0.0) {
            this.goalSelector.addGoal(1, new FindCrystalGoal(this));
            this.goalSelector.addGoal(2, new OrbitCrystalGoal(this, this));
        }
        this.goalSelector.addGoal(3, new PhantomAttackStrategyGoal());
        this.goalSelector.addGoal(4, new PhantomSweepAttackGoal());
        this.goalSelector.addGoal(5, new PhantomCircleAroundAnchorGoal());
        this.targetSelector.addGoal(0, new HasRider(this));
        this.targetSelector.addGoal(1, new PhantomAttackPlayerTargetGoal());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_SIZE, 0);
    }

    public void setPhantomSize(int size) {
        this.entityData.set(ID_SIZE, Mth.clamp(size, 0, 64));
    }

    private void updatePhantomSizeInfo() {
        this.refreshDimensions();
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.getFromCache(() -> this.level().purpurConfig.phantomMaxHealth, () -> this.level().purpurConfig.phantomMaxHealthCache, () -> 20.0));
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(this.getFromCache(() -> this.level().purpurConfig.phantomAttackDamage, () -> this.level().purpurConfig.phantomAttackDamageCache, () -> 6.0 + (double)this.getPhantomSize()));
    }

    public int getPhantomSize() {
        return this.entityData.get(ID_SIZE);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (ID_SIZE.equals(data)) {
            this.updatePhantomSizeInfo();
        }
        super.onSyncedDataUpdated(data);
    }

    public int getUniqueFlapTickOffset() {
        return this.getId() * 3;
    }

    @Override
    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    private double getFromCache(Supplier<String> equation, Supplier<Map<Integer, Double>> cache, Supplier<Double> defaultValue) {
        int size = this.getPhantomSize();
        Double value = cache.get().get(size);
        if (value == null) {
            try {
                value = ((Number)Entity.scriptEngine.eval("let size = " + size + "; " + equation.get())).doubleValue();
            }
            catch (ScriptException e) {
                e.printStackTrace();
                value = defaultValue.get();
            }
            cache.get().put(size, value);
        }
        return value;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            float f = Mth.cos((float)(this.getUniqueFlapTickOffset() + this.tickCount) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI);
            float f1 = Mth.cos((float)(this.getUniqueFlapTickOffset() + this.tickCount + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI);
            if (f > 0.0f && f1 <= 0.0f) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.PHANTOM_FLAP, this.getSoundSource(), 0.95f + this.random.nextFloat() * 0.05f, 0.95f + this.random.nextFloat() * 0.05f, false);
            }
            float f2 = this.getBbWidth() * 1.48f;
            float f3 = Mth.cos(this.getYRot() * ((float)Math.PI / 180)) * f2;
            float f4 = Mth.sin(this.getYRot() * ((float)Math.PI / 180)) * f2;
            float f5 = (0.3f + f * 0.45f) * this.getBbHeight() * 2.5f;
            this.level().addParticle(ParticleTypes.MYCELIUM, this.getX() + (double)f3, this.getY() + (double)f5, this.getZ() + (double)f4, 0.0, 0.0, 0.0);
            this.level().addParticle(ParticleTypes.MYCELIUM, this.getX() - (double)f3, this.getY() + (double)f5, this.getZ() - (double)f4, 0.0, 0.0, 0.0);
        }
        if (this.level().purpurConfig.phantomFlamesOnSwoop && this.attackPhase == AttackPhase.SWOOP) {
            this.shoot();
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.anchorPoint = this.blockPosition().above(5);
        int min = world.getLevel().purpurConfig.phantomMinSize;
        int max = world.getLevel().purpurConfig.phantomMaxSize;
        this.setPhantomSize(min == max ? min : world.getRandom().nextInt(max + 1 - min) + min);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("AX")) {
            this.anchorPoint = new BlockPos(nbt.getInt("AX"), nbt.getInt("AY"), nbt.getInt("AZ"));
        }
        this.setPhantomSize(nbt.getInt("Size"));
        if (nbt.hasUUID("Paper.SpawningEntity")) {
            this.spawningEntity = nbt.getUUID("Paper.SpawningEntity");
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("AX", this.anchorPoint.getX());
        nbt.putInt("AY", this.anchorPoint.getY());
        nbt.putInt("AZ", this.anchorPoint.getZ());
        nbt.putInt("Size", this.getPhantomSize());
        if (this.spawningEntity != null) {
            nbt.putUUID("Paper.SpawningEntity", this.spawningEntity);
        }
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.PHANTOM_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.PHANTOM_HURT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.PHANTOM_DEATH;
    }

    @Override
    public float getSoundVolume() {
        return 1.0f;
    }

    @Override
    public boolean canAttackType(EntityType<?> type) {
        return true;
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose pose) {
        int i = this.getPhantomSize();
        EntityDimensions entitysize = super.getDefaultDimensions(pose);
        return entitysize.scale(1.0f + 0.15f * (float)i);
    }

    @Nullable
    public UUID getSpawningEntity() {
        return this.spawningEntity;
    }

    public void setSpawningEntity(UUID entity) {
        this.spawningEntity = entity;
    }

    @Override
    public boolean shouldBurnInDay() {
        boolean burnFromDaylight = this.shouldBurnInDay && this.level().purpurConfig.phantomBurnInDaylight;
        boolean burnFromLightSource = this.level().purpurConfig.phantomBurnInLight > 0 && this.level().getMaxLocalRawBrightness(this.blockPosition()) >= this.level().purpurConfig.phantomBurnInLight;
        return burnFromDaylight || burnFromLightSource;
    }

    @Override
    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    private static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    private class PhantomMoveControl
    extends FlyingMoveControllerWASD {
        private float speed;

        public PhantomMoveControl(Mob entity) {
            super(entity);
            this.speed = 0.1f;
        }

        @Override
        public void purpurTick(Player rider) {
            if (!Phantom.this.onGround) {
                // empty if block
            }
            super.purpurTick(rider);
        }

        @Override
        public void vanillaTick() {
            if (Phantom.this.horizontalCollision) {
                Phantom.this.setYRot(Phantom.this.getYRot() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = Phantom.this.moveTargetPoint.x - Phantom.this.getX();
            double d1 = Phantom.this.moveTargetPoint.y - Phantom.this.getY();
            double d2 = Phantom.this.moveTargetPoint.z - Phantom.this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = Phantom.this.getYRot();
                float f1 = (float)Mth.atan2(d2, d0);
                float f2 = Mth.wrapDegrees(Phantom.this.getYRot() + 90.0f);
                float f3 = Mth.wrapDegrees(f1 * 57.295776f);
                Phantom.this.setYRot(Mth.approachDegrees(f2, f3, 4.0f) - 90.0f);
                Phantom.this.yBodyRot = Phantom.this.getYRot();
                this.speed = Mth.degreesDifferenceAbs(f, Phantom.this.getYRot()) < 3.0f ? Mth.approach(this.speed, 1.8f, 0.005f * (1.8f / this.speed)) : Mth.approach(this.speed, 0.2f, 0.025f);
                float f4 = (float)(-(Mth.atan2(-d1, d3) * 57.2957763671875));
                Phantom.this.setXRot(f4);
                float f5 = Phantom.this.getYRot() + 90.0f;
                double d6 = (double)(this.speed * Mth.cos(f5 * ((float)Math.PI / 180))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.sin(f5 * ((float)Math.PI / 180))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.sin(f4 * ((float)Math.PI / 180))) * Math.abs(d1 / d5);
                Vec3 vec3d = Phantom.this.getDeltaMovement();
                Phantom.this.setDeltaMovement(vec3d.add(new Vec3(d6, d8, d7).subtract(vec3d).scale(0.2)));
            }
        }
    }

    private class PhantomLookControl
    extends LookControllerWASD {
        public PhantomLookControl(Phantom phantom, Phantom entity, Mob phantom2) {
            super(phantom2);
        }

        @Override
        public void purpurTick(Player rider) {
            this.setYawPitch(rider.getYRot(), -rider.xRotO * 0.75f);
        }

        @Override
        public void vanillaTick() {
        }
    }

    private class PhantomBodyRotationControl
    extends BodyRotationControl {
        public PhantomBodyRotationControl(Mob entity) {
            super(entity);
        }

        @Override
        public void clientTick() {
            Phantom.this.yHeadRot = Phantom.this.yBodyRot;
            Phantom.this.yBodyRot = Phantom.this.getYRot();
        }
    }

    class FindCrystalGoal
    extends Goal {
        private final Phantom phantom;
        private EndCrystal crystal;
        private Comparator<EndCrystal> comparator;

        FindCrystalGoal(Phantom phantom) {
            this.phantom = phantom;
            this.comparator = Comparator.comparingDouble(phantom::distanceToSqr);
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            double range = this.maxTargetRange();
            List<EndCrystal> crystals = Phantom.this.level().getEntitiesOfClass(EndCrystal.class, this.phantom.getBoundingBox().inflate(range));
            if (crystals.isEmpty()) {
                return false;
            }
            crystals.sort(this.comparator);
            this.crystal = crystals.get(0);
            if (this.phantom.distanceToSqr(this.crystal) > range * range) {
                this.crystal = null;
                return false;
            }
            return true;
        }

        @Override
        public boolean canContinueToUse() {
            if (this.crystal == null || !this.crystal.isAlive()) {
                return false;
            }
            double range = this.maxTargetRange();
            return this.phantom.distanceToSqr(this.crystal) <= range * range * 2.0;
        }

        @Override
        public void start() {
            this.phantom.crystalPosition = new Vec3(this.crystal.getX(), this.crystal.getY() + (double)(this.phantom.random.nextInt(10) + 10), this.crystal.getZ());
        }

        @Override
        public void stop() {
            this.crystal = null;
            this.phantom.crystalPosition = null;
            super.stop();
        }

        private double maxTargetRange() {
            return this.phantom.level().purpurConfig.phantomOrbitCrystalRadius;
        }
    }

    class OrbitCrystalGoal
    extends Goal {
        private final Phantom phantom;
        private float offset;
        private float radius;
        private float verticalChange;
        private float direction;

        OrbitCrystalGoal(Phantom this$0, Phantom phantom) {
            this.phantom = phantom;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            return this.phantom.isCirclingCrystal();
        }

        @Override
        public void start() {
            this.radius = 5.0f + this.phantom.random.nextFloat() * 10.0f;
            this.verticalChange = -4.0f + this.phantom.random.nextFloat() * 9.0f;
            this.direction = this.phantom.random.nextBoolean() ? 1.0f : -1.0f;
            this.updateOffset();
        }

        @Override
        public void tick() {
            if (this.phantom.random.nextInt(350) == 0) {
                this.verticalChange = -4.0f + this.phantom.random.nextFloat() * 9.0f;
            }
            if (this.phantom.random.nextInt(250) == 0) {
                this.radius += 1.0f;
                if (this.radius > 15.0f) {
                    this.radius = 5.0f;
                    this.direction = -this.direction;
                }
            }
            if (this.phantom.random.nextInt(450) == 0) {
                this.offset = this.phantom.random.nextFloat() * 2.0f * (float)Math.PI;
                this.updateOffset();
            }
            if (this.phantom.moveTargetPoint.distanceToSqr(this.phantom.getX(), this.phantom.getY(), this.phantom.getZ()) < 4.0) {
                this.updateOffset();
            }
            if (this.phantom.moveTargetPoint.y < this.phantom.getY() && !this.phantom.level().isEmptyBlock(new BlockPos(this.phantom).below(1))) {
                this.verticalChange = Math.max(1.0f, this.verticalChange);
                this.updateOffset();
            }
            if (this.phantom.moveTargetPoint.y > this.phantom.getY() && !this.phantom.level().isEmptyBlock(new BlockPos(this.phantom).above(1))) {
                this.verticalChange = Math.min(-1.0f, this.verticalChange);
                this.updateOffset();
            }
        }

        private void updateOffset() {
            this.offset += this.direction * 15.0f * ((float)Math.PI / 180);
            this.phantom.moveTargetPoint = this.phantom.crystalPosition.add(this.radius * Mth.cos(this.offset), -4.0f + this.verticalChange, this.radius * Mth.sin(this.offset));
        }
    }

    private class PhantomAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        PhantomAttackStrategyGoal() {
        }

        @Override
        public boolean canUse() {
            LivingEntity entityliving = Phantom.this.getTarget();
            return entityliving != null ? Phantom.this.canAttack(entityliving, TargetingConditions.DEFAULT) : false;
        }

        @Override
        public void start() {
            this.nextSweepTick = this.adjustedTickDelay(10);
            Phantom.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        @Override
        public void stop() {
            Phantom.this.anchorPoint = Phantom.this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, Phantom.this.anchorPoint).above(10 + Phantom.this.random.nextInt(20));
        }

        @Override
        public void tick() {
            if (Phantom.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    Phantom.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.adjustedTickDelay((8 + Phantom.this.random.nextInt(4)) * 20);
                    Phantom.this.playSound(SoundEvents.PHANTOM_SWOOP, 10.0f, 0.95f + Phantom.this.random.nextFloat() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            Phantom.this.anchorPoint = Phantom.this.getTarget().blockPosition().above(20 + Phantom.this.random.nextInt(20));
            if (Phantom.this.anchorPoint.getY() < Phantom.this.level().getSeaLevel()) {
                Phantom.this.anchorPoint = new BlockPos(Phantom.this.anchorPoint.getX(), Phantom.this.level().getSeaLevel() + 1, Phantom.this.anchorPoint.getZ());
            }
        }
    }

    private class PhantomSweepAttackGoal
    extends PhantomMoveTargetGoal {
        private static final int CAT_SEARCH_TICK_DELAY = 20;
        private boolean isScaredOfCat;
        private int catSearchTick;

        PhantomSweepAttackGoal() {
        }

        @Override
        public boolean canUse() {
            return Phantom.this.getTarget() != null && Phantom.this.attackPhase == AttackPhase.SWOOP;
        }

        @Override
        public boolean canContinueToUse() {
            LivingEntity entityliving = Phantom.this.getTarget();
            if (entityliving == null) {
                return false;
            }
            if (!entityliving.isAlive()) {
                return false;
            }
            if (Phantom.this.level().purpurConfig.phantomBurnInLight > 0 && Phantom.this.level().getLightEmission(new BlockPos(Phantom.this)) >= Phantom.this.level().purpurConfig.phantomBurnInLight) {
                return false;
            }
            if (Phantom.this.level().purpurConfig.phantomIgnorePlayersWithTorch && (TORCH.test(entityliving.getItemInHand(InteractionHand.MAIN_HAND)) || TORCH.test(entityliving.getItemInHand(InteractionHand.OFF_HAND)))) {
                return false;
            }
            if (entityliving instanceof Player) {
                Player entityhuman = (Player)entityliving;
                if (entityliving.isSpectator() || entityhuman.isCreative()) {
                    return false;
                }
            }
            if (!this.canUse()) {
                return false;
            }
            if (Phantom.this.tickCount > this.catSearchTick) {
                this.catSearchTick = Phantom.this.tickCount + 20;
                List<Entity> list = Phantom.this.level().getEntitiesOfClass(Cat.class, Phantom.this.getBoundingBox().inflate(16.0), EntitySelector.ENTITY_STILL_ALIVE);
                for (Cat cat : list) {
                    cat.hiss();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
            Phantom.this.setTarget(null);
            Phantom.this.attackPhase = AttackPhase.CIRCLE;
        }

        @Override
        public void tick() {
            LivingEntity entityliving = Phantom.this.getTarget();
            if (entityliving != null) {
                Phantom.this.moveTargetPoint = new Vec3(entityliving.getX(), entityliving.getY(0.5), entityliving.getZ());
                if (Phantom.this.getBoundingBox().inflate(0.2f).intersects(entityliving.getBoundingBox())) {
                    Phantom.this.doHurtTarget(entityliving);
                    Phantom.this.attackPhase = AttackPhase.CIRCLE;
                    if (!Phantom.this.isSilent()) {
                        Phantom.this.level().levelEvent(1039, Phantom.this.blockPosition(), 0);
                    }
                } else if (Phantom.this.horizontalCollision || Phantom.this.hurtTime > 0) {
                    Phantom.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    private class PhantomCircleAroundAnchorGoal
    extends PhantomMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        PhantomCircleAroundAnchorGoal() {
        }

        @Override
        public boolean canUse() {
            return Phantom.this.getTarget() == null || Phantom.this.attackPhase == AttackPhase.CIRCLE;
        }

        @Override
        public void start() {
            this.distance = 5.0f + Phantom.this.random.nextFloat() * 10.0f;
            this.height = -4.0f + Phantom.this.random.nextFloat() * 9.0f;
            this.clockwise = Phantom.this.random.nextBoolean() ? 1.0f : -1.0f;
            this.selectNext();
        }

        @Override
        public void tick() {
            if (Phantom.this.random.nextInt(this.adjustedTickDelay(350)) == 0) {
                this.height = -4.0f + Phantom.this.random.nextFloat() * 9.0f;
            }
            if (Phantom.this.random.nextInt(this.adjustedTickDelay(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (Phantom.this.random.nextInt(this.adjustedTickDelay(450)) == 0) {
                this.angle = Phantom.this.random.nextFloat() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (Phantom.this.moveTargetPoint.y < Phantom.this.getY() && !Phantom.this.level().isEmptyBlock(Phantom.this.blockPosition().below(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (Phantom.this.moveTargetPoint.y > Phantom.this.getY() && !Phantom.this.level().isEmptyBlock(Phantom.this.blockPosition().above(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.ZERO.equals(Phantom.this.anchorPoint)) {
                Phantom.this.anchorPoint = Phantom.this.blockPosition();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            Phantom.this.moveTargetPoint = Vec3.atLowerCornerOf(Phantom.this.anchorPoint).add(this.distance * Mth.cos(this.angle), -4.0f + this.height, this.distance * Mth.sin(this.angle));
        }
    }

    private class PhantomAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);
        private int nextScanTick = PhantomAttackPlayerTargetGoal.reducedTickDelay(20);

        PhantomAttackPlayerTargetGoal() {
        }

        @Override
        public boolean canUse() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = PhantomAttackPlayerTargetGoal.reducedTickDelay(60);
            List<Player> list = Phantom.this.level().getNearbyPlayers(this.attackTargeting, Phantom.this, Phantom.this.getBoundingBox().inflate(16.0, 64.0, 16.0));
            if (Phantom.this.level().purpurConfig.phantomIgnorePlayersWithTorch) {
                list.removeIf(human -> TORCH.test(human.getItemInHand(InteractionHand.MAIN_HAND)) || TORCH.test(human.getItemInHand(InteractionHand.OFF_HAND)));
            }
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(e -> e.getY()).reversed());
                for (Player entityhuman : list) {
                    if (!Phantom.this.canAttack(entityhuman, TargetingConditions.DEFAULT)) continue;
                    if (!Phantom.this.level().paperConfig().entities.behavior.phantomsOnlyAttackInsomniacs || EntitySelector.IS_INSOMNIAC.test(entityhuman)) {
                        Phantom.this.setTarget(entityhuman, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            LivingEntity entityliving = Phantom.this.getTarget();
            return entityliving != null ? Phantom.this.canAttack(entityliving, TargetingConditions.DEFAULT) : false;
        }
    }

    private abstract class PhantomMoveTargetGoal
    extends Goal {
        public PhantomMoveTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return Phantom.this.moveTargetPoint.distanceToSqr(Phantom.this.getX(), Phantom.this.getY(), Phantom.this.getZ()) < 4.0;
        }
    }
}

