/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;

public class StartAdmiringItemIfSeen {
    public static BehaviorControl<LivingEntity> create(int duration) {
        return BehaviorBuilder.create(context -> context.group(context.present(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM), context.absent(MemoryModuleType.ADMIRING_ITEM), context.absent(MemoryModuleType.ADMIRING_DISABLED), context.absent(MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM)).apply((Applicative)context, (nearestVisibleWantedItem, admiringItem, admiringDisabled, disableWalkToAdmireItem) -> (world, entity, time) -> {
            ItemEntity itemEntity = (ItemEntity)context.get(nearestVisibleWantedItem);
            if (!PiglinAi.isLovedItem(itemEntity.getItem())) {
                return false;
            }
            admiringItem.setWithExpiry(true, duration);
            return true;
        }));
    }
}

