/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PlayerShieldDisableEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import net.kyori.adventure.util.TriState;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public abstract class Player
extends LivingEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final HumanoidArm DEFAULT_MAIN_HAND = HumanoidArm.RIGHT;
    public static final int DEFAULT_MODEL_CUSTOMIZATION = 0;
    public static final int MAX_HEALTH = 20;
    public static final int SLEEP_DURATION = 100;
    public static final int WAKE_UP_DURATION = 10;
    public static final int ENDER_SLOT_OFFSET = 200;
    public static final int HELD_ITEM_SLOT = 499;
    public static final int CRAFTING_SLOT_OFFSET = 500;
    public static final float DEFAULT_BLOCK_INTERACTION_RANGE = 4.5f;
    public static final float DEFAULT_ENTITY_INTERACTION_RANGE = 3.0f;
    public static final float CROUCH_BB_HEIGHT = 1.5f;
    public static final float SWIMMING_BB_WIDTH = 0.6f;
    public static final float SWIMMING_BB_HEIGHT = 0.6f;
    public static final float DEFAULT_EYE_HEIGHT = 1.62f;
    private static final int CURRENT_IMPULSE_CONTEXT_RESET_GRACE_TIME_TICKS = 40;
    public static final Vec3 DEFAULT_VEHICLE_ATTACHMENT = new Vec3(0.0, 0.6, 0.0);
    public static final EntityDimensions STANDING_DIMENSIONS = EntityDimensions.scalable(0.6f, 1.8f).withEyeHeight(1.62f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, DEFAULT_VEHICLE_ATTACHMENT));
    private static final Map<Pose, EntityDimensions> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_DIMENSIONS).put((Object)Pose.SLEEPING, (Object)LivingEntity.SLEEPING_DIMENSIONS).put((Object)Pose.FALL_FLYING, (Object)EntityDimensions.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)Pose.SWIMMING, (Object)EntityDimensions.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)Pose.SPIN_ATTACK, (Object)EntityDimensions.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)Pose.CROUCHING, (Object)EntityDimensions.scalable(0.6f, 1.5f).withEyeHeight(1.27f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, DEFAULT_VEHICLE_ATTACHMENT))).put((Object)Pose.DYING, (Object)EntityDimensions.fixed(0.2f, 0.2f).withEyeHeight(1.62f)).build();
    private static final EntityDataAccessor<Float> DATA_PLAYER_ABSORPTION_ID = SynchedEntityData.defineId(Player.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_SCORE_ID = SynchedEntityData.defineId(Player.class, EntityDataSerializers.INT);
    public static final EntityDataAccessor<Byte> DATA_PLAYER_MODE_CUSTOMISATION = SynchedEntityData.defineId(Player.class, EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Byte> DATA_PLAYER_MAIN_HAND = SynchedEntityData.defineId(Player.class, EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<CompoundTag> DATA_SHOULDER_LEFT = SynchedEntityData.defineId(Player.class, EntityDataSerializers.COMPOUND_TAG);
    protected static final EntityDataAccessor<CompoundTag> DATA_SHOULDER_RIGHT = SynchedEntityData.defineId(Player.class, EntityDataSerializers.COMPOUND_TAG);
    private long timeEntitySatOnShoulder;
    final Inventory inventory = new Inventory(this);
    protected PlayerEnderChestContainer enderChestInventory = new PlayerEnderChestContainer(this);
    public final InventoryMenu inventoryMenu;
    public AbstractContainerMenu containerMenu;
    protected FoodData foodData = new FoodData(this);
    protected int jumpTriggerTime;
    public float oBob;
    public float bob;
    public int takeXpDelay;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    public int sleepCounter;
    protected boolean wasUnderwater;
    private final Abilities abilities = new Abilities();
    public int experienceLevel;
    public int totalExperience;
    public float experienceProgress;
    public int enchantmentSeed;
    protected final float defaultFlySpeed = 0.02f;
    private int lastLevelUpTime;
    public GameProfile gameProfile;
    private boolean reducedDebugInfo;
    private net.minecraft.world.item.ItemStack lastItemInMainHand;
    private final ItemCooldowns cooldowns;
    private Optional<GlobalPos> lastDeathLocation;
    @Nullable
    public FishingHook fishing;
    public float hurtDir;
    @Nullable
    public Vec3 currentImpulseImpactPos;
    @Nullable
    public Entity currentExplosionCause;
    private boolean ignoreFallDamageFromCurrentImpulse;
    private int currentImpulseContextResetGraceTime;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public int sixRowEnderchestSlotCount = -1;
    public int burpDelay = 0;
    public boolean canPortalInstant = false;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    public void setAfk(boolean afk) {
    }

    public boolean isAfk() {
        return false;
    }

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public abstract void resetLastActionTime();

    @Override
    public boolean processClick(InteractionHand hand) {
        Entity vehicle = this.getRootVehicle();
        if (vehicle != null && vehicle.getRider() == this) {
            return vehicle.onClick(hand);
        }
        return false;
    }

    public Player(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super((EntityType<? extends LivingEntity>)EntityType.PLAYER, world);
        this.lastItemInMainHand = net.minecraft.world.item.ItemStack.EMPTY;
        this.cooldowns = this.createItemCooldowns();
        this.lastDeathLocation = Optional.empty();
        this.setUUID(gameProfile.getId());
        this.gameProfile = gameProfile;
        this.inventoryMenu = new InventoryMenu(this.inventory, !world.isClientSide, this);
        this.containerMenu = this.inventoryMenu;
        this.moveTo((double)pos.getX() + 0.5, pos.getY() + 1, (double)pos.getZ() + 0.5, yaw, 0.0f);
        this.rotOffs = 180.0f;
    }

    public boolean blockActionRestricted(Level world, BlockPos pos, GameType gameMode) {
        if (!gameMode.isBlockPlacingRestricted()) {
            return false;
        }
        if (gameMode == GameType.SPECTATOR) {
            return true;
        }
        if (this.mayBuild()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.getMainHandItem();
        return itemstack.isEmpty() || !itemstack.canBreakBlockInAdventureMode(new BlockInWorld(world, pos, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.1f).add(Attributes.ATTACK_SPEED).add(Attributes.LUCK).add(Attributes.BLOCK_INTERACTION_RANGE, 4.5).add(Attributes.ENTITY_INTERACTION_RANGE, 3.0).add(Attributes.BLOCK_BREAK_SPEED).add(Attributes.SUBMERGED_MINING_SPEED).add(Attributes.SNEAKING_SPEED).add(Attributes.MINING_EFFICIENCY).add(Attributes.SWEEPING_DAMAGE_RATIO);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(0.0f));
        builder.define(DATA_SCORE_ID, 0);
        builder.define(DATA_PLAYER_MODE_CUSTOMISATION, (byte)0);
        builder.define(DATA_PLAYER_MAIN_HAND, (byte)DEFAULT_MAIN_HAND.getId());
        builder.define(DATA_SHOULDER_LEFT, new CompoundTag());
        builder.define(DATA_SHOULDER_RIGHT, new CompoundTag());
    }

    @Override
    public void tick() {
        if (this.burpDelay > 0 && --this.burpDelay == 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 1.0f, this.level().random.nextFloat() * 0.1f + 0.9f);
        }
        this.noPhysics = this.isSpectator();
        if (this.isSpectator()) {
            this.setOnGround(false);
        }
        if (this.takeXpDelay > 0) {
            --this.takeXpDelay;
        }
        if (this.isSleeping()) {
            ++this.sleepCounter;
            if (this.sleepCounter == 100 && !new PlayerDeepSleepEvent((org.bukkit.entity.Player)this.getBukkitEntity()).callEvent()) {
                this.sleepCounter = Integer.MIN_VALUE;
            }
            if (this.sleepCounter > 100) {
                this.sleepCounter = 100;
            }
            if (!this.level().isClientSide && this.level().isDay()) {
                this.stopSleepInBed(false, true);
            }
        } else if (this.sleepCounter > 0) {
            ++this.sleepCounter;
            if (this.sleepCounter >= 110) {
                this.sleepCounter = 0;
            }
        }
        this.updateIsUnderwater();
        super.tick();
        if (!this.level().isClientSide && this.containerMenu != null && !this.containerMenu.stillValid(this)) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.containerMenu = this.inventoryMenu;
        }
        this.moveCloak();
        if (!this.level().isClientSide) {
            this.foodData.tick(this);
            this.awardStat(Stats.PLAY_TIME);
            this.awardStat(Stats.TOTAL_WORLD_TIME);
            if (this.isAlive()) {
                this.awardStat(Stats.TIME_SINCE_DEATH);
            }
            if (this.isDiscrete()) {
                this.awardStat(Stats.CROUCH_TIME);
            }
            if (!this.isSleeping()) {
                this.awardStat(Stats.TIME_SINCE_REST);
            }
        }
        int i = 29999999;
        double d0 = Mth.clamp(this.getX(), -2.9999999E7, 2.9999999E7);
        double d1 = Mth.clamp(this.getZ(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.getX() || d1 != this.getZ()) {
            this.setPos(d0, this.getY(), d1);
        }
        ++this.attackStrengthTicker;
        net.minecraft.world.item.ItemStack itemstack = this.getMainHandItem();
        if (!net.minecraft.world.item.ItemStack.matches(this.lastItemInMainHand, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.isSameItem(this.lastItemInMainHand, itemstack)) {
                this.resetAttackStrengthTicker();
            }
            this.lastItemInMainHand = itemstack.copy();
        }
        this.turtleHelmetTick();
        this.cooldowns.tick();
        this.updatePlayerPose();
        if (this.currentImpulseContextResetGraceTime > 0) {
            --this.currentImpulseContextResetGraceTime;
        }
    }

    @Override
    protected float getMaxHeadRotationRelativeToBody() {
        return this.isBlocking() ? 15.0f : super.getMaxHeadRotationRelativeToBody();
    }

    public boolean isSecondaryUseActive() {
        return this.isShiftKeyDown();
    }

    protected boolean wantsToStopRiding() {
        return this.isShiftKeyDown();
    }

    protected boolean isStayingOnGroundSurface() {
        return this.isShiftKeyDown();
    }

    protected boolean updateIsUnderwater() {
        this.wasUnderwater = this.isEyeInFluid(FluidTags.WATER);
        return this.wasUnderwater;
    }

    private void turtleHelmetTick() {
        net.minecraft.world.item.ItemStack itemstack = this.getItemBySlot(EquipmentSlot.HEAD);
        if (itemstack.is(Items.TURTLE_HELMET) && !this.isEyeInFluid(FluidTags.WATER)) {
            this.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
        }
        if (this.level().purpurConfig.playerNetheriteFireResistanceDuration > 0 && this.level().getGameTime() % 20L == 0L && itemstack.is(Items.NETHERITE_HELMET) && this.getItemBySlot(EquipmentSlot.CHEST).is(Items.NETHERITE_CHESTPLATE) && this.getItemBySlot(EquipmentSlot.LEGS).is(Items.NETHERITE_LEGGINGS) && this.getItemBySlot(EquipmentSlot.FEET).is(Items.NETHERITE_BOOTS)) {
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, this.level().purpurConfig.playerNetheriteFireResistanceDuration, this.level().purpurConfig.playerNetheriteFireResistanceAmplifier, this.level().purpurConfig.playerNetheriteFireResistanceAmbient, this.level().purpurConfig.playerNetheriteFireResistanceShowParticles, this.level().purpurConfig.playerNetheriteFireResistanceShowIcon), EntityPotionEffectEvent.Cause.NETHERITE_ARMOR);
        }
    }

    protected ItemCooldowns createItemCooldowns() {
        return new ItemCooldowns();
    }

    private void moveCloak() {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double d0 = this.getX() - this.xCloak;
        double d1 = this.getY() - this.yCloak;
        double d2 = this.getZ() - this.zCloak;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (d2 > 10.0) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if (d1 > 10.0) {
            this.yCloakO = this.yCloak = this.getY();
        }
        if (d0 < -10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (d2 < -10.0) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if (d1 < -10.0) {
            this.yCloakO = this.yCloak = this.getY();
        }
        this.xCloak += d0 * 0.25;
        this.zCloak += d2 * 0.25;
        this.yCloak += d1 * 0.25;
    }

    protected void updatePlayerPose() {
        if (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.SWIMMING)) {
            Pose entitypose = this.isFallFlying() ? Pose.FALL_FLYING : (this.isSleeping() ? Pose.SLEEPING : (this.isSwimming() ? Pose.SWIMMING : (this.isAutoSpinAttack() ? Pose.SPIN_ATTACK : (this.isShiftKeyDown() && !this.abilities.flying ? Pose.CROUCHING : Pose.STANDING))));
            Pose entitypose1 = !(this.isSpectator() || this.isPassenger() || this.canPlayerFitWithinBlocksAndEntitiesWhen(entitypose)) ? (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING) : entitypose;
            this.setPose(entitypose1);
        }
    }

    protected boolean canPlayerFitWithinBlocksAndEntitiesWhen(Pose pose) {
        return this.level().noCollision(this, this.getDimensions(pose).makeBoundingBox(this.position()).deflate(1.0E-7));
    }

    @Override
    protected SoundEvent getSwimSound() {
        return SoundEvents.PLAYER_SWIM;
    }

    @Override
    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.PLAYER_SPLASH;
    }

    @Override
    protected SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.PLAYER_SPLASH_HIGH_SPEED;
    }

    @Override
    public int getDimensionChangingDelay() {
        return 10;
    }

    @Override
    public void playSound(SoundEvent sound, float volume, float pitch) {
        this.level().playSound(this, this.getX(), this.getY(), this.getZ(), sound, this.getSoundSource(), volume, pitch);
    }

    public void playNotifySound(SoundEvent sound, SoundSource category, float volume, float pitch) {
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.PLAYERS;
    }

    @Override
    public int getFireImmuneTicks() {
        return 20;
    }

    @Override
    public void handleEntityEvent(byte status) {
        if (status == 9) {
            this.completeUsingItem();
        } else if (status == 23) {
            this.reducedDebugInfo = false;
        } else if (status == 22) {
            this.reducedDebugInfo = true;
        } else {
            super.handleEntityEvent(status);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.closeContainer();
        this.containerMenu = this.inventoryMenu;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.containerMenu = this.inventoryMenu;
    }

    public void closeContainer() {
        this.containerMenu = this.inventoryMenu;
    }

    protected void doCloseContainer() {
    }

    @Override
    public void rideTick() {
        if (!this.level().isClientSide && this.wantsToStopRiding() && this.isPassenger()) {
            this.stopRiding();
            if (!this.isPassenger()) {
                this.setShiftKeyDown(false);
                return;
            }
        }
        super.rideTick();
        this.oBob = this.bob;
        this.bob = 0.0f;
    }

    @Override
    protected void serverAiStep() {
        super.serverAiStep();
        this.updateSwingTime();
        this.yHeadRot = this.getYRot();
    }

    @Override
    public void aiStep() {
        if (this.jumpTriggerTime > 0) {
            --this.jumpTriggerTime;
        }
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) {
            if (this.getHealth() < this.getMaxHealth() && this.tickCount % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.foodData.getSaturationLevel() < 20.0f && this.tickCount % 20 == 0) {
                this.foodData.setSaturation(this.foodData.getSaturationLevel() + 1.0f);
            }
            if (this.foodData.needsFood() && this.tickCount % 10 == 0) {
                this.foodData.setFoodLevel(this.foodData.getFoodLevel() + 1);
            }
        }
        this.inventory.tick();
        this.oBob = this.bob;
        super.aiStep();
        this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
        float f = this.onGround() && !this.isDeadOrDying() && !this.isSwimming() ? Math.min(0.1f, (float)this.getDeltaMovement().horizontalDistance()) : 0.0f;
        this.bob += (f - this.bob) * 0.4f;
        if (this.getHealth() > 0.0f && !this.isSpectator()) {
            AABB axisalignedbb = this.isPassenger() && !this.getVehicle().isRemoved() ? this.getBoundingBox().minmax(this.getVehicle().getBoundingBox()).inflate(1.0, 0.0, 1.0) : this.getBoundingBox().inflate(1.0, 0.5, 1.0);
            List<Entity> list = this.level().getEntities(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.getType() == EntityType.EXPERIENCE_ORB && entity.level().purpurConfig.playerExpPickupDelay >= 0) {
                    list1.add(entity);
                    continue;
                }
                if (entity.isRemoved()) continue;
                this.touch(entity);
            }
            if (!list1.isEmpty()) {
                this.touch((Entity)Util.getRandom(list1, this.random));
            }
        }
        this.playShoulderEntityAmbientSound(this.getShoulderEntityLeft());
        this.playShoulderEntityAmbientSound(this.getShoulderEntityRight());
        if ((!this.level().isClientSide && (this.fallDistance > 0.5f || this.isInWater()) || this.abilities.flying || this.isSleeping() || this.isInPowderSnow) && !this.level().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.removeEntitiesOnShoulder();
        }
    }

    private void playShoulderEntityAmbientSound(@Nullable CompoundTag entityNbt) {
        if (!(entityNbt == null || entityNbt.contains("Silent") && entityNbt.getBoolean("Silent") || this.level().random.nextInt(200) != 0)) {
            String s = entityNbt.getString("id");
            EntityType.byString(s).filter(entitytypes -> entitytypes == EntityType.PARROT).ifPresent(entitytypes -> {
                if (!Parrot.imitateNearbyMobs(this.level(), this)) {
                    this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), Parrot.getAmbient(this.level(), this.level().random), this.getSoundSource(), 1.0f, Parrot.getPitch(this.level().random));
                }
            });
        }
    }

    private void touch(Entity entity) {
        entity.playerTouch(this);
    }

    public int getScore() {
        return this.entityData.get(DATA_SCORE_ID);
    }

    public void setScore(int score) {
        this.entityData.set(DATA_SCORE_ID, score);
    }

    public void increaseScore(int score) {
        int j = this.getScore();
        this.entityData.set(DATA_SCORE_ID, j + score);
    }

    public void startAutoSpinAttack(int riptideTicks, float riptideAttackDamage, net.minecraft.world.item.ItemStack stack) {
        this.autoSpinAttackTicks = riptideTicks;
        this.autoSpinAttackDmg = riptideAttackDamage;
        this.autoSpinAttackItemStack = stack;
        if (!this.level().isClientSide) {
            this.removeEntitiesOnShoulder();
            this.setLivingEntityFlag(4, true);
        }
    }

    @Override
    @Nonnull
    public net.minecraft.world.item.ItemStack getWeaponItem() {
        return this.isAutoSpinAttack() && this.autoSpinAttackItemStack != null ? this.autoSpinAttackItemStack : super.getWeaponItem();
    }

    @Override
    public void die(DamageSource damageSource) {
        Level world;
        super.die(damageSource);
        this.reapplyPosition();
        if (!this.isSpectator() && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.dropAllDeathLoot(worldserver, damageSource);
        }
        if (damageSource != null) {
            this.setDeltaMovement(-Mth.cos((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -Mth.sin((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.setDeltaMovement(0.0, 0.1, 0.0);
        }
        this.awardStat(Stats.DEATHS);
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_DEATH));
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        this.clearFire();
        this.setSharedFlagOnFire(false);
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
    }

    @Override
    protected void dropEquipment() {
        super.dropEquipment();
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            this.destroyVanishingCursedItems();
            this.inventory.dropAll();
        }
    }

    protected void destroyVanishingCursedItems() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            net.minecraft.world.item.ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || !EnchantmentHelper.has(itemstack, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.inventory.removeItemNoUpdate(i);
        }
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return source.type().effects().sound();
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.PLAYER_DEATH;
    }

    @Nullable
    public ItemEntity drop(net.minecraft.world.item.ItemStack stack, boolean retainOwnership) {
        return this.drop(stack, false, retainOwnership);
    }

    @Nullable
    public ItemEntity drop(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        return this.drop(stack, throwRandomly, retainOwnership, true);
    }

    @Nullable
    public ItemEntity drop(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        MapItemSavedData worldmap;
        if (itemstack.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide) {
            this.swing(InteractionHand.MAIN_HAND);
        }
        double d0 = this.getEyeY() - (double)0.3f;
        net.minecraft.world.item.ItemStack tmp = itemstack.copy();
        itemstack.setCount(0);
        itemstack = tmp;
        ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), d0, this.getZ(), itemstack);
        entityitem.setPickUpDelay(40);
        if (flag1) {
            entityitem.setThrower(this);
        }
        if (flag) {
            float f = this.random.nextFloat() * 0.5f;
            float f1 = this.random.nextFloat() * ((float)Math.PI * 2);
            entityitem.setDeltaMovement(-Mth.sin(f1) * f, 0.2f, Mth.cos(f1) * f);
        } else {
            float f = 0.3f;
            float f1 = Mth.sin(this.getXRot() * ((float)Math.PI / 180));
            float f2 = Mth.cos(this.getXRot() * ((float)Math.PI / 180));
            float f3 = Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            float f4 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            float f5 = this.random.nextFloat() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.random.nextFloat();
            entityitem.setDeltaMovement((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        if (!callEvent) {
            return entityitem;
        }
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)this.getBukkitEntity();
        Item drop = (Item)entityitem.getBukkitEntity();
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (flag1 && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(new ItemStack[]{drop.getItemStack()});
            }
            return null;
        }
        if (itemstack.getItem() == Items.FILLED_MAP && (worldmap = MapItem.getSavedData(itemstack, this.level())) != null) {
            worldmap.tickCarriedBy(this, itemstack);
        }
        return entityitem;
    }

    public float getDestroySpeed(BlockState block) {
        float f = this.inventory.getDestroySpeed(block);
        if (f > 1.0f) {
            f += (float)this.getAttributeValue(Attributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed(this)) {
            f *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification(this) + 1) * 0.2f;
        }
        if (this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            f *= (switch (this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        f *= (float)this.getAttributeValue(Attributes.BLOCK_BREAK_SPEED);
        if (this.isEyeInFluid(FluidTags.WATER)) {
            f *= (float)this.getAttribute(Attributes.SUBMERGED_MINING_SPEED).getValue();
        }
        if (!this.onGround()) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean hasCorrectToolForDrops(BlockState state) {
        return !state.requiresCorrectToolForDrops() || this.inventory.getSelected().isCorrectToolForDrops(state);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setUUID(this.gameProfile.getId());
        ListTag nbttaglist = nbt.getList("Inventory", 10);
        this.inventory.load(nbttaglist);
        this.inventory.selected = nbt.getInt("SelectedItemSlot");
        this.sleepCounter = nbt.getShort("SleepTimer");
        this.experienceProgress = nbt.getFloat("XpP");
        this.experienceLevel = nbt.getInt("XpLevel");
        this.totalExperience = nbt.getInt("XpTotal");
        this.enchantmentSeed = nbt.getInt("XpSeed");
        if (this.enchantmentSeed == 0) {
            this.enchantmentSeed = this.random.nextInt();
        }
        this.setScore(nbt.getInt("Score"));
        this.foodData.readAdditionalSaveData(nbt);
        this.abilities.loadSaveData(nbt);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.abilities.getWalkingSpeed());
        if (nbt.contains("EnderItems", 9)) {
            this.enderChestInventory.fromTag(nbt.getList("EnderItems", 10), this.registryAccess());
        }
        if (nbt.contains("ShoulderEntityLeft", 10)) {
            this.setShoulderEntityLeft(nbt.getCompound("ShoulderEntityLeft"));
        }
        if (nbt.contains("ShoulderEntityRight", 10)) {
            this.setShoulderEntityRight(nbt.getCompound("ShoulderEntityRight"));
        }
        if (nbt.contains("LastDeathLocation", 10)) {
            DataResult dataresult = GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("LastDeathLocation"));
            Logger logger = LOGGER;
            Objects.requireNonNull(logger);
            this.setLastDeathLocation(dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)));
        }
        if (nbt.contains("current_explosion_impact_pos", 9)) {
            DataResult dataresult1 = Vec3.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("current_explosion_impact_pos"));
            Logger logger1 = LOGGER;
            Objects.requireNonNull(logger1);
            dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).ifPresent(vec3d -> {
                this.currentImpulseImpactPos = vec3d;
            });
        }
        this.ignoreFallDamageFromCurrentImpulse = nbt.getBoolean("ignore_fall_damage_from_current_explosion");
        this.currentImpulseContextResetGraceTime = nbt.getInt("current_impulse_context_reset_grace_time");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        NbtUtils.addCurrentDataVersion(nbt);
        nbt.put("Inventory", this.inventory.save(new ListTag()));
        nbt.putInt("SelectedItemSlot", this.inventory.selected);
        nbt.putShort("SleepTimer", (short)this.sleepCounter);
        nbt.putFloat("XpP", this.experienceProgress);
        nbt.putInt("XpLevel", this.experienceLevel);
        nbt.putInt("XpTotal", this.totalExperience);
        nbt.putInt("XpSeed", this.enchantmentSeed);
        nbt.putInt("Score", this.getScore());
        this.foodData.addAdditionalSaveData(nbt);
        this.abilities.addSaveData(nbt);
        nbt.put("EnderItems", this.enderChestInventory.createTag(this.registryAccess()));
        if (!this.getShoulderEntityLeft().isEmpty()) {
            nbt.put("ShoulderEntityLeft", this.getShoulderEntityLeft());
        }
        if (!this.getShoulderEntityRight().isEmpty()) {
            nbt.put("ShoulderEntityRight", this.getShoulderEntityRight());
        }
        this.getLastDeathLocation().flatMap(globalpos -> {
            DataResult dataresult = GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, globalpos);
            Logger logger = LOGGER;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).ifPresent(nbtbase -> nbt.put("LastDeathLocation", (Tag)nbtbase));
        if (this.currentImpulseImpactPos != null) {
            nbt.put("current_explosion_impact_pos", (Tag)Vec3.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.currentImpulseImpactPos).getOrThrow());
        }
        nbt.putBoolean("ignore_fall_damage_from_current_explosion", this.ignoreFallDamageFromCurrentImpulse);
        nbt.putInt("current_impulse_context_reset_grace_time", this.currentImpulseContextResetGraceTime);
    }

    @Override
    public boolean isInvulnerableTo(DamageSource damageSource) {
        return super.isInvulnerableTo(damageSource) ? true : (damageSource.is(DamageTypeTags.IS_DROWNING) ? !this.level().getGameRules().getBoolean(GameRules.RULE_DROWNING_DAMAGE) : (damageSource.is(DamageTypeTags.IS_FALL) ? !this.level().getGameRules().getBoolean(GameRules.RULE_FALL_DAMAGE) : (damageSource.is(DamageTypeTags.IS_FIRE) ? !this.level().getGameRules().getBoolean(GameRules.RULE_FIRE_DAMAGE) : (damageSource.is(DamageTypeTags.IS_FREEZING) ? !this.level().getGameRules().getBoolean(GameRules.RULE_FREEZE_DAMAGE) : false))));
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        boolean damaged;
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (this.abilities.invulnerable && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        this.noActionTime = 0;
        if (this.isDeadOrDying()) {
            return false;
        }
        if (!this.level().isClientSide) {
            // empty if block
        }
        if (source.scalesWithDifficulty()) {
            if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
                return false;
            }
            if (this.level().getDifficulty() == Difficulty.EASY) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (this.level().getDifficulty() == Difficulty.HARD) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.hurt(source, amount)) {
            this.removeEntitiesOnShoulder();
        }
        return damaged;
    }

    @Override
    protected void blockUsingShield(LivingEntity attacker) {
        super.blockUsingShield(attacker);
        if (attacker.canDisableShield()) {
            this.disableShield(attacker);
        }
    }

    @Override
    public boolean canBeSeenAsEnemy() {
        return !this.getAbilities().invulnerable && super.canBeSeenAsEnemy();
    }

    public boolean canHarmPlayer(Player player) {
        Team team;
        if (player instanceof ServerPlayer) {
            ServerPlayer thatPlayer = (ServerPlayer)player;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = player.level().getCraftServer().getOfflinePlayer(player.getScoreboardName());
            team = player.level().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof ServerPlayer) {
            return !team.hasPlayer((OfflinePlayer)((ServerPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.level().getCraftServer().getOfflinePlayer(this.getScoreboardName()));
    }

    @Override
    protected void hurtArmor(DamageSource source, float amount) {
        this.doHurtEquipment(source, amount, EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD);
    }

    @Override
    protected void hurtHelmet(DamageSource source, float amount) {
        this.doHurtEquipment(source, amount, EquipmentSlot.HEAD);
    }

    @Override
    protected void hurtCurrentlyUsedShield(float amount) {
        if (this.useItem.is(Items.SHIELD)) {
            if (!this.level().isClientSide) {
                this.awardStat(Stats.ITEM_USED.get(this.useItem.getItem()));
            }
            if (amount >= 3.0f) {
                int i = 1 + Mth.floor(amount);
                InteractionHand enumhand = this.getUsedItemHand();
                this.useItem.hurtAndBreak(i, this, Player.getSlotForHand(enumhand));
                if (this.useItem.isEmpty()) {
                    if (enumhand == InteractionHand.MAIN_HAND) {
                        this.setItemSlot(EquipmentSlot.MAINHAND, net.minecraft.world.item.ItemStack.EMPTY);
                    } else {
                        this.setItemSlot(EquipmentSlot.OFFHAND, net.minecraft.world.item.ItemStack.EMPTY);
                    }
                    this.useItem = net.minecraft.world.item.ItemStack.EMPTY;
                    this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean actuallyHurt(DamageSource damagesource, float f, EntityDamageEvent event) {
        return super.actuallyHurt(damagesource, f, event);
    }

    public boolean isTextFilteringEnabled() {
        return false;
    }

    public void openTextEdit(SignBlockEntity sign, boolean front) {
    }

    public void openMinecartCommandBlock(BaseCommandBlock commandBlockExecutor) {
    }

    public void openCommandBlock(CommandBlockEntity commandBlock) {
    }

    public void openStructureBlock(StructureBlockEntity structureBlock) {
    }

    public void openJigsawBlock(JigsawBlockEntity jigsaw) {
    }

    public void openHorseInventory(AbstractHorse horse, Container inventory) {
    }

    public OptionalInt openMenu(@Nullable MenuProvider factory) {
        return OptionalInt.empty();
    }

    public void sendMerchantOffers(int syncId, MerchantOffers offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
    }

    public void openItemGui(net.minecraft.world.item.ItemStack book, InteractionHand hand) {
    }

    public InteractionResult interactOn(Entity entity, InteractionHand hand) {
        if (this.isSpectator()) {
            if (entity instanceof MenuProvider) {
                this.openMenu((MenuProvider)((Object)entity));
            }
            return InteractionResult.PASS;
        }
        net.minecraft.world.item.ItemStack itemstack = this.getItemInHand(hand);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.copy();
        InteractionResult enuminteractionresult = entity.interact(this, hand);
        if (enuminteractionresult.consumesAction()) {
            if (this.abilities.instabuild && itemstack == this.getItemInHand(hand) && itemstack.getCount() < itemstack1.getCount()) {
                itemstack.setCount(itemstack1.getCount());
            }
            return enuminteractionresult;
        }
        if (!itemstack.isEmpty() && entity instanceof LivingEntity) {
            InteractionResult enuminteractionresult1;
            if (this.abilities.instabuild) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.interactLivingEntity(this, (LivingEntity)entity, hand)).consumesAction()) {
                this.level().gameEvent(GameEvent.ENTITY_INTERACT, entity.position(), GameEvent.Context.of(this));
                if (itemstack.isEmpty() && !this.abilities.instabuild) {
                    this.setItemInHand(hand, net.minecraft.world.item.ItemStack.EMPTY);
                }
                return enuminteractionresult1;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void removeVehicle() {
        this.removeVehicle(false);
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        super.removeVehicle(suppressCancellation);
        this.boardingCooldown = 0;
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.isSleeping() || this.isRemoved() || !this.valid;
    }

    @Override
    public boolean isAffectedByFluids() {
        return !this.abilities.flying;
    }

    @Override
    protected Vec3 maybeBackOffFromEdge(Vec3 movement, MoverType type) {
        float f = this.maxUpStep();
        if (!this.abilities.flying && movement.y <= 0.0 && (type == MoverType.SELF || type == MoverType.PLAYER) && this.isStayingOnGroundSurface() && this.isAboveGround(f)) {
            double d0;
            double d1 = movement.z;
            double d2 = 0.05;
            double d3 = Math.signum(d0) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d0 = movement.x; d0 != 0.0 && this.canFallAtLeast(d0, 0.0, f); d0 -= d3) {
                if (!(Math.abs(d0) <= 0.05)) continue;
                d0 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.canFallAtLeast(0.0, d1, f)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.canFallAtLeast(d0, d1, f)) {
                d0 = Math.abs(d0) <= 0.05 ? 0.0 : (d0 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3(d0, movement.y, d1);
        }
        return movement;
    }

    private boolean isAboveGround(float f) {
        return this.onGround() || this.fallDistance < f && !this.canFallAtLeast(0.0, 0.0, f - this.fallDistance);
    }

    private boolean canFallAtLeast(double offsetX, double offsetZ, float f) {
        AABB axisalignedbb = this.getBoundingBox();
        return this.level().noCollision(this, new AABB(axisalignedbb.minX + offsetX, axisalignedbb.minY - (double)f - (double)1.0E-5f, axisalignedbb.minZ + offsetZ, axisalignedbb.maxX + offsetX, axisalignedbb.minY, axisalignedbb.maxZ + offsetZ));
    }

    public void attack(Entity target) {
        boolean willAttack = target.isAttackable() && !target.skipAttackInteraction(this);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            float f = this.isAutoSpinAttack() ? this.autoSpinAttackDmg : (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
            net.minecraft.world.item.ItemStack itemstack = this.getWeaponItem();
            DamageSource damagesource = this.damageSources().playerAttack(this);
            float f1 = this.getEnchantedDamage(target, f, damagesource) - f;
            float f2 = this.getAttackStrengthScale(0.5f);
            f *= 0.2f + f2 * f2 * 0.8f;
            f1 *= f2;
            if (target.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && target instanceof Projectile) {
                Projectile iprojectile = (Projectile)target;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(target, damagesource, f1, false)) {
                    return;
                }
                if (iprojectile.deflect(ProjectileDeflection.AIM_DEFLECT, this, this, true)) {
                    this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, this.getSoundSource());
                    return;
                }
            }
            if (f > 0.0f || f1 > 0.0f) {
                net.minecraft.world.item.ItemStack itemstack1;
                boolean flag1;
                boolean flag;
                boolean bl = flag = f2 > 0.9f;
                if (this.isSprinting() && flag) {
                    Player.sendSoundEffect(this, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_KNOCKBACK, this.getSoundSource(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f += itemstack.getItem().getAttackDamageBonus(target, f, damagesource);
                boolean flag2 = flag && this.fallDistance > 0.0f && !this.onGround() && !this.onClimbable() && !this.isInWater() && !this.hasEffect(MobEffects.BLINDNESS) && !this.isPassenger() && target instanceof LivingEntity && !this.isSprinting();
                boolean bl2 = flag2 = flag2 && !this.level().paperConfig().entities.behavior.disablePlayerCrits;
                if (flag2) {
                    damagesource = damagesource.critical(true);
                    f = (float)((double)f * this.level().purpurConfig.playerCriticalDamageMultiplier);
                }
                float f3 = f + f1;
                boolean flag3 = false;
                double d0 = this.walkDist - this.walkDistO;
                if (flag && !flag2 && !flag1 && this.onGround() && d0 < (double)this.getSpeed() && (itemstack1 = this.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof SwordItem) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                if (target instanceof LivingEntity) {
                    LivingEntity entityliving = (LivingEntity)target;
                    f4 = entityliving.getHealth();
                }
                Vec3 vec3d = target.getDeltaMovement();
                boolean flag4 = target.hurt(damagesource, f3);
                if (flag4) {
                    float f5 = this.getKnockback(target, damagesource) + (flag1 ? 1.0f : 0.0f);
                    if (f5 > 0.0f) {
                        if (target instanceof LivingEntity) {
                            LivingEntity entityliving1 = (LivingEntity)target;
                            entityliving1.knockback(f5 * 0.5f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                        } else {
                            target.push(-Mth.sin(this.getYRot() * ((float)Math.PI / 180)) * f5 * 0.5f, 0.1, Mth.cos(this.getYRot() * ((float)Math.PI / 180)) * f5 * 0.5f, this);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                        if (!this.level().paperConfig().misc.disableSprintInterruptionOnAttack) {
                            this.setSprinting(false);
                        }
                    }
                    if (flag3) {
                        float f6 = 1.0f + (float)this.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * f;
                        List<LivingEntity> list = this.level().getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(1.0, 0.25, 1.0));
                        for (LivingEntity entityliving2 : list) {
                            if (entityliving2 == this || entityliving2 == target || this.isAlliedTo(entityliving2) || entityliving2 instanceof ArmorStand && ((ArmorStand)entityliving2).isMarker() || !(this.distanceToSqr(entityliving2) < 9.0)) continue;
                            float f7 = this.getEnchantedDamage(entityliving2, f6, damagesource) * f2;
                            if (!entityliving2.hurt(this.damageSources().playerAttack(this).sweep().critical(flag2), f7)) continue;
                            entityliving2.knockback(0.4f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.SWEEP_ATTACK);
                            Level world = this.level();
                            if (!(world instanceof ServerLevel)) continue;
                            ServerLevel worldserver = (ServerLevel)world;
                            EnchantmentHelper.doPostAttackEffects(worldserver, entityliving2, damagesource);
                        }
                        Player.sendSoundEffect(this, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, this.getSoundSource(), 1.0f, 1.0f);
                        this.sweepAttack();
                    }
                    if (target instanceof ServerPlayer && target.hurtMarked) {
                        boolean cancelled = false;
                        org.bukkit.entity.Player player = (org.bukkit.entity.Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((ServerPlayer)target).connection.send(new ClientboundSetEntityMotionPacket(target));
                            target.hurtMarked = false;
                            target.setDeltaMovement(vec3d);
                        }
                    }
                    if (flag2) {
                        Player.sendSoundEffect(this, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, this.getSoundSource(), 1.0f, 1.0f);
                        this.crit(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            Player.sendSoundEffect(this, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, this.getSoundSource(), 1.0f, 1.0f);
                        } else {
                            Player.sendSoundEffect(this, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_WEAK, this.getSoundSource(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.magicCrit(target);
                    }
                    this.setLastHurtMob(target);
                    Entity object = target;
                    if (target instanceof EnderDragonPart) {
                        object = ((EnderDragonPart)target).parentMob;
                    }
                    boolean flag5 = false;
                    Level world1 = this.level();
                    if (world1 instanceof ServerLevel) {
                        ServerLevel worldserver1 = (ServerLevel)world1;
                        if (object instanceof LivingEntity) {
                            LivingEntity entityliving2;
                            entityliving2 = (LivingEntity)object;
                            flag5 = itemstack.hurtEnemy(entityliving2, this);
                        }
                        EnchantmentHelper.doPostAttackEffects(worldserver1, target, damagesource);
                    }
                    if (!this.level().isClientSide && !itemstack.isEmpty() && object instanceof LivingEntity) {
                        if (flag5) {
                            itemstack.postHurtEnemy((LivingEntity)object, this);
                        }
                        if (itemstack.isEmpty()) {
                            if (itemstack == this.getMainHandItem()) {
                                this.setItemInHand(InteractionHand.MAIN_HAND, net.minecraft.world.item.ItemStack.EMPTY);
                            } else {
                                this.setItemInHand(InteractionHand.OFF_HAND, net.minecraft.world.item.ItemStack.EMPTY);
                            }
                        }
                    }
                    if (target instanceof LivingEntity) {
                        float f8 = f4 - ((LivingEntity)target).getHealth();
                        this.awardStat(Stats.DAMAGE_DEALT, Math.round(f8 * 10.0f));
                        if (this.level() instanceof ServerLevel && f8 > 2.0f) {
                            int i = (int)((double)f8 * 0.5);
                            ((ServerLevel)this.level()).sendParticles(ParticleTypes.DAMAGE_INDICATOR, target.getX(), target.getY(0.5), target.getZ(), i, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.level().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    Player.sendSoundEffect(this, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, this.getSoundSource(), 1.0f, 1.0f);
                    if (this instanceof ServerPlayer) {
                        ((ServerPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    protected float getEnchantedDamage(Entity target, float baseDamage, DamageSource damageSource) {
        return baseDamage;
    }

    @Override
    protected void doAutoAttackOnTouch(LivingEntity target) {
        this.attack(target);
    }

    @DoNotUse
    @Deprecated
    public void disableShield() {
        this.disableShield(null);
    }

    public void disableShield(@Nullable LivingEntity attacker) {
        CraftEntity finalAttacker;
        CraftEntity craftEntity = finalAttacker = attacker != null ? attacker.getBukkitEntity() : null;
        if (finalAttacker != null) {
            PlayerShieldDisableEvent shieldDisableEvent = new PlayerShieldDisableEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)finalAttacker, 100);
            if (!shieldDisableEvent.callEvent()) {
                return;
            }
            this.getCooldowns().addCooldown(Items.SHIELD, shieldDisableEvent.getCooldown());
        } else {
            this.getCooldowns().addCooldown(Items.SHIELD, 100);
        }
        this.stopUsingItem();
        this.level().broadcastEntityEvent(this, (byte)30);
    }

    public void crit(Entity target) {
    }

    public void magicCrit(Entity target) {
    }

    public void sweepAttack() {
        double d0 = -Mth.sin(this.getYRot() * ((float)Math.PI / 180));
        double d1 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles(ParticleTypes.SWEEP_ATTACK, this.getX() + d0, this.getY(0.5), this.getZ() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void respawn() {
    }

    @Override
    public void remove(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.inventoryMenu.removed(this);
        if (this.containerMenu != null && this.hasContainerOpen()) {
            this.doCloseContainer();
        }
    }

    public boolean isLocalPlayer() {
        return false;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public boolean hasInfiniteMaterials() {
        return this.abilities.instabuild;
    }

    public void updateTutorialInventoryAction(net.minecraft.world.item.ItemStack cursorStack, net.minecraft.world.item.ItemStack slotStack, ClickAction clickType) {
    }

    public boolean hasContainerOpen() {
        return this.containerMenu != this.inventoryMenu;
    }

    public Either<BedSleepingProblem, Unit> startSleepInBed(BlockPos pos) {
        return this.startSleepInBed(pos, false);
    }

    public Either<BedSleepingProblem, Unit> startSleepInBed(BlockPos blockposition, boolean force) {
        this.startSleeping(blockposition);
        this.sleepCounter = 0;
        return Either.right(Unit.INSTANCE);
    }

    public void stopSleepInBed(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        super.stopSleeping();
        if (this.level() instanceof ServerLevel && updateSleepingPlayers) {
            ((ServerLevel)this.level()).updateSleepingPlayerList();
        }
        this.sleepCounter = skipSleepTimer ? 0 : 100;
    }

    @Override
    public void stopSleeping() {
        this.stopSleepInBed(true, true);
    }

    public boolean isSleepingLongEnough() {
        return this.isSleeping() && this.sleepCounter >= 100;
    }

    public int getSleepTimer() {
        return this.sleepCounter;
    }

    public void displayClientMessage(Component message, boolean overlay) {
    }

    public void awardStat(ResourceLocation stat) {
        this.awardStat(Stats.CUSTOM.get(stat));
    }

    public void awardStat(ResourceLocation stat, int amount) {
        this.awardStat(Stats.CUSTOM.get(stat), amount);
    }

    public void awardStat(Stat<?> stat) {
        this.awardStat(stat, 1);
    }

    public void awardStat(Stat<?> stat, int amount) {
    }

    public void resetStat(Stat<?> stat) {
    }

    public int awardRecipes(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    public void triggerRecipeCrafted(RecipeHolder<?> recipe, List<net.minecraft.world.item.ItemStack> ingredients) {
    }

    public void awardRecipesByKey(List<ResourceLocation> recipes) {
    }

    public int resetRecipes(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    @Override
    public void jumpFromGround() {
        super.jumpFromGround();
        this.awardStat(Stats.JUMP);
        if (this.isSprinting()) {
            this.causeFoodExhaustion(this.level().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.level().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void travel(Vec3 movementInput) {
        double d0;
        if (this.isSwimming() && !this.isPassenger()) {
            double d1;
            d0 = this.getLookAngle().y;
            double d = d1 = d0 < -0.2 ? 0.085 : 0.06;
            if (d0 <= 0.0 || this.jumping || !this.level().getBlockState(BlockPos.containing(this.getX(), this.getY() + 1.0 - 0.1, this.getZ())).getFluidState().isEmpty()) {
                Vec3 vec3d1 = this.getDeltaMovement();
                this.setDeltaMovement(vec3d1.add(0.0, (d0 - vec3d1.y) * d1, 0.0));
            }
        }
        if (this.abilities.flying && !this.isPassenger()) {
            d0 = this.getDeltaMovement().y;
            super.travel(movementInput);
            Vec3 vec3d2 = this.getDeltaMovement();
            this.setDeltaMovement(vec3d2.x, d0 * 0.6, vec3d2.z);
            this.resetFallDistance();
            if (this.getSharedFlag(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                this.setSharedFlag(7, false);
            }
        } else {
            super.travel(movementInput);
        }
    }

    @Override
    public void updateSwimming() {
        if (this.abilities.flying) {
            this.setSwimming(false);
        } else {
            super.updateSwimming();
        }
    }

    protected boolean freeAt(BlockPos pos) {
        return !this.level().getBlockState(pos).isSuffocating(this.level(), pos);
    }

    @Override
    public float getSpeed() {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    @Override
    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag;
        if (this.abilities.mayfly && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0f) {
            this.awardStat(Stats.FALL_ONE_CM, (int)Math.round((double)fallDistance * 100.0));
        }
        if (this.ignoreFallDamageFromCurrentImpulse && this.currentImpulseImpactPos != null) {
            double d0 = this.currentImpulseImpactPos.y;
            this.tryResetCurrentImpulseContext();
            if (d0 < this.getY()) {
                return false;
            }
            float f2 = Math.min(fallDistance, (float)(d0 - this.getY()));
            flag = super.causeFallDamage(f2, damageMultiplier, damageSource);
        } else {
            flag = super.causeFallDamage(fallDistance, damageMultiplier, damageSource);
        }
        if (flag) {
            this.resetCurrentImpulseContext();
        }
        return flag;
    }

    public boolean tryToStartFallFlying() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.onGround() && !this.isFallFlying() && !this.isInWater() && !this.hasEffect(MobEffects.LEVITATION) && (itemstack = this.getItemBySlot(EquipmentSlot.CHEST)).is(Items.ELYTRA) && ElytraItem.isFlyEnabled(itemstack)) {
            this.startFallFlying();
            return true;
        }
        return false;
    }

    public void startFallFlying() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.setSharedFlag(7, true);
        } else {
            this.setSharedFlag(7, true);
            this.setSharedFlag(7, false);
        }
    }

    public void stopFallFlying() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.setSharedFlag(7, true);
            this.setSharedFlag(7, false);
        }
    }

    @Override
    protected void doWaterSplashEffect() {
        if (!this.isSpectator()) {
            super.doWaterSplashEffect();
        }
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState state) {
        if (this.isInWater()) {
            this.waterSwimSound();
            this.playMuffledStepSound(state);
        } else {
            BlockPos blockposition1 = this.getPrimaryStepSoundBlockPos(pos);
            if (!pos.equals(blockposition1)) {
                BlockState iblockdata1 = this.level().getBlockState(blockposition1);
                if (iblockdata1.is(BlockTags.COMBINATION_STEP_SOUND_BLOCKS)) {
                    this.playCombinationStepSounds(iblockdata1, state);
                } else {
                    super.playStepSound(blockposition1, iblockdata1);
                }
            } else {
                super.playStepSound(pos, state);
            }
        }
    }

    @Override
    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.PLAYER_SMALL_FALL, SoundEvents.PLAYER_BIG_FALL);
    }

    @Override
    public boolean killedEntity(ServerLevel world, LivingEntity other) {
        this.awardStat(Stats.ENTITY_KILLED.get(other.getType()));
        return true;
    }

    @Override
    public void makeStuckInBlock(BlockState state, Vec3 multiplier) {
        if (!this.abilities.flying) {
            super.makeStuckInBlock(state, multiplier);
        }
        this.tryResetCurrentImpulseContext();
    }

    public void giveExperiencePoints(int experience) {
        this.increaseScore(experience);
        this.experienceProgress += (float)experience / (float)this.getXpNeededForNextLevel();
        this.totalExperience = Mth.clamp(this.totalExperience + experience, 0, Integer.MAX_VALUE);
        while (this.experienceProgress < 0.0f) {
            float f = this.experienceProgress * (float)this.getXpNeededForNextLevel();
            if (this.experienceLevel > 0) {
                this.giveExperienceLevels(-1);
                this.experienceProgress = 1.0f + f / (float)this.getXpNeededForNextLevel();
                continue;
            }
            this.giveExperienceLevels(-1);
            this.experienceProgress = 0.0f;
        }
        while (this.experienceProgress >= 1.0f) {
            this.experienceProgress = (this.experienceProgress - 1.0f) * (float)this.getXpNeededForNextLevel();
            this.giveExperienceLevels(1);
            this.experienceProgress /= (float)this.getXpNeededForNextLevel();
        }
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed;
    }

    public void onEnchantmentPerformed(net.minecraft.world.item.ItemStack enchantedItem, int experienceLevels) {
        this.experienceLevel -= experienceLevels;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        this.enchantmentSeed = this.random.nextInt();
    }

    public void giveExperienceLevels(int levels) {
        this.experienceLevel += levels;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        if (levels > 0 && this.experienceLevel % 5 == 0 && (float)this.lastLevelUpTime < (float)this.tickCount - 100.0f) {
            float f = this.experienceLevel > 30 ? 1.0f : (float)this.experienceLevel / 30.0f;
            this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_LEVELUP, this.getSoundSource(), f * 0.75f, 1.0f);
            this.lastLevelUpTime = this.tickCount;
        }
    }

    public int getXpNeededForNextLevel() {
        return this.experienceLevel >= 30 ? 112 + (this.experienceLevel - 30) * 9 : (this.experienceLevel >= 15 ? 37 + (this.experienceLevel - 15) * 5 : 7 + this.experienceLevel * 2);
    }

    private static void sendSoundEffect(Player fromEntity, double x, double y, double z, SoundEvent soundEffect, SoundSource soundCategory, float volume, float pitch) {
        fromEntity.level().playSound(fromEntity, x, y, z, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)fromEntity;
            serverPlayer.connection.send(new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(soundEffect), soundCategory, x, y, z, volume, pitch, fromEntity.random.nextLong()));
        }
    }

    public void causeFoodExhaustion(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.abilities.invulnerable || this.level().isClientSide || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f)).isCancelled())) {
            this.foodData.addExhaustion(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.empty();
    }

    public FoodData getFoodData() {
        return this.foodData;
    }

    public boolean canEat(boolean ignoreHunger) {
        return this.abilities.invulnerable || ignoreHunger || this.foodData.needsFood();
    }

    public boolean isHurt() {
        return this.getHealth() > 0.0f && this.getHealth() < this.getMaxHealth();
    }

    public boolean mayBuild() {
        return this.abilities.mayBuild;
    }

    public boolean mayUseItemAt(BlockPos pos, Direction facing, net.minecraft.world.item.ItemStack stack) {
        if (this.abilities.mayBuild) {
            return true;
        }
        BlockPos blockposition1 = pos.relative(facing.getOpposite());
        BlockInWorld shapedetectorblock = new BlockInWorld(this.level(), blockposition1, false);
        return stack.canPlaceOnBlockInAdventureMode(shapedetectorblock);
    }

    @Override
    protected int getBaseExperienceReward() {
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) && !this.isSpectator()) {
            int toDrop;
            try {
                toDrop = Math.round(((Number)Entity.scriptEngine.eval("let expLevel = " + this.experienceLevel + "; let expTotal = " + this.totalExperience + "; let exp = " + this.experienceProgress + "; " + this.level().purpurConfig.playerDeathExpDropEquation)).floatValue());
            }
            catch (ScriptException e) {
                e.printStackTrace();
                toDrop = this.experienceLevel * 7;
            }
            return Math.min(toDrop, this.level().purpurConfig.playerDeathExpDropMax);
        }
        return 0;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return true;
    }

    @Override
    public boolean shouldShowName() {
        return true;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return !this.abilities.flying && (!this.onGround() || !this.isDiscrete()) ? Entity.MovementEmission.ALL : Entity.MovementEmission.NONE;
    }

    public void onUpdateAbilities() {
    }

    @Override
    public Component getName() {
        return Component.literal(this.gameProfile.getName());
    }

    public PlayerEnderChestContainer getEnderChestInventory() {
        return this.enderChestInventory;
    }

    @Override
    public net.minecraft.world.item.ItemStack getItemBySlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.inventory.getSelected() : (slot == EquipmentSlot.OFFHAND ? this.inventory.offhand.get(0) : (slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR ? this.inventory.armor.get(slot.getIndex()) : net.minecraft.world.item.ItemStack.EMPTY));
    }

    @Override
    protected boolean doesEmitEquipEvent(EquipmentSlot slot) {
        return slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR;
    }

    @Override
    public void setItemSlot(EquipmentSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EquipmentSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.verifyEquippedItem(itemstack);
        if (enumitemslot == EquipmentSlot.MAINHAND) {
            this.onEquipItem(enumitemslot, this.inventory.items.set(this.inventory.selected, itemstack), itemstack, silent);
        } else if (enumitemslot == EquipmentSlot.OFFHAND) {
            this.onEquipItem(enumitemslot, this.inventory.offhand.set(0, itemstack), itemstack, silent);
        } else if (enumitemslot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
            this.onEquipItem(enumitemslot, this.inventory.armor.set(enumitemslot.getIndex(), itemstack), itemstack, silent);
        }
    }

    public boolean addItem(net.minecraft.world.item.ItemStack stack) {
        return this.inventory.add(stack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> getHandSlots() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.getMainHandItem(), this.getOffhandItem()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> getArmorSlots() {
        return this.inventory.armor;
    }

    @Override
    public boolean canUseSlot(EquipmentSlot slot) {
        return slot != EquipmentSlot.BODY;
    }

    @Override
    public boolean dismountsUnderwater() {
        return !this.level().purpurConfig.playerRidableInWater;
    }

    public boolean setEntityOnShoulder(CompoundTag entityNbt) {
        if (!this.isPassenger() && this.onGround() && !this.isInWater() && !this.isInPowderSnow) {
            if (this.getShoulderEntityLeft().isEmpty()) {
                this.setShoulderEntityLeft(entityNbt);
                this.timeEntitySatOnShoulder = this.level().getGameTime();
                return true;
            }
            if (this.getShoulderEntityRight().isEmpty()) {
                this.setShoulderEntityRight(entityNbt);
                this.timeEntitySatOnShoulder = this.level().getGameTime();
                return true;
            }
            return false;
        }
        return false;
    }

    public void removeEntitiesOnShoulder() {
        if (this.timeEntitySatOnShoulder + 20L < this.level().getGameTime()) {
            if (this.respawnEntityOnShoulder(this.getShoulderEntityLeft())) {
                this.setShoulderEntityLeft(new CompoundTag());
            }
            if (this.respawnEntityOnShoulder(this.getShoulderEntityRight())) {
                this.setShoulderEntityRight(new CompoundTag());
            }
        }
    }

    public Entity releaseLeftShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.getShoulderEntityLeft());
        if (entity != null) {
            this.setShoulderEntityLeft(new CompoundTag());
        }
        return entity;
    }

    public Entity releaseRightShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.getShoulderEntityRight());
        if (entity != null) {
            this.setShoulderEntityRight(new CompoundTag());
        }
        return entity;
    }

    private boolean respawnEntityOnShoulder(CompoundTag nbttagcompound) {
        return this.respawnEntityOnShoulder0(nbttagcompound) != null;
    }

    private Entity respawnEntityOnShoulder0(CompoundTag nbttagcompound) {
        if (!this.level().isClientSide && nbttagcompound != null && !nbttagcompound.isEmpty()) {
            return EntityType.create(nbttagcompound, this.level()).map(entity -> {
                if (entity instanceof TamableAnimal) {
                    ((TamableAnimal)entity).setOwnerUUID(this.uuid);
                }
                entity.setPos(this.getX(), this.getY() + (double)0.7f, this.getZ());
                boolean addedToWorld = ((ServerLevel)this.level()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
                return addedToWorld ? entity : null;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public abstract boolean isSpectator();

    @Override
    public boolean canBeHitByProjectile() {
        return !this.isSpectator() && super.canBeHitByProjectile();
    }

    @Override
    public boolean isSwimming() {
        return !this.abilities.flying && !this.isSpectator() && super.isSwimming();
    }

    public abstract boolean isCreative();

    @Override
    public boolean isPushedByFluid() {
        return !this.abilities.flying;
    }

    public Scoreboard getScoreboard() {
        return this.level().getScoreboard();
    }

    @Override
    public Component getDisplayName() {
        MutableComponent ichatmutablecomponent = PlayerTeam.formatNameForTeam(this.getTeam(), this.getName());
        return this.decorateDisplayNameComponent(ichatmutablecomponent);
    }

    private MutableComponent decorateDisplayNameComponent(MutableComponent component) {
        String s = this.getGameProfile().getName();
        return component.withStyle(chatmodifier -> chatmodifier.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tell " + s + " ")).withHoverEvent(this.createHoverEvent()).withInsertion(s));
    }

    @Override
    public String getScoreboardName() {
        return this.getGameProfile().getName();
    }

    @Override
    protected void internalSetAbsorptionAmount(float absorptionAmount) {
        this.getEntityData().set(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(absorptionAmount));
    }

    @Override
    public float getAbsorptionAmount() {
        return this.getEntityData().get(DATA_PLAYER_ABSORPTION_ID).floatValue();
    }

    public boolean isModelPartShown(PlayerModelPart modelPart) {
        return (this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION) & modelPart.getMask()) == modelPart.getMask();
    }

    @Override
    public SlotAccess getSlot(int mappedIndex) {
        if (mappedIndex == 499) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack get() {
                    return Player.this.containerMenu.getCarried();
                }

                @Override
                public boolean set(net.minecraft.world.item.ItemStack stack) {
                    Player.this.containerMenu.setCarried(stack);
                    return true;
                }
            };
        }
        final int j = mappedIndex - 500;
        if (j >= 0 && j < 4) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack get() {
                    return Player.this.inventoryMenu.getCraftSlots().getItem(j);
                }

                @Override
                public boolean set(net.minecraft.world.item.ItemStack stack) {
                    Player.this.inventoryMenu.getCraftSlots().setItem(j, stack);
                    Player.this.inventoryMenu.slotsChanged(Player.this.inventory);
                    return true;
                }
            };
        }
        if (mappedIndex >= 0 && mappedIndex < this.inventory.items.size()) {
            return SlotAccess.forContainer(this.inventory, mappedIndex);
        }
        int k = mappedIndex - 200;
        return k >= 0 && k < this.enderChestInventory.getContainerSize() ? SlotAccess.forContainer(this.enderChestInventory, k) : super.getSlot(mappedIndex);
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public void setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    @Override
    public void setRemainingFireTicks(int fireTicks) {
        super.setRemainingFireTicks(this.abilities.invulnerable ? Math.min(fireTicks, 1) : fireTicks);
    }

    @Override
    public HumanoidArm getMainArm() {
        return this.entityData.get(DATA_PLAYER_MAIN_HAND) == 0 ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public void setMainArm(HumanoidArm arm) {
        this.entityData.set(DATA_PLAYER_MAIN_HAND, (byte)(arm != HumanoidArm.LEFT ? 1 : 0));
    }

    public CompoundTag getShoulderEntityLeft() {
        return this.entityData.get(DATA_SHOULDER_LEFT);
    }

    public void setShoulderEntityLeft(CompoundTag entityNbt) {
        this.entityData.set(DATA_SHOULDER_LEFT, entityNbt);
    }

    public CompoundTag getShoulderEntityRight() {
        return this.entityData.get(DATA_SHOULDER_RIGHT);
    }

    public void setShoulderEntityRight(CompoundTag entityNbt) {
        this.entityData.set(DATA_SHOULDER_RIGHT, entityNbt);
    }

    public float getCurrentItemAttackStrengthDelay() {
        return (float)(1.0 / this.getAttributeValue(Attributes.ATTACK_SPEED) * 20.0);
    }

    public float getAttackStrengthScale(float baseTime) {
        return Mth.clamp(((float)this.attackStrengthTicker + baseTime) / this.getCurrentItemAttackStrengthDelay(), 0.0f, 1.0f);
    }

    public void resetAttackStrengthTicker() {
        this.attackStrengthTicker = 0;
    }

    public ItemCooldowns getCooldowns() {
        return this.cooldowns;
    }

    @Override
    protected float getBlockSpeedFactor() {
        return !this.abilities.flying && !this.isFallFlying() ? super.getBlockSpeedFactor() : 1.0f;
    }

    public float getLuck() {
        return (float)this.getAttributeValue(Attributes.LUCK);
    }

    public boolean canUseGameMasterBlocks() {
        return this.abilities.instabuild && this.getPermissionLevel() >= 2;
    }

    @Override
    public boolean canTakeItem(net.minecraft.world.item.ItemStack stack) {
        EquipmentSlot enumitemslot = this.getEquipmentSlotForItem(stack);
        return this.getItemBySlot(enumitemslot).isEmpty();
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose pose) {
        return POSES.getOrDefault((Object)pose, STANDING_DIMENSIONS);
    }

    @Override
    public ImmutableList<Pose> getDismountPoses() {
        return ImmutableList.of((Object)((Object)Pose.STANDING), (Object)((Object)Pose.CROUCHING), (Object)((Object)Pose.SWIMMING));
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack) {
        return !(this instanceof ServerPlayer) || new PlayerReadyArrowEvent((org.bukkit.entity.Player)((ServerPlayer)this).getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
    }

    @Override
    public net.minecraft.world.item.ItemStack getProjectile(net.minecraft.world.item.ItemStack stack) {
        if (!(stack.getItem() instanceof ProjectileWeaponItem)) {
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        Predicate<net.minecraft.world.item.ItemStack> predicate = ((ProjectileWeaponItem)stack.getItem()).getSupportedHeldProjectiles().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        net.minecraft.world.item.ItemStack itemstack1 = ProjectileWeaponItem.getHeldProjectile(this, predicate);
        if (!itemstack1.isEmpty()) {
            return itemstack1;
        }
        predicate = ((ProjectileWeaponItem)stack.getItem()).getAllSupportedProjectiles().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            net.minecraft.world.item.ItemStack itemstack2 = this.inventory.getItem(i);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.abilities.instabuild ? new net.minecraft.world.item.ItemStack(Items.ARROW) : net.minecraft.world.item.ItemStack.EMPTY;
    }

    @Override
    public net.minecraft.world.item.ItemStack eat(Level world, net.minecraft.world.item.ItemStack stack, FoodProperties foodComponent) {
        this.getFoodData().eat(stack, foodComponent);
        this.awardStat(Stats.ITEM_USED.get(stack.getItem()));
        if (this instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)this, stack);
        }
        net.minecraft.world.item.ItemStack itemstack1 = super.eat(world, stack, foodComponent);
        Optional<net.minecraft.world.item.ItemStack> optional = foodComponent.usingConvertsTo();
        if (optional.isPresent() && !this.hasInfiniteMaterials()) {
            if (itemstack1.isEmpty()) {
                return optional.get().copy();
            }
            if (!this.level().isClientSide()) {
                this.getInventory().add(optional.get().copy());
            }
        }
        return itemstack1;
    }

    @Override
    public Vec3 getRopeHoldPosition(float delta) {
        float f3;
        double d0 = 0.22 * (this.getMainArm() == HumanoidArm.RIGHT ? -1.0 : 1.0);
        float f1 = Mth.lerp(delta * 0.5f, this.getXRot(), this.xRotO) * ((float)Math.PI / 180);
        float f2 = Mth.lerp(delta, this.yBodyRotO, this.yBodyRot) * ((float)Math.PI / 180);
        if (!this.isFallFlying() && !this.isAutoSpinAttack()) {
            if (this.isVisuallySwimming()) {
                return this.getPosition(delta).add(new Vec3(d0, 0.2, -0.15).xRot(-f1).yRot(-f2));
            }
            double d2 = this.getBoundingBox().getYsize() - 1.0;
            double d1 = this.isCrouching() ? -0.2 : 0.07;
            return this.getPosition(delta).add(new Vec3(d0, d2, d1).yRot(-f2));
        }
        Vec3 vec3d = this.getViewVector(delta);
        Vec3 vec3d1 = this.getDeltaMovement();
        double d1 = vec3d1.horizontalDistanceSqr();
        double d3 = vec3d.horizontalDistanceSqr();
        if (d1 > 0.0 && d3 > 0.0) {
            double d4 = (vec3d1.x * vec3d.x + vec3d1.z * vec3d.z) / Math.sqrt(d1 * d3);
            double d5 = vec3d1.x * vec3d.z - vec3d1.z * vec3d.x;
            f3 = (float)(Math.signum(d5) * Math.acos(d4));
        } else {
            f3 = 0.0f;
        }
        return this.getPosition(delta).add(new Vec3(d0, -0.11, 0.85).zRot(-f3).xRot(-f1).yRot(-f2));
    }

    @Override
    public boolean isAlwaysTicking() {
        return true;
    }

    public boolean isScoping() {
        return this.isUsingItem() && this.getUseItem().is(Items.SPYGLASS);
    }

    @Override
    public boolean shouldBeSaved() {
        return false;
    }

    public Optional<GlobalPos> getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    public void setLastDeathLocation(Optional<GlobalPos> lastDeathPos) {
        this.lastDeathLocation = lastDeathPos;
    }

    @Override
    public float getHurtDir() {
        return this.hurtDir;
    }

    @Override
    public void animateHurt(float yaw) {
        super.animateHurt(yaw);
        this.hurtDir = yaw;
    }

    @Override
    public boolean canSprint() {
        return true;
    }

    @Override
    protected float getFlyingSpeed() {
        return this.abilities.flying && !this.isPassenger() ? (this.isSprinting() ? this.abilities.getFlyingSpeed() * 2.0f : this.abilities.getFlyingSpeed()) : (this.isSprinting() ? 0.025999999f : 0.02f);
    }

    public double blockInteractionRange() {
        return this.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
    }

    public double entityInteractionRange() {
        return this.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
    }

    public boolean canInteractWithEntity(Entity entity, double additionalRange) {
        return entity.isRemoved() ? false : this.canInteractWithEntity(entity.getBoundingBox(), additionalRange);
    }

    public boolean canInteractWithEntity(AABB box, double additionalRange) {
        double d1 = this.entityInteractionRange() + additionalRange;
        return box.distanceToSqr(this.getEyePosition()) < d1 * d1;
    }

    public boolean canInteractWithBlock(BlockPos pos, double additionalRange) {
        double d1 = this.blockInteractionRange() + additionalRange;
        return new AABB(pos).distanceToSqr(this.getEyePosition()) < d1 * d1;
    }

    public void setIgnoreFallDamageFromCurrentImpulse(boolean ignoreFallDamageFromCurrentExplosion) {
        this.ignoreFallDamageFromCurrentImpulse = ignoreFallDamageFromCurrentExplosion;
        this.currentImpulseContextResetGraceTime = ignoreFallDamageFromCurrentExplosion ? 40 : 0;
    }

    public boolean isIgnoringFallDamageFromCurrentImpulse() {
        return this.ignoreFallDamageFromCurrentImpulse;
    }

    public void tryResetCurrentImpulseContext() {
        if (this.currentImpulseContextResetGraceTime == 0) {
            this.resetCurrentImpulseContext();
        }
    }

    public void resetCurrentImpulseContext() {
        this.currentImpulseContextResetGraceTime = 0;
        this.currentExplosionCause = null;
        this.currentImpulseImpactPos = null;
        this.ignoreFallDamageFromCurrentImpulse = false;
    }

    public static enum BedSleepingProblem {
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW(Component.translatable("block.minecraft.bed.no_sleep")),
        TOO_FAR_AWAY(Component.translatable("block.minecraft.bed.too_far_away")),
        OBSTRUCTED(Component.translatable("block.minecraft.bed.obstructed")),
        OTHER_PROBLEM,
        NOT_SAFE(Component.translatable("block.minecraft.bed.not_safe"));

        @Nullable
        private final Component message;

        private BedSleepingProblem() {
            this.message = null;
        }

        private BedSleepingProblem(Component ichatbasecomponent) {
            this.message = ichatbasecomponent;
        }

        @Nullable
        public Component getMessage() {
            return this.message;
        }
    }
}

