/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.util.Crypt;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureValidator;
import org.bukkit.event.player.PlayerKickEvent;

public record ProfilePublicKey(Data data) {
    public static final Component EXPIRED_PROFILE_PUBLIC_KEY = Component.translatable("multiplayer.disconnect.expired_public_key");
    private static final Component INVALID_SIGNATURE = Component.translatable("multiplayer.disconnect.invalid_public_key_signature.new");
    public static final Duration EXPIRY_GRACE_PERIOD = Duration.ofHours(8L);
    public static final Codec<ProfilePublicKey> TRUSTED_CODEC = Data.CODEC.xmap(ProfilePublicKey::new, ProfilePublicKey::data);

    public static ProfilePublicKey createValidated(SignatureValidator servicesSignatureVerifier, UUID playerUuid, Data publicKeyData) throws ValidationException {
        if (!publicKeyData.validateSignature(servicesSignatureVerifier, playerUuid)) {
            throw new ValidationException(INVALID_SIGNATURE, PlayerKickEvent.Cause.INVALID_PUBLIC_KEY_SIGNATURE);
        }
        return new ProfilePublicKey(publicKeyData);
    }

    public SignatureValidator createSignatureValidator() {
        return SignatureValidator.from(this.data.key, "SHA256withRSA");
    }

    public record Data(Instant expiresAt, PublicKey key, byte[] keySignature) {
        private static final int MAX_KEY_SIGNATURE_SIZE = 4096;
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.INSTANT_ISO8601.fieldOf("expires_at").forGetter(Data::expiresAt), (App)Crypt.PUBLIC_KEY_CODEC.fieldOf("key").forGetter(Data::key), (App)ExtraCodecs.BASE64_STRING.fieldOf("signature_v2").forGetter(Data::keySignature)).apply((Applicative)instance, Data::new));

        public Data(FriendlyByteBuf buf) {
            this(buf.readInstant(), buf.readPublicKey(), buf.readByteArray(4096));
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeInstant(this.expiresAt);
            buf.writePublicKey(this.key);
            buf.writeByteArray(this.keySignature);
        }

        boolean validateSignature(SignatureValidator servicesSignatureVerifier, UUID playerUuid) {
            return servicesSignatureVerifier.validate(this.signedPayload(playerUuid), this.keySignature);
        }

        private byte[] signedPayload(UUID playerUuid) {
            byte[] bs = this.key.getEncoded();
            byte[] cs = new byte[24 + bs.length];
            ByteBuffer byteBuffer = ByteBuffer.wrap(cs).order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putLong(playerUuid.getMostSignificantBits()).putLong(playerUuid.getLeastSignificantBits()).putLong(this.expiresAt.toEpochMilli()).put(bs);
            return cs;
        }

        public boolean hasExpired() {
            return this.expiresAt.isBefore(Instant.now());
        }

        public boolean hasExpired(Duration gracePeriod) {
            return this.expiresAt.plus(gracePeriod).isBefore(Instant.now());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Data)) return false;
            Data data = (Data)object;
            if (!this.expiresAt.equals(data.expiresAt)) return false;
            if (!this.key.equals(data.key)) return false;
            if (!Arrays.equals(this.keySignature, data.keySignature)) return false;
            return true;
        }
    }

    public static class ValidationException
    extends ThrowingComponent {
        public final PlayerKickEvent.Cause kickCause;

        @DoNotUse
        @Deprecated
        public ValidationException(Component messageText) {
            this(messageText, PlayerKickEvent.Cause.UNKNOWN);
        }

        public ValidationException(Component messageText, PlayerKickEvent.Cause kickCause) {
            super(messageText);
            this.kickCause = kickCause;
        }
    }
}

