/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.destroystokyo.paper.event.block.AnvilDamagedEvent;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.ChatColor;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.view.CraftAnvilView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.inventory.AnvilTakeResultEvent;
import org.purpurmc.purpur.event.inventory.AnvilUpdateResultEvent;
import org.slf4j.Logger;

public class AnvilMenu
extends ItemCombinerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG_COST = false;
    public static final int MAX_NAME_LENGTH = 50;
    public int repairItemCountCost;
    @Nullable
    public String itemName;
    public final DataSlot cost = DataSlot.standalone();
    private static final int COST_FAIL = 0;
    private static final int COST_BASE = 1;
    private static final int COST_ADDED_BASE = 1;
    private static final int COST_REPAIR_MATERIAL = 1;
    private static final int COST_REPAIR_SACRIFICE = 2;
    private static final int COST_INCOMPATIBLE_PENALTY = 1;
    private static final int COST_RENAME = 1;
    private static final int INPUT_SLOT_X_PLACEMENT = 27;
    private static final int ADDITIONAL_SLOT_X_PLACEMENT = 76;
    private static final int RESULT_SLOT_X_PLACEMENT = 134;
    private static final int SLOT_Y_PLACEMENT = 47;
    public static final int DEFAULT_DENIED_COST = -1;
    public int maximumRepairCost = 40;
    private CraftAnvilView bukkitEntity;
    public boolean bypassEnchantmentLevelRestriction = false;
    public boolean bypassCost = false;
    public boolean canDoUnsafeEnchants = false;

    public AnvilMenu(int syncId, Inventory inventory) {
        this(syncId, inventory, ContainerLevelAccess.NULL);
    }

    public AnvilMenu(int syncId, Inventory inventory, ContainerLevelAccess context) {
        super(MenuType.ANVIL, syncId, inventory, context);
        this.addDataSlot(this.cost);
    }

    @Override
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, itemstack -> true).withSlot(1, 76, 47, itemstack -> true).withResultSlot(2, 134, 47).build();
    }

    @Override
    protected boolean isValidBlock(BlockState state) {
        return state.is(BlockTags.ANVIL);
    }

    @Override
    protected boolean mayPickup(Player player, boolean present) {
        return !(!player.hasInfiniteMaterials() && player.experienceLevel < this.cost.get() || !this.bypassCost && this.cost.get() <= -1 || !present);
    }

    @Override
    protected void onTake(Player player, net.minecraft.world.item.ItemStack stack) {
        net.minecraft.world.item.ItemStack itemstack;
        net.minecraft.world.item.ItemStack itemStack = itemstack = this.activeQuickItem != null ? this.activeQuickItem : stack;
        if (AnvilTakeResultEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new AnvilTakeResultEvent((HumanEntity)player.getBukkitEntity(), (InventoryView)this.getBukkitView(), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
        }
        if (!player.getAbilities().instabuild) {
            if (this.bypassCost) {
                ((ServerPlayer)player).lastSentExp = -1;
            } else {
                player.giveExperienceLevels(-this.cost.get());
            }
        }
        this.inputSlots.setItem(0, net.minecraft.world.item.ItemStack.EMPTY);
        if (this.repairItemCountCost > 0) {
            net.minecraft.world.item.ItemStack itemstack1 = this.inputSlots.getItem(1);
            if (!itemstack1.isEmpty() && itemstack1.getCount() > this.repairItemCountCost) {
                itemstack1.shrink(this.repairItemCountCost);
                this.inputSlots.setItem(1, itemstack1);
            } else {
                this.inputSlots.setItem(1, net.minecraft.world.item.ItemStack.EMPTY);
            }
        } else {
            this.inputSlots.setItem(1, net.minecraft.world.item.ItemStack.EMPTY);
        }
        this.cost.set(-1);
        this.access.execute((world, blockposition) -> {
            BlockState iblockdata = world.getBlockState((BlockPos)blockposition);
            if (!player.hasInfiniteMaterials() && iblockdata.is(BlockTags.ANVIL) && player.getRandom().nextFloat() < 0.12f) {
                BlockState iblockdata1 = AnvilBlock.damage(iblockdata);
                AnvilDamagedEvent event = new AnvilDamagedEvent((InventoryView)this.getBukkitView(), (BlockData)(iblockdata1 != null ? CraftBlockData.fromData(iblockdata1) : null));
                if (!event.callEvent()) {
                    return;
                }
                iblockdata1 = event.getDamageState() == AnvilDamagedEvent.DamageState.BROKEN ? null : (BlockState)((CraftBlockData)event.getDamageState().getMaterial().createBlockData()).getState().setValue(AnvilBlock.FACING, iblockdata.getValue(AnvilBlock.FACING));
                if (iblockdata1 == null) {
                    world.removeBlock((BlockPos)blockposition, false);
                    world.levelEvent(1029, (BlockPos)blockposition, 0);
                } else {
                    world.setBlock((BlockPos)blockposition, iblockdata1, 2);
                    world.levelEvent(1030, (BlockPos)blockposition, 0);
                }
            } else {
                world.levelEvent(1030, (BlockPos)blockposition, 0);
            }
        });
    }

    @Override
    public void createResult() {
        this.bypassCost = false;
        this.canDoUnsafeEnchants = false;
        if (AnvilUpdateResultEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new AnvilUpdateResultEvent((InventoryView)this.getBukkitView()).callEvent();
        }
        net.minecraft.world.item.ItemStack itemstack = this.inputSlots.getItem(0);
        this.cost.set(1);
        int i = 0;
        long j = 0L;
        int b0 = 0;
        if (!itemstack.isEmpty() && this.canDoUnsafeEnchants || EnchantmentHelper.canStoreEnchantments(itemstack)) {
            int k;
            net.minecraft.world.item.ItemStack itemstack1 = itemstack.copy();
            net.minecraft.world.item.ItemStack itemstack2 = this.inputSlots.getItem(1);
            ItemEnchantments.Mutable itemenchantments_a = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting(itemstack1));
            j += (long)itemstack.getOrDefault(DataComponents.REPAIR_COST, 0).intValue() + (long)itemstack2.getOrDefault(DataComponents.REPAIR_COST, 0).intValue();
            this.repairItemCountCost = 0;
            if (!itemstack2.isEmpty()) {
                boolean flag = itemstack2.has(DataComponents.STORED_ENCHANTMENTS);
                if (itemstack1.isDamageableItem() && itemstack1.getItem().isValidRepairItem(itemstack, itemstack2)) {
                    k = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    if (k <= 0) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), net.minecraft.world.item.ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                    for (i1 = 0; k > 0 && i1 < itemstack2.getCount(); ++i1) {
                        l = itemstack1.getDamageValue() - k;
                        itemstack1.setDamageValue(l);
                        ++i;
                        k = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    }
                    this.repairItemCountCost = i1;
                } else {
                    if (!(flag || itemstack1.is(itemstack2.getItem()) && itemstack1.isDamageableItem())) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), net.minecraft.world.item.ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                    if (itemstack1.isDamageableItem() && !flag) {
                        k = itemstack.getMaxDamage() - itemstack.getDamageValue();
                        i1 = itemstack2.getMaxDamage() - itemstack2.getDamageValue();
                        l = i1 + itemstack1.getMaxDamage() * 12 / 100;
                        int j1 = k + l;
                        int k1 = itemstack1.getMaxDamage() - j1;
                        if (k1 < 0) {
                            k1 = 0;
                        }
                        if (k1 < itemstack1.getDamageValue()) {
                            itemstack1.setDamageValue(k1);
                            i += 2;
                        }
                    }
                    ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting(itemstack2);
                    boolean flag1 = false;
                    boolean flag2 = false;
                    for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemenchantments.entrySet()) {
                        int i2;
                        Holder holder = (Holder)entry.getKey();
                        int l1 = itemenchantments_a.getLevel(holder);
                        i2 = l1 == (i2 = entry.getIntValue()) ? i2 + 1 : Math.max(i2, l1);
                        Enchantment enchantment = (Enchantment)holder.value();
                        boolean flag3 = this.canDoUnsafeEnchants || PurpurConfig.allowInapplicableEnchants || enchantment.canEnchant(itemstack);
                        boolean flag4 = true;
                        if (this.player.getAbilities().instabuild || itemstack.is(Items.ENCHANTED_BOOK)) {
                            flag3 = true;
                        }
                        Iterator<Holder<Enchantment>> iterator1 = itemenchantments_a.keySet().iterator();
                        while (iterator1.hasNext()) {
                            Holder<Enchantment> holder1 = iterator1.next();
                            if (holder1.equals(holder) || Enchantment.areCompatible(holder, holder1)) continue;
                            boolean bl = flag4 = this.canDoUnsafeEnchants || PurpurConfig.allowIncompatibleEnchants;
                            if (!flag4 && PurpurConfig.replaceIncompatibleEnchants) {
                                iterator1.remove();
                                flag4 = true;
                            }
                            ++i;
                        }
                        if (!flag3 || !flag4) {
                            flag2 = true;
                            continue;
                        }
                        flag1 = true;
                        if (!PurpurConfig.allowHigherEnchantsLevels && i2 > enchantment.getMaxLevel() && !this.bypassEnchantmentLevelRestriction) {
                            i2 = enchantment.getMaxLevel();
                        }
                        itemenchantments_a.set(holder, i2);
                        int j2 = enchantment.getAnvilCost();
                        if (flag) {
                            j2 = Math.max(1, j2 / 2);
                        }
                        i += j2 * i2;
                        if (itemstack.getCount() <= 1) continue;
                        i = 40;
                    }
                    if (flag2 && !flag1) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), net.minecraft.world.item.ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                }
            }
            if (this.itemName != null && !StringUtil.isBlank(this.itemName)) {
                if (!this.itemName.equals(itemstack.getHoverName().getString())) {
                    b0 = 1;
                    i += b0;
                    if (this.player != null) {
                        CraftHumanEntity player = this.player.getBukkitEntity();
                        String name = this.itemName;
                        boolean removeItalics = false;
                        if (player.hasPermission("purpur.anvil.remove_italics")) {
                            if (name.startsWith("&r")) {
                                name = name.substring(2);
                                removeItalics = true;
                            } else if (name.startsWith("<r>")) {
                                name = name.substring(3);
                                removeItalics = true;
                            } else if (name.startsWith("<reset>")) {
                                name = name.substring(7);
                                removeItalics = true;
                            }
                        }
                        if (this.player.level().purpurConfig.anvilAllowColors) {
                            Matcher matcher;
                            if (player.hasPermission("purpur.anvil.color")) {
                                matcher = Pattern.compile("(?i)&([0-9a-fr])").matcher(name);
                                while (matcher.find()) {
                                    String match = matcher.group(1);
                                    name = name.replace("&" + match, "\u00a7" + match.toLowerCase(Locale.ROOT));
                                }
                            }
                            if (player.hasPermission("purpur.anvil.format")) {
                                matcher = Pattern.compile("(?i)&([k-or])").matcher(name);
                                while (matcher.find()) {
                                    String match = matcher.group(1);
                                    name = name.replace("&" + match, "\u00a7" + match.toLowerCase(Locale.ROOT));
                                }
                            }
                        }
                        Object component = this.player.level().purpurConfig.anvilColorsUseMiniMessage && player.hasPermission("purpur.anvil.minimessage") ? MiniMessage.miniMessage().deserialize((Object)ChatColor.stripColor((String)name)) : LegacyComponentSerializer.legacySection().deserialize(name);
                        if (removeItalics) {
                            component = component.decoration(TextDecoration.ITALIC, false);
                        }
                        itemstack1.set(DataComponents.CUSTOM_NAME, PaperAdventure.asVanilla((Component)component));
                    } else {
                        itemstack1.set(DataComponents.CUSTOM_NAME, net.minecraft.network.chat.Component.literal(this.itemName));
                    }
                }
            } else if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                b0 = 1;
                i += b0;
                itemstack1.remove(DataComponents.CUSTOM_NAME);
            }
            int k2 = (int)Mth.clamp(j + (long)i, 0L, Integer.MAX_VALUE);
            this.cost.set(k2);
            if (i <= 0) {
                itemstack1 = net.minecraft.world.item.ItemStack.EMPTY;
            }
            if (b0 == i && b0 > 0 && this.cost.get() >= this.maximumRepairCost) {
                this.cost.set(this.maximumRepairCost - 1);
            }
            if (this.bypassCost && this.cost.get() >= this.maximumRepairCost) {
                this.cost.set(this.maximumRepairCost - 1);
            }
            if (this.cost.get() >= this.maximumRepairCost && !this.player.getAbilities().instabuild) {
                itemstack1 = net.minecraft.world.item.ItemStack.EMPTY;
            }
            if (!itemstack1.isEmpty()) {
                k = itemstack1.getOrDefault(DataComponents.REPAIR_COST, 0);
                if (k < itemstack2.getOrDefault(DataComponents.REPAIR_COST, 0)) {
                    k = itemstack2.getOrDefault(DataComponents.REPAIR_COST, 0);
                }
                if (b0 != i || b0 == 0) {
                    k = AnvilMenu.calculateIncreasedRepairCost(k);
                }
                itemstack1.set(DataComponents.REPAIR_COST, k);
                EnchantmentHelper.setEnchantments(itemstack1, itemenchantments_a.toImmutable());
            }
            CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), itemstack1);
            this.sendAllDataToRemote();
            this.broadcastChanges();
            if ((this.canDoUnsafeEnchants || PurpurConfig.allowInapplicableEnchants || PurpurConfig.allowIncompatibleEnchants) && itemstack1 != net.minecraft.world.item.ItemStack.EMPTY) {
                ((ServerPlayer)this.player).connection.send(new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 2, itemstack1));
                ((ServerPlayer)this.player).connection.send(new ClientboundContainerSetDataPacket(this.containerId, 0, this.cost.get()));
            }
        } else {
            CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), net.minecraft.world.item.ItemStack.EMPTY);
            this.cost.set(-1);
        }
    }

    public static int calculateIncreasedRepairCost(int cost) {
        return PurpurConfig.anvilCumulativeCost ? (int)Math.min((long)cost * 2L + 1L, Integer.MAX_VALUE) : 0;
    }

    public boolean setItemName(String newItemName) {
        String s1 = AnvilMenu.validateName(newItemName);
        if (s1 != null && !s1.equals(this.itemName)) {
            this.itemName = s1;
            if (this.getSlot(2).hasItem()) {
                net.minecraft.world.item.ItemStack itemstack = this.getSlot(2).getItem();
                if (StringUtil.isBlank(s1)) {
                    itemstack.remove(DataComponents.CUSTOM_NAME);
                } else {
                    itemstack.set(DataComponents.CUSTOM_NAME, net.minecraft.network.chat.Component.literal(s1));
                }
            }
            this.createResult();
            CraftEventFactory.callPrepareResultEvent(this, 2);
            return true;
        }
        return false;
    }

    @Nullable
    private static String validateName(String name) {
        String s1 = StringUtil.filterText(name);
        return s1.length() <= 50 ? s1 : null;
    }

    public int getCost() {
        return this.cost.get();
    }

    @Override
    public CraftAnvilView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryAnvil inventory = new CraftInventoryAnvil(this.access.getLocation(), this.inputSlots, this.resultSlots);
        this.bukkitEntity = new CraftAnvilView((HumanEntity)this.player.getBukkitEntity(), inventory, this);
        this.bukkitEntity.updateFromLegacy(inventory);
        return this.bukkitEntity;
    }
}

