/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.bukkit.Location;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;

public class CartographyTableMenu
extends AbstractContainerMenu {
    private CraftInventoryView bukkitEntity = null;
    private org.bukkit.entity.Player player;
    public static final int MAP_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final ContainerLevelAccess access;
    long lastSoundTime;
    public final Container container;
    private final ResultContainer resultContainer;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryCartography inventory = new CraftInventoryCartography(this.container, this.resultContainer);
        this.bukkitEntity = new CraftInventoryView<CartographyTableMenu, CraftInventoryCartography>((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public CartographyTableMenu(int syncId, Inventory inventory) {
        this(syncId, inventory, ContainerLevelAccess.NULL);
    }

    public CartographyTableMenu(int syncId, Inventory inventory, final ContainerLevelAccess context) {
        super(MenuType.CARTOGRAPHY_TABLE, syncId);
        int j;
        this.container = new SimpleContainer(this.createBlockHolder(context), 2){

            @Override
            public void setChanged() {
                CartographyTableMenu.this.slotsChanged(this);
                super.setChanged();
            }

            @Override
            public Location getLocation() {
                return context.getLocation();
            }
        };
        this.resultContainer = new ResultContainer(this, this.createBlockHolder(context)){

            @Override
            public void setChanged() {
                super.setChanged();
            }

            @Override
            public Location getLocation() {
                return context.getLocation();
            }
        };
        this.access = context;
        this.addSlot(new Slot(this, this.container, 0, 15, 15){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return stack.is(Items.FILLED_MAP);
            }
        });
        this.addSlot(new Slot(this, this.container, 1, 15, 52){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return stack.is(Items.PAPER) || stack.is(Items.MAP) || stack.is(Items.GLASS_PANE);
            }
        });
        this.addSlot(new Slot(this.resultContainer, 2, 145, 39){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            @Override
            public void onTake(Player player, ItemStack stack) {
                CartographyTableMenu.this.slots.get(0).remove(1);
                CartographyTableMenu.this.slots.get(1).remove(1);
                stack.getItem().onCraftedBy(stack, player.level(), player);
                context.execute((world, blockposition) -> {
                    long j = world.getGameTime();
                    if (CartographyTableMenu.this.lastSoundTime != j) {
                        world.playSound((Player)null, (BlockPos)blockposition, SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        CartographyTableMenu.this.lastSoundTime = j;
                    }
                });
                super.onTake(player, stack);
            }
        });
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot(inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot(inventory, j, 8 + j * 18, 142));
        }
        this.player = (org.bukkit.entity.Player)inventory.player.getBukkitEntity();
    }

    @Override
    public boolean stillValid(Player player) {
        if (!this.checkReachable) {
            return true;
        }
        return CartographyTableMenu.stillValid(this.access, player, Blocks.CARTOGRAPHY_TABLE);
    }

    @Override
    public void slotsChanged(Container inventory) {
        ItemStack itemstack = this.container.getItem(0);
        ItemStack itemstack1 = this.container.getItem(1);
        ItemStack itemstack2 = this.resultContainer.getItem(2);
        if (!itemstack2.isEmpty() && (itemstack.isEmpty() || itemstack1.isEmpty())) {
            this.resultContainer.removeItemNoUpdate(2);
        } else if (!itemstack.isEmpty() && !itemstack1.isEmpty()) {
            this.setupResultSlot(itemstack, itemstack1, itemstack2);
        }
        CraftEventFactory.callPrepareResultEvent(this, 2);
    }

    private void setupResultSlot(ItemStack map, ItemStack item, ItemStack oldResult) {
        this.access.execute((world, blockposition) -> {
            MapItemSavedData worldmap = MapItem.getSavedData(map, world);
            if (worldmap != null) {
                ItemStack itemstack3;
                if (item.is(Items.PAPER) && !worldmap.locked && worldmap.scale < 4) {
                    itemstack3 = map.copyWithCount(1);
                    itemstack3.set(DataComponents.MAP_POST_PROCESSING, MapPostProcessing.SCALE);
                    this.broadcastChanges();
                } else if (item.is(Items.GLASS_PANE) && !worldmap.locked) {
                    itemstack3 = map.copyWithCount(1);
                    itemstack3.set(DataComponents.MAP_POST_PROCESSING, MapPostProcessing.LOCK);
                    this.broadcastChanges();
                } else {
                    if (!item.is(Items.MAP)) {
                        this.resultContainer.removeItemNoUpdate(2);
                        this.broadcastChanges();
                        return;
                    }
                    itemstack3 = map.copyWithCount(2);
                    this.broadcastChanges();
                }
                if (!ItemStack.matches(itemstack3, oldResult)) {
                    this.resultContainer.setItem(2, itemstack3);
                    this.broadcastChanges();
                }
            }
        });
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.resultContainer && super.canTakeItemForPickAll(stack, slot);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot1 = this.slots.get(slot);
        if (slot1 != null && slot1.hasItem()) {
            ItemStack itemstack1 = slot1.getItem();
            itemstack = itemstack1.copy();
            if (slot == 2) {
                itemstack1.getItem().onCraftedBy(itemstack1, player.level(), player);
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot1.onQuickCraft(itemstack1, itemstack);
            } else if (slot != 1 && slot != 0 ? (itemstack1.is(Items.FILLED_MAP) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (!itemstack1.is(Items.PAPER) && !itemstack1.is(Items.MAP) && !itemstack1.is(Items.GLASS_PANE) ? (slot >= 3 && slot < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : slot >= 30 && slot < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 1, 2, false))) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot1.setByPlayer(ItemStack.EMPTY);
            }
            slot1.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot1.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    @Override
    public void removed(Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(2);
        this.access.execute((world, blockposition) -> this.clearContainer(player, this.container));
    }
}

