/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import gg.pufferfish.pufferfish.PufferfishConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class EndCrystalItem
extends Item {
    public EndCrystalItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        double d2;
        double d1;
        BlockPos blockposition1;
        Level world = context.getLevel();
        BlockPos blockposition = context.getClickedPos();
        BlockState iblockdata = world.getBlockState(blockposition);
        if (!(world.purpurConfig.endCrystalPlaceAnywhere || iblockdata.is(Blocks.OBSIDIAN) || iblockdata.is(Blocks.BEDROCK))) {
            return InteractionResult.FAIL;
        }
        BlockPos aboveBlockPosition = blockposition1 = blockposition.above();
        if (!world.isEmptyBlock(blockposition1)) {
            return InteractionResult.FAIL;
        }
        double d0 = blockposition1.getX();
        List<Entity> list = world.getEntities(null, new AABB(d0, d1 = (double)blockposition1.getY(), d2 = (double)blockposition1.getZ(), d0 + 1.0, d1 + 2.0, d2 + 1.0));
        if (!list.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (world instanceof ServerLevel) {
            EndCrystal entityendercrystal = new EndCrystal(world, d0 + 0.5, d1, d2 + 0.5);
            entityendercrystal.setShowBottom(false);
            if (CraftEventFactory.callEntityPlaceEvent(context, entityendercrystal).isCancelled()) {
                if (context.getPlayer() != null) {
                    context.getPlayer().containerMenu.sendAllDataToRemote();
                }
                return InteractionResult.FAIL;
            }
            world.addFreshEntity(entityendercrystal);
            world.gameEvent((Entity)context.getPlayer(), GameEvent.ENTITY_PLACE, blockposition1);
            EndDragonFight enderdragonbattle = ((ServerLevel)world).getDragonFight();
            if (enderdragonbattle != null && PufferfishConfig.allowEndCrystalRespawn) {
                enderdragonbattle.tryRespawn(aboveBlockPosition);
            }
        }
        context.getItemInHand().shrink(1);
        return InteractionResult.sidedSuccess(world.isClientSide);
    }
}

