/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class LeadItem
extends Item {
    public LeadItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockposition;
        Level world = context.getLevel();
        BlockState iblockdata = world.getBlockState(blockposition = context.getClickedPos());
        if (iblockdata.is(BlockTags.FENCES)) {
            Player entityhuman = context.getPlayer();
            if (!world.isClientSide && entityhuman != null) {
                LeadItem.bindPlayerMobs(entityhuman, world, blockposition, context.getHand());
            }
            return InteractionResult.sidedSuccess(world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult bindPlayerMobs(Player entityhuman, Level world, BlockPos blockposition, InteractionHand enumhand) {
        Entity entityleash = null;
        List<Leashable> list = LeadItem.leashableInArea(world, blockposition, leashable -> leashable.getLeashHolder() == entityhuman);
        Iterator<Leashable> iterator = list.iterator();
        while (iterator.hasNext()) {
            Entity leashed;
            Leashable leashable2 = iterator.next();
            if (entityleash == null) {
                entityleash = LeashFenceKnotEntity.getOrCreateKnot(world, blockposition);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)entityleash.getBukkitEntity(), entityhuman != null ? (org.bukkit.entity.Player)entityhuman.getBukkitEntity() : null, (Block)CraftBlock.at(world, blockposition), BlockFace.SELF, hand);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    entityleash.discard(null);
                    return InteractionResult.PASS;
                }
                ((LeashFenceKnotEntity)entityleash).playPlacementSound();
            }
            if (leashable2 instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable2), entityleash, entityhuman, enumhand).isCancelled()) {
                iterator.remove();
                continue;
            }
            leashable2.setLeashedTo(entityleash, true);
        }
        if (!list.isEmpty()) {
            world.gameEvent(GameEvent.BLOCK_ATTACH, blockposition, GameEvent.Context.of(entityhuman));
            return InteractionResult.SUCCESS;
        }
        if (entityleash != null) {
            entityleash.discard(null);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult bindPlayerMobs(Player player, Level world, BlockPos pos) {
        return LeadItem.bindPlayerMobs(player, world, pos, InteractionHand.MAIN_HAND);
    }

    public static List<Leashable> leashableInArea(Level world, BlockPos pos, Predicate<Leashable> predicate) {
        double d0 = 7.0;
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        AABB axisalignedbb = new AABB((double)i - 7.0, (double)j - 7.0, (double)k - 7.0, (double)i + 7.0, (double)j + 7.0, (double)k + 7.0);
        Stream stream = world.getEntitiesOfClass(Entity.class, axisalignedbb, entity -> {
            Leashable leashable;
            if (entity instanceof Leashable && predicate.test(leashable = (Leashable)((Object)entity))) {
                boolean flag = true;
                return flag;
            }
            boolean flag = false;
            return flag;
        }).stream();
        Objects.requireNonNull(Leashable.class);
        return stream.map(Leashable.class::cast).toList();
    }
}

