/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;

public class SnowballItem
extends Item
implements ProjectileItem {
    public SnowballItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, net.minecraft.world.entity.player.Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        if (!world.isClientSide) {
            Snowball entitysnowball = new Snowball(world, user);
            entitysnowball.setItem(itemstack);
            entitysnowball.shootFromRotation(user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, (float)world.purpurConfig.snowballProjectileOffset);
            PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((Player)user.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemstack), (Projectile)entitysnowball.getBukkitEntity());
            if (event.callEvent() && world.addFreshEntity(entitysnowball)) {
                user.awardStat(Stats.ITEM_USED.get(this));
                if (event.shouldConsume()) {
                    itemstack.consume(1, user);
                } else if (user instanceof ServerPlayer) {
                    ((ServerPlayer)user).getBukkitEntity().updateInventory();
                }
                world.playSound((net.minecraft.world.entity.player.Player)null, user.getX(), user.getY(), user.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            } else {
                if (user instanceof ServerPlayer) {
                    ((ServerPlayer)user).getBukkitEntity().updateInventory();
                }
                return InteractionResultHolder.fail(itemstack);
            }
        }
        return InteractionResultHolder.sidedSuccess(itemstack, world.isClientSide());
    }

    @Override
    public net.minecraft.world.entity.projectile.Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        Snowball entitysnowball = new Snowball(world, pos.x(), pos.y(), pos.z());
        entitysnowball.setItem(stack);
        return entitysnowball;
    }
}

