/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class SuspiciousStewItem
extends Item {
    public static final int DEFAULT_DURATION = 160;

    public SuspiciousStewItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (type.isCreative()) {
            ArrayList<MobEffectInstance> list1 = new ArrayList<MobEffectInstance>();
            SuspiciousStewEffects suspicioussteweffects = stack.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, SuspiciousStewEffects.EMPTY);
            for (SuspiciousStewEffects.Entry suspicioussteweffects_a : suspicioussteweffects.effects()) {
                list1.add(suspicioussteweffects_a.createEffectInstance());
            }
            Objects.requireNonNull(tooltip);
            PotionContents.addPotionTooltip(list1, tooltip::add, 1.0f, context.tickRate());
        }
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        SuspiciousStewEffects suspicioussteweffects = stack.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, SuspiciousStewEffects.EMPTY);
        for (SuspiciousStewEffects.Entry suspicioussteweffects_a : suspicioussteweffects.effects()) {
            user.addEffect(suspicioussteweffects_a.createEffectInstance(), EntityPotionEffectEvent.Cause.FOOD);
        }
        return super.finishUsingItem(stack, world, user);
    }

    public void cancelUsingItem(ServerPlayer entityplayer, ItemStack itemstack) {
        SuspiciousStewEffects suspicioussteweffects = itemstack.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, SuspiciousStewEffects.EMPTY);
        ArrayList<Packet<? super ClientGamePacketListener>> packets = new ArrayList<Packet<? super ClientGamePacketListener>>();
        for (SuspiciousStewEffects.Entry suspicioussteweffects_a : suspicioussteweffects.effects()) {
            packets.add(new ClientboundRemoveMobEffectPacket(entityplayer.getId(), suspicioussteweffects_a.effect()));
        }
        entityplayer.server.getPlayerList().sendActiveEffects((LivingEntity)entityplayer, packets::add);
        entityplayer.connection.send(new ClientboundBundlePacket((Iterable<Packet<? super ClientGamePacketListener>>)packets));
    }
}

