/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.bukkit.command.CommandSender;
import org.spigotmc.AsyncCatcher;

public abstract class BaseCommandBlock
implements CommandSource {
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final Component DEFAULT_NAME = Component.literal("@");
    private long lastExecution = -1L;
    private boolean updateLastExecution = true;
    private int successCount;
    private boolean trackOutput = true;
    @Nullable
    private Component lastOutput;
    private String command = "";
    @Nullable
    private Component customName;

    @Override
    public abstract CommandSender getBukkitSender(CommandSourceStack var1);

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    public Component getLastOutput() {
        return this.lastOutput == null ? CommonComponents.EMPTY : this.lastOutput;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putString("Command", this.command);
        nbt.putInt("SuccessCount", this.successCount);
        if (this.customName != null) {
            nbt.putString("CustomName", Component.Serializer.toJson(this.customName, registries));
        }
        nbt.putBoolean("TrackOutput", this.trackOutput);
        if (this.lastOutput != null && this.trackOutput) {
            nbt.putString("LastOutput", Component.Serializer.toJson(this.lastOutput, registries));
        }
        nbt.putBoolean("UpdateLastExecution", this.updateLastExecution);
        if (this.updateLastExecution && this.lastExecution > 0L) {
            nbt.putLong("LastExecution", this.lastExecution);
        }
        return nbt;
    }

    public void load(CompoundTag nbt, HolderLookup.Provider registries) {
        this.command = nbt.getString("Command");
        this.successCount = nbt.getInt("SuccessCount");
        if (nbt.contains("CustomName", 8)) {
            this.setCustomName(BlockEntity.parseCustomNameSafe(nbt.getString("CustomName"), registries));
        } else {
            this.setCustomName(null);
        }
        if (nbt.contains("TrackOutput", 1)) {
            this.trackOutput = nbt.getBoolean("TrackOutput");
        }
        if (nbt.contains("LastOutput", 8) && this.trackOutput) {
            try {
                this.lastOutput = Component.Serializer.fromJson(nbt.getString("LastOutput"), registries);
            }
            catch (Throwable throwable) {
                this.lastOutput = Component.literal(throwable.getMessage());
            }
        } else {
            this.lastOutput = null;
        }
        if (nbt.contains("UpdateLastExecution")) {
            this.updateLastExecution = nbt.getBoolean("UpdateLastExecution");
        }
        this.lastExecution = this.updateLastExecution && nbt.contains("LastExecution") ? nbt.getLong("LastExecution") : -1L;
    }

    public void setCommand(String command) {
        this.command = command;
        this.successCount = 0;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean performCommand(Level world) {
        if (!world.isClientSide && world.getGameTime() != this.lastExecution) {
            if ("Searge".equalsIgnoreCase(this.command)) {
                this.lastOutput = Component.literal("#itzlipofutzli");
                this.successCount = 1;
                return true;
            }
            this.successCount = 0;
            MinecraftServer minecraftserver = this.getLevel().getServer();
            if (minecraftserver.isCommandBlockEnabled() && !StringUtil.isNullOrEmpty(this.command)) {
                try {
                    this.lastOutput = null;
                    CommandSourceStack commandlistenerwrapper = this.createCommandSourceStack().withCallback((flag, i) -> {
                        if (flag) {
                            ++this.successCount;
                        }
                    });
                    minecraftserver.getCommands().dispatchServerCommand(commandlistenerwrapper, this.command);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable(throwable, "Executing command block");
                    CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Command to be executed");
                    crashreportsystemdetails.setDetail("Command", this::getCommand);
                    crashreportsystemdetails.setDetail("Name", () -> this.getName().getString());
                    throw new ReportedException(crashreport);
                }
            }
            this.lastExecution = this.updateLastExecution ? world.getGameTime() : -1L;
            return true;
        }
        return false;
    }

    public Component getName() {
        return this.customName != null ? this.customName : DEFAULT_NAME;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable Component customName) {
        this.customName = customName;
    }

    @Override
    public void sendSystemMessage(Component message) {
        if (this.trackOutput) {
            AsyncCatcher.catchOp("sendSystemMessage to a command block");
            SimpleDateFormat simpledateformat = TIME_FORMAT;
            Date date = new Date();
            this.lastOutput = Component.literal("[" + simpledateformat.format(date) + "] ").append(message);
            this.onUpdated();
        }
    }

    public abstract ServerLevel getLevel();

    public abstract void onUpdated();

    public void setLastOutput(@Nullable Component lastOutput) {
        this.lastOutput = lastOutput;
    }

    public void setTrackOutput(boolean trackOutput) {
        this.trackOutput = trackOutput;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }

    public InteractionResult usedBy(Player player) {
        if (!(player.canUseGameMasterBlocks() || player.isCreative() && player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            return InteractionResult.PASS;
        }
        if (player.getCommandSenderWorld().isClientSide) {
            player.openMinecartCommandBlock(this);
        }
        return InteractionResult.sidedSuccess(player.level().isClientSide);
    }

    public abstract Vec3 getPosition();

    public abstract CommandSourceStack createCommandSourceStack();

    @Override
    public boolean acceptsSuccess() {
        return this.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK) && this.trackOutput;
    }

    @Override
    public boolean acceptsFailure() {
        return this.trackOutput;
    }

    @Override
    public boolean shouldInformAdmins() {
        return this.getLevel().getGameRules().getBoolean(GameRules.RULE_COMMANDBLOCKOUTPUT);
    }

    public abstract boolean isValid();
}

