/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByBlockEvent;

public abstract class BaseFireBlock
extends Block {
    private static final int SECONDS_ON_FIRE = 8;
    private final float fireDamage;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape DOWN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public BaseFireBlock(BlockBehaviour.Properties settings, float damage) {
        super(settings);
        this.fireDamage = damage;
    }

    protected abstract MapCodec<? extends BaseFireBlock> codec();

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return BaseFireBlock.getState(ctx.getLevel(), ctx.getClickedPos());
    }

    public static BlockState getState(BlockGetter world, BlockPos pos) {
        BlockPos blockposition1 = pos.below();
        BlockState iblockdata = world.getBlockState(blockposition1);
        return SoulFireBlock.canSurviveOnBlock(iblockdata) ? Blocks.SOUL_FIRE.defaultBlockState() : ((FireBlock)Blocks.FIRE).getStateForPlacement(world, pos);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return DOWN_AABB;
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        block12: {
            block11: {
                double d2;
                double d1;
                double d0;
                int i;
                BlockPos blockposition1;
                BlockState iblockdata1;
                if (random.nextInt(24) == 0) {
                    world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
                }
                if (this.canBurn(iblockdata1 = world.getBlockState(blockposition1 = pos.below())) || iblockdata1.isFaceSturdy(world, blockposition1, Direction.UP)) break block11;
                if (this.canBurn(world.getBlockState(pos.west()))) {
                    for (i = 0; i < 2; ++i) {
                        d0 = (double)pos.getX() + random.nextDouble() * (double)0.1f;
                        d1 = (double)pos.getY() + random.nextDouble();
                        d2 = (double)pos.getZ() + random.nextDouble();
                        world.addParticle(ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(world.getBlockState(pos.east()))) {
                    for (i = 0; i < 2; ++i) {
                        d0 = (double)(pos.getX() + 1) - random.nextDouble() * (double)0.1f;
                        d1 = (double)pos.getY() + random.nextDouble();
                        d2 = (double)pos.getZ() + random.nextDouble();
                        world.addParticle(ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(world.getBlockState(pos.north()))) {
                    for (i = 0; i < 2; ++i) {
                        d0 = (double)pos.getX() + random.nextDouble();
                        d1 = (double)pos.getY() + random.nextDouble();
                        d2 = (double)pos.getZ() + random.nextDouble() * (double)0.1f;
                        world.addParticle(ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(world.getBlockState(pos.south()))) {
                    for (i = 0; i < 2; ++i) {
                        d0 = (double)pos.getX() + random.nextDouble();
                        d1 = (double)pos.getY() + random.nextDouble();
                        d2 = (double)(pos.getZ() + 1) - random.nextDouble() * (double)0.1f;
                        world.addParticle(ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.canBurn(world.getBlockState(pos.above()))) break block12;
                for (i = 0; i < 2; ++i) {
                    d0 = (double)pos.getX() + random.nextDouble();
                    d1 = (double)(pos.getY() + 1) - random.nextDouble() * (double)0.1f;
                    d2 = (double)pos.getZ() + random.nextDouble();
                    world.addParticle(ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)pos.getX() + random.nextDouble();
                double d1 = (double)pos.getY() + random.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.getZ() + random.nextDouble();
                world.addParticle(ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean canBurn(BlockState var1);

    @Override
    protected void entityInside(BlockState state, Level world, BlockPos pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!entity.fireImmune()) {
            entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 1);
            if (entity.getRemainingFireTicks() == 0) {
                EntityCombustByBlockEvent event = new EntityCombustByBlockEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), (Entity)entity.getBukkitEntity(), 8.0f);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                } else {
                    entity.setRemainingFireTicks(entity.getRemainingFireTicks() - 1);
                }
            }
        }
        entity.hurt(world.damageSources().inFire(), this.fireDamage);
        super.entityInside(state, world, pos, entity);
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag, UseOnContext context) {
        if (!iblockdata1.is(iblockdata.getBlock())) {
            Optional<PortalShape> optional;
            if (BaseFireBlock.inPortalDimension(world) && (optional = PortalShape.findEmptyPortalShape(world, blockposition, Direction.Axis.X)).isPresent()) {
                optional.get().createPortalBlocks(context == null ? null : context.getPlayer());
                return;
            }
            if (!iblockdata.canSurvive(world, blockposition)) {
                this.fireExtinguished(world, blockposition);
            }
        }
    }

    private static boolean inPortalDimension(Level world) {
        return world.getTypeKey() == LevelStem.OVERWORLD || world.getTypeKey() == LevelStem.NETHER;
    }

    @Override
    protected void spawnDestroyParticles(Level world, Player player, BlockPos pos, BlockState state) {
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide()) {
            world.levelEvent(null, 1009, pos, 0);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public static boolean canBePlacedAt(Level world, BlockPos pos, Direction direction) {
        BlockState iblockdata = world.getBlockState(pos);
        return !iblockdata.isAir() ? false : BaseFireBlock.getState(world, pos).canSurvive(world, pos) || BaseFireBlock.isPortal(world, pos, direction);
    }

    private static boolean isPortal(Level world, BlockPos pos, Direction direction) {
        if (!BaseFireBlock.inPortalDimension(world)) {
            return false;
        }
        BlockPos.MutableBlockPos blockposition_mutableblockposition = pos.mutable();
        boolean flag = false;
        for (Direction enumdirection1 : Direction.values()) {
            if (!world.getBlockState(blockposition_mutableblockposition.set(pos).move(enumdirection1)).is(Blocks.OBSIDIAN)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        Direction.Axis enumdirection_enumaxis = direction.getAxis().isHorizontal() ? direction.getCounterClockWise().getAxis() : Direction.Plane.HORIZONTAL.getRandomAxis(world.random);
        return PortalShape.findEmptyPortalShape(world, pos, enumdirection_enumaxis).isPresent();
    }

    protected void fireExtinguished(LevelAccessor world, BlockPos position) {
        if (!CraftEventFactory.callBlockFadeEvent(world, position, Blocks.AIR.defaultBlockState()).isCancelled()) {
            world.removeBlock(position, false);
        }
    }
}

