/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeCache;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.ItemStack;

public class CrafterBlock
extends BaseEntityBlock {
    public static final MapCodec<CrafterBlock> CODEC = CrafterBlock.simpleCodec(CrafterBlock::new);
    public static final BooleanProperty CRAFTING = BlockStateProperties.CRAFTING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    private static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;
    private static final int MAX_CRAFTING_TICKS = 6;
    private static final int CRAFTING_TICK_DELAY = 4;
    private static final RecipeCache RECIPE_CACHE = new RecipeCache(10);
    private static final int CRAFTER_ADVANCEMENT_DIAMETER = 17;

    public CrafterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(ORIENTATION, FrontAndTop.NORTH_UP)).setValue(TRIGGERED, false)).setValue(CRAFTING, false));
    }

    protected MapCodec<CrafterBlock> codec() {
        return CODEC;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)tileentity;
            return crafterblockentity.getRedstoneSignal();
        }
        return 0;
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean flag1 = world.hasNeighborSignal(pos);
        boolean flag2 = state.getValue(TRIGGERED);
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (flag1 && !flag2) {
            world.scheduleTick(pos, this, 4);
            world.setBlock(pos, (BlockState)state.setValue(TRIGGERED, true), 2);
            this.setBlockEntityTriggered(tileentity, true);
        } else if (!flag1 && flag2) {
            world.setBlock(pos, (BlockState)((BlockState)state.setValue(TRIGGERED, false)).setValue(CRAFTING, false), 2);
            this.setBlockEntityTriggered(tileentity, false);
        }
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.dispenseFrom(state, world, pos);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : CrafterBlock.createTickerHelper(type, BlockEntityType.CRAFTER, CrafterBlockEntity::serverTick);
    }

    private void setBlockEntityTriggered(@Nullable BlockEntity blockEntity, boolean triggered) {
        if (blockEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)blockEntity;
            crafterblockentity.setTriggered(triggered);
        }
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        CrafterBlockEntity crafterblockentity = new CrafterBlockEntity(pos, state);
        crafterblockentity.setTriggered(state.hasProperty(TRIGGERED) && state.getValue(TRIGGERED) != false);
        return crafterblockentity;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction enumdirection = ctx.getNearestLookingDirection().getOpposite();
        Direction enumdirection2 = switch (enumdirection) {
            case Direction.DOWN -> ctx.getHorizontalDirection().getOpposite();
            case Direction.UP -> ctx.getHorizontalDirection();
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Direction.UP;
            default -> throw new MatchException(null, null);
        };
        return (BlockState)((BlockState)this.defaultBlockState().setValue(ORIENTATION, FrontAndTop.fromFrontAndTop(enumdirection, enumdirection2))).setValue(TRIGGERED, ctx.getLevel().hasNeighborSignal(ctx.getClickedPos()));
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, net.minecraft.world.item.ItemStack itemStack) {
        if (state.getValue(TRIGGERED).booleanValue()) {
            world.scheduleTick(pos, this, 4);
        }
    }

    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy(state, newState, world, pos);
        super.onRemove(state, world, pos, newState, moved);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof CrafterBlockEntity) {
            player.openMenu((CrafterBlockEntity)tileentity);
        }
        return InteractionResult.CONSUME;
    }

    protected void dispenseFrom(BlockState state, ServerLevel world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)tileentity;
            CraftingInput craftinginput = crafterblockentity.asCraftInput();
            Optional<RecipeHolder<CraftingRecipe>> optional = CrafterBlock.getPotentialResults(world, craftinginput);
            if (optional.isEmpty()) {
                world.levelEvent(1050, pos, 0);
            } else {
                RecipeHolder<CraftingRecipe> recipeholder = optional.get();
                net.minecraft.world.item.ItemStack itemstack = recipeholder.value().assemble(craftinginput, world.registryAccess());
                CrafterCraftEvent event = CraftEventFactory.callCrafterCraftEvent(pos, world, crafterblockentity, itemstack, recipeholder);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = CraftItemStack.asNMSCopy(event.getResult());
                if (itemstack.isEmpty()) {
                    world.levelEvent(1050, pos, 0);
                } else {
                    crafterblockentity.setCraftingTicksRemaining(6);
                    world.setBlock(pos, (BlockState)state.setValue(CRAFTING, true), 2);
                    itemstack.onCraftedBySystem(world);
                    this.dispenseItem(world, pos, crafterblockentity, itemstack, state, recipeholder);
                    for (net.minecraft.world.item.ItemStack itemstack1 : recipeholder.value().getRemainingItems(craftinginput)) {
                        if (itemstack1.isEmpty()) continue;
                        this.dispenseItem(world, pos, crafterblockentity, itemstack1, state, recipeholder);
                    }
                    crafterblockentity.getItems().forEach(itemstack2 -> {
                        if (!itemstack2.isEmpty()) {
                            itemstack2.shrink(1);
                        }
                    });
                    crafterblockentity.setChanged();
                }
            }
        }
    }

    public static Optional<RecipeHolder<CraftingRecipe>> getPotentialResults(Level world, CraftingInput input) {
        return RECIPE_CACHE.get(world, input);
    }

    private void dispenseItem(ServerLevel world, BlockPos pos, CrafterBlockEntity blockEntity, net.minecraft.world.item.ItemStack stack, BlockState state, RecipeHolder<CraftingRecipe> recipe) {
        Direction enumdirection = state.getValue(ORIENTATION).front();
        Container iinventory = HopperBlockEntity.getContainerAt(world, pos.relative(enumdirection));
        net.minecraft.world.item.ItemStack itemstack1 = stack.copy();
        if (iinventory != null && (iinventory instanceof CrafterBlockEntity || stack.getCount() > iinventory.getMaxStackSize(stack))) {
            net.minecraft.world.item.ItemStack itemstack2;
            net.minecraft.world.item.ItemStack itemstack3;
            oitemstack = CraftItemStack.asCraftMirror(itemstack1);
            destinationInventory = iinventory instanceof CompoundContainer ? new CraftInventoryDoubleChest((CompoundContainer)iinventory) : iinventory.getOwner().getInventory();
            event = new InventoryMoveItemEvent(blockEntity.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
            while (!itemstack1.isEmpty() && !event.isCancelled() && (itemstack3 = HopperBlockEntity.addItem(blockEntity, iinventory, itemstack2 = itemstack1.copyWithCount(1), enumdirection.getOpposite())).isEmpty()) {
                itemstack1.shrink(1);
            }
        } else if (iinventory != null) {
            int i;
            oitemstack = CraftItemStack.asCraftMirror(itemstack1);
            destinationInventory = iinventory instanceof CompoundContainer ? new CraftInventoryDoubleChest((CompoundContainer)iinventory) : iinventory.getOwner().getInventory();
            event = new InventoryMoveItemEvent(blockEntity.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
            while (!itemstack1.isEmpty() && !event.isCancelled() && (i = itemstack1.getCount()) != (itemstack1 = HopperBlockEntity.addItem(blockEntity, iinventory, itemstack1, enumdirection.getOpposite())).getCount()) {
            }
        }
        if (!itemstack1.isEmpty()) {
            Vec3 vec3d = Vec3.atCenterOf(pos);
            Vec3 vec3d1 = vec3d.relative(enumdirection, 0.7);
            DefaultDispenseItemBehavior.spawnItem(world, itemstack1, 6, enumdirection, vec3d1);
            for (ServerPlayer entityplayer : world.getEntitiesOfClass(ServerPlayer.class, AABB.ofSize(vec3d, 17.0, 17.0, 17.0))) {
                CriteriaTriggers.CRAFTER_RECIPE_CRAFTED.trigger(entityplayer, recipe.id(), blockEntity.getItems());
            }
            world.levelEvent(1049, pos, 0);
            world.levelEvent(2010, pos, enumdirection.get3DDataValue());
        }
    }

    @Override
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(ORIENTATION, rotation.rotation().rotate(state.getValue(ORIENTATION)));
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(ORIENTATION, mirror.rotation().rotate(state.getValue(ORIENTATION)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(ORIENTATION, TRIGGERED, CRAFTING);
    }
}

