/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class RedStoneOreBlock
extends Block {
    public static final MapCodec<RedStoneOreBlock> CODEC = RedStoneOreBlock.simpleCodec(RedStoneOreBlock::new);
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;

    public MapCodec<RedStoneOreBlock> codec() {
        return CODEC;
    }

    public RedStoneOreBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(LIT, false));
    }

    @Override
    protected void attack(BlockState state, Level world, BlockPos pos, Player player) {
        RedStoneOreBlock.interact(state, world, pos, player);
        super.attack(state, world, pos, player);
    }

    @Override
    public void stepOn(Level world, BlockPos pos, BlockState state, net.minecraft.world.entity.Entity entity) {
        if (!entity.isSteppingCarefully()) {
            if (entity instanceof Player) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, pos, null, null, null);
                if (!event.isCancelled()) {
                    RedStoneOreBlock.interact(world.getBlockState(pos), world, pos, entity);
                }
            } else {
                EntityInteractEvent event = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ()));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    RedStoneOreBlock.interact(world.getBlockState(pos), world, pos, entity);
                }
            }
        }
        super.stepOn(world, pos, state, entity);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide) {
            RedStoneOreBlock.spawnParticles(world, pos);
        } else {
            RedStoneOreBlock.interact(state, world, pos, player);
        }
        return stack.getItem() instanceof BlockItem && new BlockPlaceContext(player, hand, stack, hit).canPlace() ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.SUCCESS;
    }

    private static void interact(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity) {
        RedStoneOreBlock.spawnParticles(world, blockposition);
        if (!iblockdata.getValue(LIT).booleanValue()) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (BlockState)iblockdata.setValue(LIT, true))) {
                return;
            }
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(LIT, true), 3);
        }
    }

    @Override
    protected boolean isRandomlyTicking(BlockState state) {
        return state.getValue(LIT);
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (state.getValue(LIT).booleanValue()) {
            if (CraftEventFactory.callBlockFadeEvent(world, pos, (BlockState)state.setValue(LIT, false)).isCancelled()) {
                return;
            }
            world.setBlock(pos, (BlockState)state.setValue(LIT, false), 3);
        }
    }

    @Override
    protected void spawnAfterBreak(BlockState state, ServerLevel world, BlockPos pos, ItemStack tool, boolean dropExperience) {
        super.spawnAfterBreak(state, world, pos, tool, dropExperience);
    }

    @Override
    public int getExpDrop(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, UniformInt.of(1, 5));
        }
        return 0;
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (state.getValue(LIT).booleanValue()) {
            RedStoneOreBlock.spawnParticles(world, pos);
        }
    }

    private static void spawnParticles(Level world, BlockPos pos) {
        double d0 = 0.5625;
        RandomSource randomsource = world.random;
        for (Direction enumdirection : Direction.values()) {
            BlockPos blockposition1 = pos.relative(enumdirection);
            if (world.getBlockState(blockposition1).isSolidRender(world, blockposition1)) continue;
            Direction.Axis enumdirection_enumaxis = enumdirection.getAxis();
            double d1 = enumdirection_enumaxis == Direction.Axis.X ? 0.5 + 0.5625 * (double)enumdirection.getStepX() : (double)randomsource.nextFloat();
            double d2 = enumdirection_enumaxis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)enumdirection.getStepY() : (double)randomsource.nextFloat();
            double d3 = enumdirection_enumaxis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)enumdirection.getStepZ() : (double)randomsource.nextFloat();
            world.addParticle(DustParticleOptions.REDSTONE, (double)pos.getX() + d1, (double)pos.getY() + d2, (double)pos.getZ() + d3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(LIT);
    }
}

