/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.block.CraftBlock;

public class RespawnAnchorBlock
extends Block {
    public static final MapCodec<RespawnAnchorBlock> CODEC = RespawnAnchorBlock.simpleCodec(RespawnAnchorBlock::new);
    public static final int MIN_CHARGES = 0;
    public static final int MAX_CHARGES = 4;
    public static final IntegerProperty CHARGE = BlockStateProperties.RESPAWN_ANCHOR_CHARGES;
    private static final ImmutableList<Vec3i> RESPAWN_HORIZONTAL_OFFSETS = ImmutableList.of((Object)new Vec3i(0, 0, -1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(1, 0, -1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(1, 0, 1));
    private static final ImmutableList<Vec3i> RESPAWN_OFFSETS = new ImmutableList.Builder().addAll(RESPAWN_HORIZONTAL_OFFSETS).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::below).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::above).iterator()).add((Object)new Vec3i(0, 1, 0)).build();

    public MapCodec<RespawnAnchorBlock> codec() {
        return CODEC;
    }

    public RespawnAnchorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.stateDefinition.any().setValue(CHARGE, 0));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (RespawnAnchorBlock.isRespawnFuel(stack) && RespawnAnchorBlock.canBeCharged(state)) {
            RespawnAnchorBlock.charge(player, world, pos, state);
            stack.consume(1, player);
            return ItemInteractionResult.sidedSuccess(world.isClientSide);
        }
        return hand == InteractionHand.MAIN_HAND && RespawnAnchorBlock.isRespawnFuel(player.getItemInHand(InteractionHand.OFF_HAND)) && RespawnAnchorBlock.canBeCharged(state) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        ServerPlayer entityplayer;
        if (state.getValue(CHARGE) == 0) {
            return InteractionResult.PASS;
        }
        if (!RespawnAnchorBlock.canSetSpawn(world)) {
            if (!world.isClientSide) {
                this.explode(state, world, pos);
            }
            return InteractionResult.sidedSuccess(world.isClientSide);
        }
        if (!(world.isClientSide || (entityplayer = (ServerPlayer)player).getRespawnDimension() == world.dimension() && pos.equals(entityplayer.getRespawnPosition()))) {
            if (entityplayer.setRespawnPosition(world.dimension(), pos, 0.0f, false, true, PlayerSetSpawnEvent.Cause.RESPAWN_ANCHOR)) {
                world.playSound((Player)null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.CONSUME;
    }

    private static boolean isRespawnFuel(ItemStack stack) {
        return stack.is(Items.GLOWSTONE);
    }

    private static boolean canBeCharged(BlockState state) {
        return state.getValue(CHARGE) < 4;
    }

    private static boolean isWaterThatWouldFlow(BlockPos pos, Level world) {
        FluidState fluid = world.getFluidState(pos);
        if (!fluid.is(FluidTags.WATER)) {
            return false;
        }
        if (fluid.isSource()) {
            return true;
        }
        float f = fluid.getAmount();
        if (f < 2.0f) {
            return false;
        }
        FluidState fluid1 = world.getFluidState(pos.below());
        return !fluid1.is(FluidTags.WATER);
    }

    private void explode(BlockState state, Level world, final BlockPos explodedPos) {
        org.bukkit.block.BlockState blockState = CraftBlock.at(world, explodedPos).getState();
        world.removeBlock(explodedPos, false);
        Stream<Direction> stream = Direction.Plane.HORIZONTAL.stream();
        Objects.requireNonNull(explodedPos);
        boolean flag = stream.map(explodedPos::relative).anyMatch(blockposition1 -> RespawnAnchorBlock.isWaterThatWouldFlow(blockposition1, world));
        final boolean flag1 = flag || world.getFluidState(explodedPos.above()).is(FluidTags.WATER);
        ExplosionDamageCalculator explosiondamagecalculator = new ExplosionDamageCalculator(this){

            @Override
            public Optional<Float> getBlockExplosionResistance(Explosion explosion, BlockGetter world, BlockPos pos, BlockState blockState, FluidState fluidState) {
                return pos.equals(explodedPos) && flag1 ? Optional.of(Float.valueOf(Blocks.WATER.getExplosionResistance())) : super.getBlockExplosionResistance(explosion, world, pos, blockState, fluidState);
            }
        };
        Vec3 vec3d = explodedPos.getCenter();
        if (world.purpurConfig.respawnAnchorExplode) {
            world.explode((Entity)null, world.damageSources().badRespawnPointExplosion(vec3d, blockState), explosiondamagecalculator, vec3d, (float)world.purpurConfig.respawnAnchorExplosionPower, world.purpurConfig.respawnAnchorExplosionFire, world.purpurConfig.respawnAnchorExplosionEffect);
        }
    }

    public static boolean canSetSpawn(Level world) {
        return world.dimensionType().respawnAnchorWorks();
    }

    public static void charge(@Nullable Entity charger, Level world, BlockPos pos, BlockState state) {
        BlockState iblockdata1 = (BlockState)state.setValue(CHARGE, state.getValue(CHARGE) + 1);
        world.setBlock(pos, iblockdata1, 3);
        world.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of(charger, iblockdata1));
        world.playSound((Player)null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (state.getValue(CHARGE) != 0) {
            if (random.nextInt(100) == 0) {
                world.playLocalSound(pos, SoundEvents.RESPAWN_ANCHOR_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            double d0 = (double)pos.getX() + 0.5 + (0.5 - random.nextDouble());
            double d1 = (double)pos.getY() + 1.0;
            double d2 = (double)pos.getZ() + 0.5 + (0.5 - random.nextDouble());
            double d3 = (double)random.nextFloat() * 0.04;
            world.addParticle(ParticleTypes.REVERSE_PORTAL, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(CHARGE);
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public static int getScaledChargeLevel(BlockState state, int maxLevel) {
        return Mth.floor((float)(state.getValue(CHARGE) - 0) / 4.0f * (float)maxLevel);
    }

    @Override
    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return RespawnAnchorBlock.getScaledChargeLevel(state, 15);
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> entity, CollisionGetter world, BlockPos pos) {
        Optional<Vec3> optional = RespawnAnchorBlock.findStandUpPosition(entity, world, pos, true);
        return optional.isPresent() ? optional : RespawnAnchorBlock.findStandUpPosition(entity, world, pos, false);
    }

    private static Optional<Vec3> findStandUpPosition(EntityType<?> entity, CollisionGetter world, BlockPos pos, boolean ignoreInvalidPos) {
        Vec3 vec3d;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        UnmodifiableIterator unmodifiableiterator = RESPAWN_OFFSETS.iterator();
        do {
            if (!unmodifiableiterator.hasNext()) {
                return Optional.empty();
            }
            Vec3i baseblockposition = (Vec3i)unmodifiableiterator.next();
            blockposition_mutableblockposition.set(pos).move(baseblockposition);
        } while ((vec3d = DismountHelper.findSafeDismountLocation(entity, world, blockposition_mutableblockposition, ignoreInvalidPos)) == null);
        return Optional.of(vec3d);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

