/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class SpawnerBlock
extends BaseEntityBlock {
    public static final MapCodec<SpawnerBlock> CODEC = SpawnerBlock.simpleCodec(SpawnerBlock::new);

    public MapCodec<SpawnerBlock> codec() {
        return CODEC;
    }

    protected SpawnerBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SpawnerBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return SpawnerBlock.createTickerHelper(type, BlockEntityType.MOB_SPAWNER, world.isClientSide ? SpawnerBlockEntity::clientTick : SpawnerBlockEntity::serverTick);
    }

    @Override
    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack, boolean includeDrops, boolean dropExp) {
        if (level.purpurConfig.silkTouchEnabled && player.getBukkitEntity().hasPermission("purpur.drop.spawners") && this.isSilkTouch(level, stack)) {
            SpawnData spawnData;
            ItemStack item = new ItemStack(Blocks.SPAWNER.asItem());
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerBlock = (SpawnerBlockEntity)blockEntity;
                spawnData = spawnerBlock.getSpawner().nextSpawnData;
            } else {
                spawnData = null;
            }
            SpawnData nextSpawnData = spawnData;
            Optional<Object> type = Optional.empty();
            if (nextSpawnData != null) {
                type = EntityType.by(nextSpawnData.getEntityToSpawn());
                SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)nextSpawnData).result().ifPresent(tag -> item.set(DataComponents.CUSTOM_DATA, CustomData.EMPTY.update(compoundTag -> compoundTag.put("Purpur.SpawnData", (Tag)tag))));
            }
            if (type.isPresent()) {
                List<String> lore;
                net.kyori.adventure.text.Component mobName = PaperAdventure.asAdventure(((EntityType)type.get()).getDescription());
                String name = level.purpurConfig.silkTouchSpawnerName;
                if (name != null && !name.isEmpty() && !name.equals("Monster Spawner")) {
                    net.kyori.adventure.text.Component displayName = MiniMessage.miniMessage().deserialize(name, (TagResolver)Placeholder.component((String)"mob", (ComponentLike)mobName));
                    if (name.startsWith("<reset>")) {
                        displayName = displayName.decoration(TextDecoration.ITALIC, false);
                    }
                    item.set(DataComponents.CUSTOM_NAME, PaperAdventure.asVanilla(displayName));
                }
                if ((lore = level.purpurConfig.silkTouchSpawnerLore) != null && !lore.isEmpty()) {
                    ArrayList<Component> loreComponentList = new ArrayList<Component>();
                    for (String line : lore) {
                        net.kyori.adventure.text.Component lineComponent = MiniMessage.miniMessage().deserialize(line, (TagResolver)Placeholder.component((String)"mob", (ComponentLike)mobName));
                        if (line.startsWith("<reset>")) {
                            lineComponent = lineComponent.decoration(TextDecoration.ITALIC, false);
                        }
                        loreComponentList.add(PaperAdventure.asVanilla(lineComponent));
                    }
                    item.set(DataComponents.LORE, new ItemLore(loreComponentList, loreComponentList));
                }
                item.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, Unit.INSTANCE);
            }
            SpawnerBlock.popResource(level, pos, item);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, stack, includeDrops, dropExp);
    }

    private boolean isSilkTouch(Level level, ItemStack stack) {
        return stack != null && level.purpurConfig.silkTouchTools.contains(stack.getItem()) && EnchantmentHelper.getItemEnchantmentLevel(Enchantments.SILK_TOUCH, stack) >= level.purpurConfig.minimumSilkTouchSpawnerRequire;
    }

    @Override
    protected void spawnAfterBreak(BlockState state, ServerLevel world, BlockPos pos, ItemStack tool, boolean dropExperience) {
        super.spawnAfterBreak(state, world, pos, tool, dropExperience);
    }

    @Override
    public int getExpDrop(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, boolean flag) {
        if (worldserver.purpurConfig.silkTouchEnabled && this.isSilkTouch(worldserver, itemstack)) {
            return 0;
        }
        if (flag) {
            int i = 15 + worldserver.random.nextInt(15) + worldserver.random.nextInt(15);
            return i;
        }
        return 0;
    }

    @Override
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        Spawner.appendHoverText(stack, tooltip, "SpawnData");
    }
}

