/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class BannerBlockEntity
extends BlockEntity
implements Nameable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_PATTERNS = 6;
    private static final String TAG_PATTERNS = "patterns";
    @Nullable
    public Component name;
    public DyeColor baseColor;
    private BannerPatternLayers patterns;
    ThreadLocal<Boolean> serialisingForNetwork = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public BannerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.BANNER, pos, state);
        this.patterns = BannerPatternLayers.EMPTY;
        this.baseColor = ((AbstractBannerBlock)state.getBlock()).getColor();
    }

    public BannerBlockEntity(BlockPos pos, BlockState state, DyeColor baseColor) {
        this(pos, state);
        this.baseColor = baseColor;
    }

    public void fromItem(ItemStack stack, DyeColor baseColor) {
        this.baseColor = baseColor;
        this.applyComponentsFromItemStack(stack);
    }

    @Override
    public Component getName() {
        return this.name != null ? this.name : Component.translatable("block.minecraft.banner");
    }

    @Override
    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (!this.patterns.equals(BannerPatternLayers.EMPTY) || this.serialisingForNetwork.get().booleanValue()) {
            nbt.put(TAG_PATTERNS, (Tag)BannerPatternLayers.CODEC.encodeStart(registryLookup.createSerializationContext(NbtOps.INSTANCE), (Object)this.patterns).getOrThrow());
        }
        if (this.name != null) {
            nbt.putString("CustomName", Component.Serializer.toJson(this.name, registryLookup));
        }
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        if (nbt.contains("CustomName", 8)) {
            this.name = BannerBlockEntity.parseCustomNameSafe(nbt.getString("CustomName"), registryLookup);
        }
        if (nbt.contains(TAG_PATTERNS)) {
            BannerPatternLayers.CODEC.parse(registryLookup.createSerializationContext(NbtOps.INSTANCE), (Object)nbt.get(TAG_PATTERNS)).resultOrPartial(s -> LOGGER.error("Failed to parse banner patterns: '{}'", s)).ifPresent(bannerpatternlayers -> this.setPatterns((BannerPatternLayers)bannerpatternlayers));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        Boolean wasSerialisingForNetwork = this.serialisingForNetwork.get();
        try {
            this.serialisingForNetwork.set(Boolean.TRUE);
            CompoundTag compoundTag = this.saveWithoutMetadata(registryLookup);
            return compoundTag;
        }
        finally {
            this.serialisingForNetwork.set(wasSerialisingForNetwork);
        }
    }

    public BannerPatternLayers getPatterns() {
        return this.patterns;
    }

    public ItemStack getItem() {
        ItemStack itemstack = new ItemStack(BannerBlock.byColor(this.baseColor));
        itemstack.applyComponents(this.collectComponents());
        return itemstack;
    }

    public DyeColor getBaseColor() {
        return this.baseColor;
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.setPatterns(components.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY));
        this.name = components.get(DataComponents.CUSTOM_NAME);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder componentMapBuilder) {
        super.collectImplicitComponents(componentMapBuilder);
        componentMapBuilder.set(DataComponents.BANNER_PATTERNS, this.patterns);
        componentMapBuilder.set(DataComponents.CUSTOM_NAME, this.name);
    }

    @Override
    public void removeComponentsFromTag(CompoundTag nbt) {
        nbt.remove(TAG_PATTERNS);
        nbt.remove("CustomName");
    }

    public void setPatterns(BannerPatternLayers bannerpatternlayers) {
        if (bannerpatternlayers.layers().size() > 20) {
            bannerpatternlayers = new BannerPatternLayers(List.copyOf(bannerpatternlayers.layers().subList(0, 20)));
        }
        this.patterns = bannerpatternlayers;
    }
}

